<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSearchEntity Array
 * @subpackage Arrays
 */
class ArrayOfSearchEntity extends AbstractStructArrayBase
{
    /**
     * The SearchEntity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\SearchEntity[]
     */
    public $SearchEntity;
    /**
     * Constructor method for ArrayOfSearchEntity
     * @uses ArrayOfSearchEntity::setSearchEntity()
     * @param \SGCIS\Struct\SearchEntity[] $searchEntity
     */
    public function __construct(array $searchEntity = array())
    {
        $this
            ->setSearchEntity($searchEntity);
    }
    /**
     * Get SearchEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\SearchEntity[]|null
     */
    public function getSearchEntity()
    {
        return isset($this->SearchEntity) ? $this->SearchEntity : null;
    }
    /**
     * Set SearchEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\SearchEntity[] $searchEntity
     * @return \SGCIS\Array\ArrayOfSearchEntity
     */
    public function setSearchEntity(array $searchEntity = array())
    {
        foreach ($searchEntity as $arrayOfSearchEntitySearchEntityItem) {
            // validation for constraint: itemType
            if (!$arrayOfSearchEntitySearchEntityItem instanceof \SGCIS\Struct\SearchEntity) {
                throw new \InvalidArgumentException(sprintf('The SearchEntity property can only contain items of \SGCIS\Struct\SearchEntity, "%s" given', is_object($arrayOfSearchEntitySearchEntityItem) ? get_class($arrayOfSearchEntitySearchEntityItem) : gettype($arrayOfSearchEntitySearchEntityItem)), __LINE__);
            }
        }
        if (is_null($searchEntity) || (is_array($searchEntity) && empty($searchEntity))) {
            unset($this->SearchEntity);
        } else {
            $this->SearchEntity = $searchEntity;
        }
        return $this;
    }
    /**
     * Add item to SearchEntity value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\SearchEntity $item
     * @return \SGCIS\Array\ArrayOfSearchEntity
     */
    public function addToSearchEntity(\SGCIS\Struct\SearchEntity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\SearchEntity) {
            throw new \InvalidArgumentException(sprintf('The SearchEntity property can only contain items of \SGCIS\Struct\SearchEntity, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SearchEntity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\SearchEntity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\SearchEntity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\SearchEntity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\SearchEntity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\SearchEntity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SearchEntity
     */
    public function getAttributeName()
    {
        return 'SearchEntity';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfSearchEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
