<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductFamily Array
 * @subpackage Arrays
 */
class ArrayOfProductFamily extends AbstractStructArrayBase
{
    /**
     * The ProductFamily
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\ProductFamily[]
     */
    public $ProductFamily;
    /**
     * Constructor method for ArrayOfProductFamily
     * @uses ArrayOfProductFamily::setProductFamily()
     * @param \SGCIS\Struct\ProductFamily[] $productFamily
     */
    public function __construct(array $productFamily = array())
    {
        $this
            ->setProductFamily($productFamily);
    }
    /**
     * Get ProductFamily value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\ProductFamily[]|null
     */
    public function getProductFamily()
    {
        return isset($this->ProductFamily) ? $this->ProductFamily : null;
    }
    /**
     * Set ProductFamily value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ProductFamily[] $productFamily
     * @return \SGCIS\Array\ArrayOfProductFamily
     */
    public function setProductFamily(array $productFamily = array())
    {
        foreach ($productFamily as $arrayOfProductFamilyProductFamilyItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductFamilyProductFamilyItem instanceof \SGCIS\Struct\ProductFamily) {
                throw new \InvalidArgumentException(sprintf('The ProductFamily property can only contain items of \SGCIS\Struct\ProductFamily, "%s" given', is_object($arrayOfProductFamilyProductFamilyItem) ? get_class($arrayOfProductFamilyProductFamilyItem) : gettype($arrayOfProductFamilyProductFamilyItem)), __LINE__);
            }
        }
        if (is_null($productFamily) || (is_array($productFamily) && empty($productFamily))) {
            unset($this->ProductFamily);
        } else {
            $this->ProductFamily = $productFamily;
        }
        return $this;
    }
    /**
     * Add item to ProductFamily value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ProductFamily $item
     * @return \SGCIS\Array\ArrayOfProductFamily
     */
    public function addToProductFamily(\SGCIS\Struct\ProductFamily $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\ProductFamily) {
            throw new \InvalidArgumentException(sprintf('The ProductFamily property can only contain items of \SGCIS\Struct\ProductFamily, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductFamily[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\ProductFamily|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\ProductFamily|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\ProductFamily|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\ProductFamily|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\ProductFamily|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductFamily
     */
    public function getAttributeName()
    {
        return 'ProductFamily';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfProductFamily
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
