<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductDocument Array
 * @subpackage Arrays
 */
class ArrayOfProductDocument extends AbstractStructArrayBase
{
    /**
     * The ProductDocument
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\ProductDocument[]
     */
    public $ProductDocument;
    /**
     * Constructor method for ArrayOfProductDocument
     * @uses ArrayOfProductDocument::setProductDocument()
     * @param \SGCIS\Struct\ProductDocument[] $productDocument
     */
    public function __construct(array $productDocument = array())
    {
        $this
            ->setProductDocument($productDocument);
    }
    /**
     * Get ProductDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\ProductDocument[]|null
     */
    public function getProductDocument()
    {
        return isset($this->ProductDocument) ? $this->ProductDocument : null;
    }
    /**
     * Set ProductDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ProductDocument[] $productDocument
     * @return \SGCIS\Array\ArrayOfProductDocument
     */
    public function setProductDocument(array $productDocument = array())
    {
        foreach ($productDocument as $arrayOfProductDocumentProductDocumentItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductDocumentProductDocumentItem instanceof \SGCIS\Struct\ProductDocument) {
                throw new \InvalidArgumentException(sprintf('The ProductDocument property can only contain items of \SGCIS\Struct\ProductDocument, "%s" given', is_object($arrayOfProductDocumentProductDocumentItem) ? get_class($arrayOfProductDocumentProductDocumentItem) : gettype($arrayOfProductDocumentProductDocumentItem)), __LINE__);
            }
        }
        if (is_null($productDocument) || (is_array($productDocument) && empty($productDocument))) {
            unset($this->ProductDocument);
        } else {
            $this->ProductDocument = $productDocument;
        }
        return $this;
    }
    /**
     * Add item to ProductDocument value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ProductDocument $item
     * @return \SGCIS\Array\ArrayOfProductDocument
     */
    public function addToProductDocument(\SGCIS\Struct\ProductDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\ProductDocument) {
            throw new \InvalidArgumentException(sprintf('The ProductDocument property can only contain items of \SGCIS\Struct\ProductDocument, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductDocument[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\ProductDocument|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\ProductDocument|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\ProductDocument|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\ProductDocument|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\ProductDocument|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductDocument
     */
    public function getAttributeName()
    {
        return 'ProductDocument';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfProductDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
