<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPersonContact Array
 * @subpackage Arrays
 */
class ArrayOfPersonContact extends AbstractStructArrayBase
{
    /**
     * The PersonContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\PersonContact[]
     */
    public $PersonContact;
    /**
     * Constructor method for ArrayOfPersonContact
     * @uses ArrayOfPersonContact::setPersonContact()
     * @param \SGCIS\Struct\PersonContact[] $personContact
     */
    public function __construct(array $personContact = array())
    {
        $this
            ->setPersonContact($personContact);
    }
    /**
     * Get PersonContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\PersonContact[]|null
     */
    public function getPersonContact()
    {
        return isset($this->PersonContact) ? $this->PersonContact : null;
    }
    /**
     * Set PersonContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\PersonContact[] $personContact
     * @return \SGCIS\Array\ArrayOfPersonContact
     */
    public function setPersonContact(array $personContact = array())
    {
        foreach ($personContact as $arrayOfPersonContactPersonContactItem) {
            // validation for constraint: itemType
            if (!$arrayOfPersonContactPersonContactItem instanceof \SGCIS\Struct\PersonContact) {
                throw new \InvalidArgumentException(sprintf('The PersonContact property can only contain items of \SGCIS\Struct\PersonContact, "%s" given', is_object($arrayOfPersonContactPersonContactItem) ? get_class($arrayOfPersonContactPersonContactItem) : gettype($arrayOfPersonContactPersonContactItem)), __LINE__);
            }
        }
        if (is_null($personContact) || (is_array($personContact) && empty($personContact))) {
            unset($this->PersonContact);
        } else {
            $this->PersonContact = $personContact;
        }
        return $this;
    }
    /**
     * Add item to PersonContact value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\PersonContact $item
     * @return \SGCIS\Array\ArrayOfPersonContact
     */
    public function addToPersonContact(\SGCIS\Struct\PersonContact $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\PersonContact) {
            throw new \InvalidArgumentException(sprintf('The PersonContact property can only contain items of \SGCIS\Struct\PersonContact, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PersonContact[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\PersonContact|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\PersonContact|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\PersonContact|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\PersonContact|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\PersonContact|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PersonContact
     */
    public function getAttributeName()
    {
        return 'PersonContact';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfPersonContact
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
