<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMeterReadDetail Array
 * @subpackage Arrays
 */
class ArrayOfMeterReadDetail extends AbstractStructArrayBase
{
    /**
     * The MeterReadDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\MeterReadDetail[]
     */
    public $MeterReadDetail;
    /**
     * Constructor method for ArrayOfMeterReadDetail
     * @uses ArrayOfMeterReadDetail::setMeterReadDetail()
     * @param \SGCIS\Struct\MeterReadDetail[] $meterReadDetail
     */
    public function __construct(array $meterReadDetail = array())
    {
        $this
            ->setMeterReadDetail($meterReadDetail);
    }
    /**
     * Get MeterReadDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\MeterReadDetail[]|null
     */
    public function getMeterReadDetail()
    {
        return isset($this->MeterReadDetail) ? $this->MeterReadDetail : null;
    }
    /**
     * Set MeterReadDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\MeterReadDetail[] $meterReadDetail
     * @return \SGCIS\Array\ArrayOfMeterReadDetail
     */
    public function setMeterReadDetail(array $meterReadDetail = array())
    {
        foreach ($meterReadDetail as $arrayOfMeterReadDetailMeterReadDetailItem) {
            // validation for constraint: itemType
            if (!$arrayOfMeterReadDetailMeterReadDetailItem instanceof \SGCIS\Struct\MeterReadDetail) {
                throw new \InvalidArgumentException(sprintf('The MeterReadDetail property can only contain items of \SGCIS\Struct\MeterReadDetail, "%s" given', is_object($arrayOfMeterReadDetailMeterReadDetailItem) ? get_class($arrayOfMeterReadDetailMeterReadDetailItem) : gettype($arrayOfMeterReadDetailMeterReadDetailItem)), __LINE__);
            }
        }
        if (is_null($meterReadDetail) || (is_array($meterReadDetail) && empty($meterReadDetail))) {
            unset($this->MeterReadDetail);
        } else {
            $this->MeterReadDetail = $meterReadDetail;
        }
        return $this;
    }
    /**
     * Add item to MeterReadDetail value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\MeterReadDetail $item
     * @return \SGCIS\Array\ArrayOfMeterReadDetail
     */
    public function addToMeterReadDetail(\SGCIS\Struct\MeterReadDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\MeterReadDetail) {
            throw new \InvalidArgumentException(sprintf('The MeterReadDetail property can only contain items of \SGCIS\Struct\MeterReadDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MeterReadDetail[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\MeterReadDetail|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\MeterReadDetail|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\MeterReadDetail|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\MeterReadDetail|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\MeterReadDetail|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MeterReadDetail
     */
    public function getAttributeName()
    {
        return 'MeterReadDetail';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfMeterReadDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
