<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLineOfBusiness Array
 * @subpackage Arrays
 */
class ArrayOfLineOfBusiness extends AbstractStructArrayBase
{
    /**
     * The LineOfBusiness
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\LineOfBusiness[]
     */
    public $LineOfBusiness;
    /**
     * Constructor method for ArrayOfLineOfBusiness
     * @uses ArrayOfLineOfBusiness::setLineOfBusiness()
     * @param \SGCIS\Struct\LineOfBusiness[] $lineOfBusiness
     */
    public function __construct(array $lineOfBusiness = array())
    {
        $this
            ->setLineOfBusiness($lineOfBusiness);
    }
    /**
     * Get LineOfBusiness value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\LineOfBusiness[]|null
     */
    public function getLineOfBusiness()
    {
        return isset($this->LineOfBusiness) ? $this->LineOfBusiness : null;
    }
    /**
     * Set LineOfBusiness value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\LineOfBusiness[] $lineOfBusiness
     * @return \SGCIS\Array\ArrayOfLineOfBusiness
     */
    public function setLineOfBusiness(array $lineOfBusiness = array())
    {
        foreach ($lineOfBusiness as $arrayOfLineOfBusinessLineOfBusinessItem) {
            // validation for constraint: itemType
            if (!$arrayOfLineOfBusinessLineOfBusinessItem instanceof \SGCIS\Struct\LineOfBusiness) {
                throw new \InvalidArgumentException(sprintf('The LineOfBusiness property can only contain items of \SGCIS\Struct\LineOfBusiness, "%s" given', is_object($arrayOfLineOfBusinessLineOfBusinessItem) ? get_class($arrayOfLineOfBusinessLineOfBusinessItem) : gettype($arrayOfLineOfBusinessLineOfBusinessItem)), __LINE__);
            }
        }
        if (is_null($lineOfBusiness) || (is_array($lineOfBusiness) && empty($lineOfBusiness))) {
            unset($this->LineOfBusiness);
        } else {
            $this->LineOfBusiness = $lineOfBusiness;
        }
        return $this;
    }
    /**
     * Add item to LineOfBusiness value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\LineOfBusiness $item
     * @return \SGCIS\Array\ArrayOfLineOfBusiness
     */
    public function addToLineOfBusiness(\SGCIS\Struct\LineOfBusiness $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\LineOfBusiness) {
            throw new \InvalidArgumentException(sprintf('The LineOfBusiness property can only contain items of \SGCIS\Struct\LineOfBusiness, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LineOfBusiness[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\LineOfBusiness|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\LineOfBusiness|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\LineOfBusiness|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\LineOfBusiness|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\LineOfBusiness|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LineOfBusiness
     */
    public function getAttributeName()
    {
        return 'LineOfBusiness';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfLineOfBusiness
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
