<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDistributionPoint Array
 * @subpackage Arrays
 */
class ArrayOfDistributionPoint extends AbstractStructArrayBase
{
    /**
     * The DistributionPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\DistributionPoint[]
     */
    public $DistributionPoint;
    /**
     * Constructor method for ArrayOfDistributionPoint
     * @uses ArrayOfDistributionPoint::setDistributionPoint()
     * @param \SGCIS\Struct\DistributionPoint[] $distributionPoint
     */
    public function __construct(array $distributionPoint = array())
    {
        $this
            ->setDistributionPoint($distributionPoint);
    }
    /**
     * Get DistributionPoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\DistributionPoint[]|null
     */
    public function getDistributionPoint()
    {
        return isset($this->DistributionPoint) ? $this->DistributionPoint : null;
    }
    /**
     * Set DistributionPoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\DistributionPoint[] $distributionPoint
     * @return \SGCIS\Array\ArrayOfDistributionPoint
     */
    public function setDistributionPoint(array $distributionPoint = array())
    {
        foreach ($distributionPoint as $arrayOfDistributionPointDistributionPointItem) {
            // validation for constraint: itemType
            if (!$arrayOfDistributionPointDistributionPointItem instanceof \SGCIS\Struct\DistributionPoint) {
                throw new \InvalidArgumentException(sprintf('The DistributionPoint property can only contain items of \SGCIS\Struct\DistributionPoint, "%s" given', is_object($arrayOfDistributionPointDistributionPointItem) ? get_class($arrayOfDistributionPointDistributionPointItem) : gettype($arrayOfDistributionPointDistributionPointItem)), __LINE__);
            }
        }
        if (is_null($distributionPoint) || (is_array($distributionPoint) && empty($distributionPoint))) {
            unset($this->DistributionPoint);
        } else {
            $this->DistributionPoint = $distributionPoint;
        }
        return $this;
    }
    /**
     * Add item to DistributionPoint value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\DistributionPoint $item
     * @return \SGCIS\Array\ArrayOfDistributionPoint
     */
    public function addToDistributionPoint(\SGCIS\Struct\DistributionPoint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\DistributionPoint) {
            throw new \InvalidArgumentException(sprintf('The DistributionPoint property can only contain items of \SGCIS\Struct\DistributionPoint, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DistributionPoint[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\DistributionPoint|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\DistributionPoint|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\DistributionPoint|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\DistributionPoint|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\DistributionPoint|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DistributionPoint
     */
    public function getAttributeName()
    {
        return 'DistributionPoint';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfDistributionPoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
