<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDataListCacheItem Array
 * @subpackage Arrays
 */
class ArrayOfDataListCacheItem extends AbstractStructArrayBase
{
    /**
     * The DataListCacheItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\DataListCacheItem[]
     */
    public $DataListCacheItem;
    /**
     * Constructor method for ArrayOfDataListCacheItem
     * @uses ArrayOfDataListCacheItem::setDataListCacheItem()
     * @param \SGCIS\Struct\DataListCacheItem[] $dataListCacheItem
     */
    public function __construct(array $dataListCacheItem = array())
    {
        $this
            ->setDataListCacheItem($dataListCacheItem);
    }
    /**
     * Get DataListCacheItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\DataListCacheItem[]|null
     */
    public function getDataListCacheItem()
    {
        return isset($this->DataListCacheItem) ? $this->DataListCacheItem : null;
    }
    /**
     * Set DataListCacheItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\DataListCacheItem[] $dataListCacheItem
     * @return \SGCIS\Array\ArrayOfDataListCacheItem
     */
    public function setDataListCacheItem(array $dataListCacheItem = array())
    {
        foreach ($dataListCacheItem as $arrayOfDataListCacheItemDataListCacheItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfDataListCacheItemDataListCacheItemItem instanceof \SGCIS\Struct\DataListCacheItem) {
                throw new \InvalidArgumentException(sprintf('The DataListCacheItem property can only contain items of \SGCIS\Struct\DataListCacheItem, "%s" given', is_object($arrayOfDataListCacheItemDataListCacheItemItem) ? get_class($arrayOfDataListCacheItemDataListCacheItemItem) : gettype($arrayOfDataListCacheItemDataListCacheItemItem)), __LINE__);
            }
        }
        if (is_null($dataListCacheItem) || (is_array($dataListCacheItem) && empty($dataListCacheItem))) {
            unset($this->DataListCacheItem);
        } else {
            $this->DataListCacheItem = $dataListCacheItem;
        }
        return $this;
    }
    /**
     * Add item to DataListCacheItem value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\DataListCacheItem $item
     * @return \SGCIS\Array\ArrayOfDataListCacheItem
     */
    public function addToDataListCacheItem(\SGCIS\Struct\DataListCacheItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\DataListCacheItem) {
            throw new \InvalidArgumentException(sprintf('The DataListCacheItem property can only contain items of \SGCIS\Struct\DataListCacheItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DataListCacheItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\DataListCacheItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\DataListCacheItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\DataListCacheItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\DataListCacheItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\DataListCacheItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DataListCacheItem
     */
    public function getAttributeName()
    {
        return 'DataListCacheItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfDataListCacheItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
