<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCCHGroupTax Array
 * @subpackage Arrays
 */
class ArrayOfCCHGroupTax extends AbstractStructArrayBase
{
    /**
     * The CCHGroupTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\CCHGroupTax[]
     */
    public $CCHGroupTax;
    /**
     * Constructor method for ArrayOfCCHGroupTax
     * @uses ArrayOfCCHGroupTax::setCCHGroupTax()
     * @param \SGCIS\Struct\CCHGroupTax[] $cCHGroupTax
     */
    public function __construct(array $cCHGroupTax = array())
    {
        $this
            ->setCCHGroupTax($cCHGroupTax);
    }
    /**
     * Get CCHGroupTax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\CCHGroupTax[]|null
     */
    public function getCCHGroupTax()
    {
        return isset($this->CCHGroupTax) ? $this->CCHGroupTax : null;
    }
    /**
     * Set CCHGroupTax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\CCHGroupTax[] $cCHGroupTax
     * @return \SGCIS\Array\ArrayOfCCHGroupTax
     */
    public function setCCHGroupTax(array $cCHGroupTax = array())
    {
        foreach ($cCHGroupTax as $arrayOfCCHGroupTaxCCHGroupTaxItem) {
            // validation for constraint: itemType
            if (!$arrayOfCCHGroupTaxCCHGroupTaxItem instanceof \SGCIS\Struct\CCHGroupTax) {
                throw new \InvalidArgumentException(sprintf('The CCHGroupTax property can only contain items of \SGCIS\Struct\CCHGroupTax, "%s" given', is_object($arrayOfCCHGroupTaxCCHGroupTaxItem) ? get_class($arrayOfCCHGroupTaxCCHGroupTaxItem) : gettype($arrayOfCCHGroupTaxCCHGroupTaxItem)), __LINE__);
            }
        }
        if (is_null($cCHGroupTax) || (is_array($cCHGroupTax) && empty($cCHGroupTax))) {
            unset($this->CCHGroupTax);
        } else {
            $this->CCHGroupTax = $cCHGroupTax;
        }
        return $this;
    }
    /**
     * Add item to CCHGroupTax value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\CCHGroupTax $item
     * @return \SGCIS\Array\ArrayOfCCHGroupTax
     */
    public function addToCCHGroupTax(\SGCIS\Struct\CCHGroupTax $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\CCHGroupTax) {
            throw new \InvalidArgumentException(sprintf('The CCHGroupTax property can only contain items of \SGCIS\Struct\CCHGroupTax, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CCHGroupTax[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\CCHGroupTax|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\CCHGroupTax|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\CCHGroupTax|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\CCHGroupTax|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\CCHGroupTax|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CCHGroupTax
     */
    public function getAttributeName()
    {
        return 'CCHGroupTax';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfCCHGroupTax
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
