<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBillServicePointCharge Array
 * @subpackage Arrays
 */
class ArrayOfBillServicePointCharge extends AbstractStructArrayBase
{
    /**
     * The BillServicePointCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\BillServicePointCharge[]
     */
    public $BillServicePointCharge;
    /**
     * Constructor method for ArrayOfBillServicePointCharge
     * @uses ArrayOfBillServicePointCharge::setBillServicePointCharge()
     * @param \SGCIS\Struct\BillServicePointCharge[] $billServicePointCharge
     */
    public function __construct(array $billServicePointCharge = array())
    {
        $this
            ->setBillServicePointCharge($billServicePointCharge);
    }
    /**
     * Get BillServicePointCharge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\BillServicePointCharge[]|null
     */
    public function getBillServicePointCharge()
    {
        return isset($this->BillServicePointCharge) ? $this->BillServicePointCharge : null;
    }
    /**
     * Set BillServicePointCharge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillServicePointCharge[] $billServicePointCharge
     * @return \SGCIS\Array\ArrayOfBillServicePointCharge
     */
    public function setBillServicePointCharge(array $billServicePointCharge = array())
    {
        foreach ($billServicePointCharge as $arrayOfBillServicePointChargeBillServicePointChargeItem) {
            // validation for constraint: itemType
            if (!$arrayOfBillServicePointChargeBillServicePointChargeItem instanceof \SGCIS\Struct\BillServicePointCharge) {
                throw new \InvalidArgumentException(sprintf('The BillServicePointCharge property can only contain items of \SGCIS\Struct\BillServicePointCharge, "%s" given', is_object($arrayOfBillServicePointChargeBillServicePointChargeItem) ? get_class($arrayOfBillServicePointChargeBillServicePointChargeItem) : gettype($arrayOfBillServicePointChargeBillServicePointChargeItem)), __LINE__);
            }
        }
        if (is_null($billServicePointCharge) || (is_array($billServicePointCharge) && empty($billServicePointCharge))) {
            unset($this->BillServicePointCharge);
        } else {
            $this->BillServicePointCharge = $billServicePointCharge;
        }
        return $this;
    }
    /**
     * Add item to BillServicePointCharge value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillServicePointCharge $item
     * @return \SGCIS\Array\ArrayOfBillServicePointCharge
     */
    public function addToBillServicePointCharge(\SGCIS\Struct\BillServicePointCharge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\BillServicePointCharge) {
            throw new \InvalidArgumentException(sprintf('The BillServicePointCharge property can only contain items of \SGCIS\Struct\BillServicePointCharge, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BillServicePointCharge[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\BillServicePointCharge|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\BillServicePointCharge|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\BillServicePointCharge|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\BillServicePointCharge|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\BillServicePointCharge|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BillServicePointCharge
     */
    public function getAttributeName()
    {
        return 'BillServicePointCharge';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfBillServicePointCharge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
