<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBillBalance Array
 * @subpackage Arrays
 */
class ArrayOfBillBalance extends AbstractStructArrayBase
{
    /**
     * The BillBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\BillBalance[]
     */
    public $BillBalance;
    /**
     * Constructor method for ArrayOfBillBalance
     * @uses ArrayOfBillBalance::setBillBalance()
     * @param \SGCIS\Struct\BillBalance[] $billBalance
     */
    public function __construct(array $billBalance = array())
    {
        $this
            ->setBillBalance($billBalance);
    }
    /**
     * Get BillBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\BillBalance[]|null
     */
    public function getBillBalance()
    {
        return isset($this->BillBalance) ? $this->BillBalance : null;
    }
    /**
     * Set BillBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillBalance[] $billBalance
     * @return \SGCIS\Array\ArrayOfBillBalance
     */
    public function setBillBalance(array $billBalance = array())
    {
        foreach ($billBalance as $arrayOfBillBalanceBillBalanceItem) {
            // validation for constraint: itemType
            if (!$arrayOfBillBalanceBillBalanceItem instanceof \SGCIS\Struct\BillBalance) {
                throw new \InvalidArgumentException(sprintf('The BillBalance property can only contain items of \SGCIS\Struct\BillBalance, "%s" given', is_object($arrayOfBillBalanceBillBalanceItem) ? get_class($arrayOfBillBalanceBillBalanceItem) : gettype($arrayOfBillBalanceBillBalanceItem)), __LINE__);
            }
        }
        if (is_null($billBalance) || (is_array($billBalance) && empty($billBalance))) {
            unset($this->BillBalance);
        } else {
            $this->BillBalance = $billBalance;
        }
        return $this;
    }
    /**
     * Add item to BillBalance value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillBalance $item
     * @return \SGCIS\Array\ArrayOfBillBalance
     */
    public function addToBillBalance(\SGCIS\Struct\BillBalance $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\BillBalance) {
            throw new \InvalidArgumentException(sprintf('The BillBalance property can only contain items of \SGCIS\Struct\BillBalance, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BillBalance[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\BillBalance|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\BillBalance|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\BillBalance|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\BillBalance|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\BillBalance|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BillBalance
     */
    public function getAttributeName()
    {
        return 'BillBalance';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfBillBalance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
