<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityDetailItem Array
 * @subpackage Arrays
 */
class ArrayOfActivityDetailItem extends AbstractStructArrayBase
{
    /**
     * The ActivityDetailItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\ActivityDetailItem[]
     */
    public $ActivityDetailItem;
    /**
     * Constructor method for ArrayOfActivityDetailItem
     * @uses ArrayOfActivityDetailItem::setActivityDetailItem()
     * @param \SGCIS\Struct\ActivityDetailItem[] $activityDetailItem
     */
    public function __construct(array $activityDetailItem = array())
    {
        $this
            ->setActivityDetailItem($activityDetailItem);
    }
    /**
     * Get ActivityDetailItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\ActivityDetailItem[]|null
     */
    public function getActivityDetailItem()
    {
        return isset($this->ActivityDetailItem) ? $this->ActivityDetailItem : null;
    }
    /**
     * Set ActivityDetailItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ActivityDetailItem[] $activityDetailItem
     * @return \SGCIS\Array\ArrayOfActivityDetailItem
     */
    public function setActivityDetailItem(array $activityDetailItem = array())
    {
        foreach ($activityDetailItem as $arrayOfActivityDetailItemActivityDetailItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfActivityDetailItemActivityDetailItemItem instanceof \SGCIS\Struct\ActivityDetailItem) {
                throw new \InvalidArgumentException(sprintf('The ActivityDetailItem property can only contain items of \SGCIS\Struct\ActivityDetailItem, "%s" given', is_object($arrayOfActivityDetailItemActivityDetailItemItem) ? get_class($arrayOfActivityDetailItemActivityDetailItemItem) : gettype($arrayOfActivityDetailItemActivityDetailItemItem)), __LINE__);
            }
        }
        if (is_null($activityDetailItem) || (is_array($activityDetailItem) && empty($activityDetailItem))) {
            unset($this->ActivityDetailItem);
        } else {
            $this->ActivityDetailItem = $activityDetailItem;
        }
        return $this;
    }
    /**
     * Add item to ActivityDetailItem value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ActivityDetailItem $item
     * @return \SGCIS\Array\ArrayOfActivityDetailItem
     */
    public function addToActivityDetailItem(\SGCIS\Struct\ActivityDetailItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\ActivityDetailItem) {
            throw new \InvalidArgumentException(sprintf('The ActivityDetailItem property can only contain items of \SGCIS\Struct\ActivityDetailItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ActivityDetailItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\ActivityDetailItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\ActivityDetailItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\ActivityDetailItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\ActivityDetailItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\ActivityDetailItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityDetailItem
     */
    public function getAttributeName()
    {
        return 'ActivityDetailItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfActivityDetailItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
