<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateProfileRequest Struct
 * @subpackage Structs
 */
class UpdateProfileRequest extends ServiceRequestBase
{
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The ProfileUpdateTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProfileUpdateTypeID;
    /**
     * The PersonID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonID;
    /**
     * The MarketingOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $MarketingOptIn;
    /**
     * The SendDailyNotification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SendDailyNotification;
    /**
     * The SecurityQuestionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SecurityQuestionID;
    /**
     * The AccountAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountAddress
     */
    public $AccountAddress;
    /**
     * The PhoneContacts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfPersonContact
     */
    public $PhoneContacts;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The CurrentPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrentPassword;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The NotificationChannels
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfNotificationChannel
     */
    public $NotificationChannels;
    /**
     * The BillDeliveryMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillDeliveryMethod
     */
    public $BillDeliveryMethod;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The SecurityQuestionAnswer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SecurityQuestionAnswer;
    /**
     * Constructor method for UpdateProfileRequest
     * @uses UpdateProfileRequest::setAccountID()
     * @uses UpdateProfileRequest::setProfileUpdateTypeID()
     * @uses UpdateProfileRequest::setPersonID()
     * @uses UpdateProfileRequest::setMarketingOptIn()
     * @uses UpdateProfileRequest::setSendDailyNotification()
     * @uses UpdateProfileRequest::setSecurityQuestionID()
     * @uses UpdateProfileRequest::setAccountAddress()
     * @uses UpdateProfileRequest::setPhoneContacts()
     * @uses UpdateProfileRequest::setUserName()
     * @uses UpdateProfileRequest::setPassword()
     * @uses UpdateProfileRequest::setCurrentPassword()
     * @uses UpdateProfileRequest::setEmail()
     * @uses UpdateProfileRequest::setNotificationChannels()
     * @uses UpdateProfileRequest::setBillDeliveryMethod()
     * @uses UpdateProfileRequest::setFirstName()
     * @uses UpdateProfileRequest::setLastName()
     * @uses UpdateProfileRequest::setSecurityQuestionAnswer()
     * @param int $accountID
     * @param int $profileUpdateTypeID
     * @param int $personID
     * @param bool $marketingOptIn
     * @param bool $sendDailyNotification
     * @param int $securityQuestionID
     * @param \SGCIS\Struct\AccountAddress $accountAddress
     * @param \SGCIS\Array\ArrayOfPersonContact $phoneContacts
     * @param string $userName
     * @param string $password
     * @param string $currentPassword
     * @param string $email
     * @param \SGCIS\Array\ArrayOfNotificationChannel $notificationChannels
     * @param \SGCIS\Array\ArrayOfBillDeliveryMethod $billDeliveryMethod
     * @param string $firstName
     * @param string $lastName
     * @param string $securityQuestionAnswer
     */
    public function __construct($accountID = null, $profileUpdateTypeID = null, $personID = null, $marketingOptIn = null, $sendDailyNotification = null, $securityQuestionID = null, \SGCIS\Struct\AccountAddress $accountAddress = null, \SGCIS\Array\ArrayOfPersonContact $phoneContacts = null, $userName = null, $password = null, $currentPassword = null, $email = null, \SGCIS\Array\ArrayOfNotificationChannel $notificationChannels = null, \SGCIS\Array\ArrayOfBillDeliveryMethod $billDeliveryMethod = null, $firstName = null, $lastName = null, $securityQuestionAnswer = null)
    {
        $this
            ->setAccountID($accountID)
            ->setProfileUpdateTypeID($profileUpdateTypeID)
            ->setPersonID($personID)
            ->setMarketingOptIn($marketingOptIn)
            ->setSendDailyNotification($sendDailyNotification)
            ->setSecurityQuestionID($securityQuestionID)
            ->setAccountAddress($accountAddress)
            ->setPhoneContacts($phoneContacts)
            ->setUserName($userName)
            ->setPassword($password)
            ->setCurrentPassword($currentPassword)
            ->setEmail($email)
            ->setNotificationChannels($notificationChannels)
            ->setBillDeliveryMethod($billDeliveryMethod)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setSecurityQuestionAnswer($securityQuestionAnswer);
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\UpdateProfileRequest
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get ProfileUpdateTypeID value
     * @return int
     */
    public function getProfileUpdateTypeID()
    {
        return $this->ProfileUpdateTypeID;
    }
    /**
     * Set ProfileUpdateTypeID value
     * @param int $profileUpdateTypeID
     * @return \SGCIS\Struct\UpdateProfileRequest
     */
    public function setProfileUpdateTypeID($profileUpdateTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($profileUpdateTypeID) && !is_numeric($profileUpdateTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileUpdateTypeID)), __LINE__);
        }
        $this->ProfileUpdateTypeID = $profileUpdateTypeID;
        return $this;
    }
    /**
     * Get PersonID value
     * @return int
     */
    public function getPersonID()
    {
        return $this->PersonID;
    }
    /**
     * Set PersonID value
     * @param int $personID
     * @return \SGCIS\Struct\UpdateProfileRequest
     */
    public function setPersonID($personID = null)
    {
        // validation for constraint: int
        if (!is_null($personID) && !is_numeric($personID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personID)), __LINE__);
        }
        $this->PersonID = $personID;
        return $this;
    }
    /**
     * Get MarketingOptIn value
     * @return bool
     */
    public function getMarketingOptIn()
    {
        return $this->MarketingOptIn;
    }
    /**
     * Set MarketingOptIn value
     * @param bool $marketingOptIn
     * @return \SGCIS\Struct\UpdateProfileRequest
     */
    public function setMarketingOptIn($marketingOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($marketingOptIn) && !is_bool($marketingOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($marketingOptIn)), __LINE__);
        }
        $this->MarketingOptIn = $marketingOptIn;
        return $this;
    }
    /**
     * Get SendDailyNotification value
     * @return bool
     */
    public function getSendDailyNotification()
    {
        return $this->SendDailyNotification;
    }
    /**
     * Set SendDailyNotification value
     * @param bool $sendDailyNotification
     * @return \SGCIS\Struct\UpdateProfileRequest
     */
    public function setSendDailyNotification($sendDailyNotification = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendDailyNotification) && !is_bool($sendDailyNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sendDailyNotification)), __LINE__);
        }
        $this->SendDailyNotification = $sendDailyNotification;
        return $this;
    }
    /**
     * Get SecurityQuestionID value
     * @return int
     */
    public function getSecurityQuestionID()
    {
        return $this->SecurityQuestionID;
    }
    /**
     * Set SecurityQuestionID value
     * @param int $securityQuestionID
     * @return \SGCIS\Struct\UpdateProfileRequest
     */
    public function setSecurityQuestionID($securityQuestionID = null)
    {
        // validation for constraint: int
        if (!is_null($securityQuestionID) && !is_numeric($securityQuestionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($securityQuestionID)), __LINE__);
        }
        $this->SecurityQuestionID = $securityQuestionID;
        return $this;
    }
    /**
     * Get AccountAddress value
     * @return \SGCIS\Struct\AccountAddress|null
     */
    public function getAccountAddress()
    {
        return $this->AccountAddress;
    }
    /**
     * Set AccountAddress value
     * @param \SGCIS\Struct\AccountAddress $accountAddress
     * @return \SGCIS\Struct\UpdateProfileRequest
     */
    public function setAccountAddress(\SGCIS\Struct\AccountAddress $accountAddress = null)
    {
        $this->AccountAddress = $accountAddress;
        return $this;
    }
    /**
     * Get PhoneContacts value
     * @return \SGCIS\Array\ArrayOfPersonContact|null
     */
    public function getPhoneContacts()
    {
        return $this->PhoneContacts;
    }
    /**
     * Set PhoneContacts value
     * @param \SGCIS\Array\ArrayOfPersonContact $phoneContacts
     * @return \SGCIS\Struct\UpdateProfileRequest
     */
    public function setPhoneContacts(\SGCIS\Array\ArrayOfPersonContact $phoneContacts = null)
    {
        $this->PhoneContacts = $phoneContacts;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \SGCIS\Struct\UpdateProfileRequest
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \SGCIS\Struct\UpdateProfileRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get CurrentPassword value
     * @return string|null
     */
    public function getCurrentPassword()
    {
        return $this->CurrentPassword;
    }
    /**
     * Set CurrentPassword value
     * @param string $currentPassword
     * @return \SGCIS\Struct\UpdateProfileRequest
     */
    public function setCurrentPassword($currentPassword = null)
    {
        // validation for constraint: string
        if (!is_null($currentPassword) && !is_string($currentPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currentPassword)), __LINE__);
        }
        $this->CurrentPassword = $currentPassword;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \SGCIS\Struct\UpdateProfileRequest
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get NotificationChannels value
     * @return \SGCIS\Array\ArrayOfNotificationChannel|null
     */
    public function getNotificationChannels()
    {
        return $this->NotificationChannels;
    }
    /**
     * Set NotificationChannels value
     * @param \SGCIS\Array\ArrayOfNotificationChannel $notificationChannels
     * @return \SGCIS\Struct\UpdateProfileRequest
     */
    public function setNotificationChannels(\SGCIS\Array\ArrayOfNotificationChannel $notificationChannels = null)
    {
        $this->NotificationChannels = $notificationChannels;
        return $this;
    }
    /**
     * Get BillDeliveryMethod value
     * @return \SGCIS\Array\ArrayOfBillDeliveryMethod|null
     */
    public function getBillDeliveryMethod()
    {
        return $this->BillDeliveryMethod;
    }
    /**
     * Set BillDeliveryMethod value
     * @param \SGCIS\Array\ArrayOfBillDeliveryMethod $billDeliveryMethod
     * @return \SGCIS\Struct\UpdateProfileRequest
     */
    public function setBillDeliveryMethod(\SGCIS\Array\ArrayOfBillDeliveryMethod $billDeliveryMethod = null)
    {
        $this->BillDeliveryMethod = $billDeliveryMethod;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \SGCIS\Struct\UpdateProfileRequest
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \SGCIS\Struct\UpdateProfileRequest
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get SecurityQuestionAnswer value
     * @return string|null
     */
    public function getSecurityQuestionAnswer()
    {
        return $this->SecurityQuestionAnswer;
    }
    /**
     * Set SecurityQuestionAnswer value
     * @param string $securityQuestionAnswer
     * @return \SGCIS\Struct\UpdateProfileRequest
     */
    public function setSecurityQuestionAnswer($securityQuestionAnswer = null)
    {
        // validation for constraint: string
        if (!is_null($securityQuestionAnswer) && !is_string($securityQuestionAnswer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($securityQuestionAnswer)), __LINE__);
        }
        $this->SecurityQuestionAnswer = $securityQuestionAnswer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\UpdateProfileRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
