<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionNotImported Struct
 * @subpackage Structs
 */
class TransactionNotImported extends AbstractStructBase
{
    /**
     * The InvoiceImportID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceImportID;
    /**
     * The MarketTransactionImportID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MarketTransactionImportID;
    /**
     * The InvoiceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceID;
    /**
     * The AmountDue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmountDue;
    /**
     * The PeriodStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PeriodStartDate;
    /**
     * The PeriodEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PeriodEndDate;
    /**
     * The TransactionDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TransactionDate;
    /**
     * The MarketID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarketID;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The Purpose
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Purpose;
    /**
     * The SubPurpose
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubPurpose;
    /**
     * The DocumentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentType;
    /**
     * The OriginalDocumentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OriginalDocumentID;
    /**
     * Constructor method for TransactionNotImported
     * @uses TransactionNotImported::setInvoiceImportID()
     * @uses TransactionNotImported::setMarketTransactionImportID()
     * @uses TransactionNotImported::setInvoiceID()
     * @uses TransactionNotImported::setAmountDue()
     * @uses TransactionNotImported::setPeriodStartDate()
     * @uses TransactionNotImported::setPeriodEndDate()
     * @uses TransactionNotImported::setTransactionDate()
     * @uses TransactionNotImported::setMarketID()
     * @uses TransactionNotImported::setErrorMessage()
     * @uses TransactionNotImported::setPurpose()
     * @uses TransactionNotImported::setSubPurpose()
     * @uses TransactionNotImported::setDocumentType()
     * @uses TransactionNotImported::setOriginalDocumentID()
     * @param int $invoiceImportID
     * @param int $marketTransactionImportID
     * @param int $invoiceID
     * @param float $amountDue
     * @param string $periodStartDate
     * @param string $periodEndDate
     * @param string $transactionDate
     * @param string $marketID
     * @param string $errorMessage
     * @param string $purpose
     * @param string $subPurpose
     * @param string $documentType
     * @param string $originalDocumentID
     */
    public function __construct($invoiceImportID = null, $marketTransactionImportID = null, $invoiceID = null, $amountDue = null, $periodStartDate = null, $periodEndDate = null, $transactionDate = null, $marketID = null, $errorMessage = null, $purpose = null, $subPurpose = null, $documentType = null, $originalDocumentID = null)
    {
        $this
            ->setInvoiceImportID($invoiceImportID)
            ->setMarketTransactionImportID($marketTransactionImportID)
            ->setInvoiceID($invoiceID)
            ->setAmountDue($amountDue)
            ->setPeriodStartDate($periodStartDate)
            ->setPeriodEndDate($periodEndDate)
            ->setTransactionDate($transactionDate)
            ->setMarketID($marketID)
            ->setErrorMessage($errorMessage)
            ->setPurpose($purpose)
            ->setSubPurpose($subPurpose)
            ->setDocumentType($documentType)
            ->setOriginalDocumentID($originalDocumentID);
    }
    /**
     * Get InvoiceImportID value
     * @return int
     */
    public function getInvoiceImportID()
    {
        return $this->InvoiceImportID;
    }
    /**
     * Set InvoiceImportID value
     * @param int $invoiceImportID
     * @return \SGCIS\Struct\TransactionNotImported
     */
    public function setInvoiceImportID($invoiceImportID = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceImportID) && !is_numeric($invoiceImportID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($invoiceImportID)), __LINE__);
        }
        $this->InvoiceImportID = $invoiceImportID;
        return $this;
    }
    /**
     * Get MarketTransactionImportID value
     * @return int
     */
    public function getMarketTransactionImportID()
    {
        return $this->MarketTransactionImportID;
    }
    /**
     * Set MarketTransactionImportID value
     * @param int $marketTransactionImportID
     * @return \SGCIS\Struct\TransactionNotImported
     */
    public function setMarketTransactionImportID($marketTransactionImportID = null)
    {
        // validation for constraint: int
        if (!is_null($marketTransactionImportID) && !is_numeric($marketTransactionImportID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($marketTransactionImportID)), __LINE__);
        }
        $this->MarketTransactionImportID = $marketTransactionImportID;
        return $this;
    }
    /**
     * Get InvoiceID value
     * @return int
     */
    public function getInvoiceID()
    {
        return $this->InvoiceID;
    }
    /**
     * Set InvoiceID value
     * @param int $invoiceID
     * @return \SGCIS\Struct\TransactionNotImported
     */
    public function setInvoiceID($invoiceID = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceID) && !is_numeric($invoiceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($invoiceID)), __LINE__);
        }
        $this->InvoiceID = $invoiceID;
        return $this;
    }
    /**
     * Get AmountDue value
     * @return float
     */
    public function getAmountDue()
    {
        return $this->AmountDue;
    }
    /**
     * Set AmountDue value
     * @param float $amountDue
     * @return \SGCIS\Struct\TransactionNotImported
     */
    public function setAmountDue($amountDue = null)
    {
        $this->AmountDue = $amountDue;
        return $this;
    }
    /**
     * Get PeriodStartDate value
     * @return string
     */
    public function getPeriodStartDate()
    {
        return $this->PeriodStartDate;
    }
    /**
     * Set PeriodStartDate value
     * @param string $periodStartDate
     * @return \SGCIS\Struct\TransactionNotImported
     */
    public function setPeriodStartDate($periodStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($periodStartDate) && !is_string($periodStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($periodStartDate)), __LINE__);
        }
        $this->PeriodStartDate = $periodStartDate;
        return $this;
    }
    /**
     * Get PeriodEndDate value
     * @return string
     */
    public function getPeriodEndDate()
    {
        return $this->PeriodEndDate;
    }
    /**
     * Set PeriodEndDate value
     * @param string $periodEndDate
     * @return \SGCIS\Struct\TransactionNotImported
     */
    public function setPeriodEndDate($periodEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($periodEndDate) && !is_string($periodEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($periodEndDate)), __LINE__);
        }
        $this->PeriodEndDate = $periodEndDate;
        return $this;
    }
    /**
     * Get TransactionDate value
     * @return string
     */
    public function getTransactionDate()
    {
        return $this->TransactionDate;
    }
    /**
     * Set TransactionDate value
     * @param string $transactionDate
     * @return \SGCIS\Struct\TransactionNotImported
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionDate)), __LINE__);
        }
        $this->TransactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get MarketID value
     * @return string|null
     */
    public function getMarketID()
    {
        return $this->MarketID;
    }
    /**
     * Set MarketID value
     * @param string $marketID
     * @return \SGCIS\Struct\TransactionNotImported
     */
    public function setMarketID($marketID = null)
    {
        // validation for constraint: string
        if (!is_null($marketID) && !is_string($marketID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marketID)), __LINE__);
        }
        $this->MarketID = $marketID;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \SGCIS\Struct\TransactionNotImported
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get Purpose value
     * @return string|null
     */
    public function getPurpose()
    {
        return $this->Purpose;
    }
    /**
     * Set Purpose value
     * @param string $purpose
     * @return \SGCIS\Struct\TransactionNotImported
     */
    public function setPurpose($purpose = null)
    {
        // validation for constraint: string
        if (!is_null($purpose) && !is_string($purpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($purpose)), __LINE__);
        }
        $this->Purpose = $purpose;
        return $this;
    }
    /**
     * Get SubPurpose value
     * @return string|null
     */
    public function getSubPurpose()
    {
        return $this->SubPurpose;
    }
    /**
     * Set SubPurpose value
     * @param string $subPurpose
     * @return \SGCIS\Struct\TransactionNotImported
     */
    public function setSubPurpose($subPurpose = null)
    {
        // validation for constraint: string
        if (!is_null($subPurpose) && !is_string($subPurpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subPurpose)), __LINE__);
        }
        $this->SubPurpose = $subPurpose;
        return $this;
    }
    /**
     * Get DocumentType value
     * @return string|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @param string $documentType
     * @return \SGCIS\Struct\TransactionNotImported
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: string
        if (!is_null($documentType) && !is_string($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentType)), __LINE__);
        }
        $this->DocumentType = $documentType;
        return $this;
    }
    /**
     * Get OriginalDocumentID value
     * @return string|null
     */
    public function getOriginalDocumentID()
    {
        return $this->OriginalDocumentID;
    }
    /**
     * Set OriginalDocumentID value
     * @param string $originalDocumentID
     * @return \SGCIS\Struct\TransactionNotImported
     */
    public function setOriginalDocumentID($originalDocumentID = null)
    {
        // validation for constraint: string
        if (!is_null($originalDocumentID) && !is_string($originalDocumentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originalDocumentID)), __LINE__);
        }
        $this->OriginalDocumentID = $originalDocumentID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\TransactionNotImported
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
