<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemRoleApplicationWidget Struct
 * @subpackage Structs
 */
class SystemRoleApplicationWidget extends AbstractStructBase
{
    /**
     * The SystemRoleApplicationWidgetID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemRoleApplicationWidgetID;
    /**
     * The SystemRoleApplicationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemRoleApplicationID;
    /**
     * The DashboardGalleryWidgetId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DashboardGalleryWidgetId;
    /**
     * The ApplicationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApplicationName;
    /**
     * The WidgetName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WidgetName;
    /**
     * The WidgetDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WidgetDescription;
    /**
     * The DashboardGalleryWidget
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\DashboardGalleryWidget
     */
    public $DashboardGalleryWidget;
    /**
     * Constructor method for SystemRoleApplicationWidget
     * @uses SystemRoleApplicationWidget::setSystemRoleApplicationWidgetID()
     * @uses SystemRoleApplicationWidget::setSystemRoleApplicationID()
     * @uses SystemRoleApplicationWidget::setDashboardGalleryWidgetId()
     * @uses SystemRoleApplicationWidget::setApplicationName()
     * @uses SystemRoleApplicationWidget::setWidgetName()
     * @uses SystemRoleApplicationWidget::setWidgetDescription()
     * @uses SystemRoleApplicationWidget::setDashboardGalleryWidget()
     * @param int $systemRoleApplicationWidgetID
     * @param int $systemRoleApplicationID
     * @param int $dashboardGalleryWidgetId
     * @param string $applicationName
     * @param string $widgetName
     * @param string $widgetDescription
     * @param \SGCIS\Struct\DashboardGalleryWidget $dashboardGalleryWidget
     */
    public function __construct($systemRoleApplicationWidgetID = null, $systemRoleApplicationID = null, $dashboardGalleryWidgetId = null, $applicationName = null, $widgetName = null, $widgetDescription = null, \SGCIS\Struct\DashboardGalleryWidget $dashboardGalleryWidget = null)
    {
        $this
            ->setSystemRoleApplicationWidgetID($systemRoleApplicationWidgetID)
            ->setSystemRoleApplicationID($systemRoleApplicationID)
            ->setDashboardGalleryWidgetId($dashboardGalleryWidgetId)
            ->setApplicationName($applicationName)
            ->setWidgetName($widgetName)
            ->setWidgetDescription($widgetDescription)
            ->setDashboardGalleryWidget($dashboardGalleryWidget);
    }
    /**
     * Get SystemRoleApplicationWidgetID value
     * @return int
     */
    public function getSystemRoleApplicationWidgetID()
    {
        return $this->SystemRoleApplicationWidgetID;
    }
    /**
     * Set SystemRoleApplicationWidgetID value
     * @param int $systemRoleApplicationWidgetID
     * @return \SGCIS\Struct\SystemRoleApplicationWidget
     */
    public function setSystemRoleApplicationWidgetID($systemRoleApplicationWidgetID = null)
    {
        // validation for constraint: int
        if (!is_null($systemRoleApplicationWidgetID) && !is_numeric($systemRoleApplicationWidgetID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemRoleApplicationWidgetID)), __LINE__);
        }
        $this->SystemRoleApplicationWidgetID = $systemRoleApplicationWidgetID;
        return $this;
    }
    /**
     * Get SystemRoleApplicationID value
     * @return int
     */
    public function getSystemRoleApplicationID()
    {
        return $this->SystemRoleApplicationID;
    }
    /**
     * Set SystemRoleApplicationID value
     * @param int $systemRoleApplicationID
     * @return \SGCIS\Struct\SystemRoleApplicationWidget
     */
    public function setSystemRoleApplicationID($systemRoleApplicationID = null)
    {
        // validation for constraint: int
        if (!is_null($systemRoleApplicationID) && !is_numeric($systemRoleApplicationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemRoleApplicationID)), __LINE__);
        }
        $this->SystemRoleApplicationID = $systemRoleApplicationID;
        return $this;
    }
    /**
     * Get DashboardGalleryWidgetId value
     * @return int
     */
    public function getDashboardGalleryWidgetId()
    {
        return $this->DashboardGalleryWidgetId;
    }
    /**
     * Set DashboardGalleryWidgetId value
     * @param int $dashboardGalleryWidgetId
     * @return \SGCIS\Struct\SystemRoleApplicationWidget
     */
    public function setDashboardGalleryWidgetId($dashboardGalleryWidgetId = null)
    {
        // validation for constraint: int
        if (!is_null($dashboardGalleryWidgetId) && !is_numeric($dashboardGalleryWidgetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dashboardGalleryWidgetId)), __LINE__);
        }
        $this->DashboardGalleryWidgetId = $dashboardGalleryWidgetId;
        return $this;
    }
    /**
     * Get ApplicationName value
     * @return string|null
     */
    public function getApplicationName()
    {
        return $this->ApplicationName;
    }
    /**
     * Set ApplicationName value
     * @param string $applicationName
     * @return \SGCIS\Struct\SystemRoleApplicationWidget
     */
    public function setApplicationName($applicationName = null)
    {
        // validation for constraint: string
        if (!is_null($applicationName) && !is_string($applicationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationName)), __LINE__);
        }
        $this->ApplicationName = $applicationName;
        return $this;
    }
    /**
     * Get WidgetName value
     * @return string|null
     */
    public function getWidgetName()
    {
        return $this->WidgetName;
    }
    /**
     * Set WidgetName value
     * @param string $widgetName
     * @return \SGCIS\Struct\SystemRoleApplicationWidget
     */
    public function setWidgetName($widgetName = null)
    {
        // validation for constraint: string
        if (!is_null($widgetName) && !is_string($widgetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($widgetName)), __LINE__);
        }
        $this->WidgetName = $widgetName;
        return $this;
    }
    /**
     * Get WidgetDescription value
     * @return string|null
     */
    public function getWidgetDescription()
    {
        return $this->WidgetDescription;
    }
    /**
     * Set WidgetDescription value
     * @param string $widgetDescription
     * @return \SGCIS\Struct\SystemRoleApplicationWidget
     */
    public function setWidgetDescription($widgetDescription = null)
    {
        // validation for constraint: string
        if (!is_null($widgetDescription) && !is_string($widgetDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($widgetDescription)), __LINE__);
        }
        $this->WidgetDescription = $widgetDescription;
        return $this;
    }
    /**
     * Get DashboardGalleryWidget value
     * @return \SGCIS\Struct\DashboardGalleryWidget|null
     */
    public function getDashboardGalleryWidget()
    {
        return $this->DashboardGalleryWidget;
    }
    /**
     * Set DashboardGalleryWidget value
     * @param \SGCIS\Struct\DashboardGalleryWidget $dashboardGalleryWidget
     * @return \SGCIS\Struct\SystemRoleApplicationWidget
     */
    public function setDashboardGalleryWidget(\SGCIS\Struct\DashboardGalleryWidget $dashboardGalleryWidget = null)
    {
        $this->DashboardGalleryWidget = $dashboardGalleryWidget;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\SystemRoleApplicationWidget
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
