<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SimpleAccountLookupResponse Struct
 * @subpackage Structs
 */
class SimpleAccountLookupResponse extends ServiceResponseBase
{
    /**
     * The AccountValid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AccountValid;
    /**
     * The Balance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Balance;
    /**
     * The DaysRemaining
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DaysRemaining;
    /**
     * The LastPaymentAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $LastPaymentAmount;
    /**
     * The LastPaymentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastPaymentDate;
    /**
     * The PastDueAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PastDueAmount;
    /**
     * The Prepaid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Prepaid;
    /**
     * The ProductTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductTypeID;
    /**
     * The RecommendedPaymentAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $RecommendedPaymentAmount;
    /**
     * The IsCashOnly
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCashOnly;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The ProductName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductName;
    /**
     * Constructor method for SimpleAccountLookupResponse
     * @uses SimpleAccountLookupResponse::setAccountValid()
     * @uses SimpleAccountLookupResponse::setBalance()
     * @uses SimpleAccountLookupResponse::setDaysRemaining()
     * @uses SimpleAccountLookupResponse::setLastPaymentAmount()
     * @uses SimpleAccountLookupResponse::setLastPaymentDate()
     * @uses SimpleAccountLookupResponse::setPastDueAmount()
     * @uses SimpleAccountLookupResponse::setPrepaid()
     * @uses SimpleAccountLookupResponse::setProductTypeID()
     * @uses SimpleAccountLookupResponse::setRecommendedPaymentAmount()
     * @uses SimpleAccountLookupResponse::setIsCashOnly()
     * @uses SimpleAccountLookupResponse::setAccountNumber()
     * @uses SimpleAccountLookupResponse::setPostalCode()
     * @uses SimpleAccountLookupResponse::setProductName()
     * @param bool $accountValid
     * @param float $balance
     * @param float $daysRemaining
     * @param float $lastPaymentAmount
     * @param string $lastPaymentDate
     * @param float $pastDueAmount
     * @param bool $prepaid
     * @param int $productTypeID
     * @param float $recommendedPaymentAmount
     * @param bool $isCashOnly
     * @param string $accountNumber
     * @param string $postalCode
     * @param string $productName
     */
    public function __construct($accountValid = null, $balance = null, $daysRemaining = null, $lastPaymentAmount = null, $lastPaymentDate = null, $pastDueAmount = null, $prepaid = null, $productTypeID = null, $recommendedPaymentAmount = null, $isCashOnly = null, $accountNumber = null, $postalCode = null, $productName = null)
    {
        $this
            ->setAccountValid($accountValid)
            ->setBalance($balance)
            ->setDaysRemaining($daysRemaining)
            ->setLastPaymentAmount($lastPaymentAmount)
            ->setLastPaymentDate($lastPaymentDate)
            ->setPastDueAmount($pastDueAmount)
            ->setPrepaid($prepaid)
            ->setProductTypeID($productTypeID)
            ->setRecommendedPaymentAmount($recommendedPaymentAmount)
            ->setIsCashOnly($isCashOnly)
            ->setAccountNumber($accountNumber)
            ->setPostalCode($postalCode)
            ->setProductName($productName);
    }
    /**
     * Get AccountValid value
     * @return bool
     */
    public function getAccountValid()
    {
        return $this->AccountValid;
    }
    /**
     * Set AccountValid value
     * @param bool $accountValid
     * @return \SGCIS\Struct\SimpleAccountLookupResponse
     */
    public function setAccountValid($accountValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($accountValid) && !is_bool($accountValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($accountValid)), __LINE__);
        }
        $this->AccountValid = $accountValid;
        return $this;
    }
    /**
     * Get Balance value
     * @return float
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param float $balance
     * @return \SGCIS\Struct\SimpleAccountLookupResponse
     */
    public function setBalance($balance = null)
    {
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get DaysRemaining value
     * @return float
     */
    public function getDaysRemaining()
    {
        return $this->DaysRemaining;
    }
    /**
     * Set DaysRemaining value
     * @param float $daysRemaining
     * @return \SGCIS\Struct\SimpleAccountLookupResponse
     */
    public function setDaysRemaining($daysRemaining = null)
    {
        $this->DaysRemaining = $daysRemaining;
        return $this;
    }
    /**
     * Get LastPaymentAmount value
     * @return float
     */
    public function getLastPaymentAmount()
    {
        return $this->LastPaymentAmount;
    }
    /**
     * Set LastPaymentAmount value
     * @param float $lastPaymentAmount
     * @return \SGCIS\Struct\SimpleAccountLookupResponse
     */
    public function setLastPaymentAmount($lastPaymentAmount = null)
    {
        $this->LastPaymentAmount = $lastPaymentAmount;
        return $this;
    }
    /**
     * Get LastPaymentDate value
     * @return string
     */
    public function getLastPaymentDate()
    {
        return $this->LastPaymentDate;
    }
    /**
     * Set LastPaymentDate value
     * @param string $lastPaymentDate
     * @return \SGCIS\Struct\SimpleAccountLookupResponse
     */
    public function setLastPaymentDate($lastPaymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastPaymentDate) && !is_string($lastPaymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastPaymentDate)), __LINE__);
        }
        $this->LastPaymentDate = $lastPaymentDate;
        return $this;
    }
    /**
     * Get PastDueAmount value
     * @return float
     */
    public function getPastDueAmount()
    {
        return $this->PastDueAmount;
    }
    /**
     * Set PastDueAmount value
     * @param float $pastDueAmount
     * @return \SGCIS\Struct\SimpleAccountLookupResponse
     */
    public function setPastDueAmount($pastDueAmount = null)
    {
        $this->PastDueAmount = $pastDueAmount;
        return $this;
    }
    /**
     * Get Prepaid value
     * @return bool
     */
    public function getPrepaid()
    {
        return $this->Prepaid;
    }
    /**
     * Set Prepaid value
     * @param bool $prepaid
     * @return \SGCIS\Struct\SimpleAccountLookupResponse
     */
    public function setPrepaid($prepaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($prepaid) && !is_bool($prepaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($prepaid)), __LINE__);
        }
        $this->Prepaid = $prepaid;
        return $this;
    }
    /**
     * Get ProductTypeID value
     * @return int
     */
    public function getProductTypeID()
    {
        return $this->ProductTypeID;
    }
    /**
     * Set ProductTypeID value
     * @param int $productTypeID
     * @return \SGCIS\Struct\SimpleAccountLookupResponse
     */
    public function setProductTypeID($productTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($productTypeID) && !is_numeric($productTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productTypeID)), __LINE__);
        }
        $this->ProductTypeID = $productTypeID;
        return $this;
    }
    /**
     * Get RecommendedPaymentAmount value
     * @return float
     */
    public function getRecommendedPaymentAmount()
    {
        return $this->RecommendedPaymentAmount;
    }
    /**
     * Set RecommendedPaymentAmount value
     * @param float $recommendedPaymentAmount
     * @return \SGCIS\Struct\SimpleAccountLookupResponse
     */
    public function setRecommendedPaymentAmount($recommendedPaymentAmount = null)
    {
        $this->RecommendedPaymentAmount = $recommendedPaymentAmount;
        return $this;
    }
    /**
     * Get IsCashOnly value
     * @return bool
     */
    public function getIsCashOnly()
    {
        return $this->IsCashOnly;
    }
    /**
     * Set IsCashOnly value
     * @param bool $isCashOnly
     * @return \SGCIS\Struct\SimpleAccountLookupResponse
     */
    public function setIsCashOnly($isCashOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCashOnly) && !is_bool($isCashOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCashOnly)), __LINE__);
        }
        $this->IsCashOnly = $isCashOnly;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\SimpleAccountLookupResponse
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \SGCIS\Struct\SimpleAccountLookupResponse
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \SGCIS\Struct\SimpleAccountLookupResponse
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\SimpleAccountLookupResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
