<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceRequestBase Struct
 * @subpackage Structs
 */
class ServiceRequestBase extends AbstractStructBase
{
    /**
     * The LanguageID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LanguageID;
    /**
     * The SourceRequestId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SourceRequestId;
    /**
     * The AuthenticationHeader
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AuthenticationHeader
     */
    public $AuthenticationHeader;
    /**
     * The CorrelationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CorrelationID;
    /**
     * Constructor method for ServiceRequestBase
     * @uses ServiceRequestBase::setLanguageID()
     * @uses ServiceRequestBase::setSourceRequestId()
     * @uses ServiceRequestBase::setAuthenticationHeader()
     * @uses ServiceRequestBase::setCorrelationID()
     * @param int $languageID
     * @param int $sourceRequestId
     * @param \SGCIS\Struct\AuthenticationHeader $authenticationHeader
     * @param string $correlationID
     */
    public function __construct($languageID = null, $sourceRequestId = null, \SGCIS\Struct\AuthenticationHeader $authenticationHeader = null, $correlationID = null)
    {
        $this
            ->setLanguageID($languageID)
            ->setSourceRequestId($sourceRequestId)
            ->setAuthenticationHeader($authenticationHeader)
            ->setCorrelationID($correlationID);
    }
    /**
     * Get LanguageID value
     * @return int
     */
    public function getLanguageID()
    {
        return $this->LanguageID;
    }
    /**
     * Set LanguageID value
     * @param int $languageID
     * @return \SGCIS\Struct\ServiceRequestBase
     */
    public function setLanguageID($languageID = null)
    {
        // validation for constraint: int
        if (!is_null($languageID) && !is_numeric($languageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($languageID)), __LINE__);
        }
        $this->LanguageID = $languageID;
        return $this;
    }
    /**
     * Get SourceRequestId value
     * @return int
     */
    public function getSourceRequestId()
    {
        return $this->SourceRequestId;
    }
    /**
     * Set SourceRequestId value
     * @param int $sourceRequestId
     * @return \SGCIS\Struct\ServiceRequestBase
     */
    public function setSourceRequestId($sourceRequestId = null)
    {
        // validation for constraint: int
        if (!is_null($sourceRequestId) && !is_numeric($sourceRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sourceRequestId)), __LINE__);
        }
        $this->SourceRequestId = $sourceRequestId;
        return $this;
    }
    /**
     * Get AuthenticationHeader value
     * @return \SGCIS\Struct\AuthenticationHeader|null
     */
    public function getAuthenticationHeader()
    {
        return $this->AuthenticationHeader;
    }
    /**
     * Set AuthenticationHeader value
     * @param \SGCIS\Struct\AuthenticationHeader $authenticationHeader
     * @return \SGCIS\Struct\ServiceRequestBase
     */
    public function setAuthenticationHeader(\SGCIS\Struct\AuthenticationHeader $authenticationHeader = null)
    {
        $this->AuthenticationHeader = $authenticationHeader;
        return $this;
    }
    /**
     * Get CorrelationID value
     * @return string|null
     */
    public function getCorrelationID()
    {
        return $this->CorrelationID;
    }
    /**
     * Set CorrelationID value
     * @param string $correlationID
     * @return \SGCIS\Struct\ServiceRequestBase
     */
    public function setCorrelationID($correlationID = null)
    {
        // validation for constraint: string
        if (!is_null($correlationID) && !is_string($correlationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($correlationID)), __LINE__);
        }
        $this->CorrelationID = $correlationID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ServiceRequestBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
