<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServicePointMeterReadDetail Struct
 * @subpackage Structs
 */
class ServicePointMeterReadDetail extends AbstractStructBase
{
    /**
     * The ServicePointMeterReadID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServicePointMeterReadID;
    /**
     * The ServicePointMeterReadDetailID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServicePointMeterReadDetailID;
    /**
     * The Consumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Consumption;
    /**
     * The EstimatedConsumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $EstimatedConsumption;
    /**
     * The ActualConsumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ActualConsumption;
    /**
     * The ServicePointMeterID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServicePointMeterID;
    /**
     * The ReadDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReadDate;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The AccountServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountServicePointID;
    /**
     * The CurrentRegisterValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CurrentRegisterValue;
    /**
     * The PreviousRegisterValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PreviousRegisterValue;
    /**
     * The Rate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Rate;
    /**
     * The RateDiscounted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $RateDiscounted;
    /**
     * The ConsumptionDollars
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ConsumptionDollars;
    /**
     * The ConsumptionDollarsDiscounted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ConsumptionDollarsDiscounted;
    /**
     * The IsVEEData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsVEEData;
    /**
     * The isActualRead
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isActualRead;
    /**
     * The RateCalculationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RateCalculationID;
    /**
     * The ChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeID;
    /**
     * The TOUChargeValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TOUChargeValue;
    /**
     * The ReadTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReadTime;
    /**
     * The VolumetricChargeCodeStr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VolumetricChargeCodeStr;
    /**
     * The IntervalStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntervalStatus;
    /**
     * The AccountServicePoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountServicePoint
     */
    public $AccountServicePoint;
    /**
     * Constructor method for ServicePointMeterReadDetail
     * @uses ServicePointMeterReadDetail::setServicePointMeterReadID()
     * @uses ServicePointMeterReadDetail::setServicePointMeterReadDetailID()
     * @uses ServicePointMeterReadDetail::setConsumption()
     * @uses ServicePointMeterReadDetail::setEstimatedConsumption()
     * @uses ServicePointMeterReadDetail::setActualConsumption()
     * @uses ServicePointMeterReadDetail::setServicePointMeterID()
     * @uses ServicePointMeterReadDetail::setReadDate()
     * @uses ServicePointMeterReadDetail::setAccountID()
     * @uses ServicePointMeterReadDetail::setAccountServicePointID()
     * @uses ServicePointMeterReadDetail::setCurrentRegisterValue()
     * @uses ServicePointMeterReadDetail::setPreviousRegisterValue()
     * @uses ServicePointMeterReadDetail::setRate()
     * @uses ServicePointMeterReadDetail::setRateDiscounted()
     * @uses ServicePointMeterReadDetail::setConsumptionDollars()
     * @uses ServicePointMeterReadDetail::setConsumptionDollarsDiscounted()
     * @uses ServicePointMeterReadDetail::setIsVEEData()
     * @uses ServicePointMeterReadDetail::setIsActualRead()
     * @uses ServicePointMeterReadDetail::setRateCalculationID()
     * @uses ServicePointMeterReadDetail::setChargeID()
     * @uses ServicePointMeterReadDetail::setTOUChargeValue()
     * @uses ServicePointMeterReadDetail::setReadTime()
     * @uses ServicePointMeterReadDetail::setVolumetricChargeCodeStr()
     * @uses ServicePointMeterReadDetail::setIntervalStatus()
     * @uses ServicePointMeterReadDetail::setAccountServicePoint()
     * @param int $servicePointMeterReadID
     * @param int $servicePointMeterReadDetailID
     * @param float $consumption
     * @param float $estimatedConsumption
     * @param float $actualConsumption
     * @param int $servicePointMeterID
     * @param string $readDate
     * @param int $accountID
     * @param int $accountServicePointID
     * @param float $currentRegisterValue
     * @param float $previousRegisterValue
     * @param float $rate
     * @param float $rateDiscounted
     * @param float $consumptionDollars
     * @param float $consumptionDollarsDiscounted
     * @param bool $isVEEData
     * @param bool $isActualRead
     * @param int $rateCalculationID
     * @param int $chargeID
     * @param float $tOUChargeValue
     * @param string $readTime
     * @param string $volumetricChargeCodeStr
     * @param string $intervalStatus
     * @param \SGCIS\Struct\AccountServicePoint $accountServicePoint
     */
    public function __construct($servicePointMeterReadID = null, $servicePointMeterReadDetailID = null, $consumption = null, $estimatedConsumption = null, $actualConsumption = null, $servicePointMeterID = null, $readDate = null, $accountID = null, $accountServicePointID = null, $currentRegisterValue = null, $previousRegisterValue = null, $rate = null, $rateDiscounted = null, $consumptionDollars = null, $consumptionDollarsDiscounted = null, $isVEEData = null, $isActualRead = null, $rateCalculationID = null, $chargeID = null, $tOUChargeValue = null, $readTime = null, $volumetricChargeCodeStr = null, $intervalStatus = null, \SGCIS\Struct\AccountServicePoint $accountServicePoint = null)
    {
        $this
            ->setServicePointMeterReadID($servicePointMeterReadID)
            ->setServicePointMeterReadDetailID($servicePointMeterReadDetailID)
            ->setConsumption($consumption)
            ->setEstimatedConsumption($estimatedConsumption)
            ->setActualConsumption($actualConsumption)
            ->setServicePointMeterID($servicePointMeterID)
            ->setReadDate($readDate)
            ->setAccountID($accountID)
            ->setAccountServicePointID($accountServicePointID)
            ->setCurrentRegisterValue($currentRegisterValue)
            ->setPreviousRegisterValue($previousRegisterValue)
            ->setRate($rate)
            ->setRateDiscounted($rateDiscounted)
            ->setConsumptionDollars($consumptionDollars)
            ->setConsumptionDollarsDiscounted($consumptionDollarsDiscounted)
            ->setIsVEEData($isVEEData)
            ->setIsActualRead($isActualRead)
            ->setRateCalculationID($rateCalculationID)
            ->setChargeID($chargeID)
            ->setTOUChargeValue($tOUChargeValue)
            ->setReadTime($readTime)
            ->setVolumetricChargeCodeStr($volumetricChargeCodeStr)
            ->setIntervalStatus($intervalStatus)
            ->setAccountServicePoint($accountServicePoint);
    }
    /**
     * Get ServicePointMeterReadID value
     * @return int
     */
    public function getServicePointMeterReadID()
    {
        return $this->ServicePointMeterReadID;
    }
    /**
     * Set ServicePointMeterReadID value
     * @param int $servicePointMeterReadID
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setServicePointMeterReadID($servicePointMeterReadID = null)
    {
        // validation for constraint: int
        if (!is_null($servicePointMeterReadID) && !is_numeric($servicePointMeterReadID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($servicePointMeterReadID)), __LINE__);
        }
        $this->ServicePointMeterReadID = $servicePointMeterReadID;
        return $this;
    }
    /**
     * Get ServicePointMeterReadDetailID value
     * @return int
     */
    public function getServicePointMeterReadDetailID()
    {
        return $this->ServicePointMeterReadDetailID;
    }
    /**
     * Set ServicePointMeterReadDetailID value
     * @param int $servicePointMeterReadDetailID
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setServicePointMeterReadDetailID($servicePointMeterReadDetailID = null)
    {
        // validation for constraint: int
        if (!is_null($servicePointMeterReadDetailID) && !is_numeric($servicePointMeterReadDetailID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($servicePointMeterReadDetailID)), __LINE__);
        }
        $this->ServicePointMeterReadDetailID = $servicePointMeterReadDetailID;
        return $this;
    }
    /**
     * Get Consumption value
     * @return float
     */
    public function getConsumption()
    {
        return $this->Consumption;
    }
    /**
     * Set Consumption value
     * @param float $consumption
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setConsumption($consumption = null)
    {
        $this->Consumption = $consumption;
        return $this;
    }
    /**
     * Get EstimatedConsumption value
     * @return float
     */
    public function getEstimatedConsumption()
    {
        return $this->EstimatedConsumption;
    }
    /**
     * Set EstimatedConsumption value
     * @param float $estimatedConsumption
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setEstimatedConsumption($estimatedConsumption = null)
    {
        $this->EstimatedConsumption = $estimatedConsumption;
        return $this;
    }
    /**
     * Get ActualConsumption value
     * @return float
     */
    public function getActualConsumption()
    {
        return $this->ActualConsumption;
    }
    /**
     * Set ActualConsumption value
     * @param float $actualConsumption
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setActualConsumption($actualConsumption = null)
    {
        $this->ActualConsumption = $actualConsumption;
        return $this;
    }
    /**
     * Get ServicePointMeterID value
     * @return int
     */
    public function getServicePointMeterID()
    {
        return $this->ServicePointMeterID;
    }
    /**
     * Set ServicePointMeterID value
     * @param int $servicePointMeterID
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setServicePointMeterID($servicePointMeterID = null)
    {
        // validation for constraint: int
        if (!is_null($servicePointMeterID) && !is_numeric($servicePointMeterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($servicePointMeterID)), __LINE__);
        }
        $this->ServicePointMeterID = $servicePointMeterID;
        return $this;
    }
    /**
     * Get ReadDate value
     * @return string
     */
    public function getReadDate()
    {
        return $this->ReadDate;
    }
    /**
     * Set ReadDate value
     * @param string $readDate
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setReadDate($readDate = null)
    {
        // validation for constraint: string
        if (!is_null($readDate) && !is_string($readDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($readDate)), __LINE__);
        }
        $this->ReadDate = $readDate;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AccountServicePointID value
     * @return int
     */
    public function getAccountServicePointID()
    {
        return $this->AccountServicePointID;
    }
    /**
     * Set AccountServicePointID value
     * @param int $accountServicePointID
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setAccountServicePointID($accountServicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($accountServicePointID) && !is_numeric($accountServicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountServicePointID)), __LINE__);
        }
        $this->AccountServicePointID = $accountServicePointID;
        return $this;
    }
    /**
     * Get CurrentRegisterValue value
     * @return float
     */
    public function getCurrentRegisterValue()
    {
        return $this->CurrentRegisterValue;
    }
    /**
     * Set CurrentRegisterValue value
     * @param float $currentRegisterValue
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setCurrentRegisterValue($currentRegisterValue = null)
    {
        $this->CurrentRegisterValue = $currentRegisterValue;
        return $this;
    }
    /**
     * Get PreviousRegisterValue value
     * @return float
     */
    public function getPreviousRegisterValue()
    {
        return $this->PreviousRegisterValue;
    }
    /**
     * Set PreviousRegisterValue value
     * @param float $previousRegisterValue
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setPreviousRegisterValue($previousRegisterValue = null)
    {
        $this->PreviousRegisterValue = $previousRegisterValue;
        return $this;
    }
    /**
     * Get Rate value
     * @return float
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param float $rate
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setRate($rate = null)
    {
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get RateDiscounted value
     * @return float
     */
    public function getRateDiscounted()
    {
        return $this->RateDiscounted;
    }
    /**
     * Set RateDiscounted value
     * @param float $rateDiscounted
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setRateDiscounted($rateDiscounted = null)
    {
        $this->RateDiscounted = $rateDiscounted;
        return $this;
    }
    /**
     * Get ConsumptionDollars value
     * @return float
     */
    public function getConsumptionDollars()
    {
        return $this->ConsumptionDollars;
    }
    /**
     * Set ConsumptionDollars value
     * @param float $consumptionDollars
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setConsumptionDollars($consumptionDollars = null)
    {
        $this->ConsumptionDollars = $consumptionDollars;
        return $this;
    }
    /**
     * Get ConsumptionDollarsDiscounted value
     * @return float
     */
    public function getConsumptionDollarsDiscounted()
    {
        return $this->ConsumptionDollarsDiscounted;
    }
    /**
     * Set ConsumptionDollarsDiscounted value
     * @param float $consumptionDollarsDiscounted
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setConsumptionDollarsDiscounted($consumptionDollarsDiscounted = null)
    {
        $this->ConsumptionDollarsDiscounted = $consumptionDollarsDiscounted;
        return $this;
    }
    /**
     * Get IsVEEData value
     * @return bool
     */
    public function getIsVEEData()
    {
        return $this->IsVEEData;
    }
    /**
     * Set IsVEEData value
     * @param bool $isVEEData
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setIsVEEData($isVEEData = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVEEData) && !is_bool($isVEEData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isVEEData)), __LINE__);
        }
        $this->IsVEEData = $isVEEData;
        return $this;
    }
    /**
     * Get isActualRead value
     * @return bool
     */
    public function getIsActualRead()
    {
        return $this->isActualRead;
    }
    /**
     * Set isActualRead value
     * @param bool $isActualRead
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setIsActualRead($isActualRead = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActualRead) && !is_bool($isActualRead)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActualRead)), __LINE__);
        }
        $this->isActualRead = $isActualRead;
        return $this;
    }
    /**
     * Get RateCalculationID value
     * @return int
     */
    public function getRateCalculationID()
    {
        return $this->RateCalculationID;
    }
    /**
     * Set RateCalculationID value
     * @param int $rateCalculationID
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setRateCalculationID($rateCalculationID = null)
    {
        // validation for constraint: int
        if (!is_null($rateCalculationID) && !is_numeric($rateCalculationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rateCalculationID)), __LINE__);
        }
        $this->RateCalculationID = $rateCalculationID;
        return $this;
    }
    /**
     * Get ChargeID value
     * @return int
     */
    public function getChargeID()
    {
        return $this->ChargeID;
    }
    /**
     * Set ChargeID value
     * @param int $chargeID
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setChargeID($chargeID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeID) && !is_numeric($chargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeID)), __LINE__);
        }
        $this->ChargeID = $chargeID;
        return $this;
    }
    /**
     * Get TOUChargeValue value
     * @return float
     */
    public function getTOUChargeValue()
    {
        return $this->TOUChargeValue;
    }
    /**
     * Set TOUChargeValue value
     * @param float $tOUChargeValue
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setTOUChargeValue($tOUChargeValue = null)
    {
        $this->TOUChargeValue = $tOUChargeValue;
        return $this;
    }
    /**
     * Get ReadTime value
     * @return string|null
     */
    public function getReadTime()
    {
        return $this->ReadTime;
    }
    /**
     * Set ReadTime value
     * @param string $readTime
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setReadTime($readTime = null)
    {
        // validation for constraint: string
        if (!is_null($readTime) && !is_string($readTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($readTime)), __LINE__);
        }
        $this->ReadTime = $readTime;
        return $this;
    }
    /**
     * Get VolumetricChargeCodeStr value
     * @return string|null
     */
    public function getVolumetricChargeCodeStr()
    {
        return $this->VolumetricChargeCodeStr;
    }
    /**
     * Set VolumetricChargeCodeStr value
     * @param string $volumetricChargeCodeStr
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setVolumetricChargeCodeStr($volumetricChargeCodeStr = null)
    {
        // validation for constraint: string
        if (!is_null($volumetricChargeCodeStr) && !is_string($volumetricChargeCodeStr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($volumetricChargeCodeStr)), __LINE__);
        }
        $this->VolumetricChargeCodeStr = $volumetricChargeCodeStr;
        return $this;
    }
    /**
     * Get IntervalStatus value
     * @return string|null
     */
    public function getIntervalStatus()
    {
        return $this->IntervalStatus;
    }
    /**
     * Set IntervalStatus value
     * @param string $intervalStatus
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setIntervalStatus($intervalStatus = null)
    {
        // validation for constraint: string
        if (!is_null($intervalStatus) && !is_string($intervalStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($intervalStatus)), __LINE__);
        }
        $this->IntervalStatus = $intervalStatus;
        return $this;
    }
    /**
     * Get AccountServicePoint value
     * @return \SGCIS\Struct\AccountServicePoint|null
     */
    public function getAccountServicePoint()
    {
        return $this->AccountServicePoint;
    }
    /**
     * Set AccountServicePoint value
     * @param \SGCIS\Struct\AccountServicePoint $accountServicePoint
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public function setAccountServicePoint(\SGCIS\Struct\AccountServicePoint $accountServicePoint = null)
    {
        $this->AccountServicePoint = $accountServicePoint;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ServicePointMeterReadDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
