<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceLocationSearchResponse Struct
 * @subpackage Structs
 */
class ServiceLocationSearchResponse extends ServiceResponseBase
{
    /**
     * The DistributionPoints
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfDistributionPoint
     */
    public $DistributionPoints;
    /**
     * The PreviousAccounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountPrevious
     */
    public $PreviousAccounts;
    /**
     * Constructor method for ServiceLocationSearchResponse
     * @uses ServiceLocationSearchResponse::setDistributionPoints()
     * @uses ServiceLocationSearchResponse::setPreviousAccounts()
     * @param \SGCIS\Array\ArrayOfDistributionPoint $distributionPoints
     * @param \SGCIS\Array\ArrayOfAccountPrevious $previousAccounts
     */
    public function __construct(\SGCIS\Array\ArrayOfDistributionPoint $distributionPoints = null, \SGCIS\Array\ArrayOfAccountPrevious $previousAccounts = null)
    {
        $this
            ->setDistributionPoints($distributionPoints)
            ->setPreviousAccounts($previousAccounts);
    }
    /**
     * Get DistributionPoints value
     * @return \SGCIS\Array\ArrayOfDistributionPoint|null
     */
    public function getDistributionPoints()
    {
        return $this->DistributionPoints;
    }
    /**
     * Set DistributionPoints value
     * @param \SGCIS\Array\ArrayOfDistributionPoint $distributionPoints
     * @return \SGCIS\Struct\ServiceLocationSearchResponse
     */
    public function setDistributionPoints(\SGCIS\Array\ArrayOfDistributionPoint $distributionPoints = null)
    {
        $this->DistributionPoints = $distributionPoints;
        return $this;
    }
    /**
     * Get PreviousAccounts value
     * @return \SGCIS\Array\ArrayOfAccountPrevious|null
     */
    public function getPreviousAccounts()
    {
        return $this->PreviousAccounts;
    }
    /**
     * Set PreviousAccounts value
     * @param \SGCIS\Array\ArrayOfAccountPrevious $previousAccounts
     * @return \SGCIS\Struct\ServiceLocationSearchResponse
     */
    public function setPreviousAccounts(\SGCIS\Array\ArrayOfAccountPrevious $previousAccounts = null)
    {
        $this->PreviousAccounts = $previousAccounts;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ServiceLocationSearchResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
