<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchEntity Struct
 * @subpackage Structs
 */
class SearchEntity extends AbstractStructBase
{
    /**
     * The SearchEntityID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SearchEntityID;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The TableName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TableName;
    /**
     * The ViewIcon
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ViewIcon;
    /**
     * The EntityViews
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfSearchEntityView
     */
    public $EntityViews;
    /**
     * Constructor method for SearchEntity
     * @uses SearchEntity::setSearchEntityID()
     * @uses SearchEntity::setCreateDate()
     * @uses SearchEntity::setDisplayName()
     * @uses SearchEntity::setTableName()
     * @uses SearchEntity::setViewIcon()
     * @uses SearchEntity::setEntityViews()
     * @param int $searchEntityID
     * @param string $createDate
     * @param string $displayName
     * @param string $tableName
     * @param string $viewIcon
     * @param \SGCIS\Array\ArrayOfSearchEntityView $entityViews
     */
    public function __construct($searchEntityID = null, $createDate = null, $displayName = null, $tableName = null, $viewIcon = null, \SGCIS\Array\ArrayOfSearchEntityView $entityViews = null)
    {
        $this
            ->setSearchEntityID($searchEntityID)
            ->setCreateDate($createDate)
            ->setDisplayName($displayName)
            ->setTableName($tableName)
            ->setViewIcon($viewIcon)
            ->setEntityViews($entityViews);
    }
    /**
     * Get SearchEntityID value
     * @return int
     */
    public function getSearchEntityID()
    {
        return $this->SearchEntityID;
    }
    /**
     * Set SearchEntityID value
     * @param int $searchEntityID
     * @return \SGCIS\Struct\SearchEntity
     */
    public function setSearchEntityID($searchEntityID = null)
    {
        // validation for constraint: int
        if (!is_null($searchEntityID) && !is_numeric($searchEntityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($searchEntityID)), __LINE__);
        }
        $this->SearchEntityID = $searchEntityID;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\SearchEntity
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \SGCIS\Struct\SearchEntity
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get TableName value
     * @return string|null
     */
    public function getTableName()
    {
        return $this->TableName;
    }
    /**
     * Set TableName value
     * @param string $tableName
     * @return \SGCIS\Struct\SearchEntity
     */
    public function setTableName($tableName = null)
    {
        // validation for constraint: string
        if (!is_null($tableName) && !is_string($tableName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tableName)), __LINE__);
        }
        $this->TableName = $tableName;
        return $this;
    }
    /**
     * Get ViewIcon value
     * @return string|null
     */
    public function getViewIcon()
    {
        return $this->ViewIcon;
    }
    /**
     * Set ViewIcon value
     * @param string $viewIcon
     * @return \SGCIS\Struct\SearchEntity
     */
    public function setViewIcon($viewIcon = null)
    {
        // validation for constraint: string
        if (!is_null($viewIcon) && !is_string($viewIcon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($viewIcon)), __LINE__);
        }
        $this->ViewIcon = $viewIcon;
        return $this;
    }
    /**
     * Get EntityViews value
     * @return \SGCIS\Array\ArrayOfSearchEntityView|null
     */
    public function getEntityViews()
    {
        return $this->EntityViews;
    }
    /**
     * Set EntityViews value
     * @param \SGCIS\Array\ArrayOfSearchEntityView $entityViews
     * @return \SGCIS\Struct\SearchEntity
     */
    public function setEntityViews(\SGCIS\Array\ArrayOfSearchEntityView $entityViews = null)
    {
        $this->EntityViews = $entityViews;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\SearchEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
