<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesAgentCompany Struct
 * @subpackage Structs
 */
class SalesAgentCompany extends AbstractStructBase
{
    /**
     * The SalesAgentCompanyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SalesAgentCompanyID;
    /**
     * The PaymentTenderTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentTenderTypeID;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The LastUpdateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastUpdateDate;
    /**
     * The SystemUserOwnerUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemUserOwnerUserID;
    /**
     * The CompanyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyName;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The RoutingNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoutingNumber;
    /**
     * The BankAccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAccountNumber;
    /**
     * The TaxIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxIdentifier;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The StateCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StateCode;
    /**
     * The ZipCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * The CreatedByUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreatedByUserName;
    /**
     * The LastUpdateUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastUpdateUserName;
    /**
     * The UserAgentCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfUserAgentCode
     */
    public $UserAgentCodes;
    /**
     * Constructor method for SalesAgentCompany
     * @uses SalesAgentCompany::setSalesAgentCompanyID()
     * @uses SalesAgentCompany::setPaymentTenderTypeID()
     * @uses SalesAgentCompany::setCreateDate()
     * @uses SalesAgentCompany::setLastUpdateDate()
     * @uses SalesAgentCompany::setSystemUserOwnerUserID()
     * @uses SalesAgentCompany::setCompanyName()
     * @uses SalesAgentCompany::setDescription()
     * @uses SalesAgentCompany::setRoutingNumber()
     * @uses SalesAgentCompany::setBankAccountNumber()
     * @uses SalesAgentCompany::setTaxIdentifier()
     * @uses SalesAgentCompany::setAddress()
     * @uses SalesAgentCompany::setCity()
     * @uses SalesAgentCompany::setStateCode()
     * @uses SalesAgentCompany::setZipCode()
     * @uses SalesAgentCompany::setCreatedByUserName()
     * @uses SalesAgentCompany::setLastUpdateUserName()
     * @uses SalesAgentCompany::setUserAgentCodes()
     * @param int $salesAgentCompanyID
     * @param int $paymentTenderTypeID
     * @param string $createDate
     * @param string $lastUpdateDate
     * @param int $systemUserOwnerUserID
     * @param string $companyName
     * @param string $description
     * @param string $routingNumber
     * @param string $bankAccountNumber
     * @param string $taxIdentifier
     * @param string $address
     * @param string $city
     * @param string $stateCode
     * @param string $zipCode
     * @param string $createdByUserName
     * @param string $lastUpdateUserName
     * @param \SGCIS\Array\ArrayOfUserAgentCode $userAgentCodes
     */
    public function __construct($salesAgentCompanyID = null, $paymentTenderTypeID = null, $createDate = null, $lastUpdateDate = null, $systemUserOwnerUserID = null, $companyName = null, $description = null, $routingNumber = null, $bankAccountNumber = null, $taxIdentifier = null, $address = null, $city = null, $stateCode = null, $zipCode = null, $createdByUserName = null, $lastUpdateUserName = null, \SGCIS\Array\ArrayOfUserAgentCode $userAgentCodes = null)
    {
        $this
            ->setSalesAgentCompanyID($salesAgentCompanyID)
            ->setPaymentTenderTypeID($paymentTenderTypeID)
            ->setCreateDate($createDate)
            ->setLastUpdateDate($lastUpdateDate)
            ->setSystemUserOwnerUserID($systemUserOwnerUserID)
            ->setCompanyName($companyName)
            ->setDescription($description)
            ->setRoutingNumber($routingNumber)
            ->setBankAccountNumber($bankAccountNumber)
            ->setTaxIdentifier($taxIdentifier)
            ->setAddress($address)
            ->setCity($city)
            ->setStateCode($stateCode)
            ->setZipCode($zipCode)
            ->setCreatedByUserName($createdByUserName)
            ->setLastUpdateUserName($lastUpdateUserName)
            ->setUserAgentCodes($userAgentCodes);
    }
    /**
     * Get SalesAgentCompanyID value
     * @return int
     */
    public function getSalesAgentCompanyID()
    {
        return $this->SalesAgentCompanyID;
    }
    /**
     * Set SalesAgentCompanyID value
     * @param int $salesAgentCompanyID
     * @return \SGCIS\Struct\SalesAgentCompany
     */
    public function setSalesAgentCompanyID($salesAgentCompanyID = null)
    {
        // validation for constraint: int
        if (!is_null($salesAgentCompanyID) && !is_numeric($salesAgentCompanyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($salesAgentCompanyID)), __LINE__);
        }
        $this->SalesAgentCompanyID = $salesAgentCompanyID;
        return $this;
    }
    /**
     * Get PaymentTenderTypeID value
     * @return int
     */
    public function getPaymentTenderTypeID()
    {
        return $this->PaymentTenderTypeID;
    }
    /**
     * Set PaymentTenderTypeID value
     * @param int $paymentTenderTypeID
     * @return \SGCIS\Struct\SalesAgentCompany
     */
    public function setPaymentTenderTypeID($paymentTenderTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentTenderTypeID) && !is_numeric($paymentTenderTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentTenderTypeID)), __LINE__);
        }
        $this->PaymentTenderTypeID = $paymentTenderTypeID;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\SalesAgentCompany
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get LastUpdateDate value
     * @return string
     */
    public function getLastUpdateDate()
    {
        return $this->LastUpdateDate;
    }
    /**
     * Set LastUpdateDate value
     * @param string $lastUpdateDate
     * @return \SGCIS\Struct\SalesAgentCompany
     */
    public function setLastUpdateDate($lastUpdateDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDate) && !is_string($lastUpdateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateDate)), __LINE__);
        }
        $this->LastUpdateDate = $lastUpdateDate;
        return $this;
    }
    /**
     * Get SystemUserOwnerUserID value
     * @return int
     */
    public function getSystemUserOwnerUserID()
    {
        return $this->SystemUserOwnerUserID;
    }
    /**
     * Set SystemUserOwnerUserID value
     * @param int $systemUserOwnerUserID
     * @return \SGCIS\Struct\SalesAgentCompany
     */
    public function setSystemUserOwnerUserID($systemUserOwnerUserID = null)
    {
        // validation for constraint: int
        if (!is_null($systemUserOwnerUserID) && !is_numeric($systemUserOwnerUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemUserOwnerUserID)), __LINE__);
        }
        $this->SystemUserOwnerUserID = $systemUserOwnerUserID;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \SGCIS\Struct\SalesAgentCompany
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\SalesAgentCompany
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get RoutingNumber value
     * @return string|null
     */
    public function getRoutingNumber()
    {
        return $this->RoutingNumber;
    }
    /**
     * Set RoutingNumber value
     * @param string $routingNumber
     * @return \SGCIS\Struct\SalesAgentCompany
     */
    public function setRoutingNumber($routingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($routingNumber) && !is_string($routingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routingNumber)), __LINE__);
        }
        $this->RoutingNumber = $routingNumber;
        return $this;
    }
    /**
     * Get BankAccountNumber value
     * @return string|null
     */
    public function getBankAccountNumber()
    {
        return $this->BankAccountNumber;
    }
    /**
     * Set BankAccountNumber value
     * @param string $bankAccountNumber
     * @return \SGCIS\Struct\SalesAgentCompany
     */
    public function setBankAccountNumber($bankAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountNumber) && !is_string($bankAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankAccountNumber)), __LINE__);
        }
        $this->BankAccountNumber = $bankAccountNumber;
        return $this;
    }
    /**
     * Get TaxIdentifier value
     * @return string|null
     */
    public function getTaxIdentifier()
    {
        return $this->TaxIdentifier;
    }
    /**
     * Set TaxIdentifier value
     * @param string $taxIdentifier
     * @return \SGCIS\Struct\SalesAgentCompany
     */
    public function setTaxIdentifier($taxIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($taxIdentifier) && !is_string($taxIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxIdentifier)), __LINE__);
        }
        $this->TaxIdentifier = $taxIdentifier;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \SGCIS\Struct\SalesAgentCompany
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \SGCIS\Struct\SalesAgentCompany
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get StateCode value
     * @return string|null
     */
    public function getStateCode()
    {
        return $this->StateCode;
    }
    /**
     * Set StateCode value
     * @param string $stateCode
     * @return \SGCIS\Struct\SalesAgentCompany
     */
    public function setStateCode($stateCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateCode) && !is_string($stateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateCode)), __LINE__);
        }
        $this->StateCode = $stateCode;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \SGCIS\Struct\SalesAgentCompany
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Get CreatedByUserName value
     * @return string|null
     */
    public function getCreatedByUserName()
    {
        return $this->CreatedByUserName;
    }
    /**
     * Set CreatedByUserName value
     * @param string $createdByUserName
     * @return \SGCIS\Struct\SalesAgentCompany
     */
    public function setCreatedByUserName($createdByUserName = null)
    {
        // validation for constraint: string
        if (!is_null($createdByUserName) && !is_string($createdByUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdByUserName)), __LINE__);
        }
        $this->CreatedByUserName = $createdByUserName;
        return $this;
    }
    /**
     * Get LastUpdateUserName value
     * @return string|null
     */
    public function getLastUpdateUserName()
    {
        return $this->LastUpdateUserName;
    }
    /**
     * Set LastUpdateUserName value
     * @param string $lastUpdateUserName
     * @return \SGCIS\Struct\SalesAgentCompany
     */
    public function setLastUpdateUserName($lastUpdateUserName = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateUserName) && !is_string($lastUpdateUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateUserName)), __LINE__);
        }
        $this->LastUpdateUserName = $lastUpdateUserName;
        return $this;
    }
    /**
     * Get UserAgentCodes value
     * @return \SGCIS\Array\ArrayOfUserAgentCode|null
     */
    public function getUserAgentCodes()
    {
        return $this->UserAgentCodes;
    }
    /**
     * Set UserAgentCodes value
     * @param \SGCIS\Array\ArrayOfUserAgentCode $userAgentCodes
     * @return \SGCIS\Struct\SalesAgentCompany
     */
    public function setUserAgentCodes(\SGCIS\Array\ArrayOfUserAgentCode $userAgentCodes = null)
    {
        $this->UserAgentCodes = $userAgentCodes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\SalesAgentCompany
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
