<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateUsageCharge Struct
 * @subpackage Structs
 */
class RateUsageCharge extends BaseDTO
{
    /**
     * The RateUsageChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RateUsageChargeID;
    /**
     * The RateID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RateID;
    /**
     * The UsageChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UsageChargeID;
    /**
     * The ChargeTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeTypeID;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for RateUsageCharge
     * @uses RateUsageCharge::setRateUsageChargeID()
     * @uses RateUsageCharge::setRateID()
     * @uses RateUsageCharge::setUsageChargeID()
     * @uses RateUsageCharge::setChargeTypeID()
     * @uses RateUsageCharge::setActive()
     * @uses RateUsageCharge::setName()
     * @param int $rateUsageChargeID
     * @param int $rateID
     * @param int $usageChargeID
     * @param int $chargeTypeID
     * @param bool $active
     * @param string $name
     */
    public function __construct($rateUsageChargeID = null, $rateID = null, $usageChargeID = null, $chargeTypeID = null, $active = null, $name = null)
    {
        $this
            ->setRateUsageChargeID($rateUsageChargeID)
            ->setRateID($rateID)
            ->setUsageChargeID($usageChargeID)
            ->setChargeTypeID($chargeTypeID)
            ->setActive($active)
            ->setName($name);
    }
    /**
     * Get RateUsageChargeID value
     * @return int
     */
    public function getRateUsageChargeID()
    {
        return $this->RateUsageChargeID;
    }
    /**
     * Set RateUsageChargeID value
     * @param int $rateUsageChargeID
     * @return \SGCIS\Struct\RateUsageCharge
     */
    public function setRateUsageChargeID($rateUsageChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($rateUsageChargeID) && !is_numeric($rateUsageChargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rateUsageChargeID)), __LINE__);
        }
        $this->RateUsageChargeID = $rateUsageChargeID;
        return $this;
    }
    /**
     * Get RateID value
     * @return int
     */
    public function getRateID()
    {
        return $this->RateID;
    }
    /**
     * Set RateID value
     * @param int $rateID
     * @return \SGCIS\Struct\RateUsageCharge
     */
    public function setRateID($rateID = null)
    {
        // validation for constraint: int
        if (!is_null($rateID) && !is_numeric($rateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rateID)), __LINE__);
        }
        $this->RateID = $rateID;
        return $this;
    }
    /**
     * Get UsageChargeID value
     * @return int
     */
    public function getUsageChargeID()
    {
        return $this->UsageChargeID;
    }
    /**
     * Set UsageChargeID value
     * @param int $usageChargeID
     * @return \SGCIS\Struct\RateUsageCharge
     */
    public function setUsageChargeID($usageChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($usageChargeID) && !is_numeric($usageChargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($usageChargeID)), __LINE__);
        }
        $this->UsageChargeID = $usageChargeID;
        return $this;
    }
    /**
     * Get ChargeTypeID value
     * @return int
     */
    public function getChargeTypeID()
    {
        return $this->ChargeTypeID;
    }
    /**
     * Set ChargeTypeID value
     * @param int $chargeTypeID
     * @return \SGCIS\Struct\RateUsageCharge
     */
    public function setChargeTypeID($chargeTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeTypeID) && !is_numeric($chargeTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeTypeID)), __LINE__);
        }
        $this->ChargeTypeID = $chargeTypeID;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\RateUsageCharge
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\RateUsageCharge
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\RateUsageCharge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
