<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateLookupRequest Struct
 * @subpackage Structs
 */
class RateLookupRequest extends ServiceRequestBase
{
    /**
     * The CalcTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CalcTypeID;
    /**
     * The NumberOfRooms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfRooms;
    /**
     * The PremiseTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PremiseTypeID;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The PaymentAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PaymentAmount;
    /**
     * The Month
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Month;
    /**
     * The Days
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Days;
    /**
     * The DistributionServiceProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionServiceProviderID;
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * The ZipCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * Constructor method for RateLookupRequest
     * @uses RateLookupRequest::setCalcTypeID()
     * @uses RateLookupRequest::setNumberOfRooms()
     * @uses RateLookupRequest::setPremiseTypeID()
     * @uses RateLookupRequest::setProductID()
     * @uses RateLookupRequest::setPaymentAmount()
     * @uses RateLookupRequest::setMonth()
     * @uses RateLookupRequest::setDays()
     * @uses RateLookupRequest::setDistributionServiceProviderID()
     * @uses RateLookupRequest::setUserID()
     * @uses RateLookupRequest::setPhoneNumber()
     * @uses RateLookupRequest::setZipCode()
     * @uses RateLookupRequest::setAccountNumber()
     * @param int $calcTypeID
     * @param int $numberOfRooms
     * @param int $premiseTypeID
     * @param int $productID
     * @param float $paymentAmount
     * @param int $month
     * @param int $days
     * @param int $distributionServiceProviderID
     * @param int $userID
     * @param string $phoneNumber
     * @param string $zipCode
     * @param string $accountNumber
     */
    public function __construct($calcTypeID = null, $numberOfRooms = null, $premiseTypeID = null, $productID = null, $paymentAmount = null, $month = null, $days = null, $distributionServiceProviderID = null, $userID = null, $phoneNumber = null, $zipCode = null, $accountNumber = null)
    {
        $this
            ->setCalcTypeID($calcTypeID)
            ->setNumberOfRooms($numberOfRooms)
            ->setPremiseTypeID($premiseTypeID)
            ->setProductID($productID)
            ->setPaymentAmount($paymentAmount)
            ->setMonth($month)
            ->setDays($days)
            ->setDistributionServiceProviderID($distributionServiceProviderID)
            ->setUserID($userID)
            ->setPhoneNumber($phoneNumber)
            ->setZipCode($zipCode)
            ->setAccountNumber($accountNumber);
    }
    /**
     * Get CalcTypeID value
     * @return int
     */
    public function getCalcTypeID()
    {
        return $this->CalcTypeID;
    }
    /**
     * Set CalcTypeID value
     * @param int $calcTypeID
     * @return \SGCIS\Struct\RateLookupRequest
     */
    public function setCalcTypeID($calcTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($calcTypeID) && !is_numeric($calcTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($calcTypeID)), __LINE__);
        }
        $this->CalcTypeID = $calcTypeID;
        return $this;
    }
    /**
     * Get NumberOfRooms value
     * @return int
     */
    public function getNumberOfRooms()
    {
        return $this->NumberOfRooms;
    }
    /**
     * Set NumberOfRooms value
     * @param int $numberOfRooms
     * @return \SGCIS\Struct\RateLookupRequest
     */
    public function setNumberOfRooms($numberOfRooms = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfRooms) && !is_numeric($numberOfRooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfRooms)), __LINE__);
        }
        $this->NumberOfRooms = $numberOfRooms;
        return $this;
    }
    /**
     * Get PremiseTypeID value
     * @return int
     */
    public function getPremiseTypeID()
    {
        return $this->PremiseTypeID;
    }
    /**
     * Set PremiseTypeID value
     * @param int $premiseTypeID
     * @return \SGCIS\Struct\RateLookupRequest
     */
    public function setPremiseTypeID($premiseTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($premiseTypeID) && !is_numeric($premiseTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($premiseTypeID)), __LINE__);
        }
        $this->PremiseTypeID = $premiseTypeID;
        return $this;
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \SGCIS\Struct\RateLookupRequest
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get PaymentAmount value
     * @return float
     */
    public function getPaymentAmount()
    {
        return $this->PaymentAmount;
    }
    /**
     * Set PaymentAmount value
     * @param float $paymentAmount
     * @return \SGCIS\Struct\RateLookupRequest
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        $this->PaymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Get Month value
     * @return int
     */
    public function getMonth()
    {
        return $this->Month;
    }
    /**
     * Set Month value
     * @param int $month
     * @return \SGCIS\Struct\RateLookupRequest
     */
    public function setMonth($month = null)
    {
        // validation for constraint: int
        if (!is_null($month) && !is_numeric($month)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($month)), __LINE__);
        }
        $this->Month = $month;
        return $this;
    }
    /**
     * Get Days value
     * @return int
     */
    public function getDays()
    {
        return $this->Days;
    }
    /**
     * Set Days value
     * @param int $days
     * @return \SGCIS\Struct\RateLookupRequest
     */
    public function setDays($days = null)
    {
        // validation for constraint: int
        if (!is_null($days) && !is_numeric($days)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($days)), __LINE__);
        }
        $this->Days = $days;
        return $this;
    }
    /**
     * Get DistributionServiceProviderID value
     * @return int
     */
    public function getDistributionServiceProviderID()
    {
        return $this->DistributionServiceProviderID;
    }
    /**
     * Set DistributionServiceProviderID value
     * @param int $distributionServiceProviderID
     * @return \SGCIS\Struct\RateLookupRequest
     */
    public function setDistributionServiceProviderID($distributionServiceProviderID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionServiceProviderID) && !is_numeric($distributionServiceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionServiceProviderID)), __LINE__);
        }
        $this->DistributionServiceProviderID = $distributionServiceProviderID;
        return $this;
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \SGCIS\Struct\RateLookupRequest
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !is_numeric($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \SGCIS\Struct\RateLookupRequest
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \SGCIS\Struct\RateLookupRequest
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\RateLookupRequest
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\RateLookupRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
