<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateAdder Struct
 * @subpackage Structs
 */
class RateAdder extends BaseDTO
{
    /**
     * The RateAdderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RateAdderID;
    /**
     * The RateID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RateID;
    /**
     * The AdderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AdderID;
    /**
     * The AdderValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AdderValue;
    /**
     * The AdderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdderName;
    /**
     * Constructor method for RateAdder
     * @uses RateAdder::setRateAdderID()
     * @uses RateAdder::setRateID()
     * @uses RateAdder::setAdderID()
     * @uses RateAdder::setAdderValue()
     * @uses RateAdder::setAdderName()
     * @param int $rateAdderID
     * @param int $rateID
     * @param int $adderID
     * @param float $adderValue
     * @param string $adderName
     */
    public function __construct($rateAdderID = null, $rateID = null, $adderID = null, $adderValue = null, $adderName = null)
    {
        $this
            ->setRateAdderID($rateAdderID)
            ->setRateID($rateID)
            ->setAdderID($adderID)
            ->setAdderValue($adderValue)
            ->setAdderName($adderName);
    }
    /**
     * Get RateAdderID value
     * @return int
     */
    public function getRateAdderID()
    {
        return $this->RateAdderID;
    }
    /**
     * Set RateAdderID value
     * @param int $rateAdderID
     * @return \SGCIS\Struct\RateAdder
     */
    public function setRateAdderID($rateAdderID = null)
    {
        // validation for constraint: int
        if (!is_null($rateAdderID) && !is_numeric($rateAdderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rateAdderID)), __LINE__);
        }
        $this->RateAdderID = $rateAdderID;
        return $this;
    }
    /**
     * Get RateID value
     * @return int
     */
    public function getRateID()
    {
        return $this->RateID;
    }
    /**
     * Set RateID value
     * @param int $rateID
     * @return \SGCIS\Struct\RateAdder
     */
    public function setRateID($rateID = null)
    {
        // validation for constraint: int
        if (!is_null($rateID) && !is_numeric($rateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rateID)), __LINE__);
        }
        $this->RateID = $rateID;
        return $this;
    }
    /**
     * Get AdderID value
     * @return int
     */
    public function getAdderID()
    {
        return $this->AdderID;
    }
    /**
     * Set AdderID value
     * @param int $adderID
     * @return \SGCIS\Struct\RateAdder
     */
    public function setAdderID($adderID = null)
    {
        // validation for constraint: int
        if (!is_null($adderID) && !is_numeric($adderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($adderID)), __LINE__);
        }
        $this->AdderID = $adderID;
        return $this;
    }
    /**
     * Get AdderValue value
     * @return float
     */
    public function getAdderValue()
    {
        return $this->AdderValue;
    }
    /**
     * Set AdderValue value
     * @param float $adderValue
     * @return \SGCIS\Struct\RateAdder
     */
    public function setAdderValue($adderValue = null)
    {
        $this->AdderValue = $adderValue;
        return $this;
    }
    /**
     * Get AdderName value
     * @return string|null
     */
    public function getAdderName()
    {
        return $this->AdderName;
    }
    /**
     * Set AdderName value
     * @param string $adderName
     * @return \SGCIS\Struct\RateAdder
     */
    public function setAdderName($adderName = null)
    {
        // validation for constraint: string
        if (!is_null($adderName) && !is_string($adderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adderName)), __LINE__);
        }
        $this->AdderName = $adderName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\RateAdder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
