<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rate Struct
 * @subpackage Structs
 */
class Rate extends BaseDTO
{
    /**
     * The RateID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RateID;
    /**
     * The CommodityID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CommodityID;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The RateCalculationMethodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RateCalculationMethodID;
    /**
     * The Approved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Approved;
    /**
     * The DateApproved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateApproved;
    /**
     * The DistributionServiceProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionServiceProviderID;
    /**
     * The CurrentRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CurrentRate;
    /**
     * The RateCustomModuleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RateCustomModuleID;
    /**
     * The AccountChannelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountChannelID;
    /**
     * The AccountTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountTypeID;
    /**
     * The IsPublic
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPublic;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The RevertToRateID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RevertToRateID;
    /**
     * The ContractLengthTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ContractLengthTypeID;
    /**
     * The RateContractPeriodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RateContractPeriodID;
    /**
     * The ContractStartTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ContractStartTypeID;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ApprovedByUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApprovedByUserName;
    /**
     * The RateCalculationMethodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RateCalculationMethodName;
    /**
     * The RateCalculationMethodDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RateCalculationMethodDescription;
    /**
     * The ProductName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductName;
    /**
     * The UsageType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UsageType;
    /**
     * The ServiceAgreement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\ServiceAgreement
     */
    public $ServiceAgreement;
    /**
     * The UsageCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfUsageCharge
     */
    public $UsageCharges;
    /**
     * The RateAdders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfRateAdder
     */
    public $RateAdders;
    /**
     * The RateTariffCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfRateTariffCharge
     */
    public $RateTariffCharges;
    /**
     * The RateUsageCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfRateUsageCharge
     */
    public $RateUsageCharges;
    /**
     * The RateOtherCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfRateOtherCharge
     */
    public $RateOtherCharges;
    /**
     * The Charge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfCharge
     */
    public $Charge;
    /**
     * The RateCharactetistic
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfRateCharacteristic
     */
    public $RateCharactetistic;
    /**
     * The ChargeGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfChargeGroup
     */
    public $ChargeGroup;
    /**
     * The Promotions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfPromotion
     */
    public $Promotions;
    /**
     * The ChargeGroupCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfCharge
     */
    public $ChargeGroupCharges;
    /**
     * The Product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Product
     */
    public $Product;
    /**
     * Constructor method for Rate
     * @uses Rate::setRateID()
     * @uses Rate::setCommodityID()
     * @uses Rate::setActive()
     * @uses Rate::setRateCalculationMethodID()
     * @uses Rate::setApproved()
     * @uses Rate::setDateApproved()
     * @uses Rate::setDistributionServiceProviderID()
     * @uses Rate::setCurrentRate()
     * @uses Rate::setRateCustomModuleID()
     * @uses Rate::setAccountChannelID()
     * @uses Rate::setAccountTypeID()
     * @uses Rate::setIsPublic()
     * @uses Rate::setStartDate()
     * @uses Rate::setEndDate()
     * @uses Rate::setRevertToRateID()
     * @uses Rate::setContractLengthTypeID()
     * @uses Rate::setRateContractPeriodID()
     * @uses Rate::setContractStartTypeID()
     * @uses Rate::setProductID()
     * @uses Rate::setName()
     * @uses Rate::setDescription()
     * @uses Rate::setApprovedByUserName()
     * @uses Rate::setRateCalculationMethodName()
     * @uses Rate::setRateCalculationMethodDescription()
     * @uses Rate::setProductName()
     * @uses Rate::setUsageType()
     * @uses Rate::setServiceAgreement()
     * @uses Rate::setUsageCharges()
     * @uses Rate::setRateAdders()
     * @uses Rate::setRateTariffCharges()
     * @uses Rate::setRateUsageCharges()
     * @uses Rate::setRateOtherCharges()
     * @uses Rate::setCharge()
     * @uses Rate::setRateCharactetistic()
     * @uses Rate::setChargeGroup()
     * @uses Rate::setPromotions()
     * @uses Rate::setChargeGroupCharges()
     * @uses Rate::setProduct()
     * @param int $rateID
     * @param int $commodityID
     * @param bool $active
     * @param int $rateCalculationMethodID
     * @param bool $approved
     * @param string $dateApproved
     * @param int $distributionServiceProviderID
     * @param float $currentRate
     * @param int $rateCustomModuleID
     * @param int $accountChannelID
     * @param int $accountTypeID
     * @param bool $isPublic
     * @param string $startDate
     * @param string $endDate
     * @param int $revertToRateID
     * @param int $contractLengthTypeID
     * @param int $rateContractPeriodID
     * @param int $contractStartTypeID
     * @param int $productID
     * @param string $name
     * @param string $description
     * @param string $approvedByUserName
     * @param string $rateCalculationMethodName
     * @param string $rateCalculationMethodDescription
     * @param string $productName
     * @param string $usageType
     * @param \SGCIS\Struct\ServiceAgreement $serviceAgreement
     * @param \SGCIS\Array\ArrayOfUsageCharge $usageCharges
     * @param \SGCIS\Array\ArrayOfRateAdder $rateAdders
     * @param \SGCIS\Array\ArrayOfRateTariffCharge $rateTariffCharges
     * @param \SGCIS\Array\ArrayOfRateUsageCharge $rateUsageCharges
     * @param \SGCIS\Array\ArrayOfRateOtherCharge $rateOtherCharges
     * @param \SGCIS\Array\ArrayOfCharge $charge
     * @param \SGCIS\Array\ArrayOfRateCharacteristic $rateCharactetistic
     * @param \SGCIS\Array\ArrayOfChargeGroup $chargeGroup
     * @param \SGCIS\Array\ArrayOfPromotion $promotions
     * @param \SGCIS\Array\ArrayOfCharge $chargeGroupCharges
     * @param \SGCIS\Struct\Product $product
     */
    public function __construct($rateID = null, $commodityID = null, $active = null, $rateCalculationMethodID = null, $approved = null, $dateApproved = null, $distributionServiceProviderID = null, $currentRate = null, $rateCustomModuleID = null, $accountChannelID = null, $accountTypeID = null, $isPublic = null, $startDate = null, $endDate = null, $revertToRateID = null, $contractLengthTypeID = null, $rateContractPeriodID = null, $contractStartTypeID = null, $productID = null, $name = null, $description = null, $approvedByUserName = null, $rateCalculationMethodName = null, $rateCalculationMethodDescription = null, $productName = null, $usageType = null, \SGCIS\Struct\ServiceAgreement $serviceAgreement = null, \SGCIS\Array\ArrayOfUsageCharge $usageCharges = null, \SGCIS\Array\ArrayOfRateAdder $rateAdders = null, \SGCIS\Array\ArrayOfRateTariffCharge $rateTariffCharges = null, \SGCIS\Array\ArrayOfRateUsageCharge $rateUsageCharges = null, \SGCIS\Array\ArrayOfRateOtherCharge $rateOtherCharges = null, \SGCIS\Array\ArrayOfCharge $charge = null, \SGCIS\Array\ArrayOfRateCharacteristic $rateCharactetistic = null, \SGCIS\Array\ArrayOfChargeGroup $chargeGroup = null, \SGCIS\Array\ArrayOfPromotion $promotions = null, \SGCIS\Array\ArrayOfCharge $chargeGroupCharges = null, \SGCIS\Struct\Product $product = null)
    {
        $this
            ->setRateID($rateID)
            ->setCommodityID($commodityID)
            ->setActive($active)
            ->setRateCalculationMethodID($rateCalculationMethodID)
            ->setApproved($approved)
            ->setDateApproved($dateApproved)
            ->setDistributionServiceProviderID($distributionServiceProviderID)
            ->setCurrentRate($currentRate)
            ->setRateCustomModuleID($rateCustomModuleID)
            ->setAccountChannelID($accountChannelID)
            ->setAccountTypeID($accountTypeID)
            ->setIsPublic($isPublic)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setRevertToRateID($revertToRateID)
            ->setContractLengthTypeID($contractLengthTypeID)
            ->setRateContractPeriodID($rateContractPeriodID)
            ->setContractStartTypeID($contractStartTypeID)
            ->setProductID($productID)
            ->setName($name)
            ->setDescription($description)
            ->setApprovedByUserName($approvedByUserName)
            ->setRateCalculationMethodName($rateCalculationMethodName)
            ->setRateCalculationMethodDescription($rateCalculationMethodDescription)
            ->setProductName($productName)
            ->setUsageType($usageType)
            ->setServiceAgreement($serviceAgreement)
            ->setUsageCharges($usageCharges)
            ->setRateAdders($rateAdders)
            ->setRateTariffCharges($rateTariffCharges)
            ->setRateUsageCharges($rateUsageCharges)
            ->setRateOtherCharges($rateOtherCharges)
            ->setCharge($charge)
            ->setRateCharactetistic($rateCharactetistic)
            ->setChargeGroup($chargeGroup)
            ->setPromotions($promotions)
            ->setChargeGroupCharges($chargeGroupCharges)
            ->setProduct($product);
    }
    /**
     * Get RateID value
     * @return int
     */
    public function getRateID()
    {
        return $this->RateID;
    }
    /**
     * Set RateID value
     * @param int $rateID
     * @return \SGCIS\Struct\Rate
     */
    public function setRateID($rateID = null)
    {
        // validation for constraint: int
        if (!is_null($rateID) && !is_numeric($rateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rateID)), __LINE__);
        }
        $this->RateID = $rateID;
        return $this;
    }
    /**
     * Get CommodityID value
     * @return int
     */
    public function getCommodityID()
    {
        return $this->CommodityID;
    }
    /**
     * Set CommodityID value
     * @param int $commodityID
     * @return \SGCIS\Struct\Rate
     */
    public function setCommodityID($commodityID = null)
    {
        // validation for constraint: int
        if (!is_null($commodityID) && !is_numeric($commodityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($commodityID)), __LINE__);
        }
        $this->CommodityID = $commodityID;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\Rate
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get RateCalculationMethodID value
     * @return int
     */
    public function getRateCalculationMethodID()
    {
        return $this->RateCalculationMethodID;
    }
    /**
     * Set RateCalculationMethodID value
     * @param int $rateCalculationMethodID
     * @return \SGCIS\Struct\Rate
     */
    public function setRateCalculationMethodID($rateCalculationMethodID = null)
    {
        // validation for constraint: int
        if (!is_null($rateCalculationMethodID) && !is_numeric($rateCalculationMethodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rateCalculationMethodID)), __LINE__);
        }
        $this->RateCalculationMethodID = $rateCalculationMethodID;
        return $this;
    }
    /**
     * Get Approved value
     * @return bool
     */
    public function getApproved()
    {
        return $this->Approved;
    }
    /**
     * Set Approved value
     * @param bool $approved
     * @return \SGCIS\Struct\Rate
     */
    public function setApproved($approved = null)
    {
        // validation for constraint: boolean
        if (!is_null($approved) && !is_bool($approved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($approved)), __LINE__);
        }
        $this->Approved = $approved;
        return $this;
    }
    /**
     * Get DateApproved value
     * @return string
     */
    public function getDateApproved()
    {
        return $this->DateApproved;
    }
    /**
     * Set DateApproved value
     * @param string $dateApproved
     * @return \SGCIS\Struct\Rate
     */
    public function setDateApproved($dateApproved = null)
    {
        // validation for constraint: string
        if (!is_null($dateApproved) && !is_string($dateApproved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateApproved)), __LINE__);
        }
        $this->DateApproved = $dateApproved;
        return $this;
    }
    /**
     * Get DistributionServiceProviderID value
     * @return int
     */
    public function getDistributionServiceProviderID()
    {
        return $this->DistributionServiceProviderID;
    }
    /**
     * Set DistributionServiceProviderID value
     * @param int $distributionServiceProviderID
     * @return \SGCIS\Struct\Rate
     */
    public function setDistributionServiceProviderID($distributionServiceProviderID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionServiceProviderID) && !is_numeric($distributionServiceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionServiceProviderID)), __LINE__);
        }
        $this->DistributionServiceProviderID = $distributionServiceProviderID;
        return $this;
    }
    /**
     * Get CurrentRate value
     * @return float
     */
    public function getCurrentRate()
    {
        return $this->CurrentRate;
    }
    /**
     * Set CurrentRate value
     * @param float $currentRate
     * @return \SGCIS\Struct\Rate
     */
    public function setCurrentRate($currentRate = null)
    {
        $this->CurrentRate = $currentRate;
        return $this;
    }
    /**
     * Get RateCustomModuleID value
     * @return int
     */
    public function getRateCustomModuleID()
    {
        return $this->RateCustomModuleID;
    }
    /**
     * Set RateCustomModuleID value
     * @param int $rateCustomModuleID
     * @return \SGCIS\Struct\Rate
     */
    public function setRateCustomModuleID($rateCustomModuleID = null)
    {
        // validation for constraint: int
        if (!is_null($rateCustomModuleID) && !is_numeric($rateCustomModuleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rateCustomModuleID)), __LINE__);
        }
        $this->RateCustomModuleID = $rateCustomModuleID;
        return $this;
    }
    /**
     * Get AccountChannelID value
     * @return int
     */
    public function getAccountChannelID()
    {
        return $this->AccountChannelID;
    }
    /**
     * Set AccountChannelID value
     * @param int $accountChannelID
     * @return \SGCIS\Struct\Rate
     */
    public function setAccountChannelID($accountChannelID = null)
    {
        // validation for constraint: int
        if (!is_null($accountChannelID) && !is_numeric($accountChannelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountChannelID)), __LINE__);
        }
        $this->AccountChannelID = $accountChannelID;
        return $this;
    }
    /**
     * Get AccountTypeID value
     * @return int
     */
    public function getAccountTypeID()
    {
        return $this->AccountTypeID;
    }
    /**
     * Set AccountTypeID value
     * @param int $accountTypeID
     * @return \SGCIS\Struct\Rate
     */
    public function setAccountTypeID($accountTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($accountTypeID) && !is_numeric($accountTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountTypeID)), __LINE__);
        }
        $this->AccountTypeID = $accountTypeID;
        return $this;
    }
    /**
     * Get IsPublic value
     * @return bool
     */
    public function getIsPublic()
    {
        return $this->IsPublic;
    }
    /**
     * Set IsPublic value
     * @param bool $isPublic
     * @return \SGCIS\Struct\Rate
     */
    public function setIsPublic($isPublic = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPublic) && !is_bool($isPublic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPublic)), __LINE__);
        }
        $this->IsPublic = $isPublic;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \SGCIS\Struct\Rate
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \SGCIS\Struct\Rate
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get RevertToRateID value
     * @return int
     */
    public function getRevertToRateID()
    {
        return $this->RevertToRateID;
    }
    /**
     * Set RevertToRateID value
     * @param int $revertToRateID
     * @return \SGCIS\Struct\Rate
     */
    public function setRevertToRateID($revertToRateID = null)
    {
        // validation for constraint: int
        if (!is_null($revertToRateID) && !is_numeric($revertToRateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($revertToRateID)), __LINE__);
        }
        $this->RevertToRateID = $revertToRateID;
        return $this;
    }
    /**
     * Get ContractLengthTypeID value
     * @return int
     */
    public function getContractLengthTypeID()
    {
        return $this->ContractLengthTypeID;
    }
    /**
     * Set ContractLengthTypeID value
     * @param int $contractLengthTypeID
     * @return \SGCIS\Struct\Rate
     */
    public function setContractLengthTypeID($contractLengthTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($contractLengthTypeID) && !is_numeric($contractLengthTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contractLengthTypeID)), __LINE__);
        }
        $this->ContractLengthTypeID = $contractLengthTypeID;
        return $this;
    }
    /**
     * Get RateContractPeriodID value
     * @return int
     */
    public function getRateContractPeriodID()
    {
        return $this->RateContractPeriodID;
    }
    /**
     * Set RateContractPeriodID value
     * @param int $rateContractPeriodID
     * @return \SGCIS\Struct\Rate
     */
    public function setRateContractPeriodID($rateContractPeriodID = null)
    {
        // validation for constraint: int
        if (!is_null($rateContractPeriodID) && !is_numeric($rateContractPeriodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rateContractPeriodID)), __LINE__);
        }
        $this->RateContractPeriodID = $rateContractPeriodID;
        return $this;
    }
    /**
     * Get ContractStartTypeID value
     * @return int
     */
    public function getContractStartTypeID()
    {
        return $this->ContractStartTypeID;
    }
    /**
     * Set ContractStartTypeID value
     * @param int $contractStartTypeID
     * @return \SGCIS\Struct\Rate
     */
    public function setContractStartTypeID($contractStartTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($contractStartTypeID) && !is_numeric($contractStartTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contractStartTypeID)), __LINE__);
        }
        $this->ContractStartTypeID = $contractStartTypeID;
        return $this;
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \SGCIS\Struct\Rate
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\Rate
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\Rate
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ApprovedByUserName value
     * @return string|null
     */
    public function getApprovedByUserName()
    {
        return $this->ApprovedByUserName;
    }
    /**
     * Set ApprovedByUserName value
     * @param string $approvedByUserName
     * @return \SGCIS\Struct\Rate
     */
    public function setApprovedByUserName($approvedByUserName = null)
    {
        // validation for constraint: string
        if (!is_null($approvedByUserName) && !is_string($approvedByUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($approvedByUserName)), __LINE__);
        }
        $this->ApprovedByUserName = $approvedByUserName;
        return $this;
    }
    /**
     * Get RateCalculationMethodName value
     * @return string|null
     */
    public function getRateCalculationMethodName()
    {
        return $this->RateCalculationMethodName;
    }
    /**
     * Set RateCalculationMethodName value
     * @param string $rateCalculationMethodName
     * @return \SGCIS\Struct\Rate
     */
    public function setRateCalculationMethodName($rateCalculationMethodName = null)
    {
        // validation for constraint: string
        if (!is_null($rateCalculationMethodName) && !is_string($rateCalculationMethodName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateCalculationMethodName)), __LINE__);
        }
        $this->RateCalculationMethodName = $rateCalculationMethodName;
        return $this;
    }
    /**
     * Get RateCalculationMethodDescription value
     * @return string|null
     */
    public function getRateCalculationMethodDescription()
    {
        return $this->RateCalculationMethodDescription;
    }
    /**
     * Set RateCalculationMethodDescription value
     * @param string $rateCalculationMethodDescription
     * @return \SGCIS\Struct\Rate
     */
    public function setRateCalculationMethodDescription($rateCalculationMethodDescription = null)
    {
        // validation for constraint: string
        if (!is_null($rateCalculationMethodDescription) && !is_string($rateCalculationMethodDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateCalculationMethodDescription)), __LINE__);
        }
        $this->RateCalculationMethodDescription = $rateCalculationMethodDescription;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \SGCIS\Struct\Rate
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get UsageType value
     * @return string|null
     */
    public function getUsageType()
    {
        return $this->UsageType;
    }
    /**
     * Set UsageType value
     * @param string $usageType
     * @return \SGCIS\Struct\Rate
     */
    public function setUsageType($usageType = null)
    {
        // validation for constraint: string
        if (!is_null($usageType) && !is_string($usageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usageType)), __LINE__);
        }
        $this->UsageType = $usageType;
        return $this;
    }
    /**
     * Get ServiceAgreement value
     * @return \SGCIS\Struct\ServiceAgreement|null
     */
    public function getServiceAgreement()
    {
        return $this->ServiceAgreement;
    }
    /**
     * Set ServiceAgreement value
     * @param \SGCIS\Struct\ServiceAgreement $serviceAgreement
     * @return \SGCIS\Struct\Rate
     */
    public function setServiceAgreement(\SGCIS\Struct\ServiceAgreement $serviceAgreement = null)
    {
        $this->ServiceAgreement = $serviceAgreement;
        return $this;
    }
    /**
     * Get UsageCharges value
     * @return \SGCIS\Array\ArrayOfUsageCharge|null
     */
    public function getUsageCharges()
    {
        return $this->UsageCharges;
    }
    /**
     * Set UsageCharges value
     * @param \SGCIS\Array\ArrayOfUsageCharge $usageCharges
     * @return \SGCIS\Struct\Rate
     */
    public function setUsageCharges(\SGCIS\Array\ArrayOfUsageCharge $usageCharges = null)
    {
        $this->UsageCharges = $usageCharges;
        return $this;
    }
    /**
     * Get RateAdders value
     * @return \SGCIS\Array\ArrayOfRateAdder|null
     */
    public function getRateAdders()
    {
        return $this->RateAdders;
    }
    /**
     * Set RateAdders value
     * @param \SGCIS\Array\ArrayOfRateAdder $rateAdders
     * @return \SGCIS\Struct\Rate
     */
    public function setRateAdders(\SGCIS\Array\ArrayOfRateAdder $rateAdders = null)
    {
        $this->RateAdders = $rateAdders;
        return $this;
    }
    /**
     * Get RateTariffCharges value
     * @return \SGCIS\Array\ArrayOfRateTariffCharge|null
     */
    public function getRateTariffCharges()
    {
        return $this->RateTariffCharges;
    }
    /**
     * Set RateTariffCharges value
     * @param \SGCIS\Array\ArrayOfRateTariffCharge $rateTariffCharges
     * @return \SGCIS\Struct\Rate
     */
    public function setRateTariffCharges(\SGCIS\Array\ArrayOfRateTariffCharge $rateTariffCharges = null)
    {
        $this->RateTariffCharges = $rateTariffCharges;
        return $this;
    }
    /**
     * Get RateUsageCharges value
     * @return \SGCIS\Array\ArrayOfRateUsageCharge|null
     */
    public function getRateUsageCharges()
    {
        return $this->RateUsageCharges;
    }
    /**
     * Set RateUsageCharges value
     * @param \SGCIS\Array\ArrayOfRateUsageCharge $rateUsageCharges
     * @return \SGCIS\Struct\Rate
     */
    public function setRateUsageCharges(\SGCIS\Array\ArrayOfRateUsageCharge $rateUsageCharges = null)
    {
        $this->RateUsageCharges = $rateUsageCharges;
        return $this;
    }
    /**
     * Get RateOtherCharges value
     * @return \SGCIS\Array\ArrayOfRateOtherCharge|null
     */
    public function getRateOtherCharges()
    {
        return $this->RateOtherCharges;
    }
    /**
     * Set RateOtherCharges value
     * @param \SGCIS\Array\ArrayOfRateOtherCharge $rateOtherCharges
     * @return \SGCIS\Struct\Rate
     */
    public function setRateOtherCharges(\SGCIS\Array\ArrayOfRateOtherCharge $rateOtherCharges = null)
    {
        $this->RateOtherCharges = $rateOtherCharges;
        return $this;
    }
    /**
     * Get Charge value
     * @return \SGCIS\Array\ArrayOfCharge|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * Set Charge value
     * @param \SGCIS\Array\ArrayOfCharge $charge
     * @return \SGCIS\Struct\Rate
     */
    public function setCharge(\SGCIS\Array\ArrayOfCharge $charge = null)
    {
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Get RateCharactetistic value
     * @return \SGCIS\Array\ArrayOfRateCharacteristic|null
     */
    public function getRateCharactetistic()
    {
        return $this->RateCharactetistic;
    }
    /**
     * Set RateCharactetistic value
     * @param \SGCIS\Array\ArrayOfRateCharacteristic $rateCharactetistic
     * @return \SGCIS\Struct\Rate
     */
    public function setRateCharactetistic(\SGCIS\Array\ArrayOfRateCharacteristic $rateCharactetistic = null)
    {
        $this->RateCharactetistic = $rateCharactetistic;
        return $this;
    }
    /**
     * Get ChargeGroup value
     * @return \SGCIS\Array\ArrayOfChargeGroup|null
     */
    public function getChargeGroup()
    {
        return $this->ChargeGroup;
    }
    /**
     * Set ChargeGroup value
     * @param \SGCIS\Array\ArrayOfChargeGroup $chargeGroup
     * @return \SGCIS\Struct\Rate
     */
    public function setChargeGroup(\SGCIS\Array\ArrayOfChargeGroup $chargeGroup = null)
    {
        $this->ChargeGroup = $chargeGroup;
        return $this;
    }
    /**
     * Get Promotions value
     * @return \SGCIS\Array\ArrayOfPromotion|null
     */
    public function getPromotions()
    {
        return $this->Promotions;
    }
    /**
     * Set Promotions value
     * @param \SGCIS\Array\ArrayOfPromotion $promotions
     * @return \SGCIS\Struct\Rate
     */
    public function setPromotions(\SGCIS\Array\ArrayOfPromotion $promotions = null)
    {
        $this->Promotions = $promotions;
        return $this;
    }
    /**
     * Get ChargeGroupCharges value
     * @return \SGCIS\Array\ArrayOfCharge|null
     */
    public function getChargeGroupCharges()
    {
        return $this->ChargeGroupCharges;
    }
    /**
     * Set ChargeGroupCharges value
     * @param \SGCIS\Array\ArrayOfCharge $chargeGroupCharges
     * @return \SGCIS\Struct\Rate
     */
    public function setChargeGroupCharges(\SGCIS\Array\ArrayOfCharge $chargeGroupCharges = null)
    {
        $this->ChargeGroupCharges = $chargeGroupCharges;
        return $this;
    }
    /**
     * Get Product value
     * @return \SGCIS\Struct\Product|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param \SGCIS\Struct\Product $product
     * @return \SGCIS\Struct\Rate
     */
    public function setProduct(\SGCIS\Struct\Product $product = null)
    {
        $this->Product = $product;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\Rate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
