<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PromotionSchedule Struct
 * @subpackage Structs
 */
class PromotionSchedule extends AbstractStructBase
{
    /**
     * The PromotionScheduleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PromotionScheduleID;
    /**
     * The PromotionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PromotionID;
    /**
     * The PromotionOccurTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PromotionOccurTypeID;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The ExpireDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ExpireDate;
    /**
     * The RecurInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RecurInterval;
    /**
     * The OnPaymentEventID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OnPaymentEventID;
    /**
     * The ExpireAfterMaxOccurences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExpireAfterMaxOccurences;
    /**
     * The ExpireAfterMaxDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExpireAfterMaxDays;
    /**
     * The StartAfterDaysActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StartAfterDaysActive;
    /**
     * The ScheduleStartTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ScheduleStartTypeID;
    /**
     * The Sun
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Sun;
    /**
     * The Mon
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Mon;
    /**
     * The Tue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Tue;
    /**
     * The Wed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Wed;
    /**
     * The Thu
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Thu;
    /**
     * The Fri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Fri;
    /**
     * The Sat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Sat;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The CreatedByUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CreatedByUserID;
    /**
     * The LastUpdateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastUpdateDate;
    /**
     * The LastUpdateUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LastUpdateUserID;
    /**
     * The ScheduleDay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ScheduleDay;
    /**
     * The TimeOfMonthID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TimeOfMonthID;
    /**
     * The NoDuplicatePostingDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NoDuplicatePostingDays;
    /**
     * Constructor method for PromotionSchedule
     * @uses PromotionSchedule::setPromotionScheduleID()
     * @uses PromotionSchedule::setPromotionID()
     * @uses PromotionSchedule::setPromotionOccurTypeID()
     * @uses PromotionSchedule::setStartDate()
     * @uses PromotionSchedule::setExpireDate()
     * @uses PromotionSchedule::setRecurInterval()
     * @uses PromotionSchedule::setOnPaymentEventID()
     * @uses PromotionSchedule::setExpireAfterMaxOccurences()
     * @uses PromotionSchedule::setExpireAfterMaxDays()
     * @uses PromotionSchedule::setStartAfterDaysActive()
     * @uses PromotionSchedule::setScheduleStartTypeID()
     * @uses PromotionSchedule::setSun()
     * @uses PromotionSchedule::setMon()
     * @uses PromotionSchedule::setTue()
     * @uses PromotionSchedule::setWed()
     * @uses PromotionSchedule::setThu()
     * @uses PromotionSchedule::setFri()
     * @uses PromotionSchedule::setSat()
     * @uses PromotionSchedule::setCreateDate()
     * @uses PromotionSchedule::setCreatedByUserID()
     * @uses PromotionSchedule::setLastUpdateDate()
     * @uses PromotionSchedule::setLastUpdateUserID()
     * @uses PromotionSchedule::setScheduleDay()
     * @uses PromotionSchedule::setTimeOfMonthID()
     * @uses PromotionSchedule::setNoDuplicatePostingDays()
     * @param int $promotionScheduleID
     * @param int $promotionID
     * @param int $promotionOccurTypeID
     * @param string $startDate
     * @param string $expireDate
     * @param int $recurInterval
     * @param int $onPaymentEventID
     * @param int $expireAfterMaxOccurences
     * @param int $expireAfterMaxDays
     * @param int $startAfterDaysActive
     * @param int $scheduleStartTypeID
     * @param bool $sun
     * @param bool $mon
     * @param bool $tue
     * @param bool $wed
     * @param bool $thu
     * @param bool $fri
     * @param bool $sat
     * @param string $createDate
     * @param int $createdByUserID
     * @param string $lastUpdateDate
     * @param int $lastUpdateUserID
     * @param int $scheduleDay
     * @param int $timeOfMonthID
     * @param int $noDuplicatePostingDays
     */
    public function __construct($promotionScheduleID = null, $promotionID = null, $promotionOccurTypeID = null, $startDate = null, $expireDate = null, $recurInterval = null, $onPaymentEventID = null, $expireAfterMaxOccurences = null, $expireAfterMaxDays = null, $startAfterDaysActive = null, $scheduleStartTypeID = null, $sun = null, $mon = null, $tue = null, $wed = null, $thu = null, $fri = null, $sat = null, $createDate = null, $createdByUserID = null, $lastUpdateDate = null, $lastUpdateUserID = null, $scheduleDay = null, $timeOfMonthID = null, $noDuplicatePostingDays = null)
    {
        $this
            ->setPromotionScheduleID($promotionScheduleID)
            ->setPromotionID($promotionID)
            ->setPromotionOccurTypeID($promotionOccurTypeID)
            ->setStartDate($startDate)
            ->setExpireDate($expireDate)
            ->setRecurInterval($recurInterval)
            ->setOnPaymentEventID($onPaymentEventID)
            ->setExpireAfterMaxOccurences($expireAfterMaxOccurences)
            ->setExpireAfterMaxDays($expireAfterMaxDays)
            ->setStartAfterDaysActive($startAfterDaysActive)
            ->setScheduleStartTypeID($scheduleStartTypeID)
            ->setSun($sun)
            ->setMon($mon)
            ->setTue($tue)
            ->setWed($wed)
            ->setThu($thu)
            ->setFri($fri)
            ->setSat($sat)
            ->setCreateDate($createDate)
            ->setCreatedByUserID($createdByUserID)
            ->setLastUpdateDate($lastUpdateDate)
            ->setLastUpdateUserID($lastUpdateUserID)
            ->setScheduleDay($scheduleDay)
            ->setTimeOfMonthID($timeOfMonthID)
            ->setNoDuplicatePostingDays($noDuplicatePostingDays);
    }
    /**
     * Get PromotionScheduleID value
     * @return int
     */
    public function getPromotionScheduleID()
    {
        return $this->PromotionScheduleID;
    }
    /**
     * Set PromotionScheduleID value
     * @param int $promotionScheduleID
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setPromotionScheduleID($promotionScheduleID = null)
    {
        // validation for constraint: int
        if (!is_null($promotionScheduleID) && !is_numeric($promotionScheduleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($promotionScheduleID)), __LINE__);
        }
        $this->PromotionScheduleID = $promotionScheduleID;
        return $this;
    }
    /**
     * Get PromotionID value
     * @return int
     */
    public function getPromotionID()
    {
        return $this->PromotionID;
    }
    /**
     * Set PromotionID value
     * @param int $promotionID
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setPromotionID($promotionID = null)
    {
        // validation for constraint: int
        if (!is_null($promotionID) && !is_numeric($promotionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($promotionID)), __LINE__);
        }
        $this->PromotionID = $promotionID;
        return $this;
    }
    /**
     * Get PromotionOccurTypeID value
     * @return int
     */
    public function getPromotionOccurTypeID()
    {
        return $this->PromotionOccurTypeID;
    }
    /**
     * Set PromotionOccurTypeID value
     * @param int $promotionOccurTypeID
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setPromotionOccurTypeID($promotionOccurTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($promotionOccurTypeID) && !is_numeric($promotionOccurTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($promotionOccurTypeID)), __LINE__);
        }
        $this->PromotionOccurTypeID = $promotionOccurTypeID;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get RecurInterval value
     * @return int
     */
    public function getRecurInterval()
    {
        return $this->RecurInterval;
    }
    /**
     * Set RecurInterval value
     * @param int $recurInterval
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setRecurInterval($recurInterval = null)
    {
        // validation for constraint: int
        if (!is_null($recurInterval) && !is_numeric($recurInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recurInterval)), __LINE__);
        }
        $this->RecurInterval = $recurInterval;
        return $this;
    }
    /**
     * Get OnPaymentEventID value
     * @return int
     */
    public function getOnPaymentEventID()
    {
        return $this->OnPaymentEventID;
    }
    /**
     * Set OnPaymentEventID value
     * @param int $onPaymentEventID
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setOnPaymentEventID($onPaymentEventID = null)
    {
        // validation for constraint: int
        if (!is_null($onPaymentEventID) && !is_numeric($onPaymentEventID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($onPaymentEventID)), __LINE__);
        }
        $this->OnPaymentEventID = $onPaymentEventID;
        return $this;
    }
    /**
     * Get ExpireAfterMaxOccurences value
     * @return int
     */
    public function getExpireAfterMaxOccurences()
    {
        return $this->ExpireAfterMaxOccurences;
    }
    /**
     * Set ExpireAfterMaxOccurences value
     * @param int $expireAfterMaxOccurences
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setExpireAfterMaxOccurences($expireAfterMaxOccurences = null)
    {
        // validation for constraint: int
        if (!is_null($expireAfterMaxOccurences) && !is_numeric($expireAfterMaxOccurences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expireAfterMaxOccurences)), __LINE__);
        }
        $this->ExpireAfterMaxOccurences = $expireAfterMaxOccurences;
        return $this;
    }
    /**
     * Get ExpireAfterMaxDays value
     * @return int
     */
    public function getExpireAfterMaxDays()
    {
        return $this->ExpireAfterMaxDays;
    }
    /**
     * Set ExpireAfterMaxDays value
     * @param int $expireAfterMaxDays
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setExpireAfterMaxDays($expireAfterMaxDays = null)
    {
        // validation for constraint: int
        if (!is_null($expireAfterMaxDays) && !is_numeric($expireAfterMaxDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expireAfterMaxDays)), __LINE__);
        }
        $this->ExpireAfterMaxDays = $expireAfterMaxDays;
        return $this;
    }
    /**
     * Get StartAfterDaysActive value
     * @return int
     */
    public function getStartAfterDaysActive()
    {
        return $this->StartAfterDaysActive;
    }
    /**
     * Set StartAfterDaysActive value
     * @param int $startAfterDaysActive
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setStartAfterDaysActive($startAfterDaysActive = null)
    {
        // validation for constraint: int
        if (!is_null($startAfterDaysActive) && !is_numeric($startAfterDaysActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($startAfterDaysActive)), __LINE__);
        }
        $this->StartAfterDaysActive = $startAfterDaysActive;
        return $this;
    }
    /**
     * Get ScheduleStartTypeID value
     * @return int
     */
    public function getScheduleStartTypeID()
    {
        return $this->ScheduleStartTypeID;
    }
    /**
     * Set ScheduleStartTypeID value
     * @param int $scheduleStartTypeID
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setScheduleStartTypeID($scheduleStartTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($scheduleStartTypeID) && !is_numeric($scheduleStartTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($scheduleStartTypeID)), __LINE__);
        }
        $this->ScheduleStartTypeID = $scheduleStartTypeID;
        return $this;
    }
    /**
     * Get Sun value
     * @return bool
     */
    public function getSun()
    {
        return $this->Sun;
    }
    /**
     * Set Sun value
     * @param bool $sun
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setSun($sun = null)
    {
        // validation for constraint: boolean
        if (!is_null($sun) && !is_bool($sun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sun)), __LINE__);
        }
        $this->Sun = $sun;
        return $this;
    }
    /**
     * Get Mon value
     * @return bool
     */
    public function getMon()
    {
        return $this->Mon;
    }
    /**
     * Set Mon value
     * @param bool $mon
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setMon($mon = null)
    {
        // validation for constraint: boolean
        if (!is_null($mon) && !is_bool($mon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mon)), __LINE__);
        }
        $this->Mon = $mon;
        return $this;
    }
    /**
     * Get Tue value
     * @return bool
     */
    public function getTue()
    {
        return $this->Tue;
    }
    /**
     * Set Tue value
     * @param bool $tue
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setTue($tue = null)
    {
        // validation for constraint: boolean
        if (!is_null($tue) && !is_bool($tue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($tue)), __LINE__);
        }
        $this->Tue = $tue;
        return $this;
    }
    /**
     * Get Wed value
     * @return bool
     */
    public function getWed()
    {
        return $this->Wed;
    }
    /**
     * Set Wed value
     * @param bool $wed
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setWed($wed = null)
    {
        // validation for constraint: boolean
        if (!is_null($wed) && !is_bool($wed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($wed)), __LINE__);
        }
        $this->Wed = $wed;
        return $this;
    }
    /**
     * Get Thu value
     * @return bool
     */
    public function getThu()
    {
        return $this->Thu;
    }
    /**
     * Set Thu value
     * @param bool $thu
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setThu($thu = null)
    {
        // validation for constraint: boolean
        if (!is_null($thu) && !is_bool($thu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($thu)), __LINE__);
        }
        $this->Thu = $thu;
        return $this;
    }
    /**
     * Get Fri value
     * @return bool
     */
    public function getFri()
    {
        return $this->Fri;
    }
    /**
     * Set Fri value
     * @param bool $fri
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setFri($fri = null)
    {
        // validation for constraint: boolean
        if (!is_null($fri) && !is_bool($fri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fri)), __LINE__);
        }
        $this->Fri = $fri;
        return $this;
    }
    /**
     * Get Sat value
     * @return bool
     */
    public function getSat()
    {
        return $this->Sat;
    }
    /**
     * Set Sat value
     * @param bool $sat
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setSat($sat = null)
    {
        // validation for constraint: boolean
        if (!is_null($sat) && !is_bool($sat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sat)), __LINE__);
        }
        $this->Sat = $sat;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CreatedByUserID value
     * @return int
     */
    public function getCreatedByUserID()
    {
        return $this->CreatedByUserID;
    }
    /**
     * Set CreatedByUserID value
     * @param int $createdByUserID
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setCreatedByUserID($createdByUserID = null)
    {
        // validation for constraint: int
        if (!is_null($createdByUserID) && !is_numeric($createdByUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($createdByUserID)), __LINE__);
        }
        $this->CreatedByUserID = $createdByUserID;
        return $this;
    }
    /**
     * Get LastUpdateDate value
     * @return string
     */
    public function getLastUpdateDate()
    {
        return $this->LastUpdateDate;
    }
    /**
     * Set LastUpdateDate value
     * @param string $lastUpdateDate
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setLastUpdateDate($lastUpdateDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDate) && !is_string($lastUpdateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateDate)), __LINE__);
        }
        $this->LastUpdateDate = $lastUpdateDate;
        return $this;
    }
    /**
     * Get LastUpdateUserID value
     * @return int
     */
    public function getLastUpdateUserID()
    {
        return $this->LastUpdateUserID;
    }
    /**
     * Set LastUpdateUserID value
     * @param int $lastUpdateUserID
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setLastUpdateUserID($lastUpdateUserID = null)
    {
        // validation for constraint: int
        if (!is_null($lastUpdateUserID) && !is_numeric($lastUpdateUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lastUpdateUserID)), __LINE__);
        }
        $this->LastUpdateUserID = $lastUpdateUserID;
        return $this;
    }
    /**
     * Get ScheduleDay value
     * @return int
     */
    public function getScheduleDay()
    {
        return $this->ScheduleDay;
    }
    /**
     * Set ScheduleDay value
     * @param int $scheduleDay
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setScheduleDay($scheduleDay = null)
    {
        // validation for constraint: int
        if (!is_null($scheduleDay) && !is_numeric($scheduleDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($scheduleDay)), __LINE__);
        }
        $this->ScheduleDay = $scheduleDay;
        return $this;
    }
    /**
     * Get TimeOfMonthID value
     * @return int
     */
    public function getTimeOfMonthID()
    {
        return $this->TimeOfMonthID;
    }
    /**
     * Set TimeOfMonthID value
     * @param int $timeOfMonthID
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setTimeOfMonthID($timeOfMonthID = null)
    {
        // validation for constraint: int
        if (!is_null($timeOfMonthID) && !is_numeric($timeOfMonthID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($timeOfMonthID)), __LINE__);
        }
        $this->TimeOfMonthID = $timeOfMonthID;
        return $this;
    }
    /**
     * Get NoDuplicatePostingDays value
     * @return int
     */
    public function getNoDuplicatePostingDays()
    {
        return $this->NoDuplicatePostingDays;
    }
    /**
     * Set NoDuplicatePostingDays value
     * @param int $noDuplicatePostingDays
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public function setNoDuplicatePostingDays($noDuplicatePostingDays = null)
    {
        // validation for constraint: int
        if (!is_null($noDuplicatePostingDays) && !is_numeric($noDuplicatePostingDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($noDuplicatePostingDays)), __LINE__);
        }
        $this->NoDuplicatePostingDays = $noDuplicatePostingDays;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PromotionSchedule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
