<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PromotionCharacteristic Struct
 * @subpackage Structs
 */
class PromotionCharacteristic extends AbstractStructBase
{
    /**
     * The PromotionCharacteristicID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PromotionCharacteristicID;
    /**
     * The PromotionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PromotionID;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The CharName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CharName;
    /**
     * The CharValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CharValue;
    /**
     * The CreatedByUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreatedByUserName;
    /**
     * Constructor method for PromotionCharacteristic
     * @uses PromotionCharacteristic::setPromotionCharacteristicID()
     * @uses PromotionCharacteristic::setPromotionID()
     * @uses PromotionCharacteristic::setCreateDate()
     * @uses PromotionCharacteristic::setCharName()
     * @uses PromotionCharacteristic::setCharValue()
     * @uses PromotionCharacteristic::setCreatedByUserName()
     * @param int $promotionCharacteristicID
     * @param int $promotionID
     * @param string $createDate
     * @param string $charName
     * @param string $charValue
     * @param string $createdByUserName
     */
    public function __construct($promotionCharacteristicID = null, $promotionID = null, $createDate = null, $charName = null, $charValue = null, $createdByUserName = null)
    {
        $this
            ->setPromotionCharacteristicID($promotionCharacteristicID)
            ->setPromotionID($promotionID)
            ->setCreateDate($createDate)
            ->setCharName($charName)
            ->setCharValue($charValue)
            ->setCreatedByUserName($createdByUserName);
    }
    /**
     * Get PromotionCharacteristicID value
     * @return int
     */
    public function getPromotionCharacteristicID()
    {
        return $this->PromotionCharacteristicID;
    }
    /**
     * Set PromotionCharacteristicID value
     * @param int $promotionCharacteristicID
     * @return \SGCIS\Struct\PromotionCharacteristic
     */
    public function setPromotionCharacteristicID($promotionCharacteristicID = null)
    {
        // validation for constraint: int
        if (!is_null($promotionCharacteristicID) && !is_numeric($promotionCharacteristicID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($promotionCharacteristicID)), __LINE__);
        }
        $this->PromotionCharacteristicID = $promotionCharacteristicID;
        return $this;
    }
    /**
     * Get PromotionID value
     * @return int
     */
    public function getPromotionID()
    {
        return $this->PromotionID;
    }
    /**
     * Set PromotionID value
     * @param int $promotionID
     * @return \SGCIS\Struct\PromotionCharacteristic
     */
    public function setPromotionID($promotionID = null)
    {
        // validation for constraint: int
        if (!is_null($promotionID) && !is_numeric($promotionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($promotionID)), __LINE__);
        }
        $this->PromotionID = $promotionID;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\PromotionCharacteristic
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CharName value
     * @return string|null
     */
    public function getCharName()
    {
        return $this->CharName;
    }
    /**
     * Set CharName value
     * @param string $charName
     * @return \SGCIS\Struct\PromotionCharacteristic
     */
    public function setCharName($charName = null)
    {
        // validation for constraint: string
        if (!is_null($charName) && !is_string($charName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($charName)), __LINE__);
        }
        $this->CharName = $charName;
        return $this;
    }
    /**
     * Get CharValue value
     * @return string|null
     */
    public function getCharValue()
    {
        return $this->CharValue;
    }
    /**
     * Set CharValue value
     * @param string $charValue
     * @return \SGCIS\Struct\PromotionCharacteristic
     */
    public function setCharValue($charValue = null)
    {
        // validation for constraint: string
        if (!is_null($charValue) && !is_string($charValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($charValue)), __LINE__);
        }
        $this->CharValue = $charValue;
        return $this;
    }
    /**
     * Get CreatedByUserName value
     * @return string|null
     */
    public function getCreatedByUserName()
    {
        return $this->CreatedByUserName;
    }
    /**
     * Set CreatedByUserName value
     * @param string $createdByUserName
     * @return \SGCIS\Struct\PromotionCharacteristic
     */
    public function setCreatedByUserName($createdByUserName = null)
    {
        // validation for constraint: string
        if (!is_null($createdByUserName) && !is_string($createdByUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdByUserName)), __LINE__);
        }
        $this->CreatedByUserName = $createdByUserName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PromotionCharacteristic
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
