<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Promotion Struct
 * @subpackage Structs
 */
class Promotion extends AbstractStructBase
{
    /**
     * The PromotionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PromotionID;
    /**
     * The PromotionTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PromotionTypeID;
    /**
     * The PromotionLevelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PromotionLevelID;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The IsApproved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsApproved;
    /**
     * The IsContracted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsContracted;
    /**
     * The PromotionCategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PromotionCategoryID;
    /**
     * The PromotionModelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PromotionModelID;
    /**
     * The UnitOfMeasureID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UnitOfMeasureID;
    /**
     * The PromotionAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PromotionAmount;
    /**
     * The PromotionAmountContracted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PromotionAmountContracted;
    /**
     * The TOUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TOUID;
    /**
     * The ThresholdUnits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ThresholdUnits;
    /**
     * The AmountBelowThreshold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmountBelowThreshold;
    /**
     * The AmountAboveThreshold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmountAboveThreshold;
    /**
     * The PaymentAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PaymentAmount;
    /**
     * The EffectiveStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EffectiveStartDate;
    /**
     * The EffectiveEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EffectiveEndDate;
    /**
     * The AvailableStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AvailableStartDate;
    /**
     * The AvailableEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AvailableEndDate;
    /**
     * The IsActiveAutoPay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActiveAutoPay;
    /**
     * The IsActiveEBill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActiveEBill;
    /**
     * The IsTaxable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTaxable;
    /**
     * The AppliesToRenewals
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AppliesToRenewals;
    /**
     * The PromotionTriggerSystemEventID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PromotionTriggerSystemEventID;
    /**
     * The ChargeCategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeCategoryID;
    /**
     * The PromotionChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PromotionChargeID;
    /**
     * The ProrateCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ProrateCharge;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The LastUpdateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastUpdateDate;
    /**
     * The ApplyAfterTerminationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ApplyAfterTerminationDate;
    /**
     * The IsPromotionCodeRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPromotionCodeRequired;
    /**
     * The CustomPromotionModuleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomPromotionModuleID;
    /**
     * The TenureActiveDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TenureActiveDays;
    /**
     * The TransactionTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransactionTypeID;
    /**
     * The TransactionTypeCategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransactionTypeCategoryID;
    /**
     * The ClawBackPeriodDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ClawBackPeriodDays;
    /**
     * The PromotionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PromotionName;
    /**
     * The PromotionDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PromotionDescription;
    /**
     * The PromoCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PromoCode;
    /**
     * The PromotionTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PromotionTypeName;
    /**
     * The BillingDisplayDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingDisplayDescription;
    /**
     * The PromotionCategoryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PromotionCategoryName;
    /**
     * The PromotionModelName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PromotionModelName;
    /**
     * The CreatedByUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreatedByUserName;
    /**
     * The LastUpdatedByUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastUpdatedByUserName;
    /**
     * The ServiceProvidersArray
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceProvidersArray;
    /**
     * The PromotionAccountTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfPromotionAccountType
     */
    public $PromotionAccountTypes;
    /**
     * The PromotionDistributionServiceProviders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfPromotionDistributionServiceProvider
     */
    public $PromotionDistributionServiceProviders;
    /**
     * The PromotionSchedule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\PromotionSchedule
     */
    public $PromotionSchedule;
    /**
     * The PromotionTiers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfPromotionTier
     */
    public $PromotionTiers;
    /**
     * The DistributionServiceProviders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfDistributionServiceProvider
     */
    public $DistributionServiceProviders;
    /**
     * The PromotionCharacteristic
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfPromotionCharacteristic
     */
    public $PromotionCharacteristic;
    /**
     * The PromotionScheduleSpecificDay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfPromotionScheduleSpecificDay
     */
    public $PromotionScheduleSpecificDay;
    /**
     * Constructor method for Promotion
     * @uses Promotion::setPromotionID()
     * @uses Promotion::setPromotionTypeID()
     * @uses Promotion::setPromotionLevelID()
     * @uses Promotion::setIsActive()
     * @uses Promotion::setIsApproved()
     * @uses Promotion::setIsContracted()
     * @uses Promotion::setPromotionCategoryID()
     * @uses Promotion::setPromotionModelID()
     * @uses Promotion::setUnitOfMeasureID()
     * @uses Promotion::setPromotionAmount()
     * @uses Promotion::setPromotionAmountContracted()
     * @uses Promotion::setTOUID()
     * @uses Promotion::setThresholdUnits()
     * @uses Promotion::setAmountBelowThreshold()
     * @uses Promotion::setAmountAboveThreshold()
     * @uses Promotion::setPaymentAmount()
     * @uses Promotion::setEffectiveStartDate()
     * @uses Promotion::setEffectiveEndDate()
     * @uses Promotion::setAvailableStartDate()
     * @uses Promotion::setAvailableEndDate()
     * @uses Promotion::setIsActiveAutoPay()
     * @uses Promotion::setIsActiveEBill()
     * @uses Promotion::setIsTaxable()
     * @uses Promotion::setAppliesToRenewals()
     * @uses Promotion::setPromotionTriggerSystemEventID()
     * @uses Promotion::setChargeCategoryID()
     * @uses Promotion::setPromotionChargeID()
     * @uses Promotion::setProrateCharge()
     * @uses Promotion::setCreateDate()
     * @uses Promotion::setLastUpdateDate()
     * @uses Promotion::setApplyAfterTerminationDate()
     * @uses Promotion::setIsPromotionCodeRequired()
     * @uses Promotion::setCustomPromotionModuleID()
     * @uses Promotion::setTenureActiveDays()
     * @uses Promotion::setTransactionTypeID()
     * @uses Promotion::setTransactionTypeCategoryID()
     * @uses Promotion::setClawBackPeriodDays()
     * @uses Promotion::setPromotionName()
     * @uses Promotion::setPromotionDescription()
     * @uses Promotion::setPromoCode()
     * @uses Promotion::setPromotionTypeName()
     * @uses Promotion::setBillingDisplayDescription()
     * @uses Promotion::setPromotionCategoryName()
     * @uses Promotion::setPromotionModelName()
     * @uses Promotion::setCreatedByUserName()
     * @uses Promotion::setLastUpdatedByUserName()
     * @uses Promotion::setServiceProvidersArray()
     * @uses Promotion::setPromotionAccountTypes()
     * @uses Promotion::setPromotionDistributionServiceProviders()
     * @uses Promotion::setPromotionSchedule()
     * @uses Promotion::setPromotionTiers()
     * @uses Promotion::setDistributionServiceProviders()
     * @uses Promotion::setPromotionCharacteristic()
     * @uses Promotion::setPromotionScheduleSpecificDay()
     * @param int $promotionID
     * @param int $promotionTypeID
     * @param int $promotionLevelID
     * @param bool $isActive
     * @param bool $isApproved
     * @param bool $isContracted
     * @param int $promotionCategoryID
     * @param int $promotionModelID
     * @param int $unitOfMeasureID
     * @param float $promotionAmount
     * @param float $promotionAmountContracted
     * @param int $tOUID
     * @param int $thresholdUnits
     * @param float $amountBelowThreshold
     * @param float $amountAboveThreshold
     * @param float $paymentAmount
     * @param string $effectiveStartDate
     * @param string $effectiveEndDate
     * @param string $availableStartDate
     * @param string $availableEndDate
     * @param bool $isActiveAutoPay
     * @param bool $isActiveEBill
     * @param bool $isTaxable
     * @param bool $appliesToRenewals
     * @param int $promotionTriggerSystemEventID
     * @param int $chargeCategoryID
     * @param int $promotionChargeID
     * @param bool $prorateCharge
     * @param string $createDate
     * @param string $lastUpdateDate
     * @param bool $applyAfterTerminationDate
     * @param bool $isPromotionCodeRequired
     * @param int $customPromotionModuleID
     * @param int $tenureActiveDays
     * @param int $transactionTypeID
     * @param int $transactionTypeCategoryID
     * @param int $clawBackPeriodDays
     * @param string $promotionName
     * @param string $promotionDescription
     * @param string $promoCode
     * @param string $promotionTypeName
     * @param string $billingDisplayDescription
     * @param string $promotionCategoryName
     * @param string $promotionModelName
     * @param string $createdByUserName
     * @param string $lastUpdatedByUserName
     * @param string $serviceProvidersArray
     * @param \SGCIS\Array\ArrayOfPromotionAccountType $promotionAccountTypes
     * @param \SGCIS\Array\ArrayOfPromotionDistributionServiceProvider $promotionDistributionServiceProviders
     * @param \SGCIS\Struct\PromotionSchedule $promotionSchedule
     * @param \SGCIS\Array\ArrayOfPromotionTier $promotionTiers
     * @param \SGCIS\Array\ArrayOfDistributionServiceProvider $distributionServiceProviders
     * @param \SGCIS\Array\ArrayOfPromotionCharacteristic $promotionCharacteristic
     * @param \SGCIS\Array\ArrayOfPromotionScheduleSpecificDay $promotionScheduleSpecificDay
     */
    public function __construct($promotionID = null, $promotionTypeID = null, $promotionLevelID = null, $isActive = null, $isApproved = null, $isContracted = null, $promotionCategoryID = null, $promotionModelID = null, $unitOfMeasureID = null, $promotionAmount = null, $promotionAmountContracted = null, $tOUID = null, $thresholdUnits = null, $amountBelowThreshold = null, $amountAboveThreshold = null, $paymentAmount = null, $effectiveStartDate = null, $effectiveEndDate = null, $availableStartDate = null, $availableEndDate = null, $isActiveAutoPay = null, $isActiveEBill = null, $isTaxable = null, $appliesToRenewals = null, $promotionTriggerSystemEventID = null, $chargeCategoryID = null, $promotionChargeID = null, $prorateCharge = null, $createDate = null, $lastUpdateDate = null, $applyAfterTerminationDate = null, $isPromotionCodeRequired = null, $customPromotionModuleID = null, $tenureActiveDays = null, $transactionTypeID = null, $transactionTypeCategoryID = null, $clawBackPeriodDays = null, $promotionName = null, $promotionDescription = null, $promoCode = null, $promotionTypeName = null, $billingDisplayDescription = null, $promotionCategoryName = null, $promotionModelName = null, $createdByUserName = null, $lastUpdatedByUserName = null, $serviceProvidersArray = null, \SGCIS\Array\ArrayOfPromotionAccountType $promotionAccountTypes = null, \SGCIS\Array\ArrayOfPromotionDistributionServiceProvider $promotionDistributionServiceProviders = null, \SGCIS\Struct\PromotionSchedule $promotionSchedule = null, \SGCIS\Array\ArrayOfPromotionTier $promotionTiers = null, \SGCIS\Array\ArrayOfDistributionServiceProvider $distributionServiceProviders = null, \SGCIS\Array\ArrayOfPromotionCharacteristic $promotionCharacteristic = null, \SGCIS\Array\ArrayOfPromotionScheduleSpecificDay $promotionScheduleSpecificDay = null)
    {
        $this
            ->setPromotionID($promotionID)
            ->setPromotionTypeID($promotionTypeID)
            ->setPromotionLevelID($promotionLevelID)
            ->setIsActive($isActive)
            ->setIsApproved($isApproved)
            ->setIsContracted($isContracted)
            ->setPromotionCategoryID($promotionCategoryID)
            ->setPromotionModelID($promotionModelID)
            ->setUnitOfMeasureID($unitOfMeasureID)
            ->setPromotionAmount($promotionAmount)
            ->setPromotionAmountContracted($promotionAmountContracted)
            ->setTOUID($tOUID)
            ->setThresholdUnits($thresholdUnits)
            ->setAmountBelowThreshold($amountBelowThreshold)
            ->setAmountAboveThreshold($amountAboveThreshold)
            ->setPaymentAmount($paymentAmount)
            ->setEffectiveStartDate($effectiveStartDate)
            ->setEffectiveEndDate($effectiveEndDate)
            ->setAvailableStartDate($availableStartDate)
            ->setAvailableEndDate($availableEndDate)
            ->setIsActiveAutoPay($isActiveAutoPay)
            ->setIsActiveEBill($isActiveEBill)
            ->setIsTaxable($isTaxable)
            ->setAppliesToRenewals($appliesToRenewals)
            ->setPromotionTriggerSystemEventID($promotionTriggerSystemEventID)
            ->setChargeCategoryID($chargeCategoryID)
            ->setPromotionChargeID($promotionChargeID)
            ->setProrateCharge($prorateCharge)
            ->setCreateDate($createDate)
            ->setLastUpdateDate($lastUpdateDate)
            ->setApplyAfterTerminationDate($applyAfterTerminationDate)
            ->setIsPromotionCodeRequired($isPromotionCodeRequired)
            ->setCustomPromotionModuleID($customPromotionModuleID)
            ->setTenureActiveDays($tenureActiveDays)
            ->setTransactionTypeID($transactionTypeID)
            ->setTransactionTypeCategoryID($transactionTypeCategoryID)
            ->setClawBackPeriodDays($clawBackPeriodDays)
            ->setPromotionName($promotionName)
            ->setPromotionDescription($promotionDescription)
            ->setPromoCode($promoCode)
            ->setPromotionTypeName($promotionTypeName)
            ->setBillingDisplayDescription($billingDisplayDescription)
            ->setPromotionCategoryName($promotionCategoryName)
            ->setPromotionModelName($promotionModelName)
            ->setCreatedByUserName($createdByUserName)
            ->setLastUpdatedByUserName($lastUpdatedByUserName)
            ->setServiceProvidersArray($serviceProvidersArray)
            ->setPromotionAccountTypes($promotionAccountTypes)
            ->setPromotionDistributionServiceProviders($promotionDistributionServiceProviders)
            ->setPromotionSchedule($promotionSchedule)
            ->setPromotionTiers($promotionTiers)
            ->setDistributionServiceProviders($distributionServiceProviders)
            ->setPromotionCharacteristic($promotionCharacteristic)
            ->setPromotionScheduleSpecificDay($promotionScheduleSpecificDay);
    }
    /**
     * Get PromotionID value
     * @return int
     */
    public function getPromotionID()
    {
        return $this->PromotionID;
    }
    /**
     * Set PromotionID value
     * @param int $promotionID
     * @return \SGCIS\Struct\Promotion
     */
    public function setPromotionID($promotionID = null)
    {
        // validation for constraint: int
        if (!is_null($promotionID) && !is_numeric($promotionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($promotionID)), __LINE__);
        }
        $this->PromotionID = $promotionID;
        return $this;
    }
    /**
     * Get PromotionTypeID value
     * @return int
     */
    public function getPromotionTypeID()
    {
        return $this->PromotionTypeID;
    }
    /**
     * Set PromotionTypeID value
     * @param int $promotionTypeID
     * @return \SGCIS\Struct\Promotion
     */
    public function setPromotionTypeID($promotionTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($promotionTypeID) && !is_numeric($promotionTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($promotionTypeID)), __LINE__);
        }
        $this->PromotionTypeID = $promotionTypeID;
        return $this;
    }
    /**
     * Get PromotionLevelID value
     * @return int
     */
    public function getPromotionLevelID()
    {
        return $this->PromotionLevelID;
    }
    /**
     * Set PromotionLevelID value
     * @param int $promotionLevelID
     * @return \SGCIS\Struct\Promotion
     */
    public function setPromotionLevelID($promotionLevelID = null)
    {
        // validation for constraint: int
        if (!is_null($promotionLevelID) && !is_numeric($promotionLevelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($promotionLevelID)), __LINE__);
        }
        $this->PromotionLevelID = $promotionLevelID;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \SGCIS\Struct\Promotion
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get IsApproved value
     * @return bool
     */
    public function getIsApproved()
    {
        return $this->IsApproved;
    }
    /**
     * Set IsApproved value
     * @param bool $isApproved
     * @return \SGCIS\Struct\Promotion
     */
    public function setIsApproved($isApproved = null)
    {
        // validation for constraint: boolean
        if (!is_null($isApproved) && !is_bool($isApproved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isApproved)), __LINE__);
        }
        $this->IsApproved = $isApproved;
        return $this;
    }
    /**
     * Get IsContracted value
     * @return bool
     */
    public function getIsContracted()
    {
        return $this->IsContracted;
    }
    /**
     * Set IsContracted value
     * @param bool $isContracted
     * @return \SGCIS\Struct\Promotion
     */
    public function setIsContracted($isContracted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isContracted) && !is_bool($isContracted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isContracted)), __LINE__);
        }
        $this->IsContracted = $isContracted;
        return $this;
    }
    /**
     * Get PromotionCategoryID value
     * @return int
     */
    public function getPromotionCategoryID()
    {
        return $this->PromotionCategoryID;
    }
    /**
     * Set PromotionCategoryID value
     * @param int $promotionCategoryID
     * @return \SGCIS\Struct\Promotion
     */
    public function setPromotionCategoryID($promotionCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($promotionCategoryID) && !is_numeric($promotionCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($promotionCategoryID)), __LINE__);
        }
        $this->PromotionCategoryID = $promotionCategoryID;
        return $this;
    }
    /**
     * Get PromotionModelID value
     * @return int
     */
    public function getPromotionModelID()
    {
        return $this->PromotionModelID;
    }
    /**
     * Set PromotionModelID value
     * @param int $promotionModelID
     * @return \SGCIS\Struct\Promotion
     */
    public function setPromotionModelID($promotionModelID = null)
    {
        // validation for constraint: int
        if (!is_null($promotionModelID) && !is_numeric($promotionModelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($promotionModelID)), __LINE__);
        }
        $this->PromotionModelID = $promotionModelID;
        return $this;
    }
    /**
     * Get UnitOfMeasureID value
     * @return int
     */
    public function getUnitOfMeasureID()
    {
        return $this->UnitOfMeasureID;
    }
    /**
     * Set UnitOfMeasureID value
     * @param int $unitOfMeasureID
     * @return \SGCIS\Struct\Promotion
     */
    public function setUnitOfMeasureID($unitOfMeasureID = null)
    {
        // validation for constraint: int
        if (!is_null($unitOfMeasureID) && !is_numeric($unitOfMeasureID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unitOfMeasureID)), __LINE__);
        }
        $this->UnitOfMeasureID = $unitOfMeasureID;
        return $this;
    }
    /**
     * Get PromotionAmount value
     * @return float
     */
    public function getPromotionAmount()
    {
        return $this->PromotionAmount;
    }
    /**
     * Set PromotionAmount value
     * @param float $promotionAmount
     * @return \SGCIS\Struct\Promotion
     */
    public function setPromotionAmount($promotionAmount = null)
    {
        $this->PromotionAmount = $promotionAmount;
        return $this;
    }
    /**
     * Get PromotionAmountContracted value
     * @return float
     */
    public function getPromotionAmountContracted()
    {
        return $this->PromotionAmountContracted;
    }
    /**
     * Set PromotionAmountContracted value
     * @param float $promotionAmountContracted
     * @return \SGCIS\Struct\Promotion
     */
    public function setPromotionAmountContracted($promotionAmountContracted = null)
    {
        $this->PromotionAmountContracted = $promotionAmountContracted;
        return $this;
    }
    /**
     * Get TOUID value
     * @return int
     */
    public function getTOUID()
    {
        return $this->TOUID;
    }
    /**
     * Set TOUID value
     * @param int $tOUID
     * @return \SGCIS\Struct\Promotion
     */
    public function setTOUID($tOUID = null)
    {
        // validation for constraint: int
        if (!is_null($tOUID) && !is_numeric($tOUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tOUID)), __LINE__);
        }
        $this->TOUID = $tOUID;
        return $this;
    }
    /**
     * Get ThresholdUnits value
     * @return int
     */
    public function getThresholdUnits()
    {
        return $this->ThresholdUnits;
    }
    /**
     * Set ThresholdUnits value
     * @param int $thresholdUnits
     * @return \SGCIS\Struct\Promotion
     */
    public function setThresholdUnits($thresholdUnits = null)
    {
        // validation for constraint: int
        if (!is_null($thresholdUnits) && !is_numeric($thresholdUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($thresholdUnits)), __LINE__);
        }
        $this->ThresholdUnits = $thresholdUnits;
        return $this;
    }
    /**
     * Get AmountBelowThreshold value
     * @return float
     */
    public function getAmountBelowThreshold()
    {
        return $this->AmountBelowThreshold;
    }
    /**
     * Set AmountBelowThreshold value
     * @param float $amountBelowThreshold
     * @return \SGCIS\Struct\Promotion
     */
    public function setAmountBelowThreshold($amountBelowThreshold = null)
    {
        $this->AmountBelowThreshold = $amountBelowThreshold;
        return $this;
    }
    /**
     * Get AmountAboveThreshold value
     * @return float
     */
    public function getAmountAboveThreshold()
    {
        return $this->AmountAboveThreshold;
    }
    /**
     * Set AmountAboveThreshold value
     * @param float $amountAboveThreshold
     * @return \SGCIS\Struct\Promotion
     */
    public function setAmountAboveThreshold($amountAboveThreshold = null)
    {
        $this->AmountAboveThreshold = $amountAboveThreshold;
        return $this;
    }
    /**
     * Get PaymentAmount value
     * @return float
     */
    public function getPaymentAmount()
    {
        return $this->PaymentAmount;
    }
    /**
     * Set PaymentAmount value
     * @param float $paymentAmount
     * @return \SGCIS\Struct\Promotion
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        $this->PaymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Get EffectiveStartDate value
     * @return string
     */
    public function getEffectiveStartDate()
    {
        return $this->EffectiveStartDate;
    }
    /**
     * Set EffectiveStartDate value
     * @param string $effectiveStartDate
     * @return \SGCIS\Struct\Promotion
     */
    public function setEffectiveStartDate($effectiveStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveStartDate) && !is_string($effectiveStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveStartDate)), __LINE__);
        }
        $this->EffectiveStartDate = $effectiveStartDate;
        return $this;
    }
    /**
     * Get EffectiveEndDate value
     * @return string
     */
    public function getEffectiveEndDate()
    {
        return $this->EffectiveEndDate;
    }
    /**
     * Set EffectiveEndDate value
     * @param string $effectiveEndDate
     * @return \SGCIS\Struct\Promotion
     */
    public function setEffectiveEndDate($effectiveEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveEndDate) && !is_string($effectiveEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveEndDate)), __LINE__);
        }
        $this->EffectiveEndDate = $effectiveEndDate;
        return $this;
    }
    /**
     * Get AvailableStartDate value
     * @return string
     */
    public function getAvailableStartDate()
    {
        return $this->AvailableStartDate;
    }
    /**
     * Set AvailableStartDate value
     * @param string $availableStartDate
     * @return \SGCIS\Struct\Promotion
     */
    public function setAvailableStartDate($availableStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($availableStartDate) && !is_string($availableStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($availableStartDate)), __LINE__);
        }
        $this->AvailableStartDate = $availableStartDate;
        return $this;
    }
    /**
     * Get AvailableEndDate value
     * @return string
     */
    public function getAvailableEndDate()
    {
        return $this->AvailableEndDate;
    }
    /**
     * Set AvailableEndDate value
     * @param string $availableEndDate
     * @return \SGCIS\Struct\Promotion
     */
    public function setAvailableEndDate($availableEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($availableEndDate) && !is_string($availableEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($availableEndDate)), __LINE__);
        }
        $this->AvailableEndDate = $availableEndDate;
        return $this;
    }
    /**
     * Get IsActiveAutoPay value
     * @return bool
     */
    public function getIsActiveAutoPay()
    {
        return $this->IsActiveAutoPay;
    }
    /**
     * Set IsActiveAutoPay value
     * @param bool $isActiveAutoPay
     * @return \SGCIS\Struct\Promotion
     */
    public function setIsActiveAutoPay($isActiveAutoPay = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActiveAutoPay) && !is_bool($isActiveAutoPay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActiveAutoPay)), __LINE__);
        }
        $this->IsActiveAutoPay = $isActiveAutoPay;
        return $this;
    }
    /**
     * Get IsActiveEBill value
     * @return bool
     */
    public function getIsActiveEBill()
    {
        return $this->IsActiveEBill;
    }
    /**
     * Set IsActiveEBill value
     * @param bool $isActiveEBill
     * @return \SGCIS\Struct\Promotion
     */
    public function setIsActiveEBill($isActiveEBill = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActiveEBill) && !is_bool($isActiveEBill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActiveEBill)), __LINE__);
        }
        $this->IsActiveEBill = $isActiveEBill;
        return $this;
    }
    /**
     * Get IsTaxable value
     * @return bool
     */
    public function getIsTaxable()
    {
        return $this->IsTaxable;
    }
    /**
     * Set IsTaxable value
     * @param bool $isTaxable
     * @return \SGCIS\Struct\Promotion
     */
    public function setIsTaxable($isTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxable) && !is_bool($isTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isTaxable)), __LINE__);
        }
        $this->IsTaxable = $isTaxable;
        return $this;
    }
    /**
     * Get AppliesToRenewals value
     * @return bool
     */
    public function getAppliesToRenewals()
    {
        return $this->AppliesToRenewals;
    }
    /**
     * Set AppliesToRenewals value
     * @param bool $appliesToRenewals
     * @return \SGCIS\Struct\Promotion
     */
    public function setAppliesToRenewals($appliesToRenewals = null)
    {
        // validation for constraint: boolean
        if (!is_null($appliesToRenewals) && !is_bool($appliesToRenewals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($appliesToRenewals)), __LINE__);
        }
        $this->AppliesToRenewals = $appliesToRenewals;
        return $this;
    }
    /**
     * Get PromotionTriggerSystemEventID value
     * @return int
     */
    public function getPromotionTriggerSystemEventID()
    {
        return $this->PromotionTriggerSystemEventID;
    }
    /**
     * Set PromotionTriggerSystemEventID value
     * @param int $promotionTriggerSystemEventID
     * @return \SGCIS\Struct\Promotion
     */
    public function setPromotionTriggerSystemEventID($promotionTriggerSystemEventID = null)
    {
        // validation for constraint: int
        if (!is_null($promotionTriggerSystemEventID) && !is_numeric($promotionTriggerSystemEventID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($promotionTriggerSystemEventID)), __LINE__);
        }
        $this->PromotionTriggerSystemEventID = $promotionTriggerSystemEventID;
        return $this;
    }
    /**
     * Get ChargeCategoryID value
     * @return int
     */
    public function getChargeCategoryID()
    {
        return $this->ChargeCategoryID;
    }
    /**
     * Set ChargeCategoryID value
     * @param int $chargeCategoryID
     * @return \SGCIS\Struct\Promotion
     */
    public function setChargeCategoryID($chargeCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeCategoryID) && !is_numeric($chargeCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeCategoryID)), __LINE__);
        }
        $this->ChargeCategoryID = $chargeCategoryID;
        return $this;
    }
    /**
     * Get PromotionChargeID value
     * @return int
     */
    public function getPromotionChargeID()
    {
        return $this->PromotionChargeID;
    }
    /**
     * Set PromotionChargeID value
     * @param int $promotionChargeID
     * @return \SGCIS\Struct\Promotion
     */
    public function setPromotionChargeID($promotionChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($promotionChargeID) && !is_numeric($promotionChargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($promotionChargeID)), __LINE__);
        }
        $this->PromotionChargeID = $promotionChargeID;
        return $this;
    }
    /**
     * Get ProrateCharge value
     * @return bool
     */
    public function getProrateCharge()
    {
        return $this->ProrateCharge;
    }
    /**
     * Set ProrateCharge value
     * @param bool $prorateCharge
     * @return \SGCIS\Struct\Promotion
     */
    public function setProrateCharge($prorateCharge = null)
    {
        // validation for constraint: boolean
        if (!is_null($prorateCharge) && !is_bool($prorateCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($prorateCharge)), __LINE__);
        }
        $this->ProrateCharge = $prorateCharge;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\Promotion
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get LastUpdateDate value
     * @return string
     */
    public function getLastUpdateDate()
    {
        return $this->LastUpdateDate;
    }
    /**
     * Set LastUpdateDate value
     * @param string $lastUpdateDate
     * @return \SGCIS\Struct\Promotion
     */
    public function setLastUpdateDate($lastUpdateDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDate) && !is_string($lastUpdateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateDate)), __LINE__);
        }
        $this->LastUpdateDate = $lastUpdateDate;
        return $this;
    }
    /**
     * Get ApplyAfterTerminationDate value
     * @return bool
     */
    public function getApplyAfterTerminationDate()
    {
        return $this->ApplyAfterTerminationDate;
    }
    /**
     * Set ApplyAfterTerminationDate value
     * @param bool $applyAfterTerminationDate
     * @return \SGCIS\Struct\Promotion
     */
    public function setApplyAfterTerminationDate($applyAfterTerminationDate = null)
    {
        // validation for constraint: boolean
        if (!is_null($applyAfterTerminationDate) && !is_bool($applyAfterTerminationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($applyAfterTerminationDate)), __LINE__);
        }
        $this->ApplyAfterTerminationDate = $applyAfterTerminationDate;
        return $this;
    }
    /**
     * Get IsPromotionCodeRequired value
     * @return bool
     */
    public function getIsPromotionCodeRequired()
    {
        return $this->IsPromotionCodeRequired;
    }
    /**
     * Set IsPromotionCodeRequired value
     * @param bool $isPromotionCodeRequired
     * @return \SGCIS\Struct\Promotion
     */
    public function setIsPromotionCodeRequired($isPromotionCodeRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPromotionCodeRequired) && !is_bool($isPromotionCodeRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPromotionCodeRequired)), __LINE__);
        }
        $this->IsPromotionCodeRequired = $isPromotionCodeRequired;
        return $this;
    }
    /**
     * Get CustomPromotionModuleID value
     * @return int
     */
    public function getCustomPromotionModuleID()
    {
        return $this->CustomPromotionModuleID;
    }
    /**
     * Set CustomPromotionModuleID value
     * @param int $customPromotionModuleID
     * @return \SGCIS\Struct\Promotion
     */
    public function setCustomPromotionModuleID($customPromotionModuleID = null)
    {
        // validation for constraint: int
        if (!is_null($customPromotionModuleID) && !is_numeric($customPromotionModuleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customPromotionModuleID)), __LINE__);
        }
        $this->CustomPromotionModuleID = $customPromotionModuleID;
        return $this;
    }
    /**
     * Get TenureActiveDays value
     * @return int
     */
    public function getTenureActiveDays()
    {
        return $this->TenureActiveDays;
    }
    /**
     * Set TenureActiveDays value
     * @param int $tenureActiveDays
     * @return \SGCIS\Struct\Promotion
     */
    public function setTenureActiveDays($tenureActiveDays = null)
    {
        // validation for constraint: int
        if (!is_null($tenureActiveDays) && !is_numeric($tenureActiveDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tenureActiveDays)), __LINE__);
        }
        $this->TenureActiveDays = $tenureActiveDays;
        return $this;
    }
    /**
     * Get TransactionTypeID value
     * @return int
     */
    public function getTransactionTypeID()
    {
        return $this->TransactionTypeID;
    }
    /**
     * Set TransactionTypeID value
     * @param int $transactionTypeID
     * @return \SGCIS\Struct\Promotion
     */
    public function setTransactionTypeID($transactionTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($transactionTypeID) && !is_numeric($transactionTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transactionTypeID)), __LINE__);
        }
        $this->TransactionTypeID = $transactionTypeID;
        return $this;
    }
    /**
     * Get TransactionTypeCategoryID value
     * @return int
     */
    public function getTransactionTypeCategoryID()
    {
        return $this->TransactionTypeCategoryID;
    }
    /**
     * Set TransactionTypeCategoryID value
     * @param int $transactionTypeCategoryID
     * @return \SGCIS\Struct\Promotion
     */
    public function setTransactionTypeCategoryID($transactionTypeCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($transactionTypeCategoryID) && !is_numeric($transactionTypeCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transactionTypeCategoryID)), __LINE__);
        }
        $this->TransactionTypeCategoryID = $transactionTypeCategoryID;
        return $this;
    }
    /**
     * Get ClawBackPeriodDays value
     * @return int
     */
    public function getClawBackPeriodDays()
    {
        return $this->ClawBackPeriodDays;
    }
    /**
     * Set ClawBackPeriodDays value
     * @param int $clawBackPeriodDays
     * @return \SGCIS\Struct\Promotion
     */
    public function setClawBackPeriodDays($clawBackPeriodDays = null)
    {
        // validation for constraint: int
        if (!is_null($clawBackPeriodDays) && !is_numeric($clawBackPeriodDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($clawBackPeriodDays)), __LINE__);
        }
        $this->ClawBackPeriodDays = $clawBackPeriodDays;
        return $this;
    }
    /**
     * Get PromotionName value
     * @return string|null
     */
    public function getPromotionName()
    {
        return $this->PromotionName;
    }
    /**
     * Set PromotionName value
     * @param string $promotionName
     * @return \SGCIS\Struct\Promotion
     */
    public function setPromotionName($promotionName = null)
    {
        // validation for constraint: string
        if (!is_null($promotionName) && !is_string($promotionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($promotionName)), __LINE__);
        }
        $this->PromotionName = $promotionName;
        return $this;
    }
    /**
     * Get PromotionDescription value
     * @return string|null
     */
    public function getPromotionDescription()
    {
        return $this->PromotionDescription;
    }
    /**
     * Set PromotionDescription value
     * @param string $promotionDescription
     * @return \SGCIS\Struct\Promotion
     */
    public function setPromotionDescription($promotionDescription = null)
    {
        // validation for constraint: string
        if (!is_null($promotionDescription) && !is_string($promotionDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($promotionDescription)), __LINE__);
        }
        $this->PromotionDescription = $promotionDescription;
        return $this;
    }
    /**
     * Get PromoCode value
     * @return string|null
     */
    public function getPromoCode()
    {
        return $this->PromoCode;
    }
    /**
     * Set PromoCode value
     * @param string $promoCode
     * @return \SGCIS\Struct\Promotion
     */
    public function setPromoCode($promoCode = null)
    {
        // validation for constraint: string
        if (!is_null($promoCode) && !is_string($promoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($promoCode)), __LINE__);
        }
        $this->PromoCode = $promoCode;
        return $this;
    }
    /**
     * Get PromotionTypeName value
     * @return string|null
     */
    public function getPromotionTypeName()
    {
        return $this->PromotionTypeName;
    }
    /**
     * Set PromotionTypeName value
     * @param string $promotionTypeName
     * @return \SGCIS\Struct\Promotion
     */
    public function setPromotionTypeName($promotionTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($promotionTypeName) && !is_string($promotionTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($promotionTypeName)), __LINE__);
        }
        $this->PromotionTypeName = $promotionTypeName;
        return $this;
    }
    /**
     * Get BillingDisplayDescription value
     * @return string|null
     */
    public function getBillingDisplayDescription()
    {
        return $this->BillingDisplayDescription;
    }
    /**
     * Set BillingDisplayDescription value
     * @param string $billingDisplayDescription
     * @return \SGCIS\Struct\Promotion
     */
    public function setBillingDisplayDescription($billingDisplayDescription = null)
    {
        // validation for constraint: string
        if (!is_null($billingDisplayDescription) && !is_string($billingDisplayDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingDisplayDescription)), __LINE__);
        }
        $this->BillingDisplayDescription = $billingDisplayDescription;
        return $this;
    }
    /**
     * Get PromotionCategoryName value
     * @return string|null
     */
    public function getPromotionCategoryName()
    {
        return $this->PromotionCategoryName;
    }
    /**
     * Set PromotionCategoryName value
     * @param string $promotionCategoryName
     * @return \SGCIS\Struct\Promotion
     */
    public function setPromotionCategoryName($promotionCategoryName = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCategoryName) && !is_string($promotionCategoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($promotionCategoryName)), __LINE__);
        }
        $this->PromotionCategoryName = $promotionCategoryName;
        return $this;
    }
    /**
     * Get PromotionModelName value
     * @return string|null
     */
    public function getPromotionModelName()
    {
        return $this->PromotionModelName;
    }
    /**
     * Set PromotionModelName value
     * @param string $promotionModelName
     * @return \SGCIS\Struct\Promotion
     */
    public function setPromotionModelName($promotionModelName = null)
    {
        // validation for constraint: string
        if (!is_null($promotionModelName) && !is_string($promotionModelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($promotionModelName)), __LINE__);
        }
        $this->PromotionModelName = $promotionModelName;
        return $this;
    }
    /**
     * Get CreatedByUserName value
     * @return string|null
     */
    public function getCreatedByUserName()
    {
        return $this->CreatedByUserName;
    }
    /**
     * Set CreatedByUserName value
     * @param string $createdByUserName
     * @return \SGCIS\Struct\Promotion
     */
    public function setCreatedByUserName($createdByUserName = null)
    {
        // validation for constraint: string
        if (!is_null($createdByUserName) && !is_string($createdByUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdByUserName)), __LINE__);
        }
        $this->CreatedByUserName = $createdByUserName;
        return $this;
    }
    /**
     * Get LastUpdatedByUserName value
     * @return string|null
     */
    public function getLastUpdatedByUserName()
    {
        return $this->LastUpdatedByUserName;
    }
    /**
     * Set LastUpdatedByUserName value
     * @param string $lastUpdatedByUserName
     * @return \SGCIS\Struct\Promotion
     */
    public function setLastUpdatedByUserName($lastUpdatedByUserName = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdatedByUserName) && !is_string($lastUpdatedByUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdatedByUserName)), __LINE__);
        }
        $this->LastUpdatedByUserName = $lastUpdatedByUserName;
        return $this;
    }
    /**
     * Get ServiceProvidersArray value
     * @return string|null
     */
    public function getServiceProvidersArray()
    {
        return $this->ServiceProvidersArray;
    }
    /**
     * Set ServiceProvidersArray value
     * @param string $serviceProvidersArray
     * @return \SGCIS\Struct\Promotion
     */
    public function setServiceProvidersArray($serviceProvidersArray = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProvidersArray) && !is_string($serviceProvidersArray)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceProvidersArray)), __LINE__);
        }
        $this->ServiceProvidersArray = $serviceProvidersArray;
        return $this;
    }
    /**
     * Get PromotionAccountTypes value
     * @return \SGCIS\Array\ArrayOfPromotionAccountType|null
     */
    public function getPromotionAccountTypes()
    {
        return $this->PromotionAccountTypes;
    }
    /**
     * Set PromotionAccountTypes value
     * @param \SGCIS\Array\ArrayOfPromotionAccountType $promotionAccountTypes
     * @return \SGCIS\Struct\Promotion
     */
    public function setPromotionAccountTypes(\SGCIS\Array\ArrayOfPromotionAccountType $promotionAccountTypes = null)
    {
        $this->PromotionAccountTypes = $promotionAccountTypes;
        return $this;
    }
    /**
     * Get PromotionDistributionServiceProviders value
     * @return \SGCIS\Array\ArrayOfPromotionDistributionServiceProvider|null
     */
    public function getPromotionDistributionServiceProviders()
    {
        return $this->PromotionDistributionServiceProviders;
    }
    /**
     * Set PromotionDistributionServiceProviders value
     * @param \SGCIS\Array\ArrayOfPromotionDistributionServiceProvider $promotionDistributionServiceProviders
     * @return \SGCIS\Struct\Promotion
     */
    public function setPromotionDistributionServiceProviders(\SGCIS\Array\ArrayOfPromotionDistributionServiceProvider $promotionDistributionServiceProviders = null)
    {
        $this->PromotionDistributionServiceProviders = $promotionDistributionServiceProviders;
        return $this;
    }
    /**
     * Get PromotionSchedule value
     * @return \SGCIS\Struct\PromotionSchedule|null
     */
    public function getPromotionSchedule()
    {
        return $this->PromotionSchedule;
    }
    /**
     * Set PromotionSchedule value
     * @param \SGCIS\Struct\PromotionSchedule $promotionSchedule
     * @return \SGCIS\Struct\Promotion
     */
    public function setPromotionSchedule(\SGCIS\Struct\PromotionSchedule $promotionSchedule = null)
    {
        $this->PromotionSchedule = $promotionSchedule;
        return $this;
    }
    /**
     * Get PromotionTiers value
     * @return \SGCIS\Array\ArrayOfPromotionTier|null
     */
    public function getPromotionTiers()
    {
        return $this->PromotionTiers;
    }
    /**
     * Set PromotionTiers value
     * @param \SGCIS\Array\ArrayOfPromotionTier $promotionTiers
     * @return \SGCIS\Struct\Promotion
     */
    public function setPromotionTiers(\SGCIS\Array\ArrayOfPromotionTier $promotionTiers = null)
    {
        $this->PromotionTiers = $promotionTiers;
        return $this;
    }
    /**
     * Get DistributionServiceProviders value
     * @return \SGCIS\Array\ArrayOfDistributionServiceProvider|null
     */
    public function getDistributionServiceProviders()
    {
        return $this->DistributionServiceProviders;
    }
    /**
     * Set DistributionServiceProviders value
     * @param \SGCIS\Array\ArrayOfDistributionServiceProvider $distributionServiceProviders
     * @return \SGCIS\Struct\Promotion
     */
    public function setDistributionServiceProviders(\SGCIS\Array\ArrayOfDistributionServiceProvider $distributionServiceProviders = null)
    {
        $this->DistributionServiceProviders = $distributionServiceProviders;
        return $this;
    }
    /**
     * Get PromotionCharacteristic value
     * @return \SGCIS\Array\ArrayOfPromotionCharacteristic|null
     */
    public function getPromotionCharacteristic()
    {
        return $this->PromotionCharacteristic;
    }
    /**
     * Set PromotionCharacteristic value
     * @param \SGCIS\Array\ArrayOfPromotionCharacteristic $promotionCharacteristic
     * @return \SGCIS\Struct\Promotion
     */
    public function setPromotionCharacteristic(\SGCIS\Array\ArrayOfPromotionCharacteristic $promotionCharacteristic = null)
    {
        $this->PromotionCharacteristic = $promotionCharacteristic;
        return $this;
    }
    /**
     * Get PromotionScheduleSpecificDay value
     * @return \SGCIS\Array\ArrayOfPromotionScheduleSpecificDay|null
     */
    public function getPromotionScheduleSpecificDay()
    {
        return $this->PromotionScheduleSpecificDay;
    }
    /**
     * Set PromotionScheduleSpecificDay value
     * @param \SGCIS\Array\ArrayOfPromotionScheduleSpecificDay $promotionScheduleSpecificDay
     * @return \SGCIS\Struct\Promotion
     */
    public function setPromotionScheduleSpecificDay(\SGCIS\Array\ArrayOfPromotionScheduleSpecificDay $promotionScheduleSpecificDay = null)
    {
        $this->PromotionScheduleSpecificDay = $promotionScheduleSpecificDay;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\Promotion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
