<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductAvgPrice Struct
 * @subpackage Structs
 */
class ProductAvgPrice extends BaseDTO
{
    /**
     * The ProductAvgPriceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductAvgPriceID;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The ServiceProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceProviderID;
    /**
     * The Kwh500
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Kwh500;
    /**
     * The Kwh1000
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Kwh1000;
    /**
     * The Kwh2000
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Kwh2000;
    /**
     * The ServiceProviderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceProviderName;
    /**
     * Constructor method for ProductAvgPrice
     * @uses ProductAvgPrice::setProductAvgPriceID()
     * @uses ProductAvgPrice::setProductID()
     * @uses ProductAvgPrice::setServiceProviderID()
     * @uses ProductAvgPrice::setKwh500()
     * @uses ProductAvgPrice::setKwh1000()
     * @uses ProductAvgPrice::setKwh2000()
     * @uses ProductAvgPrice::setServiceProviderName()
     * @param int $productAvgPriceID
     * @param int $productID
     * @param int $serviceProviderID
     * @param float $kwh500
     * @param float $kwh1000
     * @param float $kwh2000
     * @param string $serviceProviderName
     */
    public function __construct($productAvgPriceID = null, $productID = null, $serviceProviderID = null, $kwh500 = null, $kwh1000 = null, $kwh2000 = null, $serviceProviderName = null)
    {
        $this
            ->setProductAvgPriceID($productAvgPriceID)
            ->setProductID($productID)
            ->setServiceProviderID($serviceProviderID)
            ->setKwh500($kwh500)
            ->setKwh1000($kwh1000)
            ->setKwh2000($kwh2000)
            ->setServiceProviderName($serviceProviderName);
    }
    /**
     * Get ProductAvgPriceID value
     * @return int
     */
    public function getProductAvgPriceID()
    {
        return $this->ProductAvgPriceID;
    }
    /**
     * Set ProductAvgPriceID value
     * @param int $productAvgPriceID
     * @return \SGCIS\Struct\ProductAvgPrice
     */
    public function setProductAvgPriceID($productAvgPriceID = null)
    {
        // validation for constraint: int
        if (!is_null($productAvgPriceID) && !is_numeric($productAvgPriceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productAvgPriceID)), __LINE__);
        }
        $this->ProductAvgPriceID = $productAvgPriceID;
        return $this;
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \SGCIS\Struct\ProductAvgPrice
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get ServiceProviderID value
     * @return int
     */
    public function getServiceProviderID()
    {
        return $this->ServiceProviderID;
    }
    /**
     * Set ServiceProviderID value
     * @param int $serviceProviderID
     * @return \SGCIS\Struct\ProductAvgPrice
     */
    public function setServiceProviderID($serviceProviderID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceProviderID) && !is_numeric($serviceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceProviderID)), __LINE__);
        }
        $this->ServiceProviderID = $serviceProviderID;
        return $this;
    }
    /**
     * Get Kwh500 value
     * @return float
     */
    public function getKwh500()
    {
        return $this->Kwh500;
    }
    /**
     * Set Kwh500 value
     * @param float $kwh500
     * @return \SGCIS\Struct\ProductAvgPrice
     */
    public function setKwh500($kwh500 = null)
    {
        $this->Kwh500 = $kwh500;
        return $this;
    }
    /**
     * Get Kwh1000 value
     * @return float
     */
    public function getKwh1000()
    {
        return $this->Kwh1000;
    }
    /**
     * Set Kwh1000 value
     * @param float $kwh1000
     * @return \SGCIS\Struct\ProductAvgPrice
     */
    public function setKwh1000($kwh1000 = null)
    {
        $this->Kwh1000 = $kwh1000;
        return $this;
    }
    /**
     * Get Kwh2000 value
     * @return float
     */
    public function getKwh2000()
    {
        return $this->Kwh2000;
    }
    /**
     * Set Kwh2000 value
     * @param float $kwh2000
     * @return \SGCIS\Struct\ProductAvgPrice
     */
    public function setKwh2000($kwh2000 = null)
    {
        $this->Kwh2000 = $kwh2000;
        return $this;
    }
    /**
     * Get ServiceProviderName value
     * @return string|null
     */
    public function getServiceProviderName()
    {
        return $this->ServiceProviderName;
    }
    /**
     * Set ServiceProviderName value
     * @param string $serviceProviderName
     * @return \SGCIS\Struct\ProductAvgPrice
     */
    public function setServiceProviderName($serviceProviderName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderName) && !is_string($serviceProviderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceProviderName)), __LINE__);
        }
        $this->ServiceProviderName = $serviceProviderName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ProductAvgPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
