<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Person Struct
 * @subpackage Structs
 */
class Person extends BaseDTO
{
    /**
     * The PersonID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonID;
    /**
     * The PersonTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonTypeID;
    /**
     * The DateOfBirth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateOfBirth;
    /**
     * The IsPrimary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPrimary;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The PersonIDTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonIDTypeID;
    /**
     * The IsError
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsError;
    /**
     * The VerificationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $VerificationDate;
    /**
     * The SalutationTypeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SalutationTypeId;
    /**
     * The IsBelonger
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsBelonger;
    /**
     * The SendBill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SendBill;
    /**
     * The SendMessaging
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SendMessaging;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The MiddleInitial
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MiddleInitial;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The PasswordDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PasswordDisplay;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The SSN
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SSN;
    /**
     * The DriversLicense
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriversLicense;
    /**
     * The DriversLicenseState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriversLicenseState;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The AccountStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountStatusName;
    /**
     * The PersonTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonTypeName;
    /**
     * The PersonIDTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonIDTypeName;
    /**
     * The PersonIDValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonIDValue;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountAddress
     */
    public $Address;
    /**
     * The HostSystemID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HostSystemID;
    /**
     * The VerificationHash
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VerificationHash;
    /**
     * The SalutationTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalutationTypeName;
    /**
     * The BusinessName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BusinessName;
    /**
     * The FederalTaxID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FederalTaxID;
    /**
     * The RepFirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RepFirstName;
    /**
     * The RepLastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RepLastName;
    /**
     * The LegacyPersonID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LegacyPersonID;
    /**
     * The FullName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FullName;
    /**
     * The RepFullName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RepFullName;
    /**
     * The CompoundName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompoundName;
    /**
     * The PersonType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\PersonType
     */
    public $PersonType;
    /**
     * The ServicePoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\ServicePoint
     */
    public $ServicePoint;
    /**
     * The PersonContacts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfPersonContact
     */
    public $PersonContacts;
    /**
     * The NotificationChannels
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfNotificationChannel
     */
    public $NotificationChannels;
    /**
     * The AccountPersons
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountPerson
     */
    public $AccountPersons;
    /**
     * Constructor method for Person
     * @uses Person::setPersonID()
     * @uses Person::setPersonTypeID()
     * @uses Person::setDateOfBirth()
     * @uses Person::setIsPrimary()
     * @uses Person::setAccountID()
     * @uses Person::setPersonIDTypeID()
     * @uses Person::setIsError()
     * @uses Person::setVerificationDate()
     * @uses Person::setSalutationTypeId()
     * @uses Person::setIsBelonger()
     * @uses Person::setSendBill()
     * @uses Person::setSendMessaging()
     * @uses Person::setFirstName()
     * @uses Person::setLastName()
     * @uses Person::setMiddleInitial()
     * @uses Person::setUserName()
     * @uses Person::setPassword()
     * @uses Person::setPasswordDisplay()
     * @uses Person::setEmailAddress()
     * @uses Person::setSSN()
     * @uses Person::setDriversLicense()
     * @uses Person::setDriversLicenseState()
     * @uses Person::setAccountNumber()
     * @uses Person::setAccountStatusName()
     * @uses Person::setPersonTypeName()
     * @uses Person::setPersonIDTypeName()
     * @uses Person::setPersonIDValue()
     * @uses Person::setAddress()
     * @uses Person::setHostSystemID()
     * @uses Person::setVerificationHash()
     * @uses Person::setSalutationTypeName()
     * @uses Person::setBusinessName()
     * @uses Person::setFederalTaxID()
     * @uses Person::setRepFirstName()
     * @uses Person::setRepLastName()
     * @uses Person::setLegacyPersonID()
     * @uses Person::setFullName()
     * @uses Person::setRepFullName()
     * @uses Person::setCompoundName()
     * @uses Person::setPersonType()
     * @uses Person::setServicePoint()
     * @uses Person::setPersonContacts()
     * @uses Person::setNotificationChannels()
     * @uses Person::setAccountPersons()
     * @param int $personID
     * @param int $personTypeID
     * @param string $dateOfBirth
     * @param bool $isPrimary
     * @param int $accountID
     * @param int $personIDTypeID
     * @param bool $isError
     * @param string $verificationDate
     * @param int $salutationTypeId
     * @param bool $isBelonger
     * @param bool $sendBill
     * @param bool $sendMessaging
     * @param string $firstName
     * @param string $lastName
     * @param string $middleInitial
     * @param string $userName
     * @param string $password
     * @param string $passwordDisplay
     * @param string $emailAddress
     * @param string $sSN
     * @param string $driversLicense
     * @param string $driversLicenseState
     * @param string $accountNumber
     * @param string $accountStatusName
     * @param string $personTypeName
     * @param string $personIDTypeName
     * @param string $personIDValue
     * @param \SGCIS\Struct\AccountAddress $address
     * @param string $hostSystemID
     * @param string $verificationHash
     * @param string $salutationTypeName
     * @param string $businessName
     * @param string $federalTaxID
     * @param string $repFirstName
     * @param string $repLastName
     * @param string $legacyPersonID
     * @param string $fullName
     * @param string $repFullName
     * @param string $compoundName
     * @param \SGCIS\Struct\PersonType $personType
     * @param \SGCIS\Struct\ServicePoint $servicePoint
     * @param \SGCIS\Array\ArrayOfPersonContact $personContacts
     * @param \SGCIS\Array\ArrayOfNotificationChannel $notificationChannels
     * @param \SGCIS\Array\ArrayOfAccountPerson $accountPersons
     */
    public function __construct($personID = null, $personTypeID = null, $dateOfBirth = null, $isPrimary = null, $accountID = null, $personIDTypeID = null, $isError = null, $verificationDate = null, $salutationTypeId = null, $isBelonger = null, $sendBill = null, $sendMessaging = null, $firstName = null, $lastName = null, $middleInitial = null, $userName = null, $password = null, $passwordDisplay = null, $emailAddress = null, $sSN = null, $driversLicense = null, $driversLicenseState = null, $accountNumber = null, $accountStatusName = null, $personTypeName = null, $personIDTypeName = null, $personIDValue = null, \SGCIS\Struct\AccountAddress $address = null, $hostSystemID = null, $verificationHash = null, $salutationTypeName = null, $businessName = null, $federalTaxID = null, $repFirstName = null, $repLastName = null, $legacyPersonID = null, $fullName = null, $repFullName = null, $compoundName = null, \SGCIS\Struct\PersonType $personType = null, \SGCIS\Struct\ServicePoint $servicePoint = null, \SGCIS\Array\ArrayOfPersonContact $personContacts = null, \SGCIS\Array\ArrayOfNotificationChannel $notificationChannels = null, \SGCIS\Array\ArrayOfAccountPerson $accountPersons = null)
    {
        $this
            ->setPersonID($personID)
            ->setPersonTypeID($personTypeID)
            ->setDateOfBirth($dateOfBirth)
            ->setIsPrimary($isPrimary)
            ->setAccountID($accountID)
            ->setPersonIDTypeID($personIDTypeID)
            ->setIsError($isError)
            ->setVerificationDate($verificationDate)
            ->setSalutationTypeId($salutationTypeId)
            ->setIsBelonger($isBelonger)
            ->setSendBill($sendBill)
            ->setSendMessaging($sendMessaging)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setMiddleInitial($middleInitial)
            ->setUserName($userName)
            ->setPassword($password)
            ->setPasswordDisplay($passwordDisplay)
            ->setEmailAddress($emailAddress)
            ->setSSN($sSN)
            ->setDriversLicense($driversLicense)
            ->setDriversLicenseState($driversLicenseState)
            ->setAccountNumber($accountNumber)
            ->setAccountStatusName($accountStatusName)
            ->setPersonTypeName($personTypeName)
            ->setPersonIDTypeName($personIDTypeName)
            ->setPersonIDValue($personIDValue)
            ->setAddress($address)
            ->setHostSystemID($hostSystemID)
            ->setVerificationHash($verificationHash)
            ->setSalutationTypeName($salutationTypeName)
            ->setBusinessName($businessName)
            ->setFederalTaxID($federalTaxID)
            ->setRepFirstName($repFirstName)
            ->setRepLastName($repLastName)
            ->setLegacyPersonID($legacyPersonID)
            ->setFullName($fullName)
            ->setRepFullName($repFullName)
            ->setCompoundName($compoundName)
            ->setPersonType($personType)
            ->setServicePoint($servicePoint)
            ->setPersonContacts($personContacts)
            ->setNotificationChannels($notificationChannels)
            ->setAccountPersons($accountPersons);
    }
    /**
     * Get PersonID value
     * @return int
     */
    public function getPersonID()
    {
        return $this->PersonID;
    }
    /**
     * Set PersonID value
     * @param int $personID
     * @return \SGCIS\Struct\Person
     */
    public function setPersonID($personID = null)
    {
        // validation for constraint: int
        if (!is_null($personID) && !is_numeric($personID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personID)), __LINE__);
        }
        $this->PersonID = $personID;
        return $this;
    }
    /**
     * Get PersonTypeID value
     * @return int
     */
    public function getPersonTypeID()
    {
        return $this->PersonTypeID;
    }
    /**
     * Set PersonTypeID value
     * @param int $personTypeID
     * @return \SGCIS\Struct\Person
     */
    public function setPersonTypeID($personTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($personTypeID) && !is_numeric($personTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personTypeID)), __LINE__);
        }
        $this->PersonTypeID = $personTypeID;
        return $this;
    }
    /**
     * Get DateOfBirth value
     * @return string
     */
    public function getDateOfBirth()
    {
        return $this->DateOfBirth;
    }
    /**
     * Set DateOfBirth value
     * @param string $dateOfBirth
     * @return \SGCIS\Struct\Person
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfBirth) && !is_string($dateOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateOfBirth)), __LINE__);
        }
        $this->DateOfBirth = $dateOfBirth;
        return $this;
    }
    /**
     * Get IsPrimary value
     * @return bool
     */
    public function getIsPrimary()
    {
        return $this->IsPrimary;
    }
    /**
     * Set IsPrimary value
     * @param bool $isPrimary
     * @return \SGCIS\Struct\Person
     */
    public function setIsPrimary($isPrimary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrimary) && !is_bool($isPrimary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPrimary)), __LINE__);
        }
        $this->IsPrimary = $isPrimary;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\Person
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get PersonIDTypeID value
     * @return int
     */
    public function getPersonIDTypeID()
    {
        return $this->PersonIDTypeID;
    }
    /**
     * Set PersonIDTypeID value
     * @param int $personIDTypeID
     * @return \SGCIS\Struct\Person
     */
    public function setPersonIDTypeID($personIDTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($personIDTypeID) && !is_numeric($personIDTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personIDTypeID)), __LINE__);
        }
        $this->PersonIDTypeID = $personIDTypeID;
        return $this;
    }
    /**
     * Get IsError value
     * @return bool
     */
    public function getIsError()
    {
        return $this->IsError;
    }
    /**
     * Set IsError value
     * @param bool $isError
     * @return \SGCIS\Struct\Person
     */
    public function setIsError($isError = null)
    {
        // validation for constraint: boolean
        if (!is_null($isError) && !is_bool($isError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isError)), __LINE__);
        }
        $this->IsError = $isError;
        return $this;
    }
    /**
     * Get VerificationDate value
     * @return string
     */
    public function getVerificationDate()
    {
        return $this->VerificationDate;
    }
    /**
     * Set VerificationDate value
     * @param string $verificationDate
     * @return \SGCIS\Struct\Person
     */
    public function setVerificationDate($verificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($verificationDate) && !is_string($verificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($verificationDate)), __LINE__);
        }
        $this->VerificationDate = $verificationDate;
        return $this;
    }
    /**
     * Get SalutationTypeId value
     * @return int
     */
    public function getSalutationTypeId()
    {
        return $this->SalutationTypeId;
    }
    /**
     * Set SalutationTypeId value
     * @param int $salutationTypeId
     * @return \SGCIS\Struct\Person
     */
    public function setSalutationTypeId($salutationTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($salutationTypeId) && !is_numeric($salutationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($salutationTypeId)), __LINE__);
        }
        $this->SalutationTypeId = $salutationTypeId;
        return $this;
    }
    /**
     * Get IsBelonger value
     * @return bool
     */
    public function getIsBelonger()
    {
        return $this->IsBelonger;
    }
    /**
     * Set IsBelonger value
     * @param bool $isBelonger
     * @return \SGCIS\Struct\Person
     */
    public function setIsBelonger($isBelonger = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBelonger) && !is_bool($isBelonger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isBelonger)), __LINE__);
        }
        $this->IsBelonger = $isBelonger;
        return $this;
    }
    /**
     * Get SendBill value
     * @return bool
     */
    public function getSendBill()
    {
        return $this->SendBill;
    }
    /**
     * Set SendBill value
     * @param bool $sendBill
     * @return \SGCIS\Struct\Person
     */
    public function setSendBill($sendBill = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendBill) && !is_bool($sendBill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sendBill)), __LINE__);
        }
        $this->SendBill = $sendBill;
        return $this;
    }
    /**
     * Get SendMessaging value
     * @return bool
     */
    public function getSendMessaging()
    {
        return $this->SendMessaging;
    }
    /**
     * Set SendMessaging value
     * @param bool $sendMessaging
     * @return \SGCIS\Struct\Person
     */
    public function setSendMessaging($sendMessaging = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendMessaging) && !is_bool($sendMessaging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sendMessaging)), __LINE__);
        }
        $this->SendMessaging = $sendMessaging;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \SGCIS\Struct\Person
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \SGCIS\Struct\Person
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get MiddleInitial value
     * @return string|null
     */
    public function getMiddleInitial()
    {
        return $this->MiddleInitial;
    }
    /**
     * Set MiddleInitial value
     * @param string $middleInitial
     * @return \SGCIS\Struct\Person
     */
    public function setMiddleInitial($middleInitial = null)
    {
        // validation for constraint: string
        if (!is_null($middleInitial) && !is_string($middleInitial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleInitial)), __LINE__);
        }
        $this->MiddleInitial = $middleInitial;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \SGCIS\Struct\Person
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \SGCIS\Struct\Person
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get PasswordDisplay value
     * @return string|null
     */
    public function getPasswordDisplay()
    {
        return $this->PasswordDisplay;
    }
    /**
     * Set PasswordDisplay value
     * @param string $passwordDisplay
     * @return \SGCIS\Struct\Person
     */
    public function setPasswordDisplay($passwordDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($passwordDisplay) && !is_string($passwordDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passwordDisplay)), __LINE__);
        }
        $this->PasswordDisplay = $passwordDisplay;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \SGCIS\Struct\Person
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get SSN value
     * @return string|null
     */
    public function getSSN()
    {
        return $this->SSN;
    }
    /**
     * Set SSN value
     * @param string $sSN
     * @return \SGCIS\Struct\Person
     */
    public function setSSN($sSN = null)
    {
        // validation for constraint: string
        if (!is_null($sSN) && !is_string($sSN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sSN)), __LINE__);
        }
        $this->SSN = $sSN;
        return $this;
    }
    /**
     * Get DriversLicense value
     * @return string|null
     */
    public function getDriversLicense()
    {
        return $this->DriversLicense;
    }
    /**
     * Set DriversLicense value
     * @param string $driversLicense
     * @return \SGCIS\Struct\Person
     */
    public function setDriversLicense($driversLicense = null)
    {
        // validation for constraint: string
        if (!is_null($driversLicense) && !is_string($driversLicense)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driversLicense)), __LINE__);
        }
        $this->DriversLicense = $driversLicense;
        return $this;
    }
    /**
     * Get DriversLicenseState value
     * @return string|null
     */
    public function getDriversLicenseState()
    {
        return $this->DriversLicenseState;
    }
    /**
     * Set DriversLicenseState value
     * @param string $driversLicenseState
     * @return \SGCIS\Struct\Person
     */
    public function setDriversLicenseState($driversLicenseState = null)
    {
        // validation for constraint: string
        if (!is_null($driversLicenseState) && !is_string($driversLicenseState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driversLicenseState)), __LINE__);
        }
        $this->DriversLicenseState = $driversLicenseState;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\Person
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get AccountStatusName value
     * @return string|null
     */
    public function getAccountStatusName()
    {
        return $this->AccountStatusName;
    }
    /**
     * Set AccountStatusName value
     * @param string $accountStatusName
     * @return \SGCIS\Struct\Person
     */
    public function setAccountStatusName($accountStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($accountStatusName) && !is_string($accountStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountStatusName)), __LINE__);
        }
        $this->AccountStatusName = $accountStatusName;
        return $this;
    }
    /**
     * Get PersonTypeName value
     * @return string|null
     */
    public function getPersonTypeName()
    {
        return $this->PersonTypeName;
    }
    /**
     * Set PersonTypeName value
     * @param string $personTypeName
     * @return \SGCIS\Struct\Person
     */
    public function setPersonTypeName($personTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($personTypeName) && !is_string($personTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personTypeName)), __LINE__);
        }
        $this->PersonTypeName = $personTypeName;
        return $this;
    }
    /**
     * Get PersonIDTypeName value
     * @return string|null
     */
    public function getPersonIDTypeName()
    {
        return $this->PersonIDTypeName;
    }
    /**
     * Set PersonIDTypeName value
     * @param string $personIDTypeName
     * @return \SGCIS\Struct\Person
     */
    public function setPersonIDTypeName($personIDTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($personIDTypeName) && !is_string($personIDTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personIDTypeName)), __LINE__);
        }
        $this->PersonIDTypeName = $personIDTypeName;
        return $this;
    }
    /**
     * Get PersonIDValue value
     * @return string|null
     */
    public function getPersonIDValue()
    {
        return $this->PersonIDValue;
    }
    /**
     * Set PersonIDValue value
     * @param string $personIDValue
     * @return \SGCIS\Struct\Person
     */
    public function setPersonIDValue($personIDValue = null)
    {
        // validation for constraint: string
        if (!is_null($personIDValue) && !is_string($personIDValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personIDValue)), __LINE__);
        }
        $this->PersonIDValue = $personIDValue;
        return $this;
    }
    /**
     * Get Address value
     * @return \SGCIS\Struct\AccountAddress|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \SGCIS\Struct\AccountAddress $address
     * @return \SGCIS\Struct\Person
     */
    public function setAddress(\SGCIS\Struct\AccountAddress $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get HostSystemID value
     * @return string|null
     */
    public function getHostSystemID()
    {
        return $this->HostSystemID;
    }
    /**
     * Set HostSystemID value
     * @param string $hostSystemID
     * @return \SGCIS\Struct\Person
     */
    public function setHostSystemID($hostSystemID = null)
    {
        // validation for constraint: string
        if (!is_null($hostSystemID) && !is_string($hostSystemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hostSystemID)), __LINE__);
        }
        $this->HostSystemID = $hostSystemID;
        return $this;
    }
    /**
     * Get VerificationHash value
     * @return string|null
     */
    public function getVerificationHash()
    {
        return $this->VerificationHash;
    }
    /**
     * Set VerificationHash value
     * @param string $verificationHash
     * @return \SGCIS\Struct\Person
     */
    public function setVerificationHash($verificationHash = null)
    {
        // validation for constraint: string
        if (!is_null($verificationHash) && !is_string($verificationHash)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($verificationHash)), __LINE__);
        }
        $this->VerificationHash = $verificationHash;
        return $this;
    }
    /**
     * Get SalutationTypeName value
     * @return string|null
     */
    public function getSalutationTypeName()
    {
        return $this->SalutationTypeName;
    }
    /**
     * Set SalutationTypeName value
     * @param string $salutationTypeName
     * @return \SGCIS\Struct\Person
     */
    public function setSalutationTypeName($salutationTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($salutationTypeName) && !is_string($salutationTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salutationTypeName)), __LINE__);
        }
        $this->SalutationTypeName = $salutationTypeName;
        return $this;
    }
    /**
     * Get BusinessName value
     * @return string|null
     */
    public function getBusinessName()
    {
        return $this->BusinessName;
    }
    /**
     * Set BusinessName value
     * @param string $businessName
     * @return \SGCIS\Struct\Person
     */
    public function setBusinessName($businessName = null)
    {
        // validation for constraint: string
        if (!is_null($businessName) && !is_string($businessName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($businessName)), __LINE__);
        }
        $this->BusinessName = $businessName;
        return $this;
    }
    /**
     * Get FederalTaxID value
     * @return string|null
     */
    public function getFederalTaxID()
    {
        return $this->FederalTaxID;
    }
    /**
     * Set FederalTaxID value
     * @param string $federalTaxID
     * @return \SGCIS\Struct\Person
     */
    public function setFederalTaxID($federalTaxID = null)
    {
        // validation for constraint: string
        if (!is_null($federalTaxID) && !is_string($federalTaxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($federalTaxID)), __LINE__);
        }
        $this->FederalTaxID = $federalTaxID;
        return $this;
    }
    /**
     * Get RepFirstName value
     * @return string|null
     */
    public function getRepFirstName()
    {
        return $this->RepFirstName;
    }
    /**
     * Set RepFirstName value
     * @param string $repFirstName
     * @return \SGCIS\Struct\Person
     */
    public function setRepFirstName($repFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($repFirstName) && !is_string($repFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($repFirstName)), __LINE__);
        }
        $this->RepFirstName = $repFirstName;
        return $this;
    }
    /**
     * Get RepLastName value
     * @return string|null
     */
    public function getRepLastName()
    {
        return $this->RepLastName;
    }
    /**
     * Set RepLastName value
     * @param string $repLastName
     * @return \SGCIS\Struct\Person
     */
    public function setRepLastName($repLastName = null)
    {
        // validation for constraint: string
        if (!is_null($repLastName) && !is_string($repLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($repLastName)), __LINE__);
        }
        $this->RepLastName = $repLastName;
        return $this;
    }
    /**
     * Get LegacyPersonID value
     * @return string|null
     */
    public function getLegacyPersonID()
    {
        return $this->LegacyPersonID;
    }
    /**
     * Set LegacyPersonID value
     * @param string $legacyPersonID
     * @return \SGCIS\Struct\Person
     */
    public function setLegacyPersonID($legacyPersonID = null)
    {
        // validation for constraint: string
        if (!is_null($legacyPersonID) && !is_string($legacyPersonID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($legacyPersonID)), __LINE__);
        }
        $this->LegacyPersonID = $legacyPersonID;
        return $this;
    }
    /**
     * Get FullName value
     * @return string|null
     */
    public function getFullName()
    {
        return $this->FullName;
    }
    /**
     * Set FullName value
     * @param string $fullName
     * @return \SGCIS\Struct\Person
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fullName)), __LINE__);
        }
        $this->FullName = $fullName;
        return $this;
    }
    /**
     * Get RepFullName value
     * @return string|null
     */
    public function getRepFullName()
    {
        return $this->RepFullName;
    }
    /**
     * Set RepFullName value
     * @param string $repFullName
     * @return \SGCIS\Struct\Person
     */
    public function setRepFullName($repFullName = null)
    {
        // validation for constraint: string
        if (!is_null($repFullName) && !is_string($repFullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($repFullName)), __LINE__);
        }
        $this->RepFullName = $repFullName;
        return $this;
    }
    /**
     * Get CompoundName value
     * @return string|null
     */
    public function getCompoundName()
    {
        return $this->CompoundName;
    }
    /**
     * Set CompoundName value
     * @param string $compoundName
     * @return \SGCIS\Struct\Person
     */
    public function setCompoundName($compoundName = null)
    {
        // validation for constraint: string
        if (!is_null($compoundName) && !is_string($compoundName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($compoundName)), __LINE__);
        }
        $this->CompoundName = $compoundName;
        return $this;
    }
    /**
     * Get PersonType value
     * @return \SGCIS\Struct\PersonType|null
     */
    public function getPersonType()
    {
        return $this->PersonType;
    }
    /**
     * Set PersonType value
     * @param \SGCIS\Struct\PersonType $personType
     * @return \SGCIS\Struct\Person
     */
    public function setPersonType(\SGCIS\Struct\PersonType $personType = null)
    {
        $this->PersonType = $personType;
        return $this;
    }
    /**
     * Get ServicePoint value
     * @return \SGCIS\Struct\ServicePoint|null
     */
    public function getServicePoint()
    {
        return $this->ServicePoint;
    }
    /**
     * Set ServicePoint value
     * @param \SGCIS\Struct\ServicePoint $servicePoint
     * @return \SGCIS\Struct\Person
     */
    public function setServicePoint(\SGCIS\Struct\ServicePoint $servicePoint = null)
    {
        $this->ServicePoint = $servicePoint;
        return $this;
    }
    /**
     * Get PersonContacts value
     * @return \SGCIS\Array\ArrayOfPersonContact|null
     */
    public function getPersonContacts()
    {
        return $this->PersonContacts;
    }
    /**
     * Set PersonContacts value
     * @param \SGCIS\Array\ArrayOfPersonContact $personContacts
     * @return \SGCIS\Struct\Person
     */
    public function setPersonContacts(\SGCIS\Array\ArrayOfPersonContact $personContacts = null)
    {
        $this->PersonContacts = $personContacts;
        return $this;
    }
    /**
     * Get NotificationChannels value
     * @return \SGCIS\Array\ArrayOfNotificationChannel|null
     */
    public function getNotificationChannels()
    {
        return $this->NotificationChannels;
    }
    /**
     * Set NotificationChannels value
     * @param \SGCIS\Array\ArrayOfNotificationChannel $notificationChannels
     * @return \SGCIS\Struct\Person
     */
    public function setNotificationChannels(\SGCIS\Array\ArrayOfNotificationChannel $notificationChannels = null)
    {
        $this->NotificationChannels = $notificationChannels;
        return $this;
    }
    /**
     * Get AccountPersons value
     * @return \SGCIS\Array\ArrayOfAccountPerson|null
     */
    public function getAccountPersons()
    {
        return $this->AccountPersons;
    }
    /**
     * Set AccountPersons value
     * @param \SGCIS\Array\ArrayOfAccountPerson $accountPersons
     * @return \SGCIS\Struct\Person
     */
    public function setAccountPersons(\SGCIS\Array\ArrayOfAccountPerson $accountPersons = null)
    {
        $this->AccountPersons = $accountPersons;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\Person
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
