<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentLocationRequest Struct
 * @subpackage Structs
 */
class PaymentLocationRequest extends ServiceRequestBase
{
    /**
     * The PaymentLocationQuery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\PaymentLocationQuery
     */
    public $PaymentLocationQuery;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The Directions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Directions;
    /**
     * Constructor method for PaymentLocationRequest
     * @uses PaymentLocationRequest::setPaymentLocationQuery()
     * @uses PaymentLocationRequest::setEmailAddress()
     * @uses PaymentLocationRequest::setDirections()
     * @param \SGCIS\Struct\PaymentLocationQuery $paymentLocationQuery
     * @param string $emailAddress
     * @param string $directions
     */
    public function __construct(\SGCIS\Struct\PaymentLocationQuery $paymentLocationQuery = null, $emailAddress = null, $directions = null)
    {
        $this
            ->setPaymentLocationQuery($paymentLocationQuery)
            ->setEmailAddress($emailAddress)
            ->setDirections($directions);
    }
    /**
     * Get PaymentLocationQuery value
     * @return \SGCIS\Struct\PaymentLocationQuery|null
     */
    public function getPaymentLocationQuery()
    {
        return $this->PaymentLocationQuery;
    }
    /**
     * Set PaymentLocationQuery value
     * @param \SGCIS\Struct\PaymentLocationQuery $paymentLocationQuery
     * @return \SGCIS\Struct\PaymentLocationRequest
     */
    public function setPaymentLocationQuery(\SGCIS\Struct\PaymentLocationQuery $paymentLocationQuery = null)
    {
        $this->PaymentLocationQuery = $paymentLocationQuery;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \SGCIS\Struct\PaymentLocationRequest
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get Directions value
     * @return string|null
     */
    public function getDirections()
    {
        return $this->Directions;
    }
    /**
     * Set Directions value
     * @param string $directions
     * @return \SGCIS\Struct\PaymentLocationRequest
     */
    public function setDirections($directions = null)
    {
        // validation for constraint: string
        if (!is_null($directions) && !is_string($directions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directions)), __LINE__);
        }
        $this->Directions = $directions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PaymentLocationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
