<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentArrangementBill Struct
 * @subpackage Structs
 */
class PaymentArrangementBill extends AbstractStructBase
{
    /**
     * The PaymentArrangementBillID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentArrangementBillID;
    /**
     * The PaymentArrangementID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentArrangementID;
    /**
     * The BillID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillID;
    /**
     * The BillDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BillDate;
    /**
     * The BilledAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BilledAmount;
    /**
     * The BalanceOwed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BalanceOwed;
    /**
     * The IncludedAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $IncludedAmount;
    /**
     * The IsSelected
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSelected;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The BillNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillNumber;
    /**
     * Constructor method for PaymentArrangementBill
     * @uses PaymentArrangementBill::setPaymentArrangementBillID()
     * @uses PaymentArrangementBill::setPaymentArrangementID()
     * @uses PaymentArrangementBill::setBillID()
     * @uses PaymentArrangementBill::setBillDate()
     * @uses PaymentArrangementBill::setBilledAmount()
     * @uses PaymentArrangementBill::setBalanceOwed()
     * @uses PaymentArrangementBill::setIncludedAmount()
     * @uses PaymentArrangementBill::setIsSelected()
     * @uses PaymentArrangementBill::setCreateDate()
     * @uses PaymentArrangementBill::setBillNumber()
     * @param int $paymentArrangementBillID
     * @param int $paymentArrangementID
     * @param int $billID
     * @param string $billDate
     * @param float $billedAmount
     * @param float $balanceOwed
     * @param float $includedAmount
     * @param bool $isSelected
     * @param string $createDate
     * @param string $billNumber
     */
    public function __construct($paymentArrangementBillID = null, $paymentArrangementID = null, $billID = null, $billDate = null, $billedAmount = null, $balanceOwed = null, $includedAmount = null, $isSelected = null, $createDate = null, $billNumber = null)
    {
        $this
            ->setPaymentArrangementBillID($paymentArrangementBillID)
            ->setPaymentArrangementID($paymentArrangementID)
            ->setBillID($billID)
            ->setBillDate($billDate)
            ->setBilledAmount($billedAmount)
            ->setBalanceOwed($balanceOwed)
            ->setIncludedAmount($includedAmount)
            ->setIsSelected($isSelected)
            ->setCreateDate($createDate)
            ->setBillNumber($billNumber);
    }
    /**
     * Get PaymentArrangementBillID value
     * @return int
     */
    public function getPaymentArrangementBillID()
    {
        return $this->PaymentArrangementBillID;
    }
    /**
     * Set PaymentArrangementBillID value
     * @param int $paymentArrangementBillID
     * @return \SGCIS\Struct\PaymentArrangementBill
     */
    public function setPaymentArrangementBillID($paymentArrangementBillID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentArrangementBillID) && !is_numeric($paymentArrangementBillID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentArrangementBillID)), __LINE__);
        }
        $this->PaymentArrangementBillID = $paymentArrangementBillID;
        return $this;
    }
    /**
     * Get PaymentArrangementID value
     * @return int
     */
    public function getPaymentArrangementID()
    {
        return $this->PaymentArrangementID;
    }
    /**
     * Set PaymentArrangementID value
     * @param int $paymentArrangementID
     * @return \SGCIS\Struct\PaymentArrangementBill
     */
    public function setPaymentArrangementID($paymentArrangementID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentArrangementID) && !is_numeric($paymentArrangementID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentArrangementID)), __LINE__);
        }
        $this->PaymentArrangementID = $paymentArrangementID;
        return $this;
    }
    /**
     * Get BillID value
     * @return int
     */
    public function getBillID()
    {
        return $this->BillID;
    }
    /**
     * Set BillID value
     * @param int $billID
     * @return \SGCIS\Struct\PaymentArrangementBill
     */
    public function setBillID($billID = null)
    {
        // validation for constraint: int
        if (!is_null($billID) && !is_numeric($billID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billID)), __LINE__);
        }
        $this->BillID = $billID;
        return $this;
    }
    /**
     * Get BillDate value
     * @return string
     */
    public function getBillDate()
    {
        return $this->BillDate;
    }
    /**
     * Set BillDate value
     * @param string $billDate
     * @return \SGCIS\Struct\PaymentArrangementBill
     */
    public function setBillDate($billDate = null)
    {
        // validation for constraint: string
        if (!is_null($billDate) && !is_string($billDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billDate)), __LINE__);
        }
        $this->BillDate = $billDate;
        return $this;
    }
    /**
     * Get BilledAmount value
     * @return float
     */
    public function getBilledAmount()
    {
        return $this->BilledAmount;
    }
    /**
     * Set BilledAmount value
     * @param float $billedAmount
     * @return \SGCIS\Struct\PaymentArrangementBill
     */
    public function setBilledAmount($billedAmount = null)
    {
        $this->BilledAmount = $billedAmount;
        return $this;
    }
    /**
     * Get BalanceOwed value
     * @return float
     */
    public function getBalanceOwed()
    {
        return $this->BalanceOwed;
    }
    /**
     * Set BalanceOwed value
     * @param float $balanceOwed
     * @return \SGCIS\Struct\PaymentArrangementBill
     */
    public function setBalanceOwed($balanceOwed = null)
    {
        $this->BalanceOwed = $balanceOwed;
        return $this;
    }
    /**
     * Get IncludedAmount value
     * @return float
     */
    public function getIncludedAmount()
    {
        return $this->IncludedAmount;
    }
    /**
     * Set IncludedAmount value
     * @param float $includedAmount
     * @return \SGCIS\Struct\PaymentArrangementBill
     */
    public function setIncludedAmount($includedAmount = null)
    {
        $this->IncludedAmount = $includedAmount;
        return $this;
    }
    /**
     * Get IsSelected value
     * @return bool
     */
    public function getIsSelected()
    {
        return $this->IsSelected;
    }
    /**
     * Set IsSelected value
     * @param bool $isSelected
     * @return \SGCIS\Struct\PaymentArrangementBill
     */
    public function setIsSelected($isSelected = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSelected) && !is_bool($isSelected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSelected)), __LINE__);
        }
        $this->IsSelected = $isSelected;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\PaymentArrangementBill
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get BillNumber value
     * @return string|null
     */
    public function getBillNumber()
    {
        return $this->BillNumber;
    }
    /**
     * Set BillNumber value
     * @param string $billNumber
     * @return \SGCIS\Struct\PaymentArrangementBill
     */
    public function setBillNumber($billNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billNumber) && !is_string($billNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billNumber)), __LINE__);
        }
        $this->BillNumber = $billNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PaymentArrangementBill
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
