<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentArrangement Struct
 * @subpackage Structs
 */
class PaymentArrangement extends BaseDTO
{
    /**
     * The PaymentArrangementID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentArrangementID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The PaymentArrangementTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentArrangementTypeID;
    /**
     * The PaymentArrangementStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentArrangementStatusID;
    /**
     * The ChargeFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ChargeFee;
    /**
     * The IsSendSwitchHold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSendSwitchHold;
    /**
     * The BalanceSourceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BalanceSourceID;
    /**
     * The PaymentTriggerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentTriggerID;
    /**
     * The AccountBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AccountBalance;
    /**
     * The PenaltyPct
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PenaltyPct;
    /**
     * The PenaltyAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PenaltyAmount;
    /**
     * The InitialPaymentPct
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $InitialPaymentPct;
    /**
     * The PaymentRatioPct
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PaymentRatioPct;
    /**
     * The NumPayments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumPayments;
    /**
     * The PaymentIntervalDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentIntervalDays;
    /**
     * The StartingBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $StartingBalance;
    /**
     * The CurrentBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CurrentBalance;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The CanCreateArrangement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CanCreateArrangement;
    /**
     * The ThresholdBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ThresholdBalance;
    /**
     * The IsPostPayAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPostPayAccount;
    /**
     * The IsManualAcceleration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsManualAcceleration;
    /**
     * The IsDebtRecoveryDistributionMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDebtRecoveryDistributionMode;
    /**
     * The IsAutoDPP
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAutoDPP;
    /**
     * The BillID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillID;
    /**
     * The BillAmountDue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BillAmountDue;
    /**
     * The ZeroAccountBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ZeroAccountBalance;
    /**
     * The ExtensionDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ExtensionDate;
    /**
     * The IsExported
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsExported;
    /**
     * The FirstPaymentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FirstPaymentDate;
    /**
     * The ScheduleOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ScheduleOption;
    /**
     * The MonthlyPaymentAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MonthlyPaymentAmount;
    /**
     * The ArrangementIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArrangementIdentifier;
    /**
     * The PaymentArrangementTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentArrangementTypeName;
    /**
     * The PaymentArrangementStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentArrangementStatusName;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The DocumentOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentOption;
    /**
     * The PersonEmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonEmailAddress;
    /**
     * The MailingAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountAddress
     */
    public $MailingAddress;
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Account
     */
    public $Account;
    /**
     * The StartDateDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StartDateDisplay;
    /**
     * The PaymentSchedule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfPaymentArrangementSchedule
     */
    public $PaymentSchedule;
    /**
     * The PaymentArrangementBills
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfPaymentArrangementBill
     */
    public $PaymentArrangementBills;
    /**
     * The PaymentArrangementReceivables
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfPaymentArrangementReceivable
     */
    public $PaymentArrangementReceivables;
    /**
     * Constructor method for PaymentArrangement
     * @uses PaymentArrangement::setPaymentArrangementID()
     * @uses PaymentArrangement::setAccountID()
     * @uses PaymentArrangement::setPaymentArrangementTypeID()
     * @uses PaymentArrangement::setPaymentArrangementStatusID()
     * @uses PaymentArrangement::setChargeFee()
     * @uses PaymentArrangement::setIsSendSwitchHold()
     * @uses PaymentArrangement::setBalanceSourceID()
     * @uses PaymentArrangement::setPaymentTriggerID()
     * @uses PaymentArrangement::setAccountBalance()
     * @uses PaymentArrangement::setPenaltyPct()
     * @uses PaymentArrangement::setPenaltyAmount()
     * @uses PaymentArrangement::setInitialPaymentPct()
     * @uses PaymentArrangement::setPaymentRatioPct()
     * @uses PaymentArrangement::setNumPayments()
     * @uses PaymentArrangement::setPaymentIntervalDays()
     * @uses PaymentArrangement::setStartingBalance()
     * @uses PaymentArrangement::setCurrentBalance()
     * @uses PaymentArrangement::setStartDate()
     * @uses PaymentArrangement::setCanCreateArrangement()
     * @uses PaymentArrangement::setThresholdBalance()
     * @uses PaymentArrangement::setIsPostPayAccount()
     * @uses PaymentArrangement::setIsManualAcceleration()
     * @uses PaymentArrangement::setIsDebtRecoveryDistributionMode()
     * @uses PaymentArrangement::setIsAutoDPP()
     * @uses PaymentArrangement::setBillID()
     * @uses PaymentArrangement::setBillAmountDue()
     * @uses PaymentArrangement::setZeroAccountBalance()
     * @uses PaymentArrangement::setExtensionDate()
     * @uses PaymentArrangement::setIsExported()
     * @uses PaymentArrangement::setFirstPaymentDate()
     * @uses PaymentArrangement::setScheduleOption()
     * @uses PaymentArrangement::setMonthlyPaymentAmount()
     * @uses PaymentArrangement::setArrangementIdentifier()
     * @uses PaymentArrangement::setPaymentArrangementTypeName()
     * @uses PaymentArrangement::setPaymentArrangementStatusName()
     * @uses PaymentArrangement::setAccountNumber()
     * @uses PaymentArrangement::setDescription()
     * @uses PaymentArrangement::setDocumentOption()
     * @uses PaymentArrangement::setPersonEmailAddress()
     * @uses PaymentArrangement::setMailingAddress()
     * @uses PaymentArrangement::setAccount()
     * @uses PaymentArrangement::setStartDateDisplay()
     * @uses PaymentArrangement::setPaymentSchedule()
     * @uses PaymentArrangement::setPaymentArrangementBills()
     * @uses PaymentArrangement::setPaymentArrangementReceivables()
     * @param int $paymentArrangementID
     * @param int $accountID
     * @param int $paymentArrangementTypeID
     * @param int $paymentArrangementStatusID
     * @param bool $chargeFee
     * @param bool $isSendSwitchHold
     * @param int $balanceSourceID
     * @param int $paymentTriggerID
     * @param float $accountBalance
     * @param float $penaltyPct
     * @param float $penaltyAmount
     * @param float $initialPaymentPct
     * @param float $paymentRatioPct
     * @param int $numPayments
     * @param int $paymentIntervalDays
     * @param float $startingBalance
     * @param float $currentBalance
     * @param string $startDate
     * @param bool $canCreateArrangement
     * @param float $thresholdBalance
     * @param bool $isPostPayAccount
     * @param bool $isManualAcceleration
     * @param bool $isDebtRecoveryDistributionMode
     * @param bool $isAutoDPP
     * @param int $billID
     * @param float $billAmountDue
     * @param bool $zeroAccountBalance
     * @param string $extensionDate
     * @param bool $isExported
     * @param string $firstPaymentDate
     * @param int $scheduleOption
     * @param float $monthlyPaymentAmount
     * @param string $arrangementIdentifier
     * @param string $paymentArrangementTypeName
     * @param string $paymentArrangementStatusName
     * @param string $accountNumber
     * @param string $description
     * @param string $documentOption
     * @param string $personEmailAddress
     * @param \SGCIS\Struct\AccountAddress $mailingAddress
     * @param \SGCIS\Struct\Account $account
     * @param string $startDateDisplay
     * @param \SGCIS\Array\ArrayOfPaymentArrangementSchedule $paymentSchedule
     * @param \SGCIS\Array\ArrayOfPaymentArrangementBill $paymentArrangementBills
     * @param \SGCIS\Array\ArrayOfPaymentArrangementReceivable $paymentArrangementReceivables
     */
    public function __construct($paymentArrangementID = null, $accountID = null, $paymentArrangementTypeID = null, $paymentArrangementStatusID = null, $chargeFee = null, $isSendSwitchHold = null, $balanceSourceID = null, $paymentTriggerID = null, $accountBalance = null, $penaltyPct = null, $penaltyAmount = null, $initialPaymentPct = null, $paymentRatioPct = null, $numPayments = null, $paymentIntervalDays = null, $startingBalance = null, $currentBalance = null, $startDate = null, $canCreateArrangement = null, $thresholdBalance = null, $isPostPayAccount = null, $isManualAcceleration = null, $isDebtRecoveryDistributionMode = null, $isAutoDPP = null, $billID = null, $billAmountDue = null, $zeroAccountBalance = null, $extensionDate = null, $isExported = null, $firstPaymentDate = null, $scheduleOption = null, $monthlyPaymentAmount = null, $arrangementIdentifier = null, $paymentArrangementTypeName = null, $paymentArrangementStatusName = null, $accountNumber = null, $description = null, $documentOption = null, $personEmailAddress = null, \SGCIS\Struct\AccountAddress $mailingAddress = null, \SGCIS\Struct\Account $account = null, $startDateDisplay = null, \SGCIS\Array\ArrayOfPaymentArrangementSchedule $paymentSchedule = null, \SGCIS\Array\ArrayOfPaymentArrangementBill $paymentArrangementBills = null, \SGCIS\Array\ArrayOfPaymentArrangementReceivable $paymentArrangementReceivables = null)
    {
        $this
            ->setPaymentArrangementID($paymentArrangementID)
            ->setAccountID($accountID)
            ->setPaymentArrangementTypeID($paymentArrangementTypeID)
            ->setPaymentArrangementStatusID($paymentArrangementStatusID)
            ->setChargeFee($chargeFee)
            ->setIsSendSwitchHold($isSendSwitchHold)
            ->setBalanceSourceID($balanceSourceID)
            ->setPaymentTriggerID($paymentTriggerID)
            ->setAccountBalance($accountBalance)
            ->setPenaltyPct($penaltyPct)
            ->setPenaltyAmount($penaltyAmount)
            ->setInitialPaymentPct($initialPaymentPct)
            ->setPaymentRatioPct($paymentRatioPct)
            ->setNumPayments($numPayments)
            ->setPaymentIntervalDays($paymentIntervalDays)
            ->setStartingBalance($startingBalance)
            ->setCurrentBalance($currentBalance)
            ->setStartDate($startDate)
            ->setCanCreateArrangement($canCreateArrangement)
            ->setThresholdBalance($thresholdBalance)
            ->setIsPostPayAccount($isPostPayAccount)
            ->setIsManualAcceleration($isManualAcceleration)
            ->setIsDebtRecoveryDistributionMode($isDebtRecoveryDistributionMode)
            ->setIsAutoDPP($isAutoDPP)
            ->setBillID($billID)
            ->setBillAmountDue($billAmountDue)
            ->setZeroAccountBalance($zeroAccountBalance)
            ->setExtensionDate($extensionDate)
            ->setIsExported($isExported)
            ->setFirstPaymentDate($firstPaymentDate)
            ->setScheduleOption($scheduleOption)
            ->setMonthlyPaymentAmount($monthlyPaymentAmount)
            ->setArrangementIdentifier($arrangementIdentifier)
            ->setPaymentArrangementTypeName($paymentArrangementTypeName)
            ->setPaymentArrangementStatusName($paymentArrangementStatusName)
            ->setAccountNumber($accountNumber)
            ->setDescription($description)
            ->setDocumentOption($documentOption)
            ->setPersonEmailAddress($personEmailAddress)
            ->setMailingAddress($mailingAddress)
            ->setAccount($account)
            ->setStartDateDisplay($startDateDisplay)
            ->setPaymentSchedule($paymentSchedule)
            ->setPaymentArrangementBills($paymentArrangementBills)
            ->setPaymentArrangementReceivables($paymentArrangementReceivables);
    }
    /**
     * Get PaymentArrangementID value
     * @return int
     */
    public function getPaymentArrangementID()
    {
        return $this->PaymentArrangementID;
    }
    /**
     * Set PaymentArrangementID value
     * @param int $paymentArrangementID
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setPaymentArrangementID($paymentArrangementID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentArrangementID) && !is_numeric($paymentArrangementID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentArrangementID)), __LINE__);
        }
        $this->PaymentArrangementID = $paymentArrangementID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get PaymentArrangementTypeID value
     * @return int
     */
    public function getPaymentArrangementTypeID()
    {
        return $this->PaymentArrangementTypeID;
    }
    /**
     * Set PaymentArrangementTypeID value
     * @param int $paymentArrangementTypeID
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setPaymentArrangementTypeID($paymentArrangementTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentArrangementTypeID) && !is_numeric($paymentArrangementTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentArrangementTypeID)), __LINE__);
        }
        $this->PaymentArrangementTypeID = $paymentArrangementTypeID;
        return $this;
    }
    /**
     * Get PaymentArrangementStatusID value
     * @return int
     */
    public function getPaymentArrangementStatusID()
    {
        return $this->PaymentArrangementStatusID;
    }
    /**
     * Set PaymentArrangementStatusID value
     * @param int $paymentArrangementStatusID
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setPaymentArrangementStatusID($paymentArrangementStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentArrangementStatusID) && !is_numeric($paymentArrangementStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentArrangementStatusID)), __LINE__);
        }
        $this->PaymentArrangementStatusID = $paymentArrangementStatusID;
        return $this;
    }
    /**
     * Get ChargeFee value
     * @return bool
     */
    public function getChargeFee()
    {
        return $this->ChargeFee;
    }
    /**
     * Set ChargeFee value
     * @param bool $chargeFee
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setChargeFee($chargeFee = null)
    {
        // validation for constraint: boolean
        if (!is_null($chargeFee) && !is_bool($chargeFee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($chargeFee)), __LINE__);
        }
        $this->ChargeFee = $chargeFee;
        return $this;
    }
    /**
     * Get IsSendSwitchHold value
     * @return bool
     */
    public function getIsSendSwitchHold()
    {
        return $this->IsSendSwitchHold;
    }
    /**
     * Set IsSendSwitchHold value
     * @param bool $isSendSwitchHold
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setIsSendSwitchHold($isSendSwitchHold = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSendSwitchHold) && !is_bool($isSendSwitchHold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSendSwitchHold)), __LINE__);
        }
        $this->IsSendSwitchHold = $isSendSwitchHold;
        return $this;
    }
    /**
     * Get BalanceSourceID value
     * @return int
     */
    public function getBalanceSourceID()
    {
        return $this->BalanceSourceID;
    }
    /**
     * Set BalanceSourceID value
     * @param int $balanceSourceID
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setBalanceSourceID($balanceSourceID = null)
    {
        // validation for constraint: int
        if (!is_null($balanceSourceID) && !is_numeric($balanceSourceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($balanceSourceID)), __LINE__);
        }
        $this->BalanceSourceID = $balanceSourceID;
        return $this;
    }
    /**
     * Get PaymentTriggerID value
     * @return int
     */
    public function getPaymentTriggerID()
    {
        return $this->PaymentTriggerID;
    }
    /**
     * Set PaymentTriggerID value
     * @param int $paymentTriggerID
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setPaymentTriggerID($paymentTriggerID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentTriggerID) && !is_numeric($paymentTriggerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentTriggerID)), __LINE__);
        }
        $this->PaymentTriggerID = $paymentTriggerID;
        return $this;
    }
    /**
     * Get AccountBalance value
     * @return float
     */
    public function getAccountBalance()
    {
        return $this->AccountBalance;
    }
    /**
     * Set AccountBalance value
     * @param float $accountBalance
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setAccountBalance($accountBalance = null)
    {
        $this->AccountBalance = $accountBalance;
        return $this;
    }
    /**
     * Get PenaltyPct value
     * @return float
     */
    public function getPenaltyPct()
    {
        return $this->PenaltyPct;
    }
    /**
     * Set PenaltyPct value
     * @param float $penaltyPct
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setPenaltyPct($penaltyPct = null)
    {
        $this->PenaltyPct = $penaltyPct;
        return $this;
    }
    /**
     * Get PenaltyAmount value
     * @return float
     */
    public function getPenaltyAmount()
    {
        return $this->PenaltyAmount;
    }
    /**
     * Set PenaltyAmount value
     * @param float $penaltyAmount
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setPenaltyAmount($penaltyAmount = null)
    {
        $this->PenaltyAmount = $penaltyAmount;
        return $this;
    }
    /**
     * Get InitialPaymentPct value
     * @return float
     */
    public function getInitialPaymentPct()
    {
        return $this->InitialPaymentPct;
    }
    /**
     * Set InitialPaymentPct value
     * @param float $initialPaymentPct
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setInitialPaymentPct($initialPaymentPct = null)
    {
        $this->InitialPaymentPct = $initialPaymentPct;
        return $this;
    }
    /**
     * Get PaymentRatioPct value
     * @return float
     */
    public function getPaymentRatioPct()
    {
        return $this->PaymentRatioPct;
    }
    /**
     * Set PaymentRatioPct value
     * @param float $paymentRatioPct
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setPaymentRatioPct($paymentRatioPct = null)
    {
        $this->PaymentRatioPct = $paymentRatioPct;
        return $this;
    }
    /**
     * Get NumPayments value
     * @return int
     */
    public function getNumPayments()
    {
        return $this->NumPayments;
    }
    /**
     * Set NumPayments value
     * @param int $numPayments
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setNumPayments($numPayments = null)
    {
        // validation for constraint: int
        if (!is_null($numPayments) && !is_numeric($numPayments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numPayments)), __LINE__);
        }
        $this->NumPayments = $numPayments;
        return $this;
    }
    /**
     * Get PaymentIntervalDays value
     * @return int
     */
    public function getPaymentIntervalDays()
    {
        return $this->PaymentIntervalDays;
    }
    /**
     * Set PaymentIntervalDays value
     * @param int $paymentIntervalDays
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setPaymentIntervalDays($paymentIntervalDays = null)
    {
        // validation for constraint: int
        if (!is_null($paymentIntervalDays) && !is_numeric($paymentIntervalDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentIntervalDays)), __LINE__);
        }
        $this->PaymentIntervalDays = $paymentIntervalDays;
        return $this;
    }
    /**
     * Get StartingBalance value
     * @return float
     */
    public function getStartingBalance()
    {
        return $this->StartingBalance;
    }
    /**
     * Set StartingBalance value
     * @param float $startingBalance
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setStartingBalance($startingBalance = null)
    {
        $this->StartingBalance = $startingBalance;
        return $this;
    }
    /**
     * Get CurrentBalance value
     * @return float
     */
    public function getCurrentBalance()
    {
        return $this->CurrentBalance;
    }
    /**
     * Set CurrentBalance value
     * @param float $currentBalance
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setCurrentBalance($currentBalance = null)
    {
        $this->CurrentBalance = $currentBalance;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get CanCreateArrangement value
     * @return bool
     */
    public function getCanCreateArrangement()
    {
        return $this->CanCreateArrangement;
    }
    /**
     * Set CanCreateArrangement value
     * @param bool $canCreateArrangement
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setCanCreateArrangement($canCreateArrangement = null)
    {
        // validation for constraint: boolean
        if (!is_null($canCreateArrangement) && !is_bool($canCreateArrangement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($canCreateArrangement)), __LINE__);
        }
        $this->CanCreateArrangement = $canCreateArrangement;
        return $this;
    }
    /**
     * Get ThresholdBalance value
     * @return float
     */
    public function getThresholdBalance()
    {
        return $this->ThresholdBalance;
    }
    /**
     * Set ThresholdBalance value
     * @param float $thresholdBalance
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setThresholdBalance($thresholdBalance = null)
    {
        $this->ThresholdBalance = $thresholdBalance;
        return $this;
    }
    /**
     * Get IsPostPayAccount value
     * @return bool
     */
    public function getIsPostPayAccount()
    {
        return $this->IsPostPayAccount;
    }
    /**
     * Set IsPostPayAccount value
     * @param bool $isPostPayAccount
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setIsPostPayAccount($isPostPayAccount = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPostPayAccount) && !is_bool($isPostPayAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPostPayAccount)), __LINE__);
        }
        $this->IsPostPayAccount = $isPostPayAccount;
        return $this;
    }
    /**
     * Get IsManualAcceleration value
     * @return bool
     */
    public function getIsManualAcceleration()
    {
        return $this->IsManualAcceleration;
    }
    /**
     * Set IsManualAcceleration value
     * @param bool $isManualAcceleration
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setIsManualAcceleration($isManualAcceleration = null)
    {
        // validation for constraint: boolean
        if (!is_null($isManualAcceleration) && !is_bool($isManualAcceleration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isManualAcceleration)), __LINE__);
        }
        $this->IsManualAcceleration = $isManualAcceleration;
        return $this;
    }
    /**
     * Get IsDebtRecoveryDistributionMode value
     * @return bool
     */
    public function getIsDebtRecoveryDistributionMode()
    {
        return $this->IsDebtRecoveryDistributionMode;
    }
    /**
     * Set IsDebtRecoveryDistributionMode value
     * @param bool $isDebtRecoveryDistributionMode
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setIsDebtRecoveryDistributionMode($isDebtRecoveryDistributionMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDebtRecoveryDistributionMode) && !is_bool($isDebtRecoveryDistributionMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDebtRecoveryDistributionMode)), __LINE__);
        }
        $this->IsDebtRecoveryDistributionMode = $isDebtRecoveryDistributionMode;
        return $this;
    }
    /**
     * Get IsAutoDPP value
     * @return bool
     */
    public function getIsAutoDPP()
    {
        return $this->IsAutoDPP;
    }
    /**
     * Set IsAutoDPP value
     * @param bool $isAutoDPP
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setIsAutoDPP($isAutoDPP = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutoDPP) && !is_bool($isAutoDPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAutoDPP)), __LINE__);
        }
        $this->IsAutoDPP = $isAutoDPP;
        return $this;
    }
    /**
     * Get BillID value
     * @return int
     */
    public function getBillID()
    {
        return $this->BillID;
    }
    /**
     * Set BillID value
     * @param int $billID
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setBillID($billID = null)
    {
        // validation for constraint: int
        if (!is_null($billID) && !is_numeric($billID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billID)), __LINE__);
        }
        $this->BillID = $billID;
        return $this;
    }
    /**
     * Get BillAmountDue value
     * @return float
     */
    public function getBillAmountDue()
    {
        return $this->BillAmountDue;
    }
    /**
     * Set BillAmountDue value
     * @param float $billAmountDue
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setBillAmountDue($billAmountDue = null)
    {
        $this->BillAmountDue = $billAmountDue;
        return $this;
    }
    /**
     * Get ZeroAccountBalance value
     * @return bool
     */
    public function getZeroAccountBalance()
    {
        return $this->ZeroAccountBalance;
    }
    /**
     * Set ZeroAccountBalance value
     * @param bool $zeroAccountBalance
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setZeroAccountBalance($zeroAccountBalance = null)
    {
        // validation for constraint: boolean
        if (!is_null($zeroAccountBalance) && !is_bool($zeroAccountBalance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($zeroAccountBalance)), __LINE__);
        }
        $this->ZeroAccountBalance = $zeroAccountBalance;
        return $this;
    }
    /**
     * Get ExtensionDate value
     * @return string
     */
    public function getExtensionDate()
    {
        return $this->ExtensionDate;
    }
    /**
     * Set ExtensionDate value
     * @param string $extensionDate
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setExtensionDate($extensionDate = null)
    {
        // validation for constraint: string
        if (!is_null($extensionDate) && !is_string($extensionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extensionDate)), __LINE__);
        }
        $this->ExtensionDate = $extensionDate;
        return $this;
    }
    /**
     * Get IsExported value
     * @return bool
     */
    public function getIsExported()
    {
        return $this->IsExported;
    }
    /**
     * Set IsExported value
     * @param bool $isExported
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setIsExported($isExported = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExported) && !is_bool($isExported)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isExported)), __LINE__);
        }
        $this->IsExported = $isExported;
        return $this;
    }
    /**
     * Get FirstPaymentDate value
     * @return string
     */
    public function getFirstPaymentDate()
    {
        return $this->FirstPaymentDate;
    }
    /**
     * Set FirstPaymentDate value
     * @param string $firstPaymentDate
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setFirstPaymentDate($firstPaymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstPaymentDate) && !is_string($firstPaymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstPaymentDate)), __LINE__);
        }
        $this->FirstPaymentDate = $firstPaymentDate;
        return $this;
    }
    /**
     * Get ScheduleOption value
     * @return int
     */
    public function getScheduleOption()
    {
        return $this->ScheduleOption;
    }
    /**
     * Set ScheduleOption value
     * @param int $scheduleOption
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setScheduleOption($scheduleOption = null)
    {
        // validation for constraint: int
        if (!is_null($scheduleOption) && !is_numeric($scheduleOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($scheduleOption)), __LINE__);
        }
        $this->ScheduleOption = $scheduleOption;
        return $this;
    }
    /**
     * Get MonthlyPaymentAmount value
     * @return float
     */
    public function getMonthlyPaymentAmount()
    {
        return $this->MonthlyPaymentAmount;
    }
    /**
     * Set MonthlyPaymentAmount value
     * @param float $monthlyPaymentAmount
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setMonthlyPaymentAmount($monthlyPaymentAmount = null)
    {
        $this->MonthlyPaymentAmount = $monthlyPaymentAmount;
        return $this;
    }
    /**
     * Get ArrangementIdentifier value
     * @return string|null
     */
    public function getArrangementIdentifier()
    {
        return $this->ArrangementIdentifier;
    }
    /**
     * Set ArrangementIdentifier value
     * @param string $arrangementIdentifier
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setArrangementIdentifier($arrangementIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($arrangementIdentifier) && !is_string($arrangementIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrangementIdentifier)), __LINE__);
        }
        $this->ArrangementIdentifier = $arrangementIdentifier;
        return $this;
    }
    /**
     * Get PaymentArrangementTypeName value
     * @return string|null
     */
    public function getPaymentArrangementTypeName()
    {
        return $this->PaymentArrangementTypeName;
    }
    /**
     * Set PaymentArrangementTypeName value
     * @param string $paymentArrangementTypeName
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setPaymentArrangementTypeName($paymentArrangementTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentArrangementTypeName) && !is_string($paymentArrangementTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentArrangementTypeName)), __LINE__);
        }
        $this->PaymentArrangementTypeName = $paymentArrangementTypeName;
        return $this;
    }
    /**
     * Get PaymentArrangementStatusName value
     * @return string|null
     */
    public function getPaymentArrangementStatusName()
    {
        return $this->PaymentArrangementStatusName;
    }
    /**
     * Set PaymentArrangementStatusName value
     * @param string $paymentArrangementStatusName
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setPaymentArrangementStatusName($paymentArrangementStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentArrangementStatusName) && !is_string($paymentArrangementStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentArrangementStatusName)), __LINE__);
        }
        $this->PaymentArrangementStatusName = $paymentArrangementStatusName;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DocumentOption value
     * @return string|null
     */
    public function getDocumentOption()
    {
        return $this->DocumentOption;
    }
    /**
     * Set DocumentOption value
     * @param string $documentOption
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setDocumentOption($documentOption = null)
    {
        // validation for constraint: string
        if (!is_null($documentOption) && !is_string($documentOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentOption)), __LINE__);
        }
        $this->DocumentOption = $documentOption;
        return $this;
    }
    /**
     * Get PersonEmailAddress value
     * @return string|null
     */
    public function getPersonEmailAddress()
    {
        return $this->PersonEmailAddress;
    }
    /**
     * Set PersonEmailAddress value
     * @param string $personEmailAddress
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setPersonEmailAddress($personEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($personEmailAddress) && !is_string($personEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personEmailAddress)), __LINE__);
        }
        $this->PersonEmailAddress = $personEmailAddress;
        return $this;
    }
    /**
     * Get MailingAddress value
     * @return \SGCIS\Struct\AccountAddress|null
     */
    public function getMailingAddress()
    {
        return $this->MailingAddress;
    }
    /**
     * Set MailingAddress value
     * @param \SGCIS\Struct\AccountAddress $mailingAddress
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setMailingAddress(\SGCIS\Struct\AccountAddress $mailingAddress = null)
    {
        $this->MailingAddress = $mailingAddress;
        return $this;
    }
    /**
     * Get Account value
     * @return \SGCIS\Struct\Account|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \SGCIS\Struct\Account $account
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setAccount(\SGCIS\Struct\Account $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get StartDateDisplay value
     * @return string|null
     */
    public function getStartDateDisplay()
    {
        return $this->StartDateDisplay;
    }
    /**
     * Set StartDateDisplay value
     * @param string $startDateDisplay
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setStartDateDisplay($startDateDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($startDateDisplay) && !is_string($startDateDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDateDisplay)), __LINE__);
        }
        $this->StartDateDisplay = $startDateDisplay;
        return $this;
    }
    /**
     * Get PaymentSchedule value
     * @return \SGCIS\Array\ArrayOfPaymentArrangementSchedule|null
     */
    public function getPaymentSchedule()
    {
        return $this->PaymentSchedule;
    }
    /**
     * Set PaymentSchedule value
     * @param \SGCIS\Array\ArrayOfPaymentArrangementSchedule $paymentSchedule
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setPaymentSchedule(\SGCIS\Array\ArrayOfPaymentArrangementSchedule $paymentSchedule = null)
    {
        $this->PaymentSchedule = $paymentSchedule;
        return $this;
    }
    /**
     * Get PaymentArrangementBills value
     * @return \SGCIS\Array\ArrayOfPaymentArrangementBill|null
     */
    public function getPaymentArrangementBills()
    {
        return $this->PaymentArrangementBills;
    }
    /**
     * Set PaymentArrangementBills value
     * @param \SGCIS\Array\ArrayOfPaymentArrangementBill $paymentArrangementBills
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setPaymentArrangementBills(\SGCIS\Array\ArrayOfPaymentArrangementBill $paymentArrangementBills = null)
    {
        $this->PaymentArrangementBills = $paymentArrangementBills;
        return $this;
    }
    /**
     * Get PaymentArrangementReceivables value
     * @return \SGCIS\Array\ArrayOfPaymentArrangementReceivable|null
     */
    public function getPaymentArrangementReceivables()
    {
        return $this->PaymentArrangementReceivables;
    }
    /**
     * Set PaymentArrangementReceivables value
     * @param \SGCIS\Array\ArrayOfPaymentArrangementReceivable $paymentArrangementReceivables
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public function setPaymentArrangementReceivables(\SGCIS\Array\ArrayOfPaymentArrangementReceivable $paymentArrangementReceivables = null)
    {
        $this->PaymentArrangementReceivables = $paymentArrangementReceivables;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PaymentArrangement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
