<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeterResponse Struct
 * @subpackage Structs
 */
class MeterResponse extends ServiceResponseBase
{
    /**
     * The Meter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Meter
     */
    public $Meter;
    /**
     * The Meters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfMeterCopy
     */
    public $Meters;
    /**
     * The ServicePointMeter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\ServicePointMeter
     */
    public $ServicePointMeter;
    /**
     * The dsMeters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\DsMeters
     */
    public $dsMeters;
    /**
     * The MeterGroups
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfMeterGroup
     */
    public $MeterGroups;
    /**
     * The HistoricalConsumptionUsageReport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfHistoricalConsumptionUsageReport
     */
    public $HistoricalConsumptionUsageReport;
    /**
     * Constructor method for MeterResponse
     * @uses MeterResponse::setMeter()
     * @uses MeterResponse::setMeters()
     * @uses MeterResponse::setServicePointMeter()
     * @uses MeterResponse::setDsMeters()
     * @uses MeterResponse::setMeterGroups()
     * @uses MeterResponse::setHistoricalConsumptionUsageReport()
     * @param \SGCIS\Struct\Meter $meter
     * @param \SGCIS\Array\ArrayOfMeterCopy $meters
     * @param \SGCIS\Struct\ServicePointMeter $servicePointMeter
     * @param \SGCIS\Struct\DsMeters $dsMeters
     * @param \SGCIS\Array\ArrayOfMeterGroup $meterGroups
     * @param \SGCIS\Array\ArrayOfHistoricalConsumptionUsageReport $historicalConsumptionUsageReport
     */
    public function __construct(\SGCIS\Struct\Meter $meter = null, \SGCIS\Array\ArrayOfMeterCopy $meters = null, \SGCIS\Struct\ServicePointMeter $servicePointMeter = null, \SGCIS\Struct\DsMeters $dsMeters = null, \SGCIS\Array\ArrayOfMeterGroup $meterGroups = null, \SGCIS\Array\ArrayOfHistoricalConsumptionUsageReport $historicalConsumptionUsageReport = null)
    {
        $this
            ->setMeter($meter)
            ->setMeters($meters)
            ->setServicePointMeter($servicePointMeter)
            ->setDsMeters($dsMeters)
            ->setMeterGroups($meterGroups)
            ->setHistoricalConsumptionUsageReport($historicalConsumptionUsageReport);
    }
    /**
     * Get Meter value
     * @return \SGCIS\Struct\Meter|null
     */
    public function getMeter()
    {
        return $this->Meter;
    }
    /**
     * Set Meter value
     * @param \SGCIS\Struct\Meter $meter
     * @return \SGCIS\Struct\MeterResponse
     */
    public function setMeter(\SGCIS\Struct\Meter $meter = null)
    {
        $this->Meter = $meter;
        return $this;
    }
    /**
     * Get Meters value
     * @return \SGCIS\Array\ArrayOfMeterCopy|null
     */
    public function getMeters()
    {
        return $this->Meters;
    }
    /**
     * Set Meters value
     * @param \SGCIS\Array\ArrayOfMeterCopy $meters
     * @return \SGCIS\Struct\MeterResponse
     */
    public function setMeters(\SGCIS\Array\ArrayOfMeterCopy $meters = null)
    {
        $this->Meters = $meters;
        return $this;
    }
    /**
     * Get ServicePointMeter value
     * @return \SGCIS\Struct\ServicePointMeter|null
     */
    public function getServicePointMeter()
    {
        return $this->ServicePointMeter;
    }
    /**
     * Set ServicePointMeter value
     * @param \SGCIS\Struct\ServicePointMeter $servicePointMeter
     * @return \SGCIS\Struct\MeterResponse
     */
    public function setServicePointMeter(\SGCIS\Struct\ServicePointMeter $servicePointMeter = null)
    {
        $this->ServicePointMeter = $servicePointMeter;
        return $this;
    }
    /**
     * Get dsMeters value
     * @return \SGCIS\Struct\DsMeters|null
     */
    public function getDsMeters()
    {
        return $this->dsMeters;
    }
    /**
     * Set dsMeters value
     * @param \SGCIS\Struct\DsMeters $dsMeters
     * @return \SGCIS\Struct\MeterResponse
     */
    public function setDsMeters(\SGCIS\Struct\DsMeters $dsMeters = null)
    {
        $this->dsMeters = $dsMeters;
        return $this;
    }
    /**
     * Get MeterGroups value
     * @return \SGCIS\Array\ArrayOfMeterGroup|null
     */
    public function getMeterGroups()
    {
        return $this->MeterGroups;
    }
    /**
     * Set MeterGroups value
     * @param \SGCIS\Array\ArrayOfMeterGroup $meterGroups
     * @return \SGCIS\Struct\MeterResponse
     */
    public function setMeterGroups(\SGCIS\Array\ArrayOfMeterGroup $meterGroups = null)
    {
        $this->MeterGroups = $meterGroups;
        return $this;
    }
    /**
     * Get HistoricalConsumptionUsageReport value
     * @return \SGCIS\Array\ArrayOfHistoricalConsumptionUsageReport|null
     */
    public function getHistoricalConsumptionUsageReport()
    {
        return $this->HistoricalConsumptionUsageReport;
    }
    /**
     * Set HistoricalConsumptionUsageReport value
     * @param \SGCIS\Array\ArrayOfHistoricalConsumptionUsageReport $historicalConsumptionUsageReport
     * @return \SGCIS\Struct\MeterResponse
     */
    public function setHistoricalConsumptionUsageReport(\SGCIS\Array\ArrayOfHistoricalConsumptionUsageReport $historicalConsumptionUsageReport = null)
    {
        $this->HistoricalConsumptionUsageReport = $historicalConsumptionUsageReport;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\MeterResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
