<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProductsRequest Struct
 * @subpackage Structs
 */
class GetProductsRequest extends ServiceRequestBase
{
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The CompanyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CompanyID;
    /**
     * The BillingFrequencyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillingFrequencyID;
    /**
     * The BillingCalculationMethodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillingCalculationMethodID;
    /**
     * The ProductTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductTypeID;
    /**
     * The BillingTriggerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillingTriggerID;
    /**
     * The ApplicationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ApplicationID;
    /**
     * The ChannelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChannelID;
    /**
     * The AccountTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountTypeID;
    /**
     * The IPAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IPAddress;
    /**
     * Constructor method for GetProductsRequest
     * @uses GetProductsRequest::setUserID()
     * @uses GetProductsRequest::setProductID()
     * @uses GetProductsRequest::setCompanyID()
     * @uses GetProductsRequest::setBillingFrequencyID()
     * @uses GetProductsRequest::setBillingCalculationMethodID()
     * @uses GetProductsRequest::setProductTypeID()
     * @uses GetProductsRequest::setBillingTriggerID()
     * @uses GetProductsRequest::setApplicationID()
     * @uses GetProductsRequest::setChannelID()
     * @uses GetProductsRequest::setAccountTypeID()
     * @uses GetProductsRequest::setIPAddress()
     * @param int $userID
     * @param int $productID
     * @param int $companyID
     * @param int $billingFrequencyID
     * @param int $billingCalculationMethodID
     * @param int $productTypeID
     * @param int $billingTriggerID
     * @param int $applicationID
     * @param int $channelID
     * @param int $accountTypeID
     * @param string $iPAddress
     */
    public function __construct($userID = null, $productID = null, $companyID = null, $billingFrequencyID = null, $billingCalculationMethodID = null, $productTypeID = null, $billingTriggerID = null, $applicationID = null, $channelID = null, $accountTypeID = null, $iPAddress = null)
    {
        $this
            ->setUserID($userID)
            ->setProductID($productID)
            ->setCompanyID($companyID)
            ->setBillingFrequencyID($billingFrequencyID)
            ->setBillingCalculationMethodID($billingCalculationMethodID)
            ->setProductTypeID($productTypeID)
            ->setBillingTriggerID($billingTriggerID)
            ->setApplicationID($applicationID)
            ->setChannelID($channelID)
            ->setAccountTypeID($accountTypeID)
            ->setIPAddress($iPAddress);
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \SGCIS\Struct\GetProductsRequest
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !is_numeric($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \SGCIS\Struct\GetProductsRequest
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get CompanyID value
     * @return int
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \SGCIS\Struct\GetProductsRequest
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !is_numeric($companyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get BillingFrequencyID value
     * @return int
     */
    public function getBillingFrequencyID()
    {
        return $this->BillingFrequencyID;
    }
    /**
     * Set BillingFrequencyID value
     * @param int $billingFrequencyID
     * @return \SGCIS\Struct\GetProductsRequest
     */
    public function setBillingFrequencyID($billingFrequencyID = null)
    {
        // validation for constraint: int
        if (!is_null($billingFrequencyID) && !is_numeric($billingFrequencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billingFrequencyID)), __LINE__);
        }
        $this->BillingFrequencyID = $billingFrequencyID;
        return $this;
    }
    /**
     * Get BillingCalculationMethodID value
     * @return int
     */
    public function getBillingCalculationMethodID()
    {
        return $this->BillingCalculationMethodID;
    }
    /**
     * Set BillingCalculationMethodID value
     * @param int $billingCalculationMethodID
     * @return \SGCIS\Struct\GetProductsRequest
     */
    public function setBillingCalculationMethodID($billingCalculationMethodID = null)
    {
        // validation for constraint: int
        if (!is_null($billingCalculationMethodID) && !is_numeric($billingCalculationMethodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billingCalculationMethodID)), __LINE__);
        }
        $this->BillingCalculationMethodID = $billingCalculationMethodID;
        return $this;
    }
    /**
     * Get ProductTypeID value
     * @return int
     */
    public function getProductTypeID()
    {
        return $this->ProductTypeID;
    }
    /**
     * Set ProductTypeID value
     * @param int $productTypeID
     * @return \SGCIS\Struct\GetProductsRequest
     */
    public function setProductTypeID($productTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($productTypeID) && !is_numeric($productTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productTypeID)), __LINE__);
        }
        $this->ProductTypeID = $productTypeID;
        return $this;
    }
    /**
     * Get BillingTriggerID value
     * @return int
     */
    public function getBillingTriggerID()
    {
        return $this->BillingTriggerID;
    }
    /**
     * Set BillingTriggerID value
     * @param int $billingTriggerID
     * @return \SGCIS\Struct\GetProductsRequest
     */
    public function setBillingTriggerID($billingTriggerID = null)
    {
        // validation for constraint: int
        if (!is_null($billingTriggerID) && !is_numeric($billingTriggerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billingTriggerID)), __LINE__);
        }
        $this->BillingTriggerID = $billingTriggerID;
        return $this;
    }
    /**
     * Get ApplicationID value
     * @return int
     */
    public function getApplicationID()
    {
        return $this->ApplicationID;
    }
    /**
     * Set ApplicationID value
     * @param int $applicationID
     * @return \SGCIS\Struct\GetProductsRequest
     */
    public function setApplicationID($applicationID = null)
    {
        // validation for constraint: int
        if (!is_null($applicationID) && !is_numeric($applicationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($applicationID)), __LINE__);
        }
        $this->ApplicationID = $applicationID;
        return $this;
    }
    /**
     * Get ChannelID value
     * @return int
     */
    public function getChannelID()
    {
        return $this->ChannelID;
    }
    /**
     * Set ChannelID value
     * @param int $channelID
     * @return \SGCIS\Struct\GetProductsRequest
     */
    public function setChannelID($channelID = null)
    {
        // validation for constraint: int
        if (!is_null($channelID) && !is_numeric($channelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($channelID)), __LINE__);
        }
        $this->ChannelID = $channelID;
        return $this;
    }
    /**
     * Get AccountTypeID value
     * @return int
     */
    public function getAccountTypeID()
    {
        return $this->AccountTypeID;
    }
    /**
     * Set AccountTypeID value
     * @param int $accountTypeID
     * @return \SGCIS\Struct\GetProductsRequest
     */
    public function setAccountTypeID($accountTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($accountTypeID) && !is_numeric($accountTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountTypeID)), __LINE__);
        }
        $this->AccountTypeID = $accountTypeID;
        return $this;
    }
    /**
     * Get IPAddress value
     * @return string|null
     */
    public function getIPAddress()
    {
        return $this->IPAddress;
    }
    /**
     * Set IPAddress value
     * @param string $iPAddress
     * @return \SGCIS\Struct\GetProductsRequest
     */
    public function setIPAddress($iPAddress = null)
    {
        // validation for constraint: string
        if (!is_null($iPAddress) && !is_string($iPAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPAddress)), __LINE__);
        }
        $this->IPAddress = $iPAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\GetProductsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
