<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DashboardGalleryWidget Struct
 * @subpackage Structs
 */
class DashboardGalleryWidget extends AbstractStructBase
{
    /**
     * The DashboardGalleryWidgetId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DashboardGalleryWidgetId;
    /**
     * The DefaultWidth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DefaultWidth;
    /**
     * The DefaultHeight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DefaultHeight;
    /**
     * The ApplicationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ApplicationID;
    /**
     * The WidgetName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WidgetName;
    /**
     * The ControlName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ControlName;
    /**
     * The ControlUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ControlUrl;
    /**
     * The WidgetDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WidgetDescription;
    /**
     * Constructor method for DashboardGalleryWidget
     * @uses DashboardGalleryWidget::setDashboardGalleryWidgetId()
     * @uses DashboardGalleryWidget::setDefaultWidth()
     * @uses DashboardGalleryWidget::setDefaultHeight()
     * @uses DashboardGalleryWidget::setApplicationID()
     * @uses DashboardGalleryWidget::setWidgetName()
     * @uses DashboardGalleryWidget::setControlName()
     * @uses DashboardGalleryWidget::setControlUrl()
     * @uses DashboardGalleryWidget::setWidgetDescription()
     * @param int $dashboardGalleryWidgetId
     * @param int $defaultWidth
     * @param int $defaultHeight
     * @param int $applicationID
     * @param string $widgetName
     * @param string $controlName
     * @param string $controlUrl
     * @param string $widgetDescription
     */
    public function __construct($dashboardGalleryWidgetId = null, $defaultWidth = null, $defaultHeight = null, $applicationID = null, $widgetName = null, $controlName = null, $controlUrl = null, $widgetDescription = null)
    {
        $this
            ->setDashboardGalleryWidgetId($dashboardGalleryWidgetId)
            ->setDefaultWidth($defaultWidth)
            ->setDefaultHeight($defaultHeight)
            ->setApplicationID($applicationID)
            ->setWidgetName($widgetName)
            ->setControlName($controlName)
            ->setControlUrl($controlUrl)
            ->setWidgetDescription($widgetDescription);
    }
    /**
     * Get DashboardGalleryWidgetId value
     * @return int
     */
    public function getDashboardGalleryWidgetId()
    {
        return $this->DashboardGalleryWidgetId;
    }
    /**
     * Set DashboardGalleryWidgetId value
     * @param int $dashboardGalleryWidgetId
     * @return \SGCIS\Struct\DashboardGalleryWidget
     */
    public function setDashboardGalleryWidgetId($dashboardGalleryWidgetId = null)
    {
        // validation for constraint: int
        if (!is_null($dashboardGalleryWidgetId) && !is_numeric($dashboardGalleryWidgetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dashboardGalleryWidgetId)), __LINE__);
        }
        $this->DashboardGalleryWidgetId = $dashboardGalleryWidgetId;
        return $this;
    }
    /**
     * Get DefaultWidth value
     * @return int
     */
    public function getDefaultWidth()
    {
        return $this->DefaultWidth;
    }
    /**
     * Set DefaultWidth value
     * @param int $defaultWidth
     * @return \SGCIS\Struct\DashboardGalleryWidget
     */
    public function setDefaultWidth($defaultWidth = null)
    {
        // validation for constraint: int
        if (!is_null($defaultWidth) && !is_numeric($defaultWidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($defaultWidth)), __LINE__);
        }
        $this->DefaultWidth = $defaultWidth;
        return $this;
    }
    /**
     * Get DefaultHeight value
     * @return int
     */
    public function getDefaultHeight()
    {
        return $this->DefaultHeight;
    }
    /**
     * Set DefaultHeight value
     * @param int $defaultHeight
     * @return \SGCIS\Struct\DashboardGalleryWidget
     */
    public function setDefaultHeight($defaultHeight = null)
    {
        // validation for constraint: int
        if (!is_null($defaultHeight) && !is_numeric($defaultHeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($defaultHeight)), __LINE__);
        }
        $this->DefaultHeight = $defaultHeight;
        return $this;
    }
    /**
     * Get ApplicationID value
     * @return int
     */
    public function getApplicationID()
    {
        return $this->ApplicationID;
    }
    /**
     * Set ApplicationID value
     * @param int $applicationID
     * @return \SGCIS\Struct\DashboardGalleryWidget
     */
    public function setApplicationID($applicationID = null)
    {
        // validation for constraint: int
        if (!is_null($applicationID) && !is_numeric($applicationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($applicationID)), __LINE__);
        }
        $this->ApplicationID = $applicationID;
        return $this;
    }
    /**
     * Get WidgetName value
     * @return string|null
     */
    public function getWidgetName()
    {
        return $this->WidgetName;
    }
    /**
     * Set WidgetName value
     * @param string $widgetName
     * @return \SGCIS\Struct\DashboardGalleryWidget
     */
    public function setWidgetName($widgetName = null)
    {
        // validation for constraint: string
        if (!is_null($widgetName) && !is_string($widgetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($widgetName)), __LINE__);
        }
        $this->WidgetName = $widgetName;
        return $this;
    }
    /**
     * Get ControlName value
     * @return string|null
     */
    public function getControlName()
    {
        return $this->ControlName;
    }
    /**
     * Set ControlName value
     * @param string $controlName
     * @return \SGCIS\Struct\DashboardGalleryWidget
     */
    public function setControlName($controlName = null)
    {
        // validation for constraint: string
        if (!is_null($controlName) && !is_string($controlName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($controlName)), __LINE__);
        }
        $this->ControlName = $controlName;
        return $this;
    }
    /**
     * Get ControlUrl value
     * @return string|null
     */
    public function getControlUrl()
    {
        return $this->ControlUrl;
    }
    /**
     * Set ControlUrl value
     * @param string $controlUrl
     * @return \SGCIS\Struct\DashboardGalleryWidget
     */
    public function setControlUrl($controlUrl = null)
    {
        // validation for constraint: string
        if (!is_null($controlUrl) && !is_string($controlUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($controlUrl)), __LINE__);
        }
        $this->ControlUrl = $controlUrl;
        return $this;
    }
    /**
     * Get WidgetDescription value
     * @return string|null
     */
    public function getWidgetDescription()
    {
        return $this->WidgetDescription;
    }
    /**
     * Set WidgetDescription value
     * @param string $widgetDescription
     * @return \SGCIS\Struct\DashboardGalleryWidget
     */
    public function setWidgetDescription($widgetDescription = null)
    {
        // validation for constraint: string
        if (!is_null($widgetDescription) && !is_string($widgetDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($widgetDescription)), __LINE__);
        }
        $this->WidgetDescription = $widgetDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\DashboardGalleryWidget
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
