<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeSchedule Struct
 * @subpackage Structs
 */
class ChargeSchedule extends BaseDTO
{
    /**
     * The ChargeScheduleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeScheduleID;
    /**
     * The ChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeID;
    /**
     * The ChargeOccurTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeOccurTypeID;
    /**
     * The ProrationMethodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProrationMethodID;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The ExpireDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ExpireDate;
    /**
     * The RecurInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RecurInterval;
    /**
     * The ExpireAfterMaxOccurences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExpireAfterMaxOccurences;
    /**
     * The Sun
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Sun;
    /**
     * The Mon
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Mon;
    /**
     * The Tue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Tue;
    /**
     * The Wed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Wed;
    /**
     * The Thu
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Thu;
    /**
     * The Fri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Fri;
    /**
     * The Sat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Sat;
    /**
     * The ScheduleDay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ScheduleDay;
    /**
     * The TimeOfMonthID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TimeOfMonthID;
    /**
     * Constructor method for ChargeSchedule
     * @uses ChargeSchedule::setChargeScheduleID()
     * @uses ChargeSchedule::setChargeID()
     * @uses ChargeSchedule::setChargeOccurTypeID()
     * @uses ChargeSchedule::setProrationMethodID()
     * @uses ChargeSchedule::setStartDate()
     * @uses ChargeSchedule::setExpireDate()
     * @uses ChargeSchedule::setRecurInterval()
     * @uses ChargeSchedule::setExpireAfterMaxOccurences()
     * @uses ChargeSchedule::setSun()
     * @uses ChargeSchedule::setMon()
     * @uses ChargeSchedule::setTue()
     * @uses ChargeSchedule::setWed()
     * @uses ChargeSchedule::setThu()
     * @uses ChargeSchedule::setFri()
     * @uses ChargeSchedule::setSat()
     * @uses ChargeSchedule::setScheduleDay()
     * @uses ChargeSchedule::setTimeOfMonthID()
     * @param int $chargeScheduleID
     * @param int $chargeID
     * @param int $chargeOccurTypeID
     * @param int $prorationMethodID
     * @param string $startDate
     * @param string $expireDate
     * @param int $recurInterval
     * @param int $expireAfterMaxOccurences
     * @param bool $sun
     * @param bool $mon
     * @param bool $tue
     * @param bool $wed
     * @param bool $thu
     * @param bool $fri
     * @param bool $sat
     * @param int $scheduleDay
     * @param int $timeOfMonthID
     */
    public function __construct($chargeScheduleID = null, $chargeID = null, $chargeOccurTypeID = null, $prorationMethodID = null, $startDate = null, $expireDate = null, $recurInterval = null, $expireAfterMaxOccurences = null, $sun = null, $mon = null, $tue = null, $wed = null, $thu = null, $fri = null, $sat = null, $scheduleDay = null, $timeOfMonthID = null)
    {
        $this
            ->setChargeScheduleID($chargeScheduleID)
            ->setChargeID($chargeID)
            ->setChargeOccurTypeID($chargeOccurTypeID)
            ->setProrationMethodID($prorationMethodID)
            ->setStartDate($startDate)
            ->setExpireDate($expireDate)
            ->setRecurInterval($recurInterval)
            ->setExpireAfterMaxOccurences($expireAfterMaxOccurences)
            ->setSun($sun)
            ->setMon($mon)
            ->setTue($tue)
            ->setWed($wed)
            ->setThu($thu)
            ->setFri($fri)
            ->setSat($sat)
            ->setScheduleDay($scheduleDay)
            ->setTimeOfMonthID($timeOfMonthID);
    }
    /**
     * Get ChargeScheduleID value
     * @return int
     */
    public function getChargeScheduleID()
    {
        return $this->ChargeScheduleID;
    }
    /**
     * Set ChargeScheduleID value
     * @param int $chargeScheduleID
     * @return \SGCIS\Struct\ChargeSchedule
     */
    public function setChargeScheduleID($chargeScheduleID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeScheduleID) && !is_numeric($chargeScheduleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeScheduleID)), __LINE__);
        }
        $this->ChargeScheduleID = $chargeScheduleID;
        return $this;
    }
    /**
     * Get ChargeID value
     * @return int
     */
    public function getChargeID()
    {
        return $this->ChargeID;
    }
    /**
     * Set ChargeID value
     * @param int $chargeID
     * @return \SGCIS\Struct\ChargeSchedule
     */
    public function setChargeID($chargeID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeID) && !is_numeric($chargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeID)), __LINE__);
        }
        $this->ChargeID = $chargeID;
        return $this;
    }
    /**
     * Get ChargeOccurTypeID value
     * @return int
     */
    public function getChargeOccurTypeID()
    {
        return $this->ChargeOccurTypeID;
    }
    /**
     * Set ChargeOccurTypeID value
     * @param int $chargeOccurTypeID
     * @return \SGCIS\Struct\ChargeSchedule
     */
    public function setChargeOccurTypeID($chargeOccurTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeOccurTypeID) && !is_numeric($chargeOccurTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeOccurTypeID)), __LINE__);
        }
        $this->ChargeOccurTypeID = $chargeOccurTypeID;
        return $this;
    }
    /**
     * Get ProrationMethodID value
     * @return int
     */
    public function getProrationMethodID()
    {
        return $this->ProrationMethodID;
    }
    /**
     * Set ProrationMethodID value
     * @param int $prorationMethodID
     * @return \SGCIS\Struct\ChargeSchedule
     */
    public function setProrationMethodID($prorationMethodID = null)
    {
        // validation for constraint: int
        if (!is_null($prorationMethodID) && !is_numeric($prorationMethodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($prorationMethodID)), __LINE__);
        }
        $this->ProrationMethodID = $prorationMethodID;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \SGCIS\Struct\ChargeSchedule
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \SGCIS\Struct\ChargeSchedule
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get RecurInterval value
     * @return int
     */
    public function getRecurInterval()
    {
        return $this->RecurInterval;
    }
    /**
     * Set RecurInterval value
     * @param int $recurInterval
     * @return \SGCIS\Struct\ChargeSchedule
     */
    public function setRecurInterval($recurInterval = null)
    {
        // validation for constraint: int
        if (!is_null($recurInterval) && !is_numeric($recurInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recurInterval)), __LINE__);
        }
        $this->RecurInterval = $recurInterval;
        return $this;
    }
    /**
     * Get ExpireAfterMaxOccurences value
     * @return int
     */
    public function getExpireAfterMaxOccurences()
    {
        return $this->ExpireAfterMaxOccurences;
    }
    /**
     * Set ExpireAfterMaxOccurences value
     * @param int $expireAfterMaxOccurences
     * @return \SGCIS\Struct\ChargeSchedule
     */
    public function setExpireAfterMaxOccurences($expireAfterMaxOccurences = null)
    {
        // validation for constraint: int
        if (!is_null($expireAfterMaxOccurences) && !is_numeric($expireAfterMaxOccurences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expireAfterMaxOccurences)), __LINE__);
        }
        $this->ExpireAfterMaxOccurences = $expireAfterMaxOccurences;
        return $this;
    }
    /**
     * Get Sun value
     * @return bool
     */
    public function getSun()
    {
        return $this->Sun;
    }
    /**
     * Set Sun value
     * @param bool $sun
     * @return \SGCIS\Struct\ChargeSchedule
     */
    public function setSun($sun = null)
    {
        // validation for constraint: boolean
        if (!is_null($sun) && !is_bool($sun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sun)), __LINE__);
        }
        $this->Sun = $sun;
        return $this;
    }
    /**
     * Get Mon value
     * @return bool
     */
    public function getMon()
    {
        return $this->Mon;
    }
    /**
     * Set Mon value
     * @param bool $mon
     * @return \SGCIS\Struct\ChargeSchedule
     */
    public function setMon($mon = null)
    {
        // validation for constraint: boolean
        if (!is_null($mon) && !is_bool($mon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mon)), __LINE__);
        }
        $this->Mon = $mon;
        return $this;
    }
    /**
     * Get Tue value
     * @return bool
     */
    public function getTue()
    {
        return $this->Tue;
    }
    /**
     * Set Tue value
     * @param bool $tue
     * @return \SGCIS\Struct\ChargeSchedule
     */
    public function setTue($tue = null)
    {
        // validation for constraint: boolean
        if (!is_null($tue) && !is_bool($tue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($tue)), __LINE__);
        }
        $this->Tue = $tue;
        return $this;
    }
    /**
     * Get Wed value
     * @return bool
     */
    public function getWed()
    {
        return $this->Wed;
    }
    /**
     * Set Wed value
     * @param bool $wed
     * @return \SGCIS\Struct\ChargeSchedule
     */
    public function setWed($wed = null)
    {
        // validation for constraint: boolean
        if (!is_null($wed) && !is_bool($wed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($wed)), __LINE__);
        }
        $this->Wed = $wed;
        return $this;
    }
    /**
     * Get Thu value
     * @return bool
     */
    public function getThu()
    {
        return $this->Thu;
    }
    /**
     * Set Thu value
     * @param bool $thu
     * @return \SGCIS\Struct\ChargeSchedule
     */
    public function setThu($thu = null)
    {
        // validation for constraint: boolean
        if (!is_null($thu) && !is_bool($thu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($thu)), __LINE__);
        }
        $this->Thu = $thu;
        return $this;
    }
    /**
     * Get Fri value
     * @return bool
     */
    public function getFri()
    {
        return $this->Fri;
    }
    /**
     * Set Fri value
     * @param bool $fri
     * @return \SGCIS\Struct\ChargeSchedule
     */
    public function setFri($fri = null)
    {
        // validation for constraint: boolean
        if (!is_null($fri) && !is_bool($fri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fri)), __LINE__);
        }
        $this->Fri = $fri;
        return $this;
    }
    /**
     * Get Sat value
     * @return bool
     */
    public function getSat()
    {
        return $this->Sat;
    }
    /**
     * Set Sat value
     * @param bool $sat
     * @return \SGCIS\Struct\ChargeSchedule
     */
    public function setSat($sat = null)
    {
        // validation for constraint: boolean
        if (!is_null($sat) && !is_bool($sat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sat)), __LINE__);
        }
        $this->Sat = $sat;
        return $this;
    }
    /**
     * Get ScheduleDay value
     * @return int
     */
    public function getScheduleDay()
    {
        return $this->ScheduleDay;
    }
    /**
     * Set ScheduleDay value
     * @param int $scheduleDay
     * @return \SGCIS\Struct\ChargeSchedule
     */
    public function setScheduleDay($scheduleDay = null)
    {
        // validation for constraint: int
        if (!is_null($scheduleDay) && !is_numeric($scheduleDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($scheduleDay)), __LINE__);
        }
        $this->ScheduleDay = $scheduleDay;
        return $this;
    }
    /**
     * Get TimeOfMonthID value
     * @return int
     */
    public function getTimeOfMonthID()
    {
        return $this->TimeOfMonthID;
    }
    /**
     * Set TimeOfMonthID value
     * @param int $timeOfMonthID
     * @return \SGCIS\Struct\ChargeSchedule
     */
    public function setTimeOfMonthID($timeOfMonthID = null)
    {
        // validation for constraint: int
        if (!is_null($timeOfMonthID) && !is_numeric($timeOfMonthID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($timeOfMonthID)), __LINE__);
        }
        $this->TimeOfMonthID = $timeOfMonthID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ChargeSchedule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
