<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeCharacteristic Struct
 * @subpackage Structs
 */
class ChargeCharacteristic extends AbstractStructBase
{
    /**
     * The ChargeCharacteristicID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeCharacteristicID;
    /**
     * The ChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeID;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The CharName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CharName;
    /**
     * The CharValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CharValue;
    /**
     * The CreatedByUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreatedByUserName;
    /**
     * Constructor method for ChargeCharacteristic
     * @uses ChargeCharacteristic::setChargeCharacteristicID()
     * @uses ChargeCharacteristic::setChargeID()
     * @uses ChargeCharacteristic::setCreateDate()
     * @uses ChargeCharacteristic::setCharName()
     * @uses ChargeCharacteristic::setCharValue()
     * @uses ChargeCharacteristic::setCreatedByUserName()
     * @param int $chargeCharacteristicID
     * @param int $chargeID
     * @param string $createDate
     * @param string $charName
     * @param string $charValue
     * @param string $createdByUserName
     */
    public function __construct($chargeCharacteristicID = null, $chargeID = null, $createDate = null, $charName = null, $charValue = null, $createdByUserName = null)
    {
        $this
            ->setChargeCharacteristicID($chargeCharacteristicID)
            ->setChargeID($chargeID)
            ->setCreateDate($createDate)
            ->setCharName($charName)
            ->setCharValue($charValue)
            ->setCreatedByUserName($createdByUserName);
    }
    /**
     * Get ChargeCharacteristicID value
     * @return int
     */
    public function getChargeCharacteristicID()
    {
        return $this->ChargeCharacteristicID;
    }
    /**
     * Set ChargeCharacteristicID value
     * @param int $chargeCharacteristicID
     * @return \SGCIS\Struct\ChargeCharacteristic
     */
    public function setChargeCharacteristicID($chargeCharacteristicID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeCharacteristicID) && !is_numeric($chargeCharacteristicID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeCharacteristicID)), __LINE__);
        }
        $this->ChargeCharacteristicID = $chargeCharacteristicID;
        return $this;
    }
    /**
     * Get ChargeID value
     * @return int
     */
    public function getChargeID()
    {
        return $this->ChargeID;
    }
    /**
     * Set ChargeID value
     * @param int $chargeID
     * @return \SGCIS\Struct\ChargeCharacteristic
     */
    public function setChargeID($chargeID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeID) && !is_numeric($chargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeID)), __LINE__);
        }
        $this->ChargeID = $chargeID;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\ChargeCharacteristic
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CharName value
     * @return string|null
     */
    public function getCharName()
    {
        return $this->CharName;
    }
    /**
     * Set CharName value
     * @param string $charName
     * @return \SGCIS\Struct\ChargeCharacteristic
     */
    public function setCharName($charName = null)
    {
        // validation for constraint: string
        if (!is_null($charName) && !is_string($charName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($charName)), __LINE__);
        }
        $this->CharName = $charName;
        return $this;
    }
    /**
     * Get CharValue value
     * @return string|null
     */
    public function getCharValue()
    {
        return $this->CharValue;
    }
    /**
     * Set CharValue value
     * @param string $charValue
     * @return \SGCIS\Struct\ChargeCharacteristic
     */
    public function setCharValue($charValue = null)
    {
        // validation for constraint: string
        if (!is_null($charValue) && !is_string($charValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($charValue)), __LINE__);
        }
        $this->CharValue = $charValue;
        return $this;
    }
    /**
     * Get CreatedByUserName value
     * @return string|null
     */
    public function getCreatedByUserName()
    {
        return $this->CreatedByUserName;
    }
    /**
     * Set CreatedByUserName value
     * @param string $createdByUserName
     * @return \SGCIS\Struct\ChargeCharacteristic
     */
    public function setCreatedByUserName($createdByUserName = null)
    {
        // validation for constraint: string
        if (!is_null($createdByUserName) && !is_string($createdByUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdByUserName)), __LINE__);
        }
        $this->CreatedByUserName = $createdByUserName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ChargeCharacteristic
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
