<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeAccountType Struct
 * @subpackage Structs
 */
class ChargeAccountType extends AbstractStructBase
{
    /**
     * The ChargeAccountTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeAccountTypeID;
    /**
     * The ChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeID;
    /**
     * The AccountTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountTypeID;
    /**
     * Constructor method for ChargeAccountType
     * @uses ChargeAccountType::setChargeAccountTypeID()
     * @uses ChargeAccountType::setChargeID()
     * @uses ChargeAccountType::setAccountTypeID()
     * @param int $chargeAccountTypeID
     * @param int $chargeID
     * @param int $accountTypeID
     */
    public function __construct($chargeAccountTypeID = null, $chargeID = null, $accountTypeID = null)
    {
        $this
            ->setChargeAccountTypeID($chargeAccountTypeID)
            ->setChargeID($chargeID)
            ->setAccountTypeID($accountTypeID);
    }
    /**
     * Get ChargeAccountTypeID value
     * @return int
     */
    public function getChargeAccountTypeID()
    {
        return $this->ChargeAccountTypeID;
    }
    /**
     * Set ChargeAccountTypeID value
     * @param int $chargeAccountTypeID
     * @return \SGCIS\Struct\ChargeAccountType
     */
    public function setChargeAccountTypeID($chargeAccountTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeAccountTypeID) && !is_numeric($chargeAccountTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeAccountTypeID)), __LINE__);
        }
        $this->ChargeAccountTypeID = $chargeAccountTypeID;
        return $this;
    }
    /**
     * Get ChargeID value
     * @return int
     */
    public function getChargeID()
    {
        return $this->ChargeID;
    }
    /**
     * Set ChargeID value
     * @param int $chargeID
     * @return \SGCIS\Struct\ChargeAccountType
     */
    public function setChargeID($chargeID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeID) && !is_numeric($chargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeID)), __LINE__);
        }
        $this->ChargeID = $chargeID;
        return $this;
    }
    /**
     * Get AccountTypeID value
     * @return int
     */
    public function getAccountTypeID()
    {
        return $this->AccountTypeID;
    }
    /**
     * Set AccountTypeID value
     * @param int $accountTypeID
     * @return \SGCIS\Struct\ChargeAccountType
     */
    public function setAccountTypeID($accountTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($accountTypeID) && !is_numeric($accountTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountTypeID)), __LINE__);
        }
        $this->AccountTypeID = $accountTypeID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ChargeAccountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
