<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingResponse Struct
 * @subpackage Structs
 */
class BillingResponse extends ServiceResponseBase
{
    /**
     * The AccountEndCycle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AccountEndCycle;
    /**
     * The EDIBills
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfEDIBill
     */
    public $EDIBills;
    /**
     * The Bills
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBill
     */
    public $Bills;
    /**
     * The BillChargeDisplayItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillChargeDisplayItem
     */
    public $BillChargeDisplayItems;
    /**
     * The BillStatusCounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillStatusCount
     */
    public $BillStatusCounts;
    /**
     * The BillHeaders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillHeader
     */
    public $BillHeaders;
    /**
     * The BillConvertedHeaders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillConvertedHeader
     */
    public $BillConvertedHeaders;
    /**
     * The BillDocument
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Bill
     */
    public $BillDocument;
    /**
     * The BillDocuments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBill
     */
    public $BillDocuments;
    /**
     * The TransactionAssociateAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfTransactionAssociateAccount
     */
    public $TransactionAssociateAccount;
    /**
     * The TransactionsNotImported
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfTransactionNotImported
     */
    public $TransactionsNotImported;
    /**
     * The CurrentBill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\CurrentBill
     */
    public $CurrentBill;
    /**
     * The BillHistory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillBalance
     */
    public $BillHistory;
    /**
     * Constructor method for BillingResponse
     * @uses BillingResponse::setAccountEndCycle()
     * @uses BillingResponse::setEDIBills()
     * @uses BillingResponse::setBills()
     * @uses BillingResponse::setBillChargeDisplayItems()
     * @uses BillingResponse::setBillStatusCounts()
     * @uses BillingResponse::setBillHeaders()
     * @uses BillingResponse::setBillConvertedHeaders()
     * @uses BillingResponse::setBillDocument()
     * @uses BillingResponse::setBillDocuments()
     * @uses BillingResponse::setTransactionAssociateAccount()
     * @uses BillingResponse::setTransactionsNotImported()
     * @uses BillingResponse::setCurrentBill()
     * @uses BillingResponse::setBillHistory()
     * @param string $accountEndCycle
     * @param \SGCIS\Array\ArrayOfEDIBill $eDIBills
     * @param \SGCIS\Array\ArrayOfBill $bills
     * @param \SGCIS\Array\ArrayOfBillChargeDisplayItem $billChargeDisplayItems
     * @param \SGCIS\Array\ArrayOfBillStatusCount $billStatusCounts
     * @param \SGCIS\Array\ArrayOfBillHeader $billHeaders
     * @param \SGCIS\Array\ArrayOfBillConvertedHeader $billConvertedHeaders
     * @param \SGCIS\Struct\Bill $billDocument
     * @param \SGCIS\Array\ArrayOfBill $billDocuments
     * @param \SGCIS\Array\ArrayOfTransactionAssociateAccount $transactionAssociateAccount
     * @param \SGCIS\Array\ArrayOfTransactionNotImported $transactionsNotImported
     * @param \SGCIS\Struct\CurrentBill $currentBill
     * @param \SGCIS\Array\ArrayOfBillBalance $billHistory
     */
    public function __construct($accountEndCycle = null, \SGCIS\Array\ArrayOfEDIBill $eDIBills = null, \SGCIS\Array\ArrayOfBill $bills = null, \SGCIS\Array\ArrayOfBillChargeDisplayItem $billChargeDisplayItems = null, \SGCIS\Array\ArrayOfBillStatusCount $billStatusCounts = null, \SGCIS\Array\ArrayOfBillHeader $billHeaders = null, \SGCIS\Array\ArrayOfBillConvertedHeader $billConvertedHeaders = null, \SGCIS\Struct\Bill $billDocument = null, \SGCIS\Array\ArrayOfBill $billDocuments = null, \SGCIS\Array\ArrayOfTransactionAssociateAccount $transactionAssociateAccount = null, \SGCIS\Array\ArrayOfTransactionNotImported $transactionsNotImported = null, \SGCIS\Struct\CurrentBill $currentBill = null, \SGCIS\Array\ArrayOfBillBalance $billHistory = null)
    {
        $this
            ->setAccountEndCycle($accountEndCycle)
            ->setEDIBills($eDIBills)
            ->setBills($bills)
            ->setBillChargeDisplayItems($billChargeDisplayItems)
            ->setBillStatusCounts($billStatusCounts)
            ->setBillHeaders($billHeaders)
            ->setBillConvertedHeaders($billConvertedHeaders)
            ->setBillDocument($billDocument)
            ->setBillDocuments($billDocuments)
            ->setTransactionAssociateAccount($transactionAssociateAccount)
            ->setTransactionsNotImported($transactionsNotImported)
            ->setCurrentBill($currentBill)
            ->setBillHistory($billHistory);
    }
    /**
     * Get AccountEndCycle value
     * @return string
     */
    public function getAccountEndCycle()
    {
        return $this->AccountEndCycle;
    }
    /**
     * Set AccountEndCycle value
     * @param string $accountEndCycle
     * @return \SGCIS\Struct\BillingResponse
     */
    public function setAccountEndCycle($accountEndCycle = null)
    {
        // validation for constraint: string
        if (!is_null($accountEndCycle) && !is_string($accountEndCycle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountEndCycle)), __LINE__);
        }
        $this->AccountEndCycle = $accountEndCycle;
        return $this;
    }
    /**
     * Get EDIBills value
     * @return \SGCIS\Array\ArrayOfEDIBill|null
     */
    public function getEDIBills()
    {
        return $this->EDIBills;
    }
    /**
     * Set EDIBills value
     * @param \SGCIS\Array\ArrayOfEDIBill $eDIBills
     * @return \SGCIS\Struct\BillingResponse
     */
    public function setEDIBills(\SGCIS\Array\ArrayOfEDIBill $eDIBills = null)
    {
        $this->EDIBills = $eDIBills;
        return $this;
    }
    /**
     * Get Bills value
     * @return \SGCIS\Array\ArrayOfBill|null
     */
    public function getBills()
    {
        return $this->Bills;
    }
    /**
     * Set Bills value
     * @param \SGCIS\Array\ArrayOfBill $bills
     * @return \SGCIS\Struct\BillingResponse
     */
    public function setBills(\SGCIS\Array\ArrayOfBill $bills = null)
    {
        $this->Bills = $bills;
        return $this;
    }
    /**
     * Get BillChargeDisplayItems value
     * @return \SGCIS\Array\ArrayOfBillChargeDisplayItem|null
     */
    public function getBillChargeDisplayItems()
    {
        return $this->BillChargeDisplayItems;
    }
    /**
     * Set BillChargeDisplayItems value
     * @param \SGCIS\Array\ArrayOfBillChargeDisplayItem $billChargeDisplayItems
     * @return \SGCIS\Struct\BillingResponse
     */
    public function setBillChargeDisplayItems(\SGCIS\Array\ArrayOfBillChargeDisplayItem $billChargeDisplayItems = null)
    {
        $this->BillChargeDisplayItems = $billChargeDisplayItems;
        return $this;
    }
    /**
     * Get BillStatusCounts value
     * @return \SGCIS\Array\ArrayOfBillStatusCount|null
     */
    public function getBillStatusCounts()
    {
        return $this->BillStatusCounts;
    }
    /**
     * Set BillStatusCounts value
     * @param \SGCIS\Array\ArrayOfBillStatusCount $billStatusCounts
     * @return \SGCIS\Struct\BillingResponse
     */
    public function setBillStatusCounts(\SGCIS\Array\ArrayOfBillStatusCount $billStatusCounts = null)
    {
        $this->BillStatusCounts = $billStatusCounts;
        return $this;
    }
    /**
     * Get BillHeaders value
     * @return \SGCIS\Array\ArrayOfBillHeader|null
     */
    public function getBillHeaders()
    {
        return $this->BillHeaders;
    }
    /**
     * Set BillHeaders value
     * @param \SGCIS\Array\ArrayOfBillHeader $billHeaders
     * @return \SGCIS\Struct\BillingResponse
     */
    public function setBillHeaders(\SGCIS\Array\ArrayOfBillHeader $billHeaders = null)
    {
        $this->BillHeaders = $billHeaders;
        return $this;
    }
    /**
     * Get BillConvertedHeaders value
     * @return \SGCIS\Array\ArrayOfBillConvertedHeader|null
     */
    public function getBillConvertedHeaders()
    {
        return $this->BillConvertedHeaders;
    }
    /**
     * Set BillConvertedHeaders value
     * @param \SGCIS\Array\ArrayOfBillConvertedHeader $billConvertedHeaders
     * @return \SGCIS\Struct\BillingResponse
     */
    public function setBillConvertedHeaders(\SGCIS\Array\ArrayOfBillConvertedHeader $billConvertedHeaders = null)
    {
        $this->BillConvertedHeaders = $billConvertedHeaders;
        return $this;
    }
    /**
     * Get BillDocument value
     * @return \SGCIS\Struct\Bill|null
     */
    public function getBillDocument()
    {
        return $this->BillDocument;
    }
    /**
     * Set BillDocument value
     * @param \SGCIS\Struct\Bill $billDocument
     * @return \SGCIS\Struct\BillingResponse
     */
    public function setBillDocument(\SGCIS\Struct\Bill $billDocument = null)
    {
        $this->BillDocument = $billDocument;
        return $this;
    }
    /**
     * Get BillDocuments value
     * @return \SGCIS\Array\ArrayOfBill|null
     */
    public function getBillDocuments()
    {
        return $this->BillDocuments;
    }
    /**
     * Set BillDocuments value
     * @param \SGCIS\Array\ArrayOfBill $billDocuments
     * @return \SGCIS\Struct\BillingResponse
     */
    public function setBillDocuments(\SGCIS\Array\ArrayOfBill $billDocuments = null)
    {
        $this->BillDocuments = $billDocuments;
        return $this;
    }
    /**
     * Get TransactionAssociateAccount value
     * @return \SGCIS\Array\ArrayOfTransactionAssociateAccount|null
     */
    public function getTransactionAssociateAccount()
    {
        return $this->TransactionAssociateAccount;
    }
    /**
     * Set TransactionAssociateAccount value
     * @param \SGCIS\Array\ArrayOfTransactionAssociateAccount $transactionAssociateAccount
     * @return \SGCIS\Struct\BillingResponse
     */
    public function setTransactionAssociateAccount(\SGCIS\Array\ArrayOfTransactionAssociateAccount $transactionAssociateAccount = null)
    {
        $this->TransactionAssociateAccount = $transactionAssociateAccount;
        return $this;
    }
    /**
     * Get TransactionsNotImported value
     * @return \SGCIS\Array\ArrayOfTransactionNotImported|null
     */
    public function getTransactionsNotImported()
    {
        return $this->TransactionsNotImported;
    }
    /**
     * Set TransactionsNotImported value
     * @param \SGCIS\Array\ArrayOfTransactionNotImported $transactionsNotImported
     * @return \SGCIS\Struct\BillingResponse
     */
    public function setTransactionsNotImported(\SGCIS\Array\ArrayOfTransactionNotImported $transactionsNotImported = null)
    {
        $this->TransactionsNotImported = $transactionsNotImported;
        return $this;
    }
    /**
     * Get CurrentBill value
     * @return \SGCIS\Struct\CurrentBill|null
     */
    public function getCurrentBill()
    {
        return $this->CurrentBill;
    }
    /**
     * Set CurrentBill value
     * @param \SGCIS\Struct\CurrentBill $currentBill
     * @return \SGCIS\Struct\BillingResponse
     */
    public function setCurrentBill(\SGCIS\Struct\CurrentBill $currentBill = null)
    {
        $this->CurrentBill = $currentBill;
        return $this;
    }
    /**
     * Get BillHistory value
     * @return \SGCIS\Array\ArrayOfBillBalance|null
     */
    public function getBillHistory()
    {
        return $this->BillHistory;
    }
    /**
     * Set BillHistory value
     * @param \SGCIS\Array\ArrayOfBillBalance $billHistory
     * @return \SGCIS\Struct\BillingResponse
     */
    public function setBillHistory(\SGCIS\Array\ArrayOfBillBalance $billHistory = null)
    {
        $this->BillHistory = $billHistory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\BillingResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
