<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillPaymentAdjustment Struct
 * @subpackage Structs
 */
class BillPaymentAdjustment extends AbstractStructBase
{
    /**
     * The BillPaymentAdjustmentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillPaymentAdjustmentID;
    /**
     * The BillID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillID;
    /**
     * The SourceItemID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SourceItemID;
    /**
     * The TransactionDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TransactionDate;
    /**
     * The TransactionAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TransactionAmount;
    /**
     * The BillPaymentAdjustmentTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillPaymentAdjustmentTypeID;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The IsAlreadyPosted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAlreadyPosted;
    /**
     * The LevelToApply
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LevelToApply;
    /**
     * The ConsumptionCredit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ConsumptionCredit;
    /**
     * The BillDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillDisplay;
    /**
     * The BillServicePointIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillServicePointIdentifier;
    /**
     * The BillPaymentAdjustmentDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillPaymentAdjustmentDetail
     */
    public $BillPaymentAdjustmentDetails;
    /**
     * Constructor method for BillPaymentAdjustment
     * @uses BillPaymentAdjustment::setBillPaymentAdjustmentID()
     * @uses BillPaymentAdjustment::setBillID()
     * @uses BillPaymentAdjustment::setSourceItemID()
     * @uses BillPaymentAdjustment::setTransactionDate()
     * @uses BillPaymentAdjustment::setTransactionAmount()
     * @uses BillPaymentAdjustment::setBillPaymentAdjustmentTypeID()
     * @uses BillPaymentAdjustment::setCreateDate()
     * @uses BillPaymentAdjustment::setIsAlreadyPosted()
     * @uses BillPaymentAdjustment::setLevelToApply()
     * @uses BillPaymentAdjustment::setConsumptionCredit()
     * @uses BillPaymentAdjustment::setBillDisplay()
     * @uses BillPaymentAdjustment::setBillServicePointIdentifier()
     * @uses BillPaymentAdjustment::setBillPaymentAdjustmentDetails()
     * @param int $billPaymentAdjustmentID
     * @param int $billID
     * @param int $sourceItemID
     * @param string $transactionDate
     * @param float $transactionAmount
     * @param int $billPaymentAdjustmentTypeID
     * @param string $createDate
     * @param bool $isAlreadyPosted
     * @param int $levelToApply
     * @param float $consumptionCredit
     * @param string $billDisplay
     * @param string $billServicePointIdentifier
     * @param \SGCIS\Array\ArrayOfBillPaymentAdjustmentDetail $billPaymentAdjustmentDetails
     */
    public function __construct($billPaymentAdjustmentID = null, $billID = null, $sourceItemID = null, $transactionDate = null, $transactionAmount = null, $billPaymentAdjustmentTypeID = null, $createDate = null, $isAlreadyPosted = null, $levelToApply = null, $consumptionCredit = null, $billDisplay = null, $billServicePointIdentifier = null, \SGCIS\Array\ArrayOfBillPaymentAdjustmentDetail $billPaymentAdjustmentDetails = null)
    {
        $this
            ->setBillPaymentAdjustmentID($billPaymentAdjustmentID)
            ->setBillID($billID)
            ->setSourceItemID($sourceItemID)
            ->setTransactionDate($transactionDate)
            ->setTransactionAmount($transactionAmount)
            ->setBillPaymentAdjustmentTypeID($billPaymentAdjustmentTypeID)
            ->setCreateDate($createDate)
            ->setIsAlreadyPosted($isAlreadyPosted)
            ->setLevelToApply($levelToApply)
            ->setConsumptionCredit($consumptionCredit)
            ->setBillDisplay($billDisplay)
            ->setBillServicePointIdentifier($billServicePointIdentifier)
            ->setBillPaymentAdjustmentDetails($billPaymentAdjustmentDetails);
    }
    /**
     * Get BillPaymentAdjustmentID value
     * @return int
     */
    public function getBillPaymentAdjustmentID()
    {
        return $this->BillPaymentAdjustmentID;
    }
    /**
     * Set BillPaymentAdjustmentID value
     * @param int $billPaymentAdjustmentID
     * @return \SGCIS\Struct\BillPaymentAdjustment
     */
    public function setBillPaymentAdjustmentID($billPaymentAdjustmentID = null)
    {
        // validation for constraint: int
        if (!is_null($billPaymentAdjustmentID) && !is_numeric($billPaymentAdjustmentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billPaymentAdjustmentID)), __LINE__);
        }
        $this->BillPaymentAdjustmentID = $billPaymentAdjustmentID;
        return $this;
    }
    /**
     * Get BillID value
     * @return int
     */
    public function getBillID()
    {
        return $this->BillID;
    }
    /**
     * Set BillID value
     * @param int $billID
     * @return \SGCIS\Struct\BillPaymentAdjustment
     */
    public function setBillID($billID = null)
    {
        // validation for constraint: int
        if (!is_null($billID) && !is_numeric($billID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billID)), __LINE__);
        }
        $this->BillID = $billID;
        return $this;
    }
    /**
     * Get SourceItemID value
     * @return int
     */
    public function getSourceItemID()
    {
        return $this->SourceItemID;
    }
    /**
     * Set SourceItemID value
     * @param int $sourceItemID
     * @return \SGCIS\Struct\BillPaymentAdjustment
     */
    public function setSourceItemID($sourceItemID = null)
    {
        // validation for constraint: int
        if (!is_null($sourceItemID) && !is_numeric($sourceItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sourceItemID)), __LINE__);
        }
        $this->SourceItemID = $sourceItemID;
        return $this;
    }
    /**
     * Get TransactionDate value
     * @return string
     */
    public function getTransactionDate()
    {
        return $this->TransactionDate;
    }
    /**
     * Set TransactionDate value
     * @param string $transactionDate
     * @return \SGCIS\Struct\BillPaymentAdjustment
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionDate)), __LINE__);
        }
        $this->TransactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get TransactionAmount value
     * @return float
     */
    public function getTransactionAmount()
    {
        return $this->TransactionAmount;
    }
    /**
     * Set TransactionAmount value
     * @param float $transactionAmount
     * @return \SGCIS\Struct\BillPaymentAdjustment
     */
    public function setTransactionAmount($transactionAmount = null)
    {
        $this->TransactionAmount = $transactionAmount;
        return $this;
    }
    /**
     * Get BillPaymentAdjustmentTypeID value
     * @return int
     */
    public function getBillPaymentAdjustmentTypeID()
    {
        return $this->BillPaymentAdjustmentTypeID;
    }
    /**
     * Set BillPaymentAdjustmentTypeID value
     * @param int $billPaymentAdjustmentTypeID
     * @return \SGCIS\Struct\BillPaymentAdjustment
     */
    public function setBillPaymentAdjustmentTypeID($billPaymentAdjustmentTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($billPaymentAdjustmentTypeID) && !is_numeric($billPaymentAdjustmentTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billPaymentAdjustmentTypeID)), __LINE__);
        }
        $this->BillPaymentAdjustmentTypeID = $billPaymentAdjustmentTypeID;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\BillPaymentAdjustment
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get IsAlreadyPosted value
     * @return bool
     */
    public function getIsAlreadyPosted()
    {
        return $this->IsAlreadyPosted;
    }
    /**
     * Set IsAlreadyPosted value
     * @param bool $isAlreadyPosted
     * @return \SGCIS\Struct\BillPaymentAdjustment
     */
    public function setIsAlreadyPosted($isAlreadyPosted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAlreadyPosted) && !is_bool($isAlreadyPosted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAlreadyPosted)), __LINE__);
        }
        $this->IsAlreadyPosted = $isAlreadyPosted;
        return $this;
    }
    /**
     * Get LevelToApply value
     * @return int
     */
    public function getLevelToApply()
    {
        return $this->LevelToApply;
    }
    /**
     * Set LevelToApply value
     * @param int $levelToApply
     * @return \SGCIS\Struct\BillPaymentAdjustment
     */
    public function setLevelToApply($levelToApply = null)
    {
        // validation for constraint: int
        if (!is_null($levelToApply) && !is_numeric($levelToApply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($levelToApply)), __LINE__);
        }
        $this->LevelToApply = $levelToApply;
        return $this;
    }
    /**
     * Get ConsumptionCredit value
     * @return float
     */
    public function getConsumptionCredit()
    {
        return $this->ConsumptionCredit;
    }
    /**
     * Set ConsumptionCredit value
     * @param float $consumptionCredit
     * @return \SGCIS\Struct\BillPaymentAdjustment
     */
    public function setConsumptionCredit($consumptionCredit = null)
    {
        $this->ConsumptionCredit = $consumptionCredit;
        return $this;
    }
    /**
     * Get BillDisplay value
     * @return string|null
     */
    public function getBillDisplay()
    {
        return $this->BillDisplay;
    }
    /**
     * Set BillDisplay value
     * @param string $billDisplay
     * @return \SGCIS\Struct\BillPaymentAdjustment
     */
    public function setBillDisplay($billDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($billDisplay) && !is_string($billDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billDisplay)), __LINE__);
        }
        $this->BillDisplay = $billDisplay;
        return $this;
    }
    /**
     * Get BillServicePointIdentifier value
     * @return string|null
     */
    public function getBillServicePointIdentifier()
    {
        return $this->BillServicePointIdentifier;
    }
    /**
     * Set BillServicePointIdentifier value
     * @param string $billServicePointIdentifier
     * @return \SGCIS\Struct\BillPaymentAdjustment
     */
    public function setBillServicePointIdentifier($billServicePointIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($billServicePointIdentifier) && !is_string($billServicePointIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billServicePointIdentifier)), __LINE__);
        }
        $this->BillServicePointIdentifier = $billServicePointIdentifier;
        return $this;
    }
    /**
     * Get BillPaymentAdjustmentDetails value
     * @return \SGCIS\Array\ArrayOfBillPaymentAdjustmentDetail|null
     */
    public function getBillPaymentAdjustmentDetails()
    {
        return $this->BillPaymentAdjustmentDetails;
    }
    /**
     * Set BillPaymentAdjustmentDetails value
     * @param \SGCIS\Array\ArrayOfBillPaymentAdjustmentDetail $billPaymentAdjustmentDetails
     * @return \SGCIS\Struct\BillPaymentAdjustment
     */
    public function setBillPaymentAdjustmentDetails(\SGCIS\Array\ArrayOfBillPaymentAdjustmentDetail $billPaymentAdjustmentDetails = null)
    {
        $this->BillPaymentAdjustmentDetails = $billPaymentAdjustmentDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\BillPaymentAdjustment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
