<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Bill Struct
 * @subpackage Structs
 */
class Bill extends AbstractStructBase
{
    /**
     * The BillID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillID;
    /**
     * The MasterBillID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MasterBillID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The BillStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillStatusID;
    /**
     * The BillCalculationMethodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillCalculationMethodID;
    /**
     * The BillLetterTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillLetterTypeID;
    /**
     * The BillDocumentPages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillDocumentPages;
    /**
     * The BillDocumentGenerationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BillDocumentGenerationDate;
    /**
     * The ConversionInvoiceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ConversionInvoiceID;
    /**
     * The TotalAmountDue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalAmountDue;
    /**
     * The GenerationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GenerationDate;
    /**
     * The BillFinalDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BillFinalDate;
    /**
     * The BillPrintDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BillPrintDate;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The IsVip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsVip;
    /**
     * The TotalEnergyAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalEnergyAmount;
    /**
     * The TotalTDUBase
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalTDUBase;
    /**
     * The TotalTDUDelivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalTDUDelivery;
    /**
     * The TotalPayments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalPayments;
    /**
     * The TotalAdjustments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalAdjustments;
    /**
     * The PeriodStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PeriodStartDate;
    /**
     * The PeriodEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PeriodEndDate;
    /**
     * The PeriodLength
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PeriodLength;
    /**
     * The ApprovalDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ApprovalDate;
    /**
     * The BillNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillNumber;
    /**
     * The BillDocumentName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillDocumentName;
    /**
     * The BillDocumentContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillDocumentContent;
    /**
     * The BillStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillStatusName;
    /**
     * The BillCalculationMethodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillCalculationMethodName;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The AccountTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountTypeName;
    /**
     * The AccountStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountStatusName;
    /**
     * The ExceptionsList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExceptionsList;
    /**
     * The MasterAccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MasterAccountNumber;
    /**
     * The BillLetterTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillLetterTypeName;
    /**
     * The BillDeliveryMethods
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillDeliveryMethod
     */
    public $BillDeliveryMethods;
    /**
     * The BillHeader
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\BillHeader
     */
    public $BillHeader;
    /**
     * The BillServicePoints
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillServicePoint
     */
    public $BillServicePoints;
    /**
     * The BillUserNotes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillUserNote
     */
    public $BillUserNotes;
    /**
     * The BillStatusHistory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillStatusHistory
     */
    public $BillStatusHistory;
    /**
     * The BillPaymentAdjustments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillPaymentAdjustment
     */
    public $BillPaymentAdjustments;
    /**
     * The BillLevelizedSummary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\BillLevelizedBillSummary
     */
    public $BillLevelizedSummary;
    /**
     * The BudgetBillMonthlyAmounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBudgetBillMonthlyAmount
     */
    public $BudgetBillMonthlyAmounts;
    /**
     * The InvoiceIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfInt
     */
    public $InvoiceIDs;
    /**
     * The MeterReadIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfInt
     */
    public $MeterReadIDs;
    /**
     * Constructor method for Bill
     * @uses Bill::setBillID()
     * @uses Bill::setMasterBillID()
     * @uses Bill::setAccountID()
     * @uses Bill::setBillStatusID()
     * @uses Bill::setBillCalculationMethodID()
     * @uses Bill::setBillLetterTypeID()
     * @uses Bill::setBillDocumentPages()
     * @uses Bill::setBillDocumentGenerationDate()
     * @uses Bill::setConversionInvoiceID()
     * @uses Bill::setTotalAmountDue()
     * @uses Bill::setGenerationDate()
     * @uses Bill::setBillFinalDate()
     * @uses Bill::setBillPrintDate()
     * @uses Bill::setCreateDate()
     * @uses Bill::setIsVip()
     * @uses Bill::setTotalEnergyAmount()
     * @uses Bill::setTotalTDUBase()
     * @uses Bill::setTotalTDUDelivery()
     * @uses Bill::setTotalPayments()
     * @uses Bill::setTotalAdjustments()
     * @uses Bill::setPeriodStartDate()
     * @uses Bill::setPeriodEndDate()
     * @uses Bill::setPeriodLength()
     * @uses Bill::setApprovalDate()
     * @uses Bill::setBillNumber()
     * @uses Bill::setBillDocumentName()
     * @uses Bill::setBillDocumentContent()
     * @uses Bill::setBillStatusName()
     * @uses Bill::setBillCalculationMethodName()
     * @uses Bill::setAccountNumber()
     * @uses Bill::setAccountTypeName()
     * @uses Bill::setAccountStatusName()
     * @uses Bill::setExceptionsList()
     * @uses Bill::setMasterAccountNumber()
     * @uses Bill::setBillLetterTypeName()
     * @uses Bill::setBillDeliveryMethods()
     * @uses Bill::setBillHeader()
     * @uses Bill::setBillServicePoints()
     * @uses Bill::setBillUserNotes()
     * @uses Bill::setBillStatusHistory()
     * @uses Bill::setBillPaymentAdjustments()
     * @uses Bill::setBillLevelizedSummary()
     * @uses Bill::setBudgetBillMonthlyAmounts()
     * @uses Bill::setInvoiceIDs()
     * @uses Bill::setMeterReadIDs()
     * @param int $billID
     * @param int $masterBillID
     * @param int $accountID
     * @param int $billStatusID
     * @param int $billCalculationMethodID
     * @param int $billLetterTypeID
     * @param int $billDocumentPages
     * @param string $billDocumentGenerationDate
     * @param int $conversionInvoiceID
     * @param float $totalAmountDue
     * @param string $generationDate
     * @param string $billFinalDate
     * @param string $billPrintDate
     * @param string $createDate
     * @param bool $isVip
     * @param float $totalEnergyAmount
     * @param float $totalTDUBase
     * @param float $totalTDUDelivery
     * @param float $totalPayments
     * @param float $totalAdjustments
     * @param string $periodStartDate
     * @param string $periodEndDate
     * @param int $periodLength
     * @param string $approvalDate
     * @param string $billNumber
     * @param string $billDocumentName
     * @param string $billDocumentContent
     * @param string $billStatusName
     * @param string $billCalculationMethodName
     * @param string $accountNumber
     * @param string $accountTypeName
     * @param string $accountStatusName
     * @param string $exceptionsList
     * @param string $masterAccountNumber
     * @param string $billLetterTypeName
     * @param \SGCIS\Array\ArrayOfBillDeliveryMethod $billDeliveryMethods
     * @param \SGCIS\Struct\BillHeader $billHeader
     * @param \SGCIS\Array\ArrayOfBillServicePoint $billServicePoints
     * @param \SGCIS\Array\ArrayOfBillUserNote $billUserNotes
     * @param \SGCIS\Array\ArrayOfBillStatusHistory $billStatusHistory
     * @param \SGCIS\Array\ArrayOfBillPaymentAdjustment $billPaymentAdjustments
     * @param \SGCIS\Struct\BillLevelizedBillSummary $billLevelizedSummary
     * @param \SGCIS\Array\ArrayOfBudgetBillMonthlyAmount $budgetBillMonthlyAmounts
     * @param \SGCIS\Array\ArrayOfInt $invoiceIDs
     * @param \SGCIS\Array\ArrayOfInt $meterReadIDs
     */
    public function __construct($billID = null, $masterBillID = null, $accountID = null, $billStatusID = null, $billCalculationMethodID = null, $billLetterTypeID = null, $billDocumentPages = null, $billDocumentGenerationDate = null, $conversionInvoiceID = null, $totalAmountDue = null, $generationDate = null, $billFinalDate = null, $billPrintDate = null, $createDate = null, $isVip = null, $totalEnergyAmount = null, $totalTDUBase = null, $totalTDUDelivery = null, $totalPayments = null, $totalAdjustments = null, $periodStartDate = null, $periodEndDate = null, $periodLength = null, $approvalDate = null, $billNumber = null, $billDocumentName = null, $billDocumentContent = null, $billStatusName = null, $billCalculationMethodName = null, $accountNumber = null, $accountTypeName = null, $accountStatusName = null, $exceptionsList = null, $masterAccountNumber = null, $billLetterTypeName = null, \SGCIS\Array\ArrayOfBillDeliveryMethod $billDeliveryMethods = null, \SGCIS\Struct\BillHeader $billHeader = null, \SGCIS\Array\ArrayOfBillServicePoint $billServicePoints = null, \SGCIS\Array\ArrayOfBillUserNote $billUserNotes = null, \SGCIS\Array\ArrayOfBillStatusHistory $billStatusHistory = null, \SGCIS\Array\ArrayOfBillPaymentAdjustment $billPaymentAdjustments = null, \SGCIS\Struct\BillLevelizedBillSummary $billLevelizedSummary = null, \SGCIS\Array\ArrayOfBudgetBillMonthlyAmount $budgetBillMonthlyAmounts = null, \SGCIS\Array\ArrayOfInt $invoiceIDs = null, \SGCIS\Array\ArrayOfInt $meterReadIDs = null)
    {
        $this
            ->setBillID($billID)
            ->setMasterBillID($masterBillID)
            ->setAccountID($accountID)
            ->setBillStatusID($billStatusID)
            ->setBillCalculationMethodID($billCalculationMethodID)
            ->setBillLetterTypeID($billLetterTypeID)
            ->setBillDocumentPages($billDocumentPages)
            ->setBillDocumentGenerationDate($billDocumentGenerationDate)
            ->setConversionInvoiceID($conversionInvoiceID)
            ->setTotalAmountDue($totalAmountDue)
            ->setGenerationDate($generationDate)
            ->setBillFinalDate($billFinalDate)
            ->setBillPrintDate($billPrintDate)
            ->setCreateDate($createDate)
            ->setIsVip($isVip)
            ->setTotalEnergyAmount($totalEnergyAmount)
            ->setTotalTDUBase($totalTDUBase)
            ->setTotalTDUDelivery($totalTDUDelivery)
            ->setTotalPayments($totalPayments)
            ->setTotalAdjustments($totalAdjustments)
            ->setPeriodStartDate($periodStartDate)
            ->setPeriodEndDate($periodEndDate)
            ->setPeriodLength($periodLength)
            ->setApprovalDate($approvalDate)
            ->setBillNumber($billNumber)
            ->setBillDocumentName($billDocumentName)
            ->setBillDocumentContent($billDocumentContent)
            ->setBillStatusName($billStatusName)
            ->setBillCalculationMethodName($billCalculationMethodName)
            ->setAccountNumber($accountNumber)
            ->setAccountTypeName($accountTypeName)
            ->setAccountStatusName($accountStatusName)
            ->setExceptionsList($exceptionsList)
            ->setMasterAccountNumber($masterAccountNumber)
            ->setBillLetterTypeName($billLetterTypeName)
            ->setBillDeliveryMethods($billDeliveryMethods)
            ->setBillHeader($billHeader)
            ->setBillServicePoints($billServicePoints)
            ->setBillUserNotes($billUserNotes)
            ->setBillStatusHistory($billStatusHistory)
            ->setBillPaymentAdjustments($billPaymentAdjustments)
            ->setBillLevelizedSummary($billLevelizedSummary)
            ->setBudgetBillMonthlyAmounts($budgetBillMonthlyAmounts)
            ->setInvoiceIDs($invoiceIDs)
            ->setMeterReadIDs($meterReadIDs);
    }
    /**
     * Get BillID value
     * @return int
     */
    public function getBillID()
    {
        return $this->BillID;
    }
    /**
     * Set BillID value
     * @param int $billID
     * @return \SGCIS\Struct\Bill
     */
    public function setBillID($billID = null)
    {
        // validation for constraint: int
        if (!is_null($billID) && !is_numeric($billID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billID)), __LINE__);
        }
        $this->BillID = $billID;
        return $this;
    }
    /**
     * Get MasterBillID value
     * @return int
     */
    public function getMasterBillID()
    {
        return $this->MasterBillID;
    }
    /**
     * Set MasterBillID value
     * @param int $masterBillID
     * @return \SGCIS\Struct\Bill
     */
    public function setMasterBillID($masterBillID = null)
    {
        // validation for constraint: int
        if (!is_null($masterBillID) && !is_numeric($masterBillID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($masterBillID)), __LINE__);
        }
        $this->MasterBillID = $masterBillID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\Bill
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get BillStatusID value
     * @return int
     */
    public function getBillStatusID()
    {
        return $this->BillStatusID;
    }
    /**
     * Set BillStatusID value
     * @param int $billStatusID
     * @return \SGCIS\Struct\Bill
     */
    public function setBillStatusID($billStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($billStatusID) && !is_numeric($billStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billStatusID)), __LINE__);
        }
        $this->BillStatusID = $billStatusID;
        return $this;
    }
    /**
     * Get BillCalculationMethodID value
     * @return int
     */
    public function getBillCalculationMethodID()
    {
        return $this->BillCalculationMethodID;
    }
    /**
     * Set BillCalculationMethodID value
     * @param int $billCalculationMethodID
     * @return \SGCIS\Struct\Bill
     */
    public function setBillCalculationMethodID($billCalculationMethodID = null)
    {
        // validation for constraint: int
        if (!is_null($billCalculationMethodID) && !is_numeric($billCalculationMethodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billCalculationMethodID)), __LINE__);
        }
        $this->BillCalculationMethodID = $billCalculationMethodID;
        return $this;
    }
    /**
     * Get BillLetterTypeID value
     * @return int
     */
    public function getBillLetterTypeID()
    {
        return $this->BillLetterTypeID;
    }
    /**
     * Set BillLetterTypeID value
     * @param int $billLetterTypeID
     * @return \SGCIS\Struct\Bill
     */
    public function setBillLetterTypeID($billLetterTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($billLetterTypeID) && !is_numeric($billLetterTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billLetterTypeID)), __LINE__);
        }
        $this->BillLetterTypeID = $billLetterTypeID;
        return $this;
    }
    /**
     * Get BillDocumentPages value
     * @return int
     */
    public function getBillDocumentPages()
    {
        return $this->BillDocumentPages;
    }
    /**
     * Set BillDocumentPages value
     * @param int $billDocumentPages
     * @return \SGCIS\Struct\Bill
     */
    public function setBillDocumentPages($billDocumentPages = null)
    {
        // validation for constraint: int
        if (!is_null($billDocumentPages) && !is_numeric($billDocumentPages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billDocumentPages)), __LINE__);
        }
        $this->BillDocumentPages = $billDocumentPages;
        return $this;
    }
    /**
     * Get BillDocumentGenerationDate value
     * @return string
     */
    public function getBillDocumentGenerationDate()
    {
        return $this->BillDocumentGenerationDate;
    }
    /**
     * Set BillDocumentGenerationDate value
     * @param string $billDocumentGenerationDate
     * @return \SGCIS\Struct\Bill
     */
    public function setBillDocumentGenerationDate($billDocumentGenerationDate = null)
    {
        // validation for constraint: string
        if (!is_null($billDocumentGenerationDate) && !is_string($billDocumentGenerationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billDocumentGenerationDate)), __LINE__);
        }
        $this->BillDocumentGenerationDate = $billDocumentGenerationDate;
        return $this;
    }
    /**
     * Get ConversionInvoiceID value
     * @return int
     */
    public function getConversionInvoiceID()
    {
        return $this->ConversionInvoiceID;
    }
    /**
     * Set ConversionInvoiceID value
     * @param int $conversionInvoiceID
     * @return \SGCIS\Struct\Bill
     */
    public function setConversionInvoiceID($conversionInvoiceID = null)
    {
        // validation for constraint: int
        if (!is_null($conversionInvoiceID) && !is_numeric($conversionInvoiceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($conversionInvoiceID)), __LINE__);
        }
        $this->ConversionInvoiceID = $conversionInvoiceID;
        return $this;
    }
    /**
     * Get TotalAmountDue value
     * @return float
     */
    public function getTotalAmountDue()
    {
        return $this->TotalAmountDue;
    }
    /**
     * Set TotalAmountDue value
     * @param float $totalAmountDue
     * @return \SGCIS\Struct\Bill
     */
    public function setTotalAmountDue($totalAmountDue = null)
    {
        $this->TotalAmountDue = $totalAmountDue;
        return $this;
    }
    /**
     * Get GenerationDate value
     * @return string
     */
    public function getGenerationDate()
    {
        return $this->GenerationDate;
    }
    /**
     * Set GenerationDate value
     * @param string $generationDate
     * @return \SGCIS\Struct\Bill
     */
    public function setGenerationDate($generationDate = null)
    {
        // validation for constraint: string
        if (!is_null($generationDate) && !is_string($generationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($generationDate)), __LINE__);
        }
        $this->GenerationDate = $generationDate;
        return $this;
    }
    /**
     * Get BillFinalDate value
     * @return string
     */
    public function getBillFinalDate()
    {
        return $this->BillFinalDate;
    }
    /**
     * Set BillFinalDate value
     * @param string $billFinalDate
     * @return \SGCIS\Struct\Bill
     */
    public function setBillFinalDate($billFinalDate = null)
    {
        // validation for constraint: string
        if (!is_null($billFinalDate) && !is_string($billFinalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billFinalDate)), __LINE__);
        }
        $this->BillFinalDate = $billFinalDate;
        return $this;
    }
    /**
     * Get BillPrintDate value
     * @return string
     */
    public function getBillPrintDate()
    {
        return $this->BillPrintDate;
    }
    /**
     * Set BillPrintDate value
     * @param string $billPrintDate
     * @return \SGCIS\Struct\Bill
     */
    public function setBillPrintDate($billPrintDate = null)
    {
        // validation for constraint: string
        if (!is_null($billPrintDate) && !is_string($billPrintDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billPrintDate)), __LINE__);
        }
        $this->BillPrintDate = $billPrintDate;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\Bill
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get IsVip value
     * @return bool
     */
    public function getIsVip()
    {
        return $this->IsVip;
    }
    /**
     * Set IsVip value
     * @param bool $isVip
     * @return \SGCIS\Struct\Bill
     */
    public function setIsVip($isVip = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVip) && !is_bool($isVip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isVip)), __LINE__);
        }
        $this->IsVip = $isVip;
        return $this;
    }
    /**
     * Get TotalEnergyAmount value
     * @return float
     */
    public function getTotalEnergyAmount()
    {
        return $this->TotalEnergyAmount;
    }
    /**
     * Set TotalEnergyAmount value
     * @param float $totalEnergyAmount
     * @return \SGCIS\Struct\Bill
     */
    public function setTotalEnergyAmount($totalEnergyAmount = null)
    {
        $this->TotalEnergyAmount = $totalEnergyAmount;
        return $this;
    }
    /**
     * Get TotalTDUBase value
     * @return float
     */
    public function getTotalTDUBase()
    {
        return $this->TotalTDUBase;
    }
    /**
     * Set TotalTDUBase value
     * @param float $totalTDUBase
     * @return \SGCIS\Struct\Bill
     */
    public function setTotalTDUBase($totalTDUBase = null)
    {
        $this->TotalTDUBase = $totalTDUBase;
        return $this;
    }
    /**
     * Get TotalTDUDelivery value
     * @return float
     */
    public function getTotalTDUDelivery()
    {
        return $this->TotalTDUDelivery;
    }
    /**
     * Set TotalTDUDelivery value
     * @param float $totalTDUDelivery
     * @return \SGCIS\Struct\Bill
     */
    public function setTotalTDUDelivery($totalTDUDelivery = null)
    {
        $this->TotalTDUDelivery = $totalTDUDelivery;
        return $this;
    }
    /**
     * Get TotalPayments value
     * @return float
     */
    public function getTotalPayments()
    {
        return $this->TotalPayments;
    }
    /**
     * Set TotalPayments value
     * @param float $totalPayments
     * @return \SGCIS\Struct\Bill
     */
    public function setTotalPayments($totalPayments = null)
    {
        $this->TotalPayments = $totalPayments;
        return $this;
    }
    /**
     * Get TotalAdjustments value
     * @return float
     */
    public function getTotalAdjustments()
    {
        return $this->TotalAdjustments;
    }
    /**
     * Set TotalAdjustments value
     * @param float $totalAdjustments
     * @return \SGCIS\Struct\Bill
     */
    public function setTotalAdjustments($totalAdjustments = null)
    {
        $this->TotalAdjustments = $totalAdjustments;
        return $this;
    }
    /**
     * Get PeriodStartDate value
     * @return string
     */
    public function getPeriodStartDate()
    {
        return $this->PeriodStartDate;
    }
    /**
     * Set PeriodStartDate value
     * @param string $periodStartDate
     * @return \SGCIS\Struct\Bill
     */
    public function setPeriodStartDate($periodStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($periodStartDate) && !is_string($periodStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($periodStartDate)), __LINE__);
        }
        $this->PeriodStartDate = $periodStartDate;
        return $this;
    }
    /**
     * Get PeriodEndDate value
     * @return string
     */
    public function getPeriodEndDate()
    {
        return $this->PeriodEndDate;
    }
    /**
     * Set PeriodEndDate value
     * @param string $periodEndDate
     * @return \SGCIS\Struct\Bill
     */
    public function setPeriodEndDate($periodEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($periodEndDate) && !is_string($periodEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($periodEndDate)), __LINE__);
        }
        $this->PeriodEndDate = $periodEndDate;
        return $this;
    }
    /**
     * Get PeriodLength value
     * @return int
     */
    public function getPeriodLength()
    {
        return $this->PeriodLength;
    }
    /**
     * Set PeriodLength value
     * @param int $periodLength
     * @return \SGCIS\Struct\Bill
     */
    public function setPeriodLength($periodLength = null)
    {
        // validation for constraint: int
        if (!is_null($periodLength) && !is_numeric($periodLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($periodLength)), __LINE__);
        }
        $this->PeriodLength = $periodLength;
        return $this;
    }
    /**
     * Get ApprovalDate value
     * @return string
     */
    public function getApprovalDate()
    {
        return $this->ApprovalDate;
    }
    /**
     * Set ApprovalDate value
     * @param string $approvalDate
     * @return \SGCIS\Struct\Bill
     */
    public function setApprovalDate($approvalDate = null)
    {
        // validation for constraint: string
        if (!is_null($approvalDate) && !is_string($approvalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($approvalDate)), __LINE__);
        }
        $this->ApprovalDate = $approvalDate;
        return $this;
    }
    /**
     * Get BillNumber value
     * @return string|null
     */
    public function getBillNumber()
    {
        return $this->BillNumber;
    }
    /**
     * Set BillNumber value
     * @param string $billNumber
     * @return \SGCIS\Struct\Bill
     */
    public function setBillNumber($billNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billNumber) && !is_string($billNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billNumber)), __LINE__);
        }
        $this->BillNumber = $billNumber;
        return $this;
    }
    /**
     * Get BillDocumentName value
     * @return string|null
     */
    public function getBillDocumentName()
    {
        return $this->BillDocumentName;
    }
    /**
     * Set BillDocumentName value
     * @param string $billDocumentName
     * @return \SGCIS\Struct\Bill
     */
    public function setBillDocumentName($billDocumentName = null)
    {
        // validation for constraint: string
        if (!is_null($billDocumentName) && !is_string($billDocumentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billDocumentName)), __LINE__);
        }
        $this->BillDocumentName = $billDocumentName;
        return $this;
    }
    /**
     * Get BillDocumentContent value
     * @return string|null
     */
    public function getBillDocumentContent()
    {
        return $this->BillDocumentContent;
    }
    /**
     * Set BillDocumentContent value
     * @param string $billDocumentContent
     * @return \SGCIS\Struct\Bill
     */
    public function setBillDocumentContent($billDocumentContent = null)
    {
        // validation for constraint: string
        if (!is_null($billDocumentContent) && !is_string($billDocumentContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billDocumentContent)), __LINE__);
        }
        $this->BillDocumentContent = $billDocumentContent;
        return $this;
    }
    /**
     * Get BillStatusName value
     * @return string|null
     */
    public function getBillStatusName()
    {
        return $this->BillStatusName;
    }
    /**
     * Set BillStatusName value
     * @param string $billStatusName
     * @return \SGCIS\Struct\Bill
     */
    public function setBillStatusName($billStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($billStatusName) && !is_string($billStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billStatusName)), __LINE__);
        }
        $this->BillStatusName = $billStatusName;
        return $this;
    }
    /**
     * Get BillCalculationMethodName value
     * @return string|null
     */
    public function getBillCalculationMethodName()
    {
        return $this->BillCalculationMethodName;
    }
    /**
     * Set BillCalculationMethodName value
     * @param string $billCalculationMethodName
     * @return \SGCIS\Struct\Bill
     */
    public function setBillCalculationMethodName($billCalculationMethodName = null)
    {
        // validation for constraint: string
        if (!is_null($billCalculationMethodName) && !is_string($billCalculationMethodName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billCalculationMethodName)), __LINE__);
        }
        $this->BillCalculationMethodName = $billCalculationMethodName;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\Bill
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get AccountTypeName value
     * @return string|null
     */
    public function getAccountTypeName()
    {
        return $this->AccountTypeName;
    }
    /**
     * Set AccountTypeName value
     * @param string $accountTypeName
     * @return \SGCIS\Struct\Bill
     */
    public function setAccountTypeName($accountTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($accountTypeName) && !is_string($accountTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountTypeName)), __LINE__);
        }
        $this->AccountTypeName = $accountTypeName;
        return $this;
    }
    /**
     * Get AccountStatusName value
     * @return string|null
     */
    public function getAccountStatusName()
    {
        return $this->AccountStatusName;
    }
    /**
     * Set AccountStatusName value
     * @param string $accountStatusName
     * @return \SGCIS\Struct\Bill
     */
    public function setAccountStatusName($accountStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($accountStatusName) && !is_string($accountStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountStatusName)), __LINE__);
        }
        $this->AccountStatusName = $accountStatusName;
        return $this;
    }
    /**
     * Get ExceptionsList value
     * @return string|null
     */
    public function getExceptionsList()
    {
        return $this->ExceptionsList;
    }
    /**
     * Set ExceptionsList value
     * @param string $exceptionsList
     * @return \SGCIS\Struct\Bill
     */
    public function setExceptionsList($exceptionsList = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionsList) && !is_string($exceptionsList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exceptionsList)), __LINE__);
        }
        $this->ExceptionsList = $exceptionsList;
        return $this;
    }
    /**
     * Get MasterAccountNumber value
     * @return string|null
     */
    public function getMasterAccountNumber()
    {
        return $this->MasterAccountNumber;
    }
    /**
     * Set MasterAccountNumber value
     * @param string $masterAccountNumber
     * @return \SGCIS\Struct\Bill
     */
    public function setMasterAccountNumber($masterAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($masterAccountNumber) && !is_string($masterAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($masterAccountNumber)), __LINE__);
        }
        $this->MasterAccountNumber = $masterAccountNumber;
        return $this;
    }
    /**
     * Get BillLetterTypeName value
     * @return string|null
     */
    public function getBillLetterTypeName()
    {
        return $this->BillLetterTypeName;
    }
    /**
     * Set BillLetterTypeName value
     * @param string $billLetterTypeName
     * @return \SGCIS\Struct\Bill
     */
    public function setBillLetterTypeName($billLetterTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($billLetterTypeName) && !is_string($billLetterTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billLetterTypeName)), __LINE__);
        }
        $this->BillLetterTypeName = $billLetterTypeName;
        return $this;
    }
    /**
     * Get BillDeliveryMethods value
     * @return \SGCIS\Array\ArrayOfBillDeliveryMethod|null
     */
    public function getBillDeliveryMethods()
    {
        return $this->BillDeliveryMethods;
    }
    /**
     * Set BillDeliveryMethods value
     * @param \SGCIS\Array\ArrayOfBillDeliveryMethod $billDeliveryMethods
     * @return \SGCIS\Struct\Bill
     */
    public function setBillDeliveryMethods(\SGCIS\Array\ArrayOfBillDeliveryMethod $billDeliveryMethods = null)
    {
        $this->BillDeliveryMethods = $billDeliveryMethods;
        return $this;
    }
    /**
     * Get BillHeader value
     * @return \SGCIS\Struct\BillHeader|null
     */
    public function getBillHeader()
    {
        return $this->BillHeader;
    }
    /**
     * Set BillHeader value
     * @param \SGCIS\Struct\BillHeader $billHeader
     * @return \SGCIS\Struct\Bill
     */
    public function setBillHeader(\SGCIS\Struct\BillHeader $billHeader = null)
    {
        $this->BillHeader = $billHeader;
        return $this;
    }
    /**
     * Get BillServicePoints value
     * @return \SGCIS\Array\ArrayOfBillServicePoint|null
     */
    public function getBillServicePoints()
    {
        return $this->BillServicePoints;
    }
    /**
     * Set BillServicePoints value
     * @param \SGCIS\Array\ArrayOfBillServicePoint $billServicePoints
     * @return \SGCIS\Struct\Bill
     */
    public function setBillServicePoints(\SGCIS\Array\ArrayOfBillServicePoint $billServicePoints = null)
    {
        $this->BillServicePoints = $billServicePoints;
        return $this;
    }
    /**
     * Get BillUserNotes value
     * @return \SGCIS\Array\ArrayOfBillUserNote|null
     */
    public function getBillUserNotes()
    {
        return $this->BillUserNotes;
    }
    /**
     * Set BillUserNotes value
     * @param \SGCIS\Array\ArrayOfBillUserNote $billUserNotes
     * @return \SGCIS\Struct\Bill
     */
    public function setBillUserNotes(\SGCIS\Array\ArrayOfBillUserNote $billUserNotes = null)
    {
        $this->BillUserNotes = $billUserNotes;
        return $this;
    }
    /**
     * Get BillStatusHistory value
     * @return \SGCIS\Array\ArrayOfBillStatusHistory|null
     */
    public function getBillStatusHistory()
    {
        return $this->BillStatusHistory;
    }
    /**
     * Set BillStatusHistory value
     * @param \SGCIS\Array\ArrayOfBillStatusHistory $billStatusHistory
     * @return \SGCIS\Struct\Bill
     */
    public function setBillStatusHistory(\SGCIS\Array\ArrayOfBillStatusHistory $billStatusHistory = null)
    {
        $this->BillStatusHistory = $billStatusHistory;
        return $this;
    }
    /**
     * Get BillPaymentAdjustments value
     * @return \SGCIS\Array\ArrayOfBillPaymentAdjustment|null
     */
    public function getBillPaymentAdjustments()
    {
        return $this->BillPaymentAdjustments;
    }
    /**
     * Set BillPaymentAdjustments value
     * @param \SGCIS\Array\ArrayOfBillPaymentAdjustment $billPaymentAdjustments
     * @return \SGCIS\Struct\Bill
     */
    public function setBillPaymentAdjustments(\SGCIS\Array\ArrayOfBillPaymentAdjustment $billPaymentAdjustments = null)
    {
        $this->BillPaymentAdjustments = $billPaymentAdjustments;
        return $this;
    }
    /**
     * Get BillLevelizedSummary value
     * @return \SGCIS\Struct\BillLevelizedBillSummary|null
     */
    public function getBillLevelizedSummary()
    {
        return $this->BillLevelizedSummary;
    }
    /**
     * Set BillLevelizedSummary value
     * @param \SGCIS\Struct\BillLevelizedBillSummary $billLevelizedSummary
     * @return \SGCIS\Struct\Bill
     */
    public function setBillLevelizedSummary(\SGCIS\Struct\BillLevelizedBillSummary $billLevelizedSummary = null)
    {
        $this->BillLevelizedSummary = $billLevelizedSummary;
        return $this;
    }
    /**
     * Get BudgetBillMonthlyAmounts value
     * @return \SGCIS\Array\ArrayOfBudgetBillMonthlyAmount|null
     */
    public function getBudgetBillMonthlyAmounts()
    {
        return $this->BudgetBillMonthlyAmounts;
    }
    /**
     * Set BudgetBillMonthlyAmounts value
     * @param \SGCIS\Array\ArrayOfBudgetBillMonthlyAmount $budgetBillMonthlyAmounts
     * @return \SGCIS\Struct\Bill
     */
    public function setBudgetBillMonthlyAmounts(\SGCIS\Array\ArrayOfBudgetBillMonthlyAmount $budgetBillMonthlyAmounts = null)
    {
        $this->BudgetBillMonthlyAmounts = $budgetBillMonthlyAmounts;
        return $this;
    }
    /**
     * Get InvoiceIDs value
     * @return \SGCIS\Array\ArrayOfInt|null
     */
    public function getInvoiceIDs()
    {
        return $this->InvoiceIDs;
    }
    /**
     * Set InvoiceIDs value
     * @param \SGCIS\Array\ArrayOfInt $invoiceIDs
     * @return \SGCIS\Struct\Bill
     */
    public function setInvoiceIDs(\SGCIS\Array\ArrayOfInt $invoiceIDs = null)
    {
        $this->InvoiceIDs = $invoiceIDs;
        return $this;
    }
    /**
     * Get MeterReadIDs value
     * @return \SGCIS\Array\ArrayOfInt|null
     */
    public function getMeterReadIDs()
    {
        return $this->MeterReadIDs;
    }
    /**
     * Set MeterReadIDs value
     * @param \SGCIS\Array\ArrayOfInt $meterReadIDs
     * @return \SGCIS\Struct\Bill
     */
    public function setMeterReadIDs(\SGCIS\Array\ArrayOfInt $meterReadIDs = null)
    {
        $this->MeterReadIDs = $meterReadIDs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\Bill
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
