<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Application Struct
 * @subpackage Structs
 */
class Application extends AbstractStructBase
{
    /**
     * The ApplicationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ApplicationID;
    /**
     * The ApplicationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApplicationName;
    /**
     * Constructor method for Application
     * @uses Application::setApplicationID()
     * @uses Application::setApplicationName()
     * @param int $applicationID
     * @param string $applicationName
     */
    public function __construct($applicationID = null, $applicationName = null)
    {
        $this
            ->setApplicationID($applicationID)
            ->setApplicationName($applicationName);
    }
    /**
     * Get ApplicationID value
     * @return int
     */
    public function getApplicationID()
    {
        return $this->ApplicationID;
    }
    /**
     * Set ApplicationID value
     * @param int $applicationID
     * @return \SGCIS\Struct\Application
     */
    public function setApplicationID($applicationID = null)
    {
        // validation for constraint: int
        if (!is_null($applicationID) && !is_numeric($applicationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($applicationID)), __LINE__);
        }
        $this->ApplicationID = $applicationID;
        return $this;
    }
    /**
     * Get ApplicationName value
     * @return string|null
     */
    public function getApplicationName()
    {
        return $this->ApplicationName;
    }
    /**
     * Set ApplicationName value
     * @param string $applicationName
     * @return \SGCIS\Struct\Application
     */
    public function setApplicationName($applicationName = null)
    {
        // validation for constraint: string
        if (!is_null($applicationName) && !is_string($applicationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationName)), __LINE__);
        }
        $this->ApplicationName = $applicationName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\Application
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
