<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityDetailItem Struct
 * @subpackage Structs
 */
class ActivityDetailItem extends AbstractStructBase
{
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Date;
    /**
     * The IsCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCharge;
    /**
     * The IsCredit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCredit;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The Balance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Balance;
    /**
     * The AvgRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AvgRate;
    /**
     * The Charge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Charge;
    /**
     * The Credit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Credit;
    /**
     * The ESIID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ESIID;
    /**
     * The GroupIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupIndex;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for ActivityDetailItem
     * @uses ActivityDetailItem::setDate()
     * @uses ActivityDetailItem::setIsCharge()
     * @uses ActivityDetailItem::setIsCredit()
     * @uses ActivityDetailItem::setAmount()
     * @uses ActivityDetailItem::setBalance()
     * @uses ActivityDetailItem::setAvgRate()
     * @uses ActivityDetailItem::setCharge()
     * @uses ActivityDetailItem::setCredit()
     * @uses ActivityDetailItem::setESIID()
     * @uses ActivityDetailItem::setGroupIndex()
     * @uses ActivityDetailItem::setDescription()
     * @param string $date
     * @param bool $isCharge
     * @param bool $isCredit
     * @param float $amount
     * @param float $balance
     * @param float $avgRate
     * @param float $charge
     * @param float $credit
     * @param string $eSIID
     * @param string $groupIndex
     * @param string $description
     */
    public function __construct($date = null, $isCharge = null, $isCredit = null, $amount = null, $balance = null, $avgRate = null, $charge = null, $credit = null, $eSIID = null, $groupIndex = null, $description = null)
    {
        $this
            ->setDate($date)
            ->setIsCharge($isCharge)
            ->setIsCredit($isCredit)
            ->setAmount($amount)
            ->setBalance($balance)
            ->setAvgRate($avgRate)
            ->setCharge($charge)
            ->setCredit($credit)
            ->setESIID($eSIID)
            ->setGroupIndex($groupIndex)
            ->setDescription($description);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \SGCIS\Struct\ActivityDetailItem
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get IsCharge value
     * @return bool
     */
    public function getIsCharge()
    {
        return $this->IsCharge;
    }
    /**
     * Set IsCharge value
     * @param bool $isCharge
     * @return \SGCIS\Struct\ActivityDetailItem
     */
    public function setIsCharge($isCharge = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCharge) && !is_bool($isCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCharge)), __LINE__);
        }
        $this->IsCharge = $isCharge;
        return $this;
    }
    /**
     * Get IsCredit value
     * @return bool
     */
    public function getIsCredit()
    {
        return $this->IsCredit;
    }
    /**
     * Set IsCredit value
     * @param bool $isCredit
     * @return \SGCIS\Struct\ActivityDetailItem
     */
    public function setIsCredit($isCredit = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCredit) && !is_bool($isCredit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCredit)), __LINE__);
        }
        $this->IsCredit = $isCredit;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \SGCIS\Struct\ActivityDetailItem
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Balance value
     * @return float
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param float $balance
     * @return \SGCIS\Struct\ActivityDetailItem
     */
    public function setBalance($balance = null)
    {
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get AvgRate value
     * @return float
     */
    public function getAvgRate()
    {
        return $this->AvgRate;
    }
    /**
     * Set AvgRate value
     * @param float $avgRate
     * @return \SGCIS\Struct\ActivityDetailItem
     */
    public function setAvgRate($avgRate = null)
    {
        $this->AvgRate = $avgRate;
        return $this;
    }
    /**
     * Get Charge value
     * @return float
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * Set Charge value
     * @param float $charge
     * @return \SGCIS\Struct\ActivityDetailItem
     */
    public function setCharge($charge = null)
    {
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Get Credit value
     * @return float
     */
    public function getCredit()
    {
        return $this->Credit;
    }
    /**
     * Set Credit value
     * @param float $credit
     * @return \SGCIS\Struct\ActivityDetailItem
     */
    public function setCredit($credit = null)
    {
        $this->Credit = $credit;
        return $this;
    }
    /**
     * Get ESIID value
     * @return string|null
     */
    public function getESIID()
    {
        return $this->ESIID;
    }
    /**
     * Set ESIID value
     * @param string $eSIID
     * @return \SGCIS\Struct\ActivityDetailItem
     */
    public function setESIID($eSIID = null)
    {
        // validation for constraint: string
        if (!is_null($eSIID) && !is_string($eSIID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eSIID)), __LINE__);
        }
        $this->ESIID = $eSIID;
        return $this;
    }
    /**
     * Get GroupIndex value
     * @return string|null
     */
    public function getGroupIndex()
    {
        return $this->GroupIndex;
    }
    /**
     * Set GroupIndex value
     * @param string $groupIndex
     * @return \SGCIS\Struct\ActivityDetailItem
     */
    public function setGroupIndex($groupIndex = null)
    {
        // validation for constraint: string
        if (!is_null($groupIndex) && !is_string($groupIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupIndex)), __LINE__);
        }
        $this->GroupIndex = $groupIndex;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\ActivityDetailItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ActivityDetailItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
