<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountDocumentTypeRequest Struct
 * @subpackage Structs
 */
class AccountDocumentTypeRequest extends ServiceRequestBase
{
    /**
     * The AccountDocumentTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountDocumentTypeID;
    /**
     * The AccountDocumentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountDocumentType
     */
    public $AccountDocumentType;
    /**
     * Constructor method for AccountDocumentTypeRequest
     * @uses AccountDocumentTypeRequest::setAccountDocumentTypeID()
     * @uses AccountDocumentTypeRequest::setAccountDocumentType()
     * @param int $accountDocumentTypeID
     * @param \SGCIS\Struct\AccountDocumentType $accountDocumentType
     */
    public function __construct($accountDocumentTypeID = null, \SGCIS\Struct\AccountDocumentType $accountDocumentType = null)
    {
        $this
            ->setAccountDocumentTypeID($accountDocumentTypeID)
            ->setAccountDocumentType($accountDocumentType);
    }
    /**
     * Get AccountDocumentTypeID value
     * @return int
     */
    public function getAccountDocumentTypeID()
    {
        return $this->AccountDocumentTypeID;
    }
    /**
     * Set AccountDocumentTypeID value
     * @param int $accountDocumentTypeID
     * @return \SGCIS\Struct\AccountDocumentTypeRequest
     */
    public function setAccountDocumentTypeID($accountDocumentTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($accountDocumentTypeID) && !is_numeric($accountDocumentTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountDocumentTypeID)), __LINE__);
        }
        $this->AccountDocumentTypeID = $accountDocumentTypeID;
        return $this;
    }
    /**
     * Get AccountDocumentType value
     * @return \SGCIS\Struct\AccountDocumentType|null
     */
    public function getAccountDocumentType()
    {
        return $this->AccountDocumentType;
    }
    /**
     * Set AccountDocumentType value
     * @param \SGCIS\Struct\AccountDocumentType $accountDocumentType
     * @return \SGCIS\Struct\AccountDocumentTypeRequest
     */
    public function setAccountDocumentType(\SGCIS\Struct\AccountDocumentType $accountDocumentType = null)
    {
        $this->AccountDocumentType = $accountDocumentType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountDocumentTypeRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
