<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountDepositTransaction Struct
 * @subpackage Structs
 */
class AccountDepositTransaction extends BaseDTO
{
    /**
     * The AccountDepositTransactionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountDepositTransactionID;
    /**
     * The AccountDepositID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountDepositID;
    /**
     * The DepositOwed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DepositOwed;
    /**
     * The DepositAmountBilled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DepositAmountBilled;
    /**
     * The DepositAmountPaid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DepositAmountPaid;
    /**
     * The DepositBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DepositBalance;
    /**
     * The PaymentClearDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentClearDate;
    /**
     * The ScheduleToAccelerate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ScheduleToAccelerate;
    /**
     * The BillCycleIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillCycleIdentifier;
    /**
     * Constructor method for AccountDepositTransaction
     * @uses AccountDepositTransaction::setAccountDepositTransactionID()
     * @uses AccountDepositTransaction::setAccountDepositID()
     * @uses AccountDepositTransaction::setDepositOwed()
     * @uses AccountDepositTransaction::setDepositAmountBilled()
     * @uses AccountDepositTransaction::setDepositAmountPaid()
     * @uses AccountDepositTransaction::setDepositBalance()
     * @uses AccountDepositTransaction::setPaymentClearDate()
     * @uses AccountDepositTransaction::setScheduleToAccelerate()
     * @uses AccountDepositTransaction::setBillCycleIdentifier()
     * @param int $accountDepositTransactionID
     * @param int $accountDepositID
     * @param float $depositOwed
     * @param float $depositAmountBilled
     * @param float $depositAmountPaid
     * @param float $depositBalance
     * @param string $paymentClearDate
     * @param bool $scheduleToAccelerate
     * @param string $billCycleIdentifier
     */
    public function __construct($accountDepositTransactionID = null, $accountDepositID = null, $depositOwed = null, $depositAmountBilled = null, $depositAmountPaid = null, $depositBalance = null, $paymentClearDate = null, $scheduleToAccelerate = null, $billCycleIdentifier = null)
    {
        $this
            ->setAccountDepositTransactionID($accountDepositTransactionID)
            ->setAccountDepositID($accountDepositID)
            ->setDepositOwed($depositOwed)
            ->setDepositAmountBilled($depositAmountBilled)
            ->setDepositAmountPaid($depositAmountPaid)
            ->setDepositBalance($depositBalance)
            ->setPaymentClearDate($paymentClearDate)
            ->setScheduleToAccelerate($scheduleToAccelerate)
            ->setBillCycleIdentifier($billCycleIdentifier);
    }
    /**
     * Get AccountDepositTransactionID value
     * @return int
     */
    public function getAccountDepositTransactionID()
    {
        return $this->AccountDepositTransactionID;
    }
    /**
     * Set AccountDepositTransactionID value
     * @param int $accountDepositTransactionID
     * @return \SGCIS\Struct\AccountDepositTransaction
     */
    public function setAccountDepositTransactionID($accountDepositTransactionID = null)
    {
        // validation for constraint: int
        if (!is_null($accountDepositTransactionID) && !is_numeric($accountDepositTransactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountDepositTransactionID)), __LINE__);
        }
        $this->AccountDepositTransactionID = $accountDepositTransactionID;
        return $this;
    }
    /**
     * Get AccountDepositID value
     * @return int
     */
    public function getAccountDepositID()
    {
        return $this->AccountDepositID;
    }
    /**
     * Set AccountDepositID value
     * @param int $accountDepositID
     * @return \SGCIS\Struct\AccountDepositTransaction
     */
    public function setAccountDepositID($accountDepositID = null)
    {
        // validation for constraint: int
        if (!is_null($accountDepositID) && !is_numeric($accountDepositID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountDepositID)), __LINE__);
        }
        $this->AccountDepositID = $accountDepositID;
        return $this;
    }
    /**
     * Get DepositOwed value
     * @return float
     */
    public function getDepositOwed()
    {
        return $this->DepositOwed;
    }
    /**
     * Set DepositOwed value
     * @param float $depositOwed
     * @return \SGCIS\Struct\AccountDepositTransaction
     */
    public function setDepositOwed($depositOwed = null)
    {
        $this->DepositOwed = $depositOwed;
        return $this;
    }
    /**
     * Get DepositAmountBilled value
     * @return float
     */
    public function getDepositAmountBilled()
    {
        return $this->DepositAmountBilled;
    }
    /**
     * Set DepositAmountBilled value
     * @param float $depositAmountBilled
     * @return \SGCIS\Struct\AccountDepositTransaction
     */
    public function setDepositAmountBilled($depositAmountBilled = null)
    {
        $this->DepositAmountBilled = $depositAmountBilled;
        return $this;
    }
    /**
     * Get DepositAmountPaid value
     * @return float
     */
    public function getDepositAmountPaid()
    {
        return $this->DepositAmountPaid;
    }
    /**
     * Set DepositAmountPaid value
     * @param float $depositAmountPaid
     * @return \SGCIS\Struct\AccountDepositTransaction
     */
    public function setDepositAmountPaid($depositAmountPaid = null)
    {
        $this->DepositAmountPaid = $depositAmountPaid;
        return $this;
    }
    /**
     * Get DepositBalance value
     * @return float
     */
    public function getDepositBalance()
    {
        return $this->DepositBalance;
    }
    /**
     * Set DepositBalance value
     * @param float $depositBalance
     * @return \SGCIS\Struct\AccountDepositTransaction
     */
    public function setDepositBalance($depositBalance = null)
    {
        $this->DepositBalance = $depositBalance;
        return $this;
    }
    /**
     * Get PaymentClearDate value
     * @return string
     */
    public function getPaymentClearDate()
    {
        return $this->PaymentClearDate;
    }
    /**
     * Set PaymentClearDate value
     * @param string $paymentClearDate
     * @return \SGCIS\Struct\AccountDepositTransaction
     */
    public function setPaymentClearDate($paymentClearDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentClearDate) && !is_string($paymentClearDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentClearDate)), __LINE__);
        }
        $this->PaymentClearDate = $paymentClearDate;
        return $this;
    }
    /**
     * Get ScheduleToAccelerate value
     * @return bool
     */
    public function getScheduleToAccelerate()
    {
        return $this->ScheduleToAccelerate;
    }
    /**
     * Set ScheduleToAccelerate value
     * @param bool $scheduleToAccelerate
     * @return \SGCIS\Struct\AccountDepositTransaction
     */
    public function setScheduleToAccelerate($scheduleToAccelerate = null)
    {
        // validation for constraint: boolean
        if (!is_null($scheduleToAccelerate) && !is_bool($scheduleToAccelerate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($scheduleToAccelerate)), __LINE__);
        }
        $this->ScheduleToAccelerate = $scheduleToAccelerate;
        return $this;
    }
    /**
     * Get BillCycleIdentifier value
     * @return string|null
     */
    public function getBillCycleIdentifier()
    {
        return $this->BillCycleIdentifier;
    }
    /**
     * Set BillCycleIdentifier value
     * @param string $billCycleIdentifier
     * @return \SGCIS\Struct\AccountDepositTransaction
     */
    public function setBillCycleIdentifier($billCycleIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($billCycleIdentifier) && !is_string($billCycleIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billCycleIdentifier)), __LINE__);
        }
        $this->BillCycleIdentifier = $billCycleIdentifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountDepositTransaction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
