<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountDeposit Struct
 * @subpackage Structs
 */
class AccountDeposit extends AbstractStructBase
{
    /**
     * The AccountDepositID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountDepositID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The AccountServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountServicePointID;
    /**
     * The DepositModelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DepositModelID;
    /**
     * The AccountDepositStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountDepositStatusID;
    /**
     * The DepositStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DepositStartDate;
    /**
     * The CreditScore
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CreditScore;
    /**
     * The WaivedCreditCheck
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $WaivedCreditCheck;
    /**
     * The WaivedDeposit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $WaivedDeposit;
    /**
     * The IsPendingWaiver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPendingWaiver;
    /**
     * The IsMaxDeposit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMaxDeposit;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The LastUpdateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastUpdateDate;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The DistributionPointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionPointID;
    /**
     * The NumberOfBills
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfBills;
    /**
     * The DepositAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DepositAmount;
    /**
     * The DepositWaiveReasonID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DepositWaiveReasonID;
    /**
     * The DepositStarts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DepositStarts;
    /**
     * The InitialPayment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $InitialPayment;
    /**
     * The DepositPayments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DepositPayments;
    /**
     * The DepositSplitTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DepositSplitTypeID;
    /**
     * The PaymentInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentInterval;
    /**
     * The TotalNumberPayments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalNumberPayments;
    /**
     * The UpfrontPaymentRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UpfrontPaymentRequired;
    /**
     * The IsRefunded
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsRefunded;
    /**
     * The DepositRefundDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DepositRefundDate;
    /**
     * The PaidToDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PaidToDate;
    /**
     * The UnpaidToDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $UnpaidToDate;
    /**
     * The Balance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Balance;
    /**
     * The DepositAmountHeld
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DepositAmountHeld;
    /**
     * The DepositModelName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DepositModelName;
    /**
     * The AccountDepositStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountDepositStatusName;
    /**
     * The CreatedByUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreatedByUserName;
    /**
     * The LastUpdateUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastUpdateUserName;
    /**
     * The ServiceProviderIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceProviderIdentifier;
    /**
     * The ProductName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductName;
    /**
     * The LocationAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationAddress;
    /**
     * The DepositWaiveReasonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DepositWaiveReasonName;
    /**
     * The AccountDepositSchedule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountDepositSchedule
     */
    public $AccountDepositSchedule;
    /**
     * The AccountDepositTransactions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountDepositTransaction
     */
    public $AccountDepositTransactions;
    /**
     * Constructor method for AccountDeposit
     * @uses AccountDeposit::setAccountDepositID()
     * @uses AccountDeposit::setAccountID()
     * @uses AccountDeposit::setAccountServicePointID()
     * @uses AccountDeposit::setDepositModelID()
     * @uses AccountDeposit::setAccountDepositStatusID()
     * @uses AccountDeposit::setDepositStartDate()
     * @uses AccountDeposit::setCreditScore()
     * @uses AccountDeposit::setWaivedCreditCheck()
     * @uses AccountDeposit::setWaivedDeposit()
     * @uses AccountDeposit::setIsPendingWaiver()
     * @uses AccountDeposit::setIsMaxDeposit()
     * @uses AccountDeposit::setCreateDate()
     * @uses AccountDeposit::setLastUpdateDate()
     * @uses AccountDeposit::setProductID()
     * @uses AccountDeposit::setDistributionPointID()
     * @uses AccountDeposit::setNumberOfBills()
     * @uses AccountDeposit::setDepositAmount()
     * @uses AccountDeposit::setDepositWaiveReasonID()
     * @uses AccountDeposit::setDepositStarts()
     * @uses AccountDeposit::setInitialPayment()
     * @uses AccountDeposit::setDepositPayments()
     * @uses AccountDeposit::setDepositSplitTypeID()
     * @uses AccountDeposit::setPaymentInterval()
     * @uses AccountDeposit::setTotalNumberPayments()
     * @uses AccountDeposit::setUpfrontPaymentRequired()
     * @uses AccountDeposit::setIsRefunded()
     * @uses AccountDeposit::setDepositRefundDate()
     * @uses AccountDeposit::setPaidToDate()
     * @uses AccountDeposit::setUnpaidToDate()
     * @uses AccountDeposit::setBalance()
     * @uses AccountDeposit::setDepositAmountHeld()
     * @uses AccountDeposit::setDepositModelName()
     * @uses AccountDeposit::setAccountDepositStatusName()
     * @uses AccountDeposit::setCreatedByUserName()
     * @uses AccountDeposit::setLastUpdateUserName()
     * @uses AccountDeposit::setServiceProviderIdentifier()
     * @uses AccountDeposit::setProductName()
     * @uses AccountDeposit::setLocationAddress()
     * @uses AccountDeposit::setDepositWaiveReasonName()
     * @uses AccountDeposit::setAccountDepositSchedule()
     * @uses AccountDeposit::setAccountDepositTransactions()
     * @param int $accountDepositID
     * @param int $accountID
     * @param int $accountServicePointID
     * @param int $depositModelID
     * @param int $accountDepositStatusID
     * @param string $depositStartDate
     * @param int $creditScore
     * @param bool $waivedCreditCheck
     * @param bool $waivedDeposit
     * @param bool $isPendingWaiver
     * @param bool $isMaxDeposit
     * @param string $createDate
     * @param string $lastUpdateDate
     * @param int $productID
     * @param int $distributionPointID
     * @param int $numberOfBills
     * @param float $depositAmount
     * @param int $depositWaiveReasonID
     * @param string $depositStarts
     * @param float $initialPayment
     * @param int $depositPayments
     * @param int $depositSplitTypeID
     * @param int $paymentInterval
     * @param int $totalNumberPayments
     * @param bool $upfrontPaymentRequired
     * @param bool $isRefunded
     * @param string $depositRefundDate
     * @param float $paidToDate
     * @param float $unpaidToDate
     * @param float $balance
     * @param float $depositAmountHeld
     * @param string $depositModelName
     * @param string $accountDepositStatusName
     * @param string $createdByUserName
     * @param string $lastUpdateUserName
     * @param string $serviceProviderIdentifier
     * @param string $productName
     * @param string $locationAddress
     * @param string $depositWaiveReasonName
     * @param \SGCIS\Array\ArrayOfAccountDepositSchedule $accountDepositSchedule
     * @param \SGCIS\Array\ArrayOfAccountDepositTransaction $accountDepositTransactions
     */
    public function __construct($accountDepositID = null, $accountID = null, $accountServicePointID = null, $depositModelID = null, $accountDepositStatusID = null, $depositStartDate = null, $creditScore = null, $waivedCreditCheck = null, $waivedDeposit = null, $isPendingWaiver = null, $isMaxDeposit = null, $createDate = null, $lastUpdateDate = null, $productID = null, $distributionPointID = null, $numberOfBills = null, $depositAmount = null, $depositWaiveReasonID = null, $depositStarts = null, $initialPayment = null, $depositPayments = null, $depositSplitTypeID = null, $paymentInterval = null, $totalNumberPayments = null, $upfrontPaymentRequired = null, $isRefunded = null, $depositRefundDate = null, $paidToDate = null, $unpaidToDate = null, $balance = null, $depositAmountHeld = null, $depositModelName = null, $accountDepositStatusName = null, $createdByUserName = null, $lastUpdateUserName = null, $serviceProviderIdentifier = null, $productName = null, $locationAddress = null, $depositWaiveReasonName = null, \SGCIS\Array\ArrayOfAccountDepositSchedule $accountDepositSchedule = null, \SGCIS\Array\ArrayOfAccountDepositTransaction $accountDepositTransactions = null)
    {
        $this
            ->setAccountDepositID($accountDepositID)
            ->setAccountID($accountID)
            ->setAccountServicePointID($accountServicePointID)
            ->setDepositModelID($depositModelID)
            ->setAccountDepositStatusID($accountDepositStatusID)
            ->setDepositStartDate($depositStartDate)
            ->setCreditScore($creditScore)
            ->setWaivedCreditCheck($waivedCreditCheck)
            ->setWaivedDeposit($waivedDeposit)
            ->setIsPendingWaiver($isPendingWaiver)
            ->setIsMaxDeposit($isMaxDeposit)
            ->setCreateDate($createDate)
            ->setLastUpdateDate($lastUpdateDate)
            ->setProductID($productID)
            ->setDistributionPointID($distributionPointID)
            ->setNumberOfBills($numberOfBills)
            ->setDepositAmount($depositAmount)
            ->setDepositWaiveReasonID($depositWaiveReasonID)
            ->setDepositStarts($depositStarts)
            ->setInitialPayment($initialPayment)
            ->setDepositPayments($depositPayments)
            ->setDepositSplitTypeID($depositSplitTypeID)
            ->setPaymentInterval($paymentInterval)
            ->setTotalNumberPayments($totalNumberPayments)
            ->setUpfrontPaymentRequired($upfrontPaymentRequired)
            ->setIsRefunded($isRefunded)
            ->setDepositRefundDate($depositRefundDate)
            ->setPaidToDate($paidToDate)
            ->setUnpaidToDate($unpaidToDate)
            ->setBalance($balance)
            ->setDepositAmountHeld($depositAmountHeld)
            ->setDepositModelName($depositModelName)
            ->setAccountDepositStatusName($accountDepositStatusName)
            ->setCreatedByUserName($createdByUserName)
            ->setLastUpdateUserName($lastUpdateUserName)
            ->setServiceProviderIdentifier($serviceProviderIdentifier)
            ->setProductName($productName)
            ->setLocationAddress($locationAddress)
            ->setDepositWaiveReasonName($depositWaiveReasonName)
            ->setAccountDepositSchedule($accountDepositSchedule)
            ->setAccountDepositTransactions($accountDepositTransactions);
    }
    /**
     * Get AccountDepositID value
     * @return int
     */
    public function getAccountDepositID()
    {
        return $this->AccountDepositID;
    }
    /**
     * Set AccountDepositID value
     * @param int $accountDepositID
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setAccountDepositID($accountDepositID = null)
    {
        // validation for constraint: int
        if (!is_null($accountDepositID) && !is_numeric($accountDepositID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountDepositID)), __LINE__);
        }
        $this->AccountDepositID = $accountDepositID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AccountServicePointID value
     * @return int
     */
    public function getAccountServicePointID()
    {
        return $this->AccountServicePointID;
    }
    /**
     * Set AccountServicePointID value
     * @param int $accountServicePointID
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setAccountServicePointID($accountServicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($accountServicePointID) && !is_numeric($accountServicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountServicePointID)), __LINE__);
        }
        $this->AccountServicePointID = $accountServicePointID;
        return $this;
    }
    /**
     * Get DepositModelID value
     * @return int
     */
    public function getDepositModelID()
    {
        return $this->DepositModelID;
    }
    /**
     * Set DepositModelID value
     * @param int $depositModelID
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setDepositModelID($depositModelID = null)
    {
        // validation for constraint: int
        if (!is_null($depositModelID) && !is_numeric($depositModelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($depositModelID)), __LINE__);
        }
        $this->DepositModelID = $depositModelID;
        return $this;
    }
    /**
     * Get AccountDepositStatusID value
     * @return int
     */
    public function getAccountDepositStatusID()
    {
        return $this->AccountDepositStatusID;
    }
    /**
     * Set AccountDepositStatusID value
     * @param int $accountDepositStatusID
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setAccountDepositStatusID($accountDepositStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($accountDepositStatusID) && !is_numeric($accountDepositStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountDepositStatusID)), __LINE__);
        }
        $this->AccountDepositStatusID = $accountDepositStatusID;
        return $this;
    }
    /**
     * Get DepositStartDate value
     * @return string
     */
    public function getDepositStartDate()
    {
        return $this->DepositStartDate;
    }
    /**
     * Set DepositStartDate value
     * @param string $depositStartDate
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setDepositStartDate($depositStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($depositStartDate) && !is_string($depositStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($depositStartDate)), __LINE__);
        }
        $this->DepositStartDate = $depositStartDate;
        return $this;
    }
    /**
     * Get CreditScore value
     * @return int
     */
    public function getCreditScore()
    {
        return $this->CreditScore;
    }
    /**
     * Set CreditScore value
     * @param int $creditScore
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setCreditScore($creditScore = null)
    {
        // validation for constraint: int
        if (!is_null($creditScore) && !is_numeric($creditScore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($creditScore)), __LINE__);
        }
        $this->CreditScore = $creditScore;
        return $this;
    }
    /**
     * Get WaivedCreditCheck value
     * @return bool
     */
    public function getWaivedCreditCheck()
    {
        return $this->WaivedCreditCheck;
    }
    /**
     * Set WaivedCreditCheck value
     * @param bool $waivedCreditCheck
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setWaivedCreditCheck($waivedCreditCheck = null)
    {
        // validation for constraint: boolean
        if (!is_null($waivedCreditCheck) && !is_bool($waivedCreditCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($waivedCreditCheck)), __LINE__);
        }
        $this->WaivedCreditCheck = $waivedCreditCheck;
        return $this;
    }
    /**
     * Get WaivedDeposit value
     * @return bool
     */
    public function getWaivedDeposit()
    {
        return $this->WaivedDeposit;
    }
    /**
     * Set WaivedDeposit value
     * @param bool $waivedDeposit
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setWaivedDeposit($waivedDeposit = null)
    {
        // validation for constraint: boolean
        if (!is_null($waivedDeposit) && !is_bool($waivedDeposit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($waivedDeposit)), __LINE__);
        }
        $this->WaivedDeposit = $waivedDeposit;
        return $this;
    }
    /**
     * Get IsPendingWaiver value
     * @return bool
     */
    public function getIsPendingWaiver()
    {
        return $this->IsPendingWaiver;
    }
    /**
     * Set IsPendingWaiver value
     * @param bool $isPendingWaiver
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setIsPendingWaiver($isPendingWaiver = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPendingWaiver) && !is_bool($isPendingWaiver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPendingWaiver)), __LINE__);
        }
        $this->IsPendingWaiver = $isPendingWaiver;
        return $this;
    }
    /**
     * Get IsMaxDeposit value
     * @return bool
     */
    public function getIsMaxDeposit()
    {
        return $this->IsMaxDeposit;
    }
    /**
     * Set IsMaxDeposit value
     * @param bool $isMaxDeposit
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setIsMaxDeposit($isMaxDeposit = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMaxDeposit) && !is_bool($isMaxDeposit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isMaxDeposit)), __LINE__);
        }
        $this->IsMaxDeposit = $isMaxDeposit;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get LastUpdateDate value
     * @return string
     */
    public function getLastUpdateDate()
    {
        return $this->LastUpdateDate;
    }
    /**
     * Set LastUpdateDate value
     * @param string $lastUpdateDate
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setLastUpdateDate($lastUpdateDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDate) && !is_string($lastUpdateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateDate)), __LINE__);
        }
        $this->LastUpdateDate = $lastUpdateDate;
        return $this;
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get DistributionPointID value
     * @return int
     */
    public function getDistributionPointID()
    {
        return $this->DistributionPointID;
    }
    /**
     * Set DistributionPointID value
     * @param int $distributionPointID
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setDistributionPointID($distributionPointID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionPointID) && !is_numeric($distributionPointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionPointID)), __LINE__);
        }
        $this->DistributionPointID = $distributionPointID;
        return $this;
    }
    /**
     * Get NumberOfBills value
     * @return int
     */
    public function getNumberOfBills()
    {
        return $this->NumberOfBills;
    }
    /**
     * Set NumberOfBills value
     * @param int $numberOfBills
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setNumberOfBills($numberOfBills = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfBills) && !is_numeric($numberOfBills)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfBills)), __LINE__);
        }
        $this->NumberOfBills = $numberOfBills;
        return $this;
    }
    /**
     * Get DepositAmount value
     * @return float
     */
    public function getDepositAmount()
    {
        return $this->DepositAmount;
    }
    /**
     * Set DepositAmount value
     * @param float $depositAmount
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setDepositAmount($depositAmount = null)
    {
        $this->DepositAmount = $depositAmount;
        return $this;
    }
    /**
     * Get DepositWaiveReasonID value
     * @return int
     */
    public function getDepositWaiveReasonID()
    {
        return $this->DepositWaiveReasonID;
    }
    /**
     * Set DepositWaiveReasonID value
     * @param int $depositWaiveReasonID
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setDepositWaiveReasonID($depositWaiveReasonID = null)
    {
        // validation for constraint: int
        if (!is_null($depositWaiveReasonID) && !is_numeric($depositWaiveReasonID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($depositWaiveReasonID)), __LINE__);
        }
        $this->DepositWaiveReasonID = $depositWaiveReasonID;
        return $this;
    }
    /**
     * Get DepositStarts value
     * @return string
     */
    public function getDepositStarts()
    {
        return $this->DepositStarts;
    }
    /**
     * Set DepositStarts value
     * @param string $depositStarts
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setDepositStarts($depositStarts = null)
    {
        // validation for constraint: string
        if (!is_null($depositStarts) && !is_string($depositStarts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($depositStarts)), __LINE__);
        }
        $this->DepositStarts = $depositStarts;
        return $this;
    }
    /**
     * Get InitialPayment value
     * @return float
     */
    public function getInitialPayment()
    {
        return $this->InitialPayment;
    }
    /**
     * Set InitialPayment value
     * @param float $initialPayment
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setInitialPayment($initialPayment = null)
    {
        $this->InitialPayment = $initialPayment;
        return $this;
    }
    /**
     * Get DepositPayments value
     * @return int
     */
    public function getDepositPayments()
    {
        return $this->DepositPayments;
    }
    /**
     * Set DepositPayments value
     * @param int $depositPayments
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setDepositPayments($depositPayments = null)
    {
        // validation for constraint: int
        if (!is_null($depositPayments) && !is_numeric($depositPayments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($depositPayments)), __LINE__);
        }
        $this->DepositPayments = $depositPayments;
        return $this;
    }
    /**
     * Get DepositSplitTypeID value
     * @return int
     */
    public function getDepositSplitTypeID()
    {
        return $this->DepositSplitTypeID;
    }
    /**
     * Set DepositSplitTypeID value
     * @param int $depositSplitTypeID
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setDepositSplitTypeID($depositSplitTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($depositSplitTypeID) && !is_numeric($depositSplitTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($depositSplitTypeID)), __LINE__);
        }
        $this->DepositSplitTypeID = $depositSplitTypeID;
        return $this;
    }
    /**
     * Get PaymentInterval value
     * @return int
     */
    public function getPaymentInterval()
    {
        return $this->PaymentInterval;
    }
    /**
     * Set PaymentInterval value
     * @param int $paymentInterval
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setPaymentInterval($paymentInterval = null)
    {
        // validation for constraint: int
        if (!is_null($paymentInterval) && !is_numeric($paymentInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentInterval)), __LINE__);
        }
        $this->PaymentInterval = $paymentInterval;
        return $this;
    }
    /**
     * Get TotalNumberPayments value
     * @return int
     */
    public function getTotalNumberPayments()
    {
        return $this->TotalNumberPayments;
    }
    /**
     * Set TotalNumberPayments value
     * @param int $totalNumberPayments
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setTotalNumberPayments($totalNumberPayments = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberPayments) && !is_numeric($totalNumberPayments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalNumberPayments)), __LINE__);
        }
        $this->TotalNumberPayments = $totalNumberPayments;
        return $this;
    }
    /**
     * Get UpfrontPaymentRequired value
     * @return bool
     */
    public function getUpfrontPaymentRequired()
    {
        return $this->UpfrontPaymentRequired;
    }
    /**
     * Set UpfrontPaymentRequired value
     * @param bool $upfrontPaymentRequired
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setUpfrontPaymentRequired($upfrontPaymentRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($upfrontPaymentRequired) && !is_bool($upfrontPaymentRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($upfrontPaymentRequired)), __LINE__);
        }
        $this->UpfrontPaymentRequired = $upfrontPaymentRequired;
        return $this;
    }
    /**
     * Get IsRefunded value
     * @return bool
     */
    public function getIsRefunded()
    {
        return $this->IsRefunded;
    }
    /**
     * Set IsRefunded value
     * @param bool $isRefunded
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setIsRefunded($isRefunded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRefunded) && !is_bool($isRefunded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isRefunded)), __LINE__);
        }
        $this->IsRefunded = $isRefunded;
        return $this;
    }
    /**
     * Get DepositRefundDate value
     * @return string
     */
    public function getDepositRefundDate()
    {
        return $this->DepositRefundDate;
    }
    /**
     * Set DepositRefundDate value
     * @param string $depositRefundDate
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setDepositRefundDate($depositRefundDate = null)
    {
        // validation for constraint: string
        if (!is_null($depositRefundDate) && !is_string($depositRefundDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($depositRefundDate)), __LINE__);
        }
        $this->DepositRefundDate = $depositRefundDate;
        return $this;
    }
    /**
     * Get PaidToDate value
     * @return float
     */
    public function getPaidToDate()
    {
        return $this->PaidToDate;
    }
    /**
     * Set PaidToDate value
     * @param float $paidToDate
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setPaidToDate($paidToDate = null)
    {
        $this->PaidToDate = $paidToDate;
        return $this;
    }
    /**
     * Get UnpaidToDate value
     * @return float
     */
    public function getUnpaidToDate()
    {
        return $this->UnpaidToDate;
    }
    /**
     * Set UnpaidToDate value
     * @param float $unpaidToDate
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setUnpaidToDate($unpaidToDate = null)
    {
        $this->UnpaidToDate = $unpaidToDate;
        return $this;
    }
    /**
     * Get Balance value
     * @return float
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param float $balance
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setBalance($balance = null)
    {
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get DepositAmountHeld value
     * @return float
     */
    public function getDepositAmountHeld()
    {
        return $this->DepositAmountHeld;
    }
    /**
     * Set DepositAmountHeld value
     * @param float $depositAmountHeld
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setDepositAmountHeld($depositAmountHeld = null)
    {
        $this->DepositAmountHeld = $depositAmountHeld;
        return $this;
    }
    /**
     * Get DepositModelName value
     * @return string|null
     */
    public function getDepositModelName()
    {
        return $this->DepositModelName;
    }
    /**
     * Set DepositModelName value
     * @param string $depositModelName
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setDepositModelName($depositModelName = null)
    {
        // validation for constraint: string
        if (!is_null($depositModelName) && !is_string($depositModelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($depositModelName)), __LINE__);
        }
        $this->DepositModelName = $depositModelName;
        return $this;
    }
    /**
     * Get AccountDepositStatusName value
     * @return string|null
     */
    public function getAccountDepositStatusName()
    {
        return $this->AccountDepositStatusName;
    }
    /**
     * Set AccountDepositStatusName value
     * @param string $accountDepositStatusName
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setAccountDepositStatusName($accountDepositStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($accountDepositStatusName) && !is_string($accountDepositStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountDepositStatusName)), __LINE__);
        }
        $this->AccountDepositStatusName = $accountDepositStatusName;
        return $this;
    }
    /**
     * Get CreatedByUserName value
     * @return string|null
     */
    public function getCreatedByUserName()
    {
        return $this->CreatedByUserName;
    }
    /**
     * Set CreatedByUserName value
     * @param string $createdByUserName
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setCreatedByUserName($createdByUserName = null)
    {
        // validation for constraint: string
        if (!is_null($createdByUserName) && !is_string($createdByUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdByUserName)), __LINE__);
        }
        $this->CreatedByUserName = $createdByUserName;
        return $this;
    }
    /**
     * Get LastUpdateUserName value
     * @return string|null
     */
    public function getLastUpdateUserName()
    {
        return $this->LastUpdateUserName;
    }
    /**
     * Set LastUpdateUserName value
     * @param string $lastUpdateUserName
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setLastUpdateUserName($lastUpdateUserName = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateUserName) && !is_string($lastUpdateUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateUserName)), __LINE__);
        }
        $this->LastUpdateUserName = $lastUpdateUserName;
        return $this;
    }
    /**
     * Get ServiceProviderIdentifier value
     * @return string|null
     */
    public function getServiceProviderIdentifier()
    {
        return $this->ServiceProviderIdentifier;
    }
    /**
     * Set ServiceProviderIdentifier value
     * @param string $serviceProviderIdentifier
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setServiceProviderIdentifier($serviceProviderIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderIdentifier) && !is_string($serviceProviderIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceProviderIdentifier)), __LINE__);
        }
        $this->ServiceProviderIdentifier = $serviceProviderIdentifier;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get LocationAddress value
     * @return string|null
     */
    public function getLocationAddress()
    {
        return $this->LocationAddress;
    }
    /**
     * Set LocationAddress value
     * @param string $locationAddress
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setLocationAddress($locationAddress = null)
    {
        // validation for constraint: string
        if (!is_null($locationAddress) && !is_string($locationAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationAddress)), __LINE__);
        }
        $this->LocationAddress = $locationAddress;
        return $this;
    }
    /**
     * Get DepositWaiveReasonName value
     * @return string|null
     */
    public function getDepositWaiveReasonName()
    {
        return $this->DepositWaiveReasonName;
    }
    /**
     * Set DepositWaiveReasonName value
     * @param string $depositWaiveReasonName
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setDepositWaiveReasonName($depositWaiveReasonName = null)
    {
        // validation for constraint: string
        if (!is_null($depositWaiveReasonName) && !is_string($depositWaiveReasonName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($depositWaiveReasonName)), __LINE__);
        }
        $this->DepositWaiveReasonName = $depositWaiveReasonName;
        return $this;
    }
    /**
     * Get AccountDepositSchedule value
     * @return \SGCIS\Array\ArrayOfAccountDepositSchedule|null
     */
    public function getAccountDepositSchedule()
    {
        return $this->AccountDepositSchedule;
    }
    /**
     * Set AccountDepositSchedule value
     * @param \SGCIS\Array\ArrayOfAccountDepositSchedule $accountDepositSchedule
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setAccountDepositSchedule(\SGCIS\Array\ArrayOfAccountDepositSchedule $accountDepositSchedule = null)
    {
        $this->AccountDepositSchedule = $accountDepositSchedule;
        return $this;
    }
    /**
     * Get AccountDepositTransactions value
     * @return \SGCIS\Array\ArrayOfAccountDepositTransaction|null
     */
    public function getAccountDepositTransactions()
    {
        return $this->AccountDepositTransactions;
    }
    /**
     * Set AccountDepositTransactions value
     * @param \SGCIS\Array\ArrayOfAccountDepositTransaction $accountDepositTransactions
     * @return \SGCIS\Struct\AccountDeposit
     */
    public function setAccountDepositTransactions(\SGCIS\Array\ArrayOfAccountDepositTransaction $accountDepositTransactions = null)
    {
        $this->AccountDepositTransactions = $accountDepositTransactions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountDeposit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
