<?php

namespace SGCIS\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for all operations
 * @subpackage Services
 */
class Service extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetAccountShallowCopy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetAccountShallowCopy $parameters
     * @return \SGCIS\Struct\GetAccountShallowCopyResponse|bool
     */
    public function GetAccountShallowCopy(\SGCIS\Struct\GetAccountShallowCopy $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountShallowCopy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserAgentCodeByAgentID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetUserAgentCodeByAgentID $parameters
     * @return \SGCIS\Struct\GetUserAgentCodeByAgentIDResponse|bool
     */
    public function GetUserAgentCodeByAgentID(\SGCIS\Struct\GetUserAgentCodeByAgentID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUserAgentCodeByAgentID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveAutoPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\SaveAutoPayment $parameters
     * @return \SGCIS\Struct\SaveAutoPaymentResponse|bool
     */
    public function SaveAutoPayment(\SGCIS\Struct\SaveAutoPayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveAutoPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountDocuments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetAccountDocuments $parameters
     * @return \SGCIS\Struct\GetAccountDocumentsResponse|bool
     */
    public function GetAccountDocuments(\SGCIS\Struct\GetAccountDocuments $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountDocuments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountDocumentTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetAccountDocumentTypes $parameters
     * @return \SGCIS\Struct\GetAccountDocumentTypesResponse|bool
     */
    public function GetAccountDocumentTypes(\SGCIS\Struct\GetAccountDocumentTypes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountDocumentTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountIVR
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetAccountIVR $parameters
     * @return \SGCIS\Struct\GetAccountIVRResponse|bool
     */
    public function GetAccountIVR(\SGCIS\Struct\GetAccountIVR $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountIVR($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ValidPhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\ValidPhone $parameters
     * @return \SGCIS\Struct\ValidPhoneResponse|bool
     */
    public function ValidPhone(\SGCIS\Struct\ValidPhone $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ValidPhone($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RegisterCustomerWith2FactorAuth
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\RegisterCustomerWith2FactorAuth $parameters
     * @return \SGCIS\Struct\RegisterCustomerWith2FactorAuthResponse|bool
     */
    public function RegisterCustomerWith2FactorAuth(\SGCIS\Struct\RegisterCustomerWith2FactorAuth $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RegisterCustomerWith2FactorAuth($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Claim2FactorAuthCustomerRegistration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\Claim2FactorAuthCustomerRegistration $parameters
     * @return \SGCIS\Struct\Claim2FactorAuthCustomerRegistrationResponse|bool
     */
    public function Claim2FactorAuthCustomerRegistration(\SGCIS\Struct\Claim2FactorAuthCustomerRegistration $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Claim2FactorAuthCustomerRegistration($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductsByZipCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetProductsByZipCode $parameters
     * @return \SGCIS\Struct\GetProductsByZipCodeResponse|bool
     */
    public function GetProductsByZipCode(\SGCIS\Struct\GetProductsByZipCode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProductsByZipCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetProducts $parameters
     * @return \SGCIS\Struct\GetProductsResponse|bool
     */
    public function GetProducts(\SGCIS\Struct\GetProducts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProducts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ValidateEnrollmentLocations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\ValidateEnrollmentLocations $parameters
     * @return \SGCIS\Struct\ValidateEnrollmentLocationsResponse|bool
     */
    public function ValidateEnrollmentLocations(\SGCIS\Struct\ValidateEnrollmentLocations $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ValidateEnrollmentLocations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessAccountEnrollment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\ProcessAccountEnrollment $parameters
     * @return \SGCIS\Struct\ProcessAccountEnrollmentResponse|bool
     */
    public function ProcessAccountEnrollment(\SGCIS\Struct\ProcessAccountEnrollment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ProcessAccountEnrollment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDistributionPoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetDistributionPoints $parameters
     * @return \SGCIS\Struct\GetDistributionPointsResponse|bool
     */
    public function GetDistributionPoints(\SGCIS\Struct\GetDistributionPoints $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDistributionPoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountActivityMobile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetAccountActivityMobile $parameters
     * @return \SGCIS\Struct\GetAccountActivityMobileResponse|bool
     */
    public function GetAccountActivityMobile(\SGCIS\Struct\GetAccountActivityMobile $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountActivityMobile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAutoPayMetaData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetAutoPayMetaData $parameters
     * @return \SGCIS\Struct\GetAutoPayMetaDataResponse|bool
     */
    public function GetAutoPayMetaData(\SGCIS\Struct\GetAutoPayMetaData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAutoPayMetaData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConnectSoftArmedMeter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\ConnectSoftArmedMeter $parameters
     * @return \SGCIS\Struct\ConnectSoftArmedMeterResponse|bool
     */
    public function ConnectSoftArmedMeter(\SGCIS\Struct\ConnectSoftArmedMeter $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ConnectSoftArmedMeter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductDeepCopy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetProductDeepCopy $parameters
     * @return \SGCIS\Struct\GetProductDeepCopyResponse|bool
     */
    public function GetProductDeepCopy(\SGCIS\Struct\GetProductDeepCopy $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProductDeepCopy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AuthenticateUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\AuthenticateUser $parameters
     * @return \SGCIS\Struct\AuthenticateUserResponse|bool
     */
    public function AuthenticateUser(\SGCIS\Struct\AuthenticateUser $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AuthenticateUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChangePassword
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\ChangePassword $parameters
     * @return \SGCIS\Struct\ChangePasswordResponse|bool
     */
    public function ChangePassword(\SGCIS\Struct\ChangePassword $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ChangePassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Register
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\Register $parameters
     * @return \SGCIS\Struct\RegisterResponse|bool
     */
    public function Register(\SGCIS\Struct\Register $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Register($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateAccountProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\UpdateAccountProfile $parameters
     * @return \SGCIS\Struct\UpdateAccountProfileResponse|bool
     */
    public function UpdateAccountProfile(\SGCIS\Struct\UpdateAccountProfile $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateAccountProfile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPaymentLocations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetPaymentLocations $parameters
     * @return \SGCIS\Struct\GetPaymentLocationsResponse|bool
     */
    public function GetPaymentLocations(\SGCIS\Struct\GetPaymentLocations $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPaymentLocations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeletePaymentAccount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\DeletePaymentAccount $parameters
     * @return \SGCIS\Struct\DeletePaymentAccountResponse|bool
     */
    public function DeletePaymentAccount(\SGCIS\Struct\DeletePaymentAccount $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeletePaymentAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SavePaymentAccount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\SavePaymentAccount $parameters
     * @return \SGCIS\Struct\SavePaymentAccountResponse|bool
     */
    public function SavePaymentAccount(\SGCIS\Struct\SavePaymentAccount $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SavePaymentAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendPassword
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\SendPassword $parameters
     * @return \SGCIS\Struct\SendPasswordResponse|bool
     */
    public function SendPassword(\SGCIS\Struct\SendPassword $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendPassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * UpdateAccountCommunicationViewStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\UpdateAccountCommunicationViewStatus $parameters
     * @return \SGCIS\Struct\UpdateAccountCommunicationViewStatusResponse|bool
     */
    public function UpdateAccountCommunicationViewStatus(\SGCIS\Struct\UpdateAccountCommunicationViewStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateAccountCommunicationViewStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountActivity
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetAccountActivity $parameters
     * @return \SGCIS\Struct\GetAccountActivityResponse|bool
     */
    public function GetAccountActivity(\SGCIS\Struct\GetAccountActivity $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountActivity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetAccount $parameters
     * @return \SGCIS\Struct\GetAccountResponse|bool
     */
    public function GetAccount(\SGCIS\Struct\GetAccount $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUspAccount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetUspAccount $parameters
     * @return \SGCIS\Struct\GetUspAccountResponse|bool
     */
    public function GetUspAccount(\SGCIS\Struct\GetUspAccount $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUspAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFees
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetFees $parameters
     * @return \SGCIS\Struct\GetFeesResponse|bool
     */
    public function GetFees(\SGCIS\Struct\GetFees $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFees($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPaymentArrangements
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetPaymentArrangements $parameters
     * @return \SGCIS\Struct\GetPaymentArrangementsResponse|bool
     */
    public function GetPaymentArrangements(\SGCIS\Struct\GetPaymentArrangements $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPaymentArrangements($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPaymentArrangement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetPaymentArrangement $parameters
     * @return \SGCIS\Struct\GetPaymentArrangementResponse|bool
     */
    public function GetPaymentArrangement(\SGCIS\Struct\GetPaymentArrangement $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPaymentArrangement($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateNewPaymentArrangement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\CreateNewPaymentArrangement $parameters
     * @return \SGCIS\Struct\CreateNewPaymentArrangementResponse|bool
     */
    public function CreateNewPaymentArrangement(\SGCIS\Struct\CreateNewPaymentArrangement $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateNewPaymentArrangement($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPaymentAccounts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetPaymentAccounts $parameters
     * @return \SGCIS\Struct\GetPaymentAccountsResponse|bool
     */
    public function GetPaymentAccounts(\SGCIS\Struct\GetPaymentAccounts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPaymentAccounts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountAutopayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetAccountAutopayment $parameters
     * @return \SGCIS\Struct\GetAccountAutopaymentResponse|bool
     */
    public function GetAccountAutopayment(\SGCIS\Struct\GetAccountAutopayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountAutopayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostUspPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\PostUspPayment $parameters
     * @return \SGCIS\Struct\PostUspPaymentResponse|bool
     */
    public function PostUspPayment(\SGCIS\Struct\PostUspPayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PostUspPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostAccountPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\PostAccountPayment $parameters
     * @return \SGCIS\Struct\PostAccountPaymentResponse|bool
     */
    public function PostAccountPayment(\SGCIS\Struct\PostAccountPayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PostAccountPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessAccountPayLater
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\ProcessAccountPayLater $parameters
     * @return \SGCIS\Struct\ProcessAccountPayLaterResponse|bool
     */
    public function ProcessAccountPayLater(\SGCIS\Struct\ProcessAccountPayLater $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ProcessAccountPayLater($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDataLists
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetDataLists $parameters
     * @return \SGCIS\Struct\GetDataListsResponse|bool
     */
    public function GetDataLists(\SGCIS\Struct\GetDataLists $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDataLists($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDataList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetDataList $parameters
     * @return \SGCIS\Struct\GetDataListResponse|bool
     */
    public function GetDataList(\SGCIS\Struct\GetDataList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDataList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSystemProperty
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetSystemProperty $parameters
     * @return \SGCIS\Struct\GetSystemPropertyResponse|bool
     */
    public function GetSystemProperty(\SGCIS\Struct\GetSystemProperty $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSystemProperty($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCurrentBill
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetCurrentBill $parameters
     * @return \SGCIS\Struct\GetCurrentBillResponse|bool
     */
    public function GetCurrentBill(\SGCIS\Struct\GetCurrentBill $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCurrentBill($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBillHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetBillHistory $parameters
     * @return \SGCIS\Struct\GetBillHistoryResponse|bool
     */
    public function GetBillHistory(\SGCIS\Struct\GetBillHistory $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetBillHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ProcessAccountTransferServiceLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\ProcessAccountTransferServiceLocation $parameters
     * @return \SGCIS\Struct\ProcessAccountTransferServiceLocationResponse|bool
     */
    public function ProcessAccountTransferServiceLocation(\SGCIS\Struct\ProcessAccountTransferServiceLocation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ProcessAccountTransferServiceLocation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FindServiceLocations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\FindServiceLocations $parameters
     * @return \SGCIS\Struct\FindServiceLocationsResponse|bool
     */
    public function FindServiceLocations(\SGCIS\Struct\FindServiceLocations $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->FindServiceLocations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CaptureLead
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\CaptureLead $parameters
     * @return \SGCIS\Struct\CaptureLeadResponse|bool
     */
    public function CaptureLead(\SGCIS\Struct\CaptureLead $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CaptureLead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWebProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetWebProducts $parameters
     * @return \SGCIS\Struct\GetWebProductsResponse|bool
     */
    public function GetWebProducts(\SGCIS\Struct\GetWebProducts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetWebProducts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountTransactionSummary
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetAccountTransactionSummary $parameters
     * @return \SGCIS\Struct\GetAccountTransactionSummaryResponse|bool
     */
    public function GetAccountTransactionSummary(\SGCIS\Struct\GetAccountTransactionSummary $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountTransactionSummary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetCustomFields $parameters
     * @return \SGCIS\Struct\GetCustomFieldsResponse|bool
     */
    public function GetCustomFields(\SGCIS\Struct\GetCustomFields $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountCustomFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetAccountCustomFields $parameters
     * @return \SGCIS\Struct\GetAccountCustomFieldsResponse|bool
     */
    public function GetAccountCustomFields(\SGCIS\Struct\GetAccountCustomFields $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountCustomFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveAccountCustomFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\SaveAccountCustomFields $parameters
     * @return \SGCIS\Struct\SaveAccountCustomFieldsResponse|bool
     */
    public function SaveAccountCustomFields(\SGCIS\Struct\SaveAccountCustomFields $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveAccountCustomFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserCharacteristics
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetUserCharacteristics $parameters
     * @return \SGCIS\Struct\GetUserCharacteristicsResponse|bool
     */
    public function GetUserCharacteristics(\SGCIS\Struct\GetUserCharacteristics $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUserCharacteristics($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetZipCodeWeather
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetZipCodeWeather $parameters
     * @return \SGCIS\Struct\GetZipCodeWeatherResponse|bool
     */
    public function GetZipCodeWeather(\SGCIS\Struct\GetZipCodeWeather $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetZipCodeWeather($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExternalAuthenticateUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\ExternalAuthenticateUser $parameters
     * @return \SGCIS\Struct\ExternalAuthenticateUserResponse|bool
     */
    public function ExternalAuthenticateUser(\SGCIS\Struct\ExternalAuthenticateUser $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExternalAuthenticateUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExternalRecoverPassword
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\ExternalRecoverPassword $parameters
     * @return \SGCIS\Struct\ExternalRecoverPasswordResponse|bool
     */
    public function ExternalRecoverPassword(\SGCIS\Struct\ExternalRecoverPassword $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExternalRecoverPassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \SGCIS\Struct\AuthenticateUserResponse|\SGCIS\Struct\CaptureLeadResponse|\SGCIS\Struct\ChangePasswordResponse|\SGCIS\Struct\Claim2FactorAuthCustomerRegistrationResponse|\SGCIS\Struct\ConnectSoftArmedMeterResponse|\SGCIS\Struct\CreateNewPaymentArrangementResponse|\SGCIS\Struct\DeletePaymentAccountResponse|\SGCIS\Struct\ExternalAuthenticateUserResponse|\SGCIS\Struct\ExternalRecoverPasswordResponse|\SGCIS\Struct\FindServiceLocationsResponse|\SGCIS\Struct\GetAccountActivityMobileResponse|\SGCIS\Struct\GetAccountActivityResponse|\SGCIS\Struct\GetAccountAutopaymentResponse|\SGCIS\Struct\GetAccountCustomFieldsResponse|\SGCIS\Struct\GetAccountDocumentsResponse|\SGCIS\Struct\GetAccountDocumentTypesResponse|\SGCIS\Struct\GetAccountIVRResponse|\SGCIS\Struct\GetAccountResponse|\SGCIS\Struct\GetAccountShallowCopyResponse|\SGCIS\Struct\GetAccountTransactionSummaryResponse|\SGCIS\Struct\GetAutoPayMetaDataResponse|\SGCIS\Struct\GetBillHistoryResponse|\SGCIS\Struct\GetCurrentBillResponse|\SGCIS\Struct\GetCustomFieldsResponse|\SGCIS\Struct\GetDataListResponse|\SGCIS\Struct\GetDataListsResponse|\SGCIS\Struct\GetDistributionPointsResponse|\SGCIS\Struct\GetFeesResponse|\SGCIS\Struct\GetPaymentAccountsResponse|\SGCIS\Struct\GetPaymentArrangementResponse|\SGCIS\Struct\GetPaymentArrangementsResponse|\SGCIS\Struct\GetPaymentLocationsResponse|\SGCIS\Struct\GetProductDeepCopyResponse|\SGCIS\Struct\GetProductsByZipCodeResponse|\SGCIS\Struct\GetProductsResponse|\SGCIS\Struct\GetSystemPropertyResponse|\SGCIS\Struct\GetUserAgentCodeByAgentIDResponse|\SGCIS\Struct\GetUserCharacteristicsResponse|\SGCIS\Struct\GetUspAccountResponse|\SGCIS\Struct\GetWebProductsResponse|\SGCIS\Struct\GetZipCodeWeatherResponse|\SGCIS\Struct\PostAccountPaymentResponse|\SGCIS\Struct\PostUspPaymentResponse|\SGCIS\Struct\ProcessAccountEnrollmentResponse|\SGCIS\Struct\ProcessAccountPayLaterResponse|\SGCIS\Struct\ProcessAccountTransferServiceLocationResponse|\SGCIS\Struct\RegisterCustomerWith2FactorAuthResponse|\SGCIS\Struct\RegisterResponse|\SGCIS\Struct\SaveAccountCustomFieldsResponse|\SGCIS\Struct\SaveAutoPaymentResponse|\SGCIS\Struct\SavePaymentAccountResponse|\SGCIS\Struct\SendPasswordResponse|\SGCIS\Struct\UpdateAccountCommunicationViewStatusResponse|\SGCIS\Struct\UpdateAccountProfileResponse|\SGCIS\Struct\ValidateEnrollmentLocationsResponse|\SGCIS\Struct\ValidPhoneResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
