<?php

namespace SGCIS\Enum;

/**
 * This class stands for DeletePaymentAccountMode Enum
 * @subpackage Enumerations
 */
class DeletePaymentAccountMode
{
    /**
     * Constant for value 'ValidateBeforeDelete'
     * @return string 'ValidateBeforeDelete'
     */
    const VALUE_VALIDATE_BEFORE_DELETE = 'ValidateBeforeDelete';
    /**
     * Constant for value 'CompleteDeletion'
     * @return string 'CompleteDeletion'
     */
    const VALUE_COMPLETE_DELETION = 'CompleteDeletion';
    /**
     * Constant for value 'DeleteLocal'
     * @return string 'DeleteLocal'
     */
    const VALUE_DELETE_LOCAL = 'DeleteLocal';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_VALIDATE_BEFORE_DELETE
     * @uses self::VALUE_COMPLETE_DELETION
     * @uses self::VALUE_DELETE_LOCAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VALIDATE_BEFORE_DELETE,
            self::VALUE_COMPLETE_DELETION,
            self::VALUE_DELETE_LOCAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
