<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfUsageCharge Array
 * @subpackage Arrays
 */
class ArrayOfUsageCharge extends AbstractStructArrayBase
{
    /**
     * The UsageCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\UsageCharge[]
     */
    public $UsageCharge;
    /**
     * Constructor method for ArrayOfUsageCharge
     * @uses ArrayOfUsageCharge::setUsageCharge()
     * @param \SGCIS\Struct\UsageCharge[] $usageCharge
     */
    public function __construct(array $usageCharge = array())
    {
        $this
            ->setUsageCharge($usageCharge);
    }
    /**
     * Get UsageCharge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\UsageCharge[]|null
     */
    public function getUsageCharge()
    {
        return isset($this->UsageCharge) ? $this->UsageCharge : null;
    }
    /**
     * Set UsageCharge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\UsageCharge[] $usageCharge
     * @return \SGCIS\Array\ArrayOfUsageCharge
     */
    public function setUsageCharge(array $usageCharge = array())
    {
        foreach ($usageCharge as $arrayOfUsageChargeUsageChargeItem) {
            // validation for constraint: itemType
            if (!$arrayOfUsageChargeUsageChargeItem instanceof \SGCIS\Struct\UsageCharge) {
                throw new \InvalidArgumentException(sprintf('The UsageCharge property can only contain items of \SGCIS\Struct\UsageCharge, "%s" given', is_object($arrayOfUsageChargeUsageChargeItem) ? get_class($arrayOfUsageChargeUsageChargeItem) : gettype($arrayOfUsageChargeUsageChargeItem)), __LINE__);
            }
        }
        if (is_null($usageCharge) || (is_array($usageCharge) && empty($usageCharge))) {
            unset($this->UsageCharge);
        } else {
            $this->UsageCharge = $usageCharge;
        }
        return $this;
    }
    /**
     * Add item to UsageCharge value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\UsageCharge $item
     * @return \SGCIS\Array\ArrayOfUsageCharge
     */
    public function addToUsageCharge(\SGCIS\Struct\UsageCharge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\UsageCharge) {
            throw new \InvalidArgumentException(sprintf('The UsageCharge property can only contain items of \SGCIS\Struct\UsageCharge, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UsageCharge[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\UsageCharge|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\UsageCharge|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\UsageCharge|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\UsageCharge|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\UsageCharge|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string UsageCharge
     */
    public function getAttributeName()
    {
        return 'UsageCharge';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfUsageCharge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
